(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Mon Aug 10  0:28:21 PDT 1992 by meehan                   *)
(*      modified on Tue Jun 16 13:08:12 PDT 1992 by muller                   *)
(*      modified on Mon Jun 15 19:29:22 1992 by mhb                          *)


(* A {\em switch}\index{switch} ("SwitchVBT.T") is the VBTkit version
   of a {\em button} ("ButtonVBT.T").  A switch "s" follows these three
   conventions:
   
   \begin{enumerate}
   
   \item "s" has a "callback" method.  This method will be invoked
        whenever a button would have invoked its "action" procedure.
   
   \item The "VBT"-child of "s" is a feedback, "f".  "s.pre()" invokes
       "Feedback.Excited(f)".  "s.post()" and "s.cancel()" invoke
       "Feedback.Normal(f)".

   \item "s" is also a multi-filter.  Its multi-child is defined to
       be the multi-child of "f".
       
   \end{enumerate} 
   
   Although all VBTkit switches follow these conventions and are
   subtypes of "ButtonVBT.T", not all are subtypes of "SwitchVBT.T".
   A "MenuSwitchVBT", for example, is a subtype of "MenuBtnVBT.T". *)

INTERFACE SwitchVBT;

IMPORT ButtonVBT, Feedback, MultiClass, VBT;

TYPE
  T <: Public;
  Public =
    ButtonVBT.T OBJECT
    METHODS
      init     (f: Feedback.T; multiclass: MC := NIL): T;
      callback (READONLY cd: VBT.MouseRec) := DefaultCallback;
    OVERRIDES
      pre    := Pre;
      post   := Post;
      cancel := Cancel;
    END;

  MC <: MultiClass.T;
(* The type "MC" overrides the "replace", "pred", and "succ" methods
   of the type "MultiClass.T". *)

PROCEDURE Pre    (v: ButtonVBT.T);
PROCEDURE Post   (v: ButtonVBT.T);
PROCEDURE Cancel (v: ButtonVBT.T);

PROCEDURE DefaultCallback (         v : ButtonVBT.T;
                           READONLY cd: VBT.MouseRec );
(* A no-op. *)

END SwitchVBT.



