(* Copyright (C) 1990, Digital Equipment Corporation.         *)
(* All rights reserved.                                       *)
(* See the file COPYRIGHT for a full description.             *)

(* Last modified on Thu Sep 24 11:51:56 PDT 1992 by steveg   *)

INTERFACE VBTAlbum;

(* "VBTAlbum" manages a photo album of snapshots of VBTs.  The
   snapshots are taken by "VBTSnap". *)

<* PRAGMA LL *> 

IMPORT
  Axis, VBT;

TYPE
  T <: TPublic;
  TPrivate <: VBT.Split;
  TPublic = TPrivate OBJECT
            METHODS
              <* LL <= VBT.mu *>
              init (layoutAxis   : Axis.T;
                    size         : CARDINAL;
                    width, height: REAL       := 30.0): T;

              <* LL = VBT.mu *>
              add   (v: VBT.T);
              clear ();
            END;

(* A "VBTAlbum.T" is a "VBT.Split" that manages the layout of a series of
   images produced by taking snapshots of VBTs using "VBTSnap".  The images
   are all shaped "width" by "height" millimeters and laid out in a grid.

   If "layoutAxis" is horizontal, then there are "size" images laid out
   horizontally in each row, with rows laid out top to bottom.  If
   "layoutAxis" is vertical, then there are "size" images per column and
   the columns are laid out left to right.

   "add" adds a new snapshot to the album.  It occupies the next slot
   either vertically or horizontally (depending on "layoutAxis").

   "clear" removes all snapshots from the album. *)

END VBTAlbum.
