(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* Last modified on Fri Sep 11 22:45:44 PDT 1992 by mhb *)

(* This interface used by widgets in VBTKit to retrieve their
   pixmap, cursor, and other resources.  The resources are
   bundled in VBTKitBundle.  Resources are look for using the
   path consisting of the value of the environment variable
   VBTKITPATH followed by VBTKitBundle. *)

INTERFACE VBTKitResources;

IMPORT Cursor, Pixmap;

PROCEDURE Get (name: TEXT): TEXT;
(* Return the contents of the resource "name".  It is a runtime
   exception if "name" cannot be read successfully. *)

PROCEDURE GetPixmap (name: TEXT): Pixmap.T;
(* Return the pixmap "name".  It is a runtime exception if the
   pixmap is not found or if it cannot be read successfully. *)

PROCEDURE GetCursor (name: TEXT): Cursor.T;
(* Return the cursor "name".  It is a runtime exception if the
   cursor cannot be read from the bundle successfully. *)

END VBTKitResources.

