(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Jun 16 12:58:06 PDT 1992 by muller   *)
(*      modified on Thu Jun 11 23:09:14 1992 by mhb      *)

MODULE VBTColors;

IMPORT PaintOp, VBT;

TYPE
  Colors = PaintOp.ColorScheme BRANDED OBJECT END;

VAR mu := NEW(MUTEX);

PROCEDURE Put (v: VBT.T; colors: PaintOp.ColorScheme) =
  BEGIN
    LOCK mu DO VBT.PutProp(v, NARROW(colors, Colors)) END
  END Put;

PROCEDURE Get (v: VBT.T): PaintOp.ColorScheme =
  VAR colors: Colors;
  BEGIN
    LOCK mu DO
      colors := NARROW(VBT.GetProp(v, TYPECODE(Colors)), Colors)
    END;
    IF colors = NIL THEN
      RETURN PaintOp.bgFg
    ELSE
      RETURN NARROW(colors, PaintOp.ColorScheme)
    END
  END Get;

BEGIN
END VBTColors.
