(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Fri Oct 16 10:21:13 PDT 1992 by steveg *)

(* "XTrestle" checks for X-style "-display" and "-geometry" 
   switches and installs a top-level window accordingly.
*)

INTERFACE XTrestle;

<* PRAGMA LL *>

IMPORT TrestleComm, VBT;

PROCEDURE Install (v          : VBT.T;
                   applName   : TEXT    := NIL;
                   inst       : TEXT    := NIL;
                   windowTitle: TEXT    := NIL;
                   iconTitle  : TEXT    := NIL;
                   bgColorR   : REAL    := -1.0;
                   bgColorG   : REAL    := -1.0;
                   bgColorB   : REAL    := -1.0;
                   iconWindow : VBT.T   := NIL   )
  RAISES {TrestleComm.Failure}; <* LL.sup = VBT.mu *>
(* Like "Trestle.Install" except that the locking level is different and
   the command line is parsed for X-style "-display" and "-geometry"
   options (as described in the X man page or "X Window System" by
   Scheifler and Gettys).

   If there is a "-display" argument, it will be made the default trestle
   connection.

   If there is a "-geometry" argument, it will affect the first install call. *)

END XTrestle.
