(* Copyright 1992 Digital Equipment Corporation.           *)
(* Distributed only by permission.                         *)
(* Last modified on Tue Aug 25 14:42:06 PDT 1992 by johnh*)
(*      modified on Wed May 13 07:34:39 1992 by mhb    *)


MODULE Algorithm;

IMPORT AlgorithmClass, FormsVBT, List, Sx, TextRd, Thread, Wr, ZeusClass;
<* PRAGMA LL *>

REVEAL
  T = AlgorithmClass.T BRANDED OBJECT
      OVERRIDES
        run               := DefaultRun;
        init              := DefaultInit;
        snapshot          := DefaultSnapshot;
        restore           := DefaultRestore;
        updateEventCounts := DefaultUpdateCts;
      END;


EXCEPTION FatalError;
<*FATAL FatalError*>

PROCEDURE DefaultRun (<*UNUSED*> v: T) RAISES {Thread.Alerted} = 
<* LL = {} *>
  BEGIN
    RAISE FatalError
  END DefaultRun;

PROCEDURE DefaultInit (v: T): T =
<* LL = VBT.mu *>
  BEGIN
    v.evtMu := NEW(MUTEX);
    v.reactivity(FALSE);
    RETURN v
  END DefaultInit;

PROCEDURE DefaultSnapshot (v: T; wr: Wr.T) RAISES {ZeusClass.Error} =
<* LL = VBT.mu *>
  BEGIN
    IF v.data # NIL THEN
      TYPECASE v.data OF
      | FormsVBT.T (fv) =>
          TRY
            fv.snapshot(wr);
          EXCEPT
            FormsVBT.Error (msg) =>
              RAISE ZeusClass.Error(
                      "Algorithm.DefaultSnapshot FV error: " & msg);
          ELSE
            RAISE ZeusClass.Error("Algorithm.DefaultSnapshot error");
          END;
      ELSE
      END;
    END;
    ZeusClass.T.snapshot(v, wr);
  END DefaultSnapshot;


PROCEDURE DefaultRestore (v: T; list: List.T) RAISES {ZeusClass.Error} =
<* LL = VBT.mu *>
  VAR
    mylist: List.T;
    trd   : TextRd.T;
  BEGIN
    IF List.Length(list) = 0 THEN RETURN END;
    IF v.data # NIL THEN
      TRY
        TYPECASE v.data OF
        | FormsVBT.T (fv) =>
            mylist := List.Pop(list); (* Snapshot brackets w/ parens *)
            trd := TextRd.New(Sx.ToText(mylist));
            fv.restore(trd);
        ELSE
        END;
      EXCEPT
      ELSE
        RAISE ZeusClass.Error("Algorithm.DefaultRestore error");
      END;
    END;
    ZeusClass.T.restore(v, list);
  END DefaultRestore;

PROCEDURE DefaultUpdateCts (<*UNUSED*> v: T; <*UNUSED*> reset: BOOLEAN) =
  <* LL = VBT.mu *>
  BEGIN
  END DefaultUpdateCts;
  
BEGIN END Algorithm.

