(* Copyright 1992 Digital Equipment Corporation.           *)
(* Distributed only by permission.                         *)
(* Last modified on Thu Aug 20 19:13:49 PDT 1992 by johnh*)
(*      modified on Wed May 13 00:49:38 1992 by mhb  *)

(* The definition of the base class for Zeus algorithms and views. *)

INTERFACE ZeusClass;

IMPORT List, VBT, Wr;

EXCEPTION Error(TEXT);

TYPE
  T <: Public;
  Private <: VBT.T;
  Public = Private OBJECT
           METHODS
             (* LL = VBT.mu *)
             install    ();
             delete     ();
             snapshot   (wr: Wr.T) RAISES {Error};
             restore    (rd: List.T) RAISES {Error};
             config     (state: StateChange; object: T);
             reactivity (on: BOOLEAN);
           END;

TYPE StateChange = {ViewAttached, ViewDetached, LockedBy, UnlockedBy};

(* install(v) is called to install into the WM all windows that v needs.
   This procedure should be called only once for each v.  Typically, this
   procedure will fork a thread to wait for the installed window(s) to be
   deleted.  At that time, it should perform any necessary cleanup (calling
   Zeus.DetachView before VBT.Discarding itself, if v is a "view,"
   e.g.). *)

(* delete(v) is called to delete from the WM all windows v has installed.
   This procedure will never be called more than once; if it is called, it
   is guaranteed that the install method was previously invoked.

   Note that there are two ways for v to be deleted: by the user issuing a
   delete command to the WM, or by invoking v's delete method (in response
   to some command in the control panel).  Thus any necessary cleanup
   should be performed by the thread that install() forks, rather than by
   the delete() method. *)

(* snapshot(v, wr) is called to snapshot the state of v as zero or more
   s-expressions that are written into the supplied writer.  The state
   should include a description and location of any windows that v
   installs, any data it has gotten from the user, and so on. *)

(* restore(v, list) is passed a list representing a sequence of
   s-expressions.  Specifically, if list # NIL, then List.First(list)
   represents the first s-expression that snapshot(v, wr) wrote to the
   writer, etc.  The restore method should restore the static state of v
   from this description.  If the list is NIL, then v should be restored to
   an initial state.  This method and v's snapshot method should be
   inverses, so restore should do List.Pop(list) once for each s-exp that
   snapshot writes. *)

(* config(v, whatChanged, instigator) is called by Zeus whenever Zeus's
   "configuration" changes.  A configuration change happens when a view is
   attached or detached, or a view has acquired or released the edit
   lock. *)

(* reactivity(v, on) is called by ZeusPanel to enable (on=TRUE) or disable
   (on=FALSE) feedback events.  It will be called when the algorithm
   pauses. *)


(* If a subtype overrides one or more of the default methods, the
   overriding method should call the method of the supertype. *)
END ZeusClass.
