PROCEDURE GetPriority (): INTEGER;
(* Report what priority the user has set in the control panel. *)

PROCEDURE SetPriority (priority: INTEGER);
(* Change the priority.  Client algorithms can use this to cause events to
   be generated that are not included in the "Step" command.  To do so, the
   algorithm first retrieves the current priority, then lowers it (probably
   to 0), does some stuff, then restores the priority to its initial
   value. *)

PROCEDURE GetDelayTime (): REAL;
(* Report what the delay time the user has set in the control panel.
   (There should probably be a procedure that will be tickled whenever the
   delay time is changed.) *)

PROCEDURE IgnoreDelayTime (ignore: BOOLEAN := TRUE);
(* Normally, ZeusPanel will pause after each event the amount of time
   specified by the user.  If views are able to slow themselves down (as is
   the case when the Anim package is used), then ZeusPanel should not
   pause. *)

