/* Copyright (C) 1990, Digital Equipment Corporation.         */
/* All rights reserved.                                       */
/* See the file COPYRIGHT for a full description.             */

/* Last modified on Fri Feb 28 11:23:32 PST 1992 by kalsow    */
/*      modified on Wed Mar 27 03:00:50 1991 by muller        */

/* for OKI */

/* These are the storage classes and type qualifiers */

#define _VOLATILE

#define _PRIVATE static
#define _IMPORT  extern
#define _EXPORT        

#define _LOCAL_PROC  static
#define _LOCAL       auto

#define _STACK_GROWS_DOWN
/* comment this out if stacks grow up (toward increasing addresses) */

#define _HAS_NO_BCOPY
/* comment this out if you have bcopy, bzero */

#define _setjmp setjmp
#define _longjmp longjmp
/* comment these out if you have _setjmp, _longjmp.  
   Otherwise, plain setjmp, longjmp will be used. */

/* A Modula-3 procedure value can be either a C function pointer or a
   pointer to a CLOSURE struct. The first field of CLOSURE structs
   "marker", is always equal to CLOSURE_MARKER.

   To test if a procedure value is a closure or not, we assume is it
   one and look at the marker field. If we don't find CLOSURE_MARKER,
   we have a C function pointer.

   Since a C function pointer is the address of the first instruction,
   we chose the value of CLOSURE_MARKER to be different from any
   instruction that may start a procedure. */
   
#define _CLOSURE_MARKER (-1)      /* illegal opcode */
#define _IS_CLOSURE(p) ((p != 0) && ((_CLOSURE *)p)->marker == _CLOSURE_MARKER)



/* NILCHECKB must evaluate its argument 'e' (a char*) and
   generate a trap if it is NIL (0). */
#define _NILCHKCHAR volatile char
_IMPORT _NILCHKCHAR _M3__nil_check_char;
#define _NILCHECKB(e) _M3__nil_check_char = ((char*)(e))[-1];


/* The type 'signed_char' is 'signed char' in ANSI-C,
   but CC may not like that. Same for 'signed_int'. */
typedef char signed_char;
typedef int  signed_int;

