#include "M3Runtime.h"
_PRIVATE _TXT __file = { {0, 1}, "IntegerToIntegerTable.m3", 25};
/*------------------*/
_PRIVATE _REAL _real[] = {
  0.0,
  1.0,
  0.0625,
  4.0,
  0.75,
  1.5,
  1.25
};
/*------------------*/
/*------------------*/
/*------------------*/
#define _t223565b7 _INTEGER
#define _t95a227bb _VOID
typedef _ADDRESS _t96076584;
typedef _ADDRESS _td28c3ed0;
_IMPORT _TYPE* _td28c3ed0_TC;
#define _t2b3260be unsigned char
typedef _t2b3260be (*_te472781b)();
typedef _t223565b7 (*_te287e46a)();
typedef _t2b3260be (*_t281f5950)();
typedef _t95a227bb (*_t89e7331d)();
typedef _t96076584 (*_t6113ebc8)();
typedef struct _rec_tef28c2a6 *_t92850976;
typedef _ADDRESS _t76b14e78;
_IMPORT _TYPE* _t76b14e78_TC;
struct _rec_tef28c2a6 {
   _t76b14e78 first;
   _t92850976 tail;
};
typedef struct _rec_tef28c2a6 _tef28c2a6;
_IMPORT _TYPE* _t92850976_TC;
typedef _t92850976 (*_t0a69263d)();
typedef _t2b3260be (*_t6c8d469b)();
typedef _t2b3260be (*_t592a3657)();
typedef struct {
   _t2b3260be (*in)();
   _t223565b7 (*get)();
   _t2b3260be (*put)();
   _t2b3260be (*delete)();
   _t95a227bb (*clear)();
   _t96076584 (*copy)();
   _t92850976 (*toKeyList)();
   _t92850976 (*toValueList)();
   _t92850976 (*toAssocList)();
   _t2b3260be (*enumerate)();
} _t96076584_methods;
_IMPORT _TYPE* _t96076584_TC;
typedef _t96076584 (*_t5f7b13c1)();
#define _tdfa73f81 int
struct _rec_t5e18e439 {
   _t223565b7 key;
   _t223565b7 value;
};
typedef struct _rec_t5e18e439 _t5e18e439;
typedef struct _array_tbf05c01a *_tf8a86f10;
struct _array_tbf05c01a { _t5e18e439 *elts; int size[1]; };
typedef struct _array_tbf05c01a _tbf05c01a;
_IMPORT _TYPE* _tf8a86f10_TC;
typedef _ADDRESS _t91096db0;
_IMPORT _TYPE* _t91096db0_TC;
#define _t91aa2fb1 _REAL
struct _rec_t056bf944 {
   _t91096db0 mutex;
   _tf8a86f10 buckets;
   _t2b3260be nullKeyPresent;
   _t223565b7 nullKeyValue;
   _t2b3260be deletedKeyPresent;
   _t223565b7 deletedKeyValue;
   _t91aa2fb1 avgProbes;
   _tdfa73f81 numFilled;
   _tdfa73f81 numDeleted;
};
typedef struct _rec_t056bf944 _t056bf944;
typedef _ADDRESS _tbb8a9dbe;
typedef struct {
   _t056bf944 rec;
} _tbb8a9dbe_fields;
_IMPORT _TYPE* _tbb8a9dbe_TC;
struct _array_t36adabfd { _tdfa73f81 *elts; int size[1]; };
typedef struct _array_t36adabfd _t36adabfd;
typedef _tf8a86f10 (*_t9bc60a63)();
typedef _t2b3260be (*_t5cb85ad0)();
typedef _t2b3260be (*_t6d6219e1)();
typedef _t223565b7 (*_tacecfc6b)();
typedef _t2b3260be (*_t09d96bff)();
typedef _t2b3260be (*_t57c9f068)();
typedef _t95a227bb (*_td8791be0)();
typedef _t95a227bb (*_t6f18d764)();
typedef _t2b3260be (*_ta9afb6a2)();
typedef _t95a227bb (*_t1e5e876a)();
typedef _t96076584 (*_tab3bb066)();
typedef _t92850976 (*_t8646f1d7)();
typedef _t2b3260be (*_t055138be)();
typedef _ADDRESS _t352479bd;
_IMPORT _TYPE* _t352479bd_TC;
typedef _t223565b7* _tc0059bc6;
_IMPORT _TYPE* _tc0059bc6_TC;
typedef _t223565b7 (*_t95892aae)();
typedef _t92850976 (*_t96b982b7)();
typedef _t92850976 (*_tf4eaeaa5)();
/*------------------*/
_IMPORT _EXCEPTION_NAME IntegerToIntegerTable__NotFound;
_EXPORT _t96076584 IntegerToIntegerTable__New ();
_LOCAL_PROC _tf8a86f10 IntegerToIntegerTable__NewBuckets ();
_LOCAL_PROC _t2b3260be IntegerToIntegerTable__Put ();
_LOCAL_PROC _t2b3260be IntegerToIntegerTable__DoPut ();
_LOCAL_PROC _t223565b7 IntegerToIntegerTable__Get ();
_LOCAL_PROC _t2b3260be IntegerToIntegerTable__In ();
_LOCAL_PROC _t2b3260be IntegerToIntegerTable__DoIn ();
_LOCAL_PROC _t2b3260be IntegerToIntegerTable__Delete ();
_LOCAL_PROC _t2b3260be IntegerToIntegerTable__DoDelete ();
_LOCAL_PROC _t95a227bb IntegerToIntegerTable__AvgProbesTooHigh ();
_LOCAL_PROC _t95a227bb IntegerToIntegerTable__Rehash ();
_LOCAL_PROC _t2b3260be IntegerToIntegerTable__CopyEntries ();
_LOCAL_PROC _t95a227bb IntegerToIntegerTable__Clear ();
_LOCAL_PROC _t96076584 IntegerToIntegerTable__Copy ();
_LOCAL_PROC _t92850976 IntegerToIntegerTable__ToKeyList ();
_LOCAL_PROC _t92850976 IntegerToIntegerTable__ToValueList ();
_LOCAL_PROC _t92850976 IntegerToIntegerTable__ToAssocList ();
_LOCAL_PROC _t2b3260be IntegerToIntegerTable__Enumerate ();
_IMPORT _t223565b7 Word__Times ();
_IMPORT _t223565b7 Word__Mod ();
_IMPORT _t92850976 List__New ();
_IMPORT _t92850976 List__List2 ();
/*------------------*/





_PRIVATE _tdfa73f81 _openConst1 [] = {23, 89, 181, 359, 719, 1447, 2887, 4093, 5791, 8191, 11579, 16381, 23167, 32749, 46337, 65521, 92681, 131071, 185363, 262139, 370723, 524287, 741431, 1048573, 1482907, 2097143, 2965819, 4194301, 5931641, 8388593, 11863279, 16777213, 23726561, 33554393, 47453111, 67108859, 94906249, 134217689};
_PRIVATE _t36adabfd IntegerToIntegerTable__standardSize = { _openConst1, 38}
;
_PRIVATE _t5e18e439 IntegerToIntegerTable__NullEntry = {
   0
};
/*------------------*/


#line 129 "IntegerToIntegerTable.m3"
  _EXPORT _t96076584 IntegerToIntegerTable__New (initialSize)  _tdfa73f81 initialSize;  {  _LOCAL _tbb8a9dbe table;  _LOCAL _t96076584 _result;
#line 129




   _tbb8a9dbe _z0; 

   _tbb8a9dbe _z1;  _t352479bd _z3; 
   _t91096db0 _z2; 
   _tf8a86f10 _z4; 
#line 129 "IntegerToIntegerTable.m3"
 



   table = _NIL; 
#line 129
   _result = _NIL; 



   {  _ADDRESS _ptr = (_ADDRESS)_TNEWOBJ (_tbb8a9dbe_TC);  _z0 = (_tbb8a9dbe) _ptr;   }  table = _z0; 

   _NILCHECKB (_z1 = table);  _z3 = (_ADDRESS) & (((_tbb8a9dbe_fields*)(((_ADDRESS)_z1)+4))->rec);  {  _LOCAL _t056bf944 * t;
#line 135
 t = (_t056bf944*) _z3; 
      {  _ADDRESS _ptr = (_ADDRESS)_TNEWOBJ (_t91096db0_TC);  _z2 = (_t91096db0) _ptr;   }  ((*t).mutex) = _z2; 
      _z4 = IntegerToIntegerTable__NewBuckets (initialSize);  ((*t).buckets) = _z4; 

      ((*t).nullKeyPresent) =  0 ; 
      ((*t).nullKeyValue) =  0 ; 
      ((*t).deletedKeyPresent) =  0 ; 
      ((*t).deletedKeyValue) =  0 ; 
      ((*t).avgProbes) = _real[0]; 
      ((*t).numFilled) =  0 ; 
      ((*t).numDeleted) =  0 ;   } 


   return (_t96076584)table;   } /* APPROX FRAME SIZE: 124 bytes */ 

#line 151 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _tf8a86f10 IntegerToIntegerTable__NewBuckets (size)  _tdfa73f81 size;  {  _LOCAL _tdfa73f81 i;  _LOCAL _tf8a86f10 _result;
#line 151





   _t2b3260be _z3;  _t352479bd _z4;  _tdfa73f81 _z5; 
   _t352479bd _z2; 
   _tf8a86f10 _z0;  _tf8a86f10 _z1; 
   _t223565b7 _z6;  _t223565b7 _z7;  _t223565b7 _z8; 
#line 151 "IntegerToIntegerTable.m3"
 
   i = 0; 
#line 151
   _result = _NIL; 



   i =  0 ; 
   _L20:   _z3 = 0; if ((i <  37 )) {  {  _t36adabfd* _array = & IntegerToIntegerTable__standardSize;  _z5 = i;  if (_z5 >= (_array->size[0])) _RANGEFAULT(&__file.str,156);
#line 156
 _z4 = (_ADDRESS) (_array->elts + _z5);   }  _z3 = (size > (*(_tdfa73f81*)_z4));  }  if (!(_z3)) goto _L21;  i +=  1 ;
#line 156
 goto _L20;   _L21:; 
   {  _t36adabfd* _array = & IntegerToIntegerTable__standardSize;  _z5 = i;  if (_z5 >= (_array->size[0])) _RANGEFAULT(&__file.str,157);
#line 157
 _z2 = (_ADDRESS) (_array->elts + _z5);   }  size = (*(_tdfa73f81*)_z2); 
   {  _tbf05c01a* _ptr;  struct {int *elts; int nb_dims; int dim[1];} _sizes;  _sizes.elts = _sizes.dim; _sizes.nb_dims = 1;
#line 158
 _sizes.dim[0] = size;  _ptr = (_tbf05c01a*) _TNEWA (_tf8a86f10_TC, &_sizes);  _z0 = (_tf8a86f10) _ptr;   }  _z1 = _z0;
#line 158
 {  _LOCAL _tf8a86f10 rb;  rb = _NIL;  rb = (_tf8a86f10) _z1;  _NILCHECKB (_z1 = rb);  _z2 = (_ADDRESS) & (*((_tbf05c01a*)  _z1));
#line 158
 {  _LOCAL _tbf05c01a buck;  _COPY (_z2, &buck, sizeof (_tbf05c01a)); 
         _z6 =  0 ;  _z7 = buck.size[0] - 1;  _z8 = _z7;  {  _LOCAL _t223565b7 i;  for (; _z6 <= _z8; _z6 += 1){
#line 159
 i = (_t223565b7) _z6;  {  _tbf05c01a* _array = & buck;  _z7 = i;  if (_z7 >= (_array->size[0])) _RANGEFAULT(&__file.str,159);
#line 159
 _z4 = (_ADDRESS) (_array->elts + _z7);   }  (*(_t5e18e439*)_z4) = IntegerToIntegerTable__NullEntry;   }   } 
         return rb;   }   }   } /* APPROX FRAME SIZE: 140 bytes */ 

#line 164 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _t2b3260be IntegerToIntegerTable__Put (table, key, value)  _tbb8a9dbe table;  _t223565b7 key;  _t223565b7 * value;
#line 164
 {  _LOCAL _tdfa73f81 probes;  _LOCAL _t2b3260be found;  _LOCAL _t2b3260be crowded;  _LOCAL _t2b3260be _result; 







   _tbb8a9dbe _z1;  _t352479bd _z3; 
   _t352479bd _z2;  _LOCK_HANDLER _h24; 
#line 195
   _tf8a86f10 _z5;  _t2b3260be _z10; 







   _t91aa2fb1 _z9; 

   _t2b3260be _z6;  _tdfa73f81 _z0;  _tf8a86f10 _z4; 
#line 164 "IntegerToIntegerTable.m3"
 




   probes = 0; 
   found = 0;  crowded = 0; 
#line 164
   _result = 0; 







   _NILCHECKB (_z1 = table);  _z3 = (_ADDRESS) & (((_tbb8a9dbe_fields*)(((_ADDRESS)_z1)+4))->rec);  {  _LOCAL _t056bf944 * t;
#line 172
 t = (_t056bf944*) _z3; 
      _z2 = (_ADDRESS) ((*t).mutex);  Thread__Acquire (_z2);  _PUSH_LOCK (_h24, _z2); 


         if ((key == ((_t223565b7) 0 ))) { 
            ((*t).nullKeyValue) = (*value); 
            if (((*t).nullKeyPresent)) { 
               Thread__Release (_h24.mutex);  _CUT_TO_NEXT_HANDLER (_h24);  return  1 ;   }   

               ((*t).nullKeyPresent) =  1 ;  Thread__Release (_h24.mutex);  _CUT_TO_NEXT_HANDLER (_h24);  return  0 ;
#line 181
    } 

         if ((key == ((_t223565b7) -1 ))) { 
            ((*t).deletedKeyValue) = (*value); 
            if (((*t).deletedKeyPresent)) { 
               Thread__Release (_h24.mutex);  _CUT_TO_NEXT_HANDLER (_h24);  return  1 ;   }   

               ((*t).deletedKeyPresent) =  1 ;  Thread__Release (_h24.mutex);  _CUT_TO_NEXT_HANDLER (_h24);  return  0 ;
#line 188
    } 




         _z3 = (_ADDRESS) & key;  {  _LOCAL _t223565b7 * hash;  hash = (_t223565b7*) _z3; 
            _L28:;  
               _NILCHECKB (_z5 = ((*t).buckets));  _z10 = IntegerToIntegerTable__DoPut (&(*t), &(*((_tbf05c01a*)  _z5)), (*hash), key, &(*value), &probes, &crowded);
#line 195
 found = _z10; 






               if ((!crowded)) { 
                  _z9 = _CVTIF (probes);  ((*t).avgProbes) = (((_real[1] - _real[2]) * ((*t).avgProbes)) + (_real[2] * _z9));
#line 203


                  _z6 = 0; if ((((*t).avgProbes) > _real[3])) {  _NILCHECKB (_z4 = ((*t).buckets));  _z0 = (*((_tbf05c01a*)  _z4)).size[0];
#line 205
 _z6 = (_z0 <  134217689 );  }  if (_z6) { 

                     IntegerToIntegerTable__AvgProbesTooHigh (&(*t), probes);   } 

                  Thread__Release (_h24.mutex);  _CUT_TO_NEXT_HANDLER (_h24);  return found;   } 



               IntegerToIntegerTable__Rehash (&(*t),  1 );  goto _L28;     }     }   } /* APPROX FRAME SIZE: 164 bytes */
#line 213


#line 220 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _t2b3260be IntegerToIntegerTable__DoPut (t, buck, hash, key, value, probes, crowded)  _t056bf944 * t;  _tbf05c01a * buck;
#line 220
 _t223565b7 hash;  _t223565b7 key;  _t223565b7 * value;  _tdfa73f81 * probes;  _t2b3260be * crowded;  {  _LOCAL _tdfa73f81 i;
#line 220
 _LOCAL _tdfa73f81 free;  _LOCAL _t2b3260be _result; 
#line 236
   _tdfa73f81 _z0;  _t223565b7 _z1; 
   _t223565b7 _z2; 
   _t223565b7 _z3;  _t223565b7 _z5; 






   _t352479bd _z4;  _tdfa73f81 _z6;  _t352479bd _z7; 
#line 220 "IntegerToIntegerTable.m3"
 
#line 233
   i = 0;  free = 0; 
#line 220
   _result = 0; 
#line 236
   _z0 = (*buck).size[0];  _z1 = _z0;  {  _LOCAL _tdfa73f81 M;  M = 0;  M = (_tdfa73f81) _z1; 
      _z2 = (unsigned)hash % (unsigned)M;  _z1 = _z2;  {  _LOCAL _t223565b7 chainBase;  chainBase = (_t223565b7) _z1;
#line 237

         _z3 = (unsigned)hash * (unsigned) 1052823 ;  _z5 = (unsigned)_z3 % (unsigned)(M -  1 );  _z2 = ( 1  + _z5);
#line 238
 {  _LOCAL _t223565b7 chainStep;  chainStep = (_t223565b7) _z2; 

            _z1 = chainBase; if (_z1 < 0) _RANGEFAULT(&__file.str,240);  i = _z1; 
            (*probes) =  0 ; 
            free = M; 
            _L33:;  
               (*probes) +=  1 ; 
               {  _tbf05c01a* _array = & (*buck);  _z6 = i;  if (_z6 >= (_array->size[0])) _RANGEFAULT(&__file.str,245);
#line 245
 _z4 = (_ADDRESS) (_array->elts + _z6);   }  _z7 = (_ADDRESS) & (*(_t5e18e439*)_z4);  {  _LOCAL _t5e18e439 * entry;
#line 245
 entry = (_t5e18e439*) _z7; 

                  if ((((*entry).key) == ((_t223565b7) 0 ))) { 

                     if ((free != ((_t223565b7)M))) { 
                        {  _tbf05c01a* _array = & (*buck);  _z6 = free;  if (_z6 >= (_array->size[0])) _RANGEFAULT(&__file.str,250);
#line 250
 _z4 = (_ADDRESS) (_array->elts + _z6);   }  ((*(_t5e18e439*)_z4).key) = key; 
                        {  _tbf05c01a* _array = & (*buck);  _z6 = free;  if (_z6 >= (_array->size[0])) _RANGEFAULT(&__file.str,251);
#line 251
 _z4 = (_ADDRESS) (_array->elts + _z6);   }  ((*(_t5e18e439*)_z4).value) = (*value); 
                        {  register int _r;  _r = ((*t).numDeleted) -  1 ;  if (_r < 0) _RANGEFAULT(&__file.str,252);
#line 252
 ((*t).numDeleted) = _r;   }  goto _L36;   }   

                        ((*entry).key) = key; 
                        ((*entry).value) = (*value);    _L36:; 

                     ((*t).numFilled) +=  1 ; 
                     (*crowded) =  0 ; 
                     return  0 ;   } 
                  if ((((*entry).key) == ((_t223565b7) -1 ))) { 

                     if ((free == ((_t223565b7)M))) {  free = i;   }  goto _L35;   } 
                  if ((((*entry).key) == ((_t223565b7)key))) { 

                     ((*entry).value) = (*value); 
                     (*crowded) =  0 ; 
                     return  1 ;   }  _L35:; 


                  if (((*probes) >= M)) { 

                     if ((free == ((_t223565b7)M))) { 

                        (*crowded) =  1 ;  goto _L39;   }   


                        {  _tbf05c01a* _array = & (*buck);  _z6 = free;  if (_z6 >= (_array->size[0])) _RANGEFAULT(&__file.str,277);
#line 277
 _z4 = (_ADDRESS) (_array->elts + _z6);   }  ((*(_t5e18e439*)_z4).key) = key; 
                        {  _tbf05c01a* _array = & (*buck);  _z6 = free;  if (_z6 >= (_array->size[0])) _RANGEFAULT(&__file.str,278);
#line 278
 _z4 = (_ADDRESS) (_array->elts + _z6);   }  ((*(_t5e18e439*)_z4).value) = (*value); 
                        {  register int _r;  _r = ((*t).numDeleted) -  1 ;  if (_r < 0) _RANGEFAULT(&__file.str,279);
#line 279
 ((*t).numDeleted) = _r;   } 
                        ((*t).numFilled) +=  1 ; 
                        (*crowded) =  0 ;    _L39:; 

                     return  0 ;   }   } 


               _z5 = _IMODXP((i + chainStep), M);  _z1 = _z5; if (_z1 < 0) _RANGEFAULT(&__file.str,286);  i = _z1;
#line 286
 goto _L33;     }   }   }   } /* APPROX FRAME SIZE: 168 bytes */ _PRIVATE _EXCEPTION _raises_3 [] = {
   & IntegerToIntegerTable__NotFound, (_EXCEPTION) _NIL};


#line 291 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _t223565b7 IntegerToIntegerTable__Get (table, key)  _tbb8a9dbe table;  _t223565b7 key;  {  _LOCAL _t223565b7 value;
#line 291
 _LOCAL _t223565b7 _result; 


   _t2b3260be _z4; 
#line 291 "IntegerToIntegerTable.m3"
 


   _z4 = IntegerToIntegerTable__In (table, key, &value);  if (_z4) {  return value;   }    _RAISE (& IntegerToIntegerTable__NotFound, _NIL);
#line 294
    } /* APPROX FRAME SIZE: 68 bytes */ 

#line 298 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _t2b3260be IntegerToIntegerTable__In (table, key, value)  _tbb8a9dbe table;  _t223565b7 key;  _t223565b7 * value;
#line 298
 {  _LOCAL _tdfa73f81 probes;  _LOCAL _t2b3260be found;  _LOCAL _t2b3260be _result; 









   _tbb8a9dbe _z1;  _t352479bd _z3; 
   _t352479bd _z2;  _LOCK_HANDLER _h43; 
#line 338
   _tf8a86f10 _z5;  _t2b3260be _z9; 






   _t91aa2fb1 _z10; 

   _t2b3260be _z6;  _tdfa73f81 _z0;  _tf8a86f10 _z4; 
#line 298 "IntegerToIntegerTable.m3"
 






   probes = 0; 
   found = 0; 
#line 298
   _result = 0; 









   _NILCHECKB (_z1 = table);  _z3 = (_ADDRESS) & (((_tbb8a9dbe_fields*)(((_ADDRESS)_z1)+4))->rec);  {  _LOCAL _t056bf944 * t;
#line 308
 t = (_t056bf944*) _z3; 
      _z2 = (_ADDRESS) ((*t).mutex);  Thread__Acquire (_z2);  _PUSH_LOCK (_h43, _z2); 



         if ((key == ((_t223565b7) 0 ))) { 

            if (((*t).nullKeyPresent)) { 
               (*value) = ((*t).nullKeyValue); 
               Thread__Release (_h43.mutex);  _CUT_TO_NEXT_HANDLER (_h43);  return  1 ;   }   

               (*value) =  0 ; 
               Thread__Release (_h43.mutex);  _CUT_TO_NEXT_HANDLER (_h43);  return  0 ;     } 


         if ((key == ((_t223565b7) -1 ))) { 

            if (((*t).deletedKeyPresent)) { 
               (*value) = ((*t).deletedKeyValue); 
               Thread__Release (_h43.mutex);  _CUT_TO_NEXT_HANDLER (_h43);  return  1 ;   }   

               (*value) =  0 ; 
               Thread__Release (_h43.mutex);  _CUT_TO_NEXT_HANDLER (_h43);  return  0 ;     } 





         _z3 = (_ADDRESS) & key;  {  _LOCAL _t223565b7 * hash;  hash = (_t223565b7*) _z3; 

            _NILCHECKB (_z5 = ((*t).buckets));  _z9 = IntegerToIntegerTable__DoIn (&(*t), &(*((_tbf05c01a*)  _z5)), (*hash), key, &(*value), &probes);
#line 338
 found = _z9; 






            _z10 = _CVTIF (probes);  ((*t).avgProbes) = (((_real[1] - _real[2]) * ((*t).avgProbes)) + (_real[2] * _z10));
#line 345


            _z6 = 0; if ((((*t).avgProbes) > _real[3])) {  _NILCHECKB (_z4 = ((*t).buckets));  _z0 = (*((_tbf05c01a*)  _z4)).size[0];
#line 347
 _z6 = (_z0 <  134217689 );  }  if (_z6) { 

               IntegerToIntegerTable__AvgProbesTooHigh (&(*t), probes);   } 

            Thread__Release (_h43.mutex);  _CUT_TO_NEXT_HANDLER (_h43);  return found;   }     }   } /* APPROX FRAME SIZE: 160 bytes */
#line 351


#line 358 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _t2b3260be IntegerToIntegerTable__DoIn (t, buck, hash, key, value, probes)  _t056bf944 * t;  _tbf05c01a * buck;
#line 358
 _t223565b7 hash;  _t223565b7 key;  _t223565b7 * value;  _tdfa73f81 * probes;  {  _LOCAL _tdfa73f81 i;  _LOCAL _tdfa73f81 free;
#line 358
 _LOCAL _t2b3260be _result; 
#line 376
   _tdfa73f81 _z0;  _t223565b7 _z1; 
   _t223565b7 _z2; 
   _t223565b7 _z3;  _t223565b7 _z5; 






   _t352479bd _z4;  _tdfa73f81 _z6;  _t352479bd _z7; 
#line 358 "IntegerToIntegerTable.m3"
 
#line 373
   i = 0;  free = 0; 
#line 358
   _result = 0; 
#line 376
   _z0 = (*buck).size[0];  _z1 = _z0;  {  _LOCAL _tdfa73f81 M;  M = 0;  M = (_tdfa73f81) _z1; 
      _z2 = (unsigned)hash % (unsigned)M;  _z1 = _z2;  {  _LOCAL _t223565b7 chainBase;  chainBase = (_t223565b7) _z1;
#line 377

         _z3 = (unsigned)hash * (unsigned) 1052823 ;  _z5 = (unsigned)_z3 % (unsigned)(M -  1 );  _z2 = ( 1  + _z5);
#line 378
 {  _LOCAL _t223565b7 chainStep;  chainStep = (_t223565b7) _z2; 

            _z1 = chainBase; if (_z1 < 0) _RANGEFAULT(&__file.str,380);  i = _z1; 
            (*probes) =  0 ; 
            free = M; 
            _L49:;  
               (*probes) +=  1 ; 
               {  _tbf05c01a* _array = & (*buck);  _z6 = i;  if (_z6 >= (_array->size[0])) _RANGEFAULT(&__file.str,385);
#line 385
 _z4 = (_ADDRESS) (_array->elts + _z6);   }  _z7 = (_ADDRESS) & (*(_t5e18e439*)_z4);  {  _LOCAL _t5e18e439 * entry;
#line 385
 entry = (_t5e18e439*) _z7; 
                  if ((((*entry).key) == ((_t223565b7) 0 ))) { 

                     (*value) =  0 ; 
                     return  0 ;   } 
                  if ((((*entry).key) == ((_t223565b7) -1 ))) { 

                     if ((free == ((_t223565b7)M))) {  free = i;   }  goto _L51;   } 

                  if ((key == ((_t223565b7)((*entry).key)))) { 

                     (*value) = ((*entry).value); 
                     if ((free != ((_t223565b7)M))) { 

                        {  _tbf05c01a* _array = & (*buck);  _z6 = free;  if (_z6 >= (_array->size[0])) _RANGEFAULT(&__file.str,399);
#line 399
 _z4 = (_ADDRESS) (_array->elts + _z6);   }  (*(_t5e18e439*)_z4) = (*entry); 
                        ((*entry).key) =  -1 ; 
                        ((*entry).value) =  0 ;   } 

                     return  1 ;   } 
                  if (((*probes) >= M)) { 

                     (*value) =  0 ; 
                     return  0 ;   }  _L51:;   } 


               _z5 = _IMODXP((i + chainStep), M);  _z1 = _z5; if (_z1 < 0) _RANGEFAULT(&__file.str,410);  i = _z1;
#line 410
 goto _L49;     }   }   }   } /* APPROX FRAME SIZE: 144 bytes */ 

#line 415 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _t2b3260be IntegerToIntegerTable__Delete (table, key, value)  _tbb8a9dbe table;  _t223565b7 key;  _t223565b7 * value;
#line 415
 {  _LOCAL _tdfa73f81 probes;  _LOCAL _t2b3260be found;  _LOCAL _t2b3260be _result; 








   _tbb8a9dbe _z1;  _t352479bd _z3; 
   _t352479bd _z2;  _LOCK_HANDLER _h55; 
#line 450
   _tf8a86f10 _z5;  _t2b3260be _z9; 






   _t91aa2fb1 _z10; 

   _t2b3260be _z6;  _tdfa73f81 _z0;  _tf8a86f10 _z4; 




   _t223565b7 _z7; 
   _t91aa2fb1 _z8; 
#line 415 "IntegerToIntegerTable.m3"
 





   probes = 0; 
   found = 0; 
#line 415
   _result = 0; 








   _NILCHECKB (_z1 = table);  _z3 = (_ADDRESS) & (((_tbb8a9dbe_fields*)(((_ADDRESS)_z1)+4))->rec);  {  _LOCAL _t056bf944 * t;
#line 424
 t = (_t056bf944*) _z3; 
      _z2 = (_ADDRESS) ((*t).mutex);  Thread__Acquire (_z2);  _PUSH_LOCK (_h55, _z2); 


         if ((key == ((_t223565b7) 0 ))) { 
            if (((*t).nullKeyPresent)) { 
               (*value) = ((*t).nullKeyValue); 
               ((*t).nullKeyPresent) =  0 ; 
               Thread__Release (_h55.mutex);  _CUT_TO_NEXT_HANDLER (_h55);  return  1 ;   }   

               (*value) =  0 ; 
               Thread__Release (_h55.mutex);  _CUT_TO_NEXT_HANDLER (_h55);  return  0 ;     } 

         if ((key == ((_t223565b7) -1 ))) { 
            if (((*t).deletedKeyPresent)) { 
               (*value) = ((*t).deletedKeyValue); 
               ((*t).deletedKeyPresent) =  0 ; 
               Thread__Release (_h55.mutex);  _CUT_TO_NEXT_HANDLER (_h55);  return  1 ;   }   

               (*value) =  0 ; 
               Thread__Release (_h55.mutex);  _CUT_TO_NEXT_HANDLER (_h55);  return  0 ;     } 




         _z3 = (_ADDRESS) & key;  {  _LOCAL _t223565b7 * hash;  hash = (_t223565b7*) _z3; 
            _NILCHECKB (_z5 = ((*t).buckets));  _z9 = IntegerToIntegerTable__DoDelete (&(*t), &(*((_tbf05c01a*)  _z5)), (*hash), key, &(*value), &probes);
#line 450
 found = _z9; 






            _z10 = _CVTIF (probes);  ((*t).avgProbes) = (((_real[1] - _real[2]) * ((*t).avgProbes)) + (_real[2] * _z10));
#line 457


            _z6 = 0; if ((((*t).avgProbes) > _real[3])) {  _NILCHECKB (_z4 = ((*t).buckets));  _z0 = (*((_tbf05c01a*)  _z4)).size[0];
#line 459
 _z6 = (_z0 <  134217689 );  }  if (_z6) { 

               IntegerToIntegerTable__AvgProbesTooHigh (&(*t), probes);   } 

            if (found) { 
               _NILCHECKB (_z4 = ((*t).buckets));  _z0 = (*((_tbf05c01a*)  _z4)).size[0];  _z7 = _z0;  {  _LOCAL _tdfa73f81 M;
#line 464
 M = 0;  M = (_tdfa73f81) _z7; 
                  _z8 = _CVTIF (((*t).numDeleted));  _z10 = _CVTIF (M);  _z6 = 0; if ((_z8 > (_real[4] * _z10))) {
#line 465
 _z6 = (M >  23 );  }  if (_z6) { 


                     IntegerToIntegerTable__Rehash (&(*t),  0 );   }   }   } 



            Thread__Release (_h55.mutex);  _CUT_TO_NEXT_HANDLER (_h55);  return found;   }     }   } /* APPROX FRAME SIZE: 172 bytes */
#line 472


#line 478 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _t2b3260be IntegerToIntegerTable__DoDelete (t, buck, hash, key, value, probes)  _t056bf944 * t;  _tbf05c01a * buck;
#line 478
 _t223565b7 hash;  _t223565b7 key;  _t223565b7 * value;  _tdfa73f81 * probes;  {  _LOCAL _tdfa73f81 i;  _LOCAL _t2b3260be _result;
#line 478

#line 500
   _tdfa73f81 _z0;  _t223565b7 _z1; 
   _t223565b7 _z2; 
   _t223565b7 _z3;  _t223565b7 _z5; 





   _t352479bd _z4;  _tdfa73f81 _z6;  _t352479bd _z7; 



   _t2b3260be _z8; 
#line 478 "IntegerToIntegerTable.m3"
 
#line 497
   i = 0; 
#line 478
   _result = 0; 
#line 500
   _z0 = (*buck).size[0];  _z1 = _z0;  {  _LOCAL _tdfa73f81 M;  M = 0;  M = (_tdfa73f81) _z1; 
      _z2 = (unsigned)hash % (unsigned)M;  _z1 = _z2;  {  _LOCAL _t223565b7 chainBase;  chainBase = (_t223565b7) _z1;
#line 501

         _z3 = (unsigned)hash * (unsigned) 1052823 ;  _z5 = (unsigned)_z3 % (unsigned)(M -  1 );  _z2 = ( 1  + _z5);
#line 502
 {  _LOCAL _t223565b7 chainStep;  chainStep = (_t223565b7) _z2; 

            _z1 = chainBase; if (_z1 < 0) _RANGEFAULT(&__file.str,504);  i = _z1; 
            (*probes) =  0 ; 
            _L63:;  
               (*probes) +=  1 ; 
               {  _tbf05c01a* _array = & (*buck);  _z6 = i;  if (_z6 >= (_array->size[0])) _RANGEFAULT(&__file.str,508);
#line 508
 _z4 = (_ADDRESS) (_array->elts + _z6);   }  _z7 = (_ADDRESS) & (*(_t5e18e439*)_z4);  {  _LOCAL _t5e18e439 * entry;
#line 508
 entry = (_t5e18e439*) _z7; 
                  if ((((*entry).key) == ((_t223565b7) 0 ))) { 
                     (*value) =  0 ; 
                     return  0 ;   } 
                  _z8 = 0; if ((!(((*entry).key) == ((_t223565b7) -1 )))) {  _z8 = (((*entry).key) == ((_t223565b7)key));
#line 512
 }  if (_z8) { 

                     (*value) = ((*entry).value); 
                     ((*entry).key) =  -1 ; 
                     ((*entry).value) =  0 ; 
                     ((*t).numDeleted) +=  1 ; 
                     {  register int _r;  _r = ((*t).numFilled) -  1 ;  if (_r < 0) _RANGEFAULT(&__file.str,518);  ((*t).numFilled) = _r;
#line 518
  } 
                     return  1 ;   } 
                  if (((*probes) >= M)) { 
                     (*value) =  0 ; 
                     return  0 ;   }   } 


               _z5 = _IMODXP((i + chainStep), M);  _z1 = _z5; if (_z1 < 0) _RANGEFAULT(&__file.str,525);  i = _z1;
#line 525
 goto _L63;     }   }   }   } /* APPROX FRAME SIZE: 144 bytes */ 

#line 530 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _t95a227bb IntegerToIntegerTable__AvgProbesTooHigh (t, probes)  _t056bf944 * t;  _tdfa73f81 probes;  { 



   _t91aa2fb1 _z2;  _tdfa73f81 _z0;  _tf8a86f10 _z4;  _t91aa2fb1 _z1; 
#line 530 "IntegerToIntegerTable.m3"
 



   _z2 = _CVTIF (((*t).numFilled));  _NILCHECKB (_z4 = ((*t).buckets));  _z0 = (*((_tbf05c01a*)  _z4)).size[0];  _z1 = _CVTIF (_z0);
#line 534
 if ((_z2 > (_z1 * (_real[1] - _real[4])))) { 
      IntegerToIntegerTable__Rehash (&(*t),  1 );  goto _L67;   }   


      ((*t).avgProbes) = _real[0];    _L67:;   } /* APPROX FRAME SIZE: 72 bytes */ 

#line 542 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _t95a227bb IntegerToIntegerTable__Rehash (t, expand)  _t056bf944 * t;  _t2b3260be expand;  {  _LOCAL _tf8a86f10 oldBuckets;
#line 542
 _LOCAL _tf8a86f10 newBuckets;  _LOCAL _tdfa73f81 size;  _LOCAL _t2b3260be success; 
#line 555
   _t91aa2fb1 _z7; 
   _t91aa2fb1 _z2;  _t223565b7 _z3;  _t223565b7 _z0; 


   _t223565b7 _z1; 



   _tdfa73f81 _z4;  _tf8a86f10 _z5; 
#line 580
   _tf8a86f10 _z6;  _t2b3260be _z8; 









   _t91aa2fb1 _z9; 
#line 542 "IntegerToIntegerTable.m3"
 



   oldBuckets = _NIL;  newBuckets = _NIL; 
   size = 0; 
   success = 0; 


   _L69:;  

      oldBuckets = ((*t).buckets); 

      _z7 = ((_real[1] - (_real[1] / _real[3])) / _real[5]);  {  _LOCAL _t91aa2fb1 idealOccupancy;  idealOccupancy = 0.0;
#line 555
 idealOccupancy = (_t91aa2fb1) _z7; 
         _z2 = _CVTIF (((*t).numFilled));  _z3 = _ROUND ((_z2 / idealOccupancy));  _z0 = _z3;  {  _LOCAL _t223565b7 idealNewSize;
#line 556
 idealNewSize = (_t223565b7) _z0; 


            _z1 = idealNewSize; if (_z1 < 0) _RANGEFAULT(&__file.str,559);  size = _z1;   }   } 

      if (expand) { 

         _NILCHECKB (_z5 = oldBuckets);  _z4 = (*((_tbf05c01a*)  _z5)).size[0];  _z3 = (_z4 - ((*t).numDeleted));
#line 563
 {  _LOCAL _t223565b7 effectiveSize;  effectiveSize = (_t223565b7) _z3; 
            _z2 = _CVTIF (effectiveSize);  _z3 = _ROUND ((_z2 * _real[6]));  _z0 = _z3;  {  _LOCAL _t223565b7 minNewSize;
#line 564
 minNewSize = (_t223565b7) _z0; 


               _z4 = size;  _z3 = minNewSize;  if (_z4 < _z3) _z4 = _z3;  _z0 = _z4; if (_z0 < 0) _RANGEFAULT(&__file.str,567);
#line 567
 size = _z0; 
               _NILCHECKB (_z5 = oldBuckets);  _z4 = (*((_tbf05c01a*)  _z5)).size[0];  if (!(size > (_z4 - ((*t).numDeleted)))) _ASSERTFAULT(&__file.str,568);
#line 568
  }   }   } 


      _z5 = IntegerToIntegerTable__NewBuckets (size);  newBuckets = _z5; 
      _NILCHECKB (_z5 = newBuckets);  _z4 = (*((_tbf05c01a*)  _z5)).size[0];  if (!(_z4 >= ((*t).numFilled))) _ASSERTFAULT(&__file.str,572);
#line 572


      ((*t).buckets) = newBuckets; 
      ((*t).numDeleted) =  0 ; 
      ((*t).numFilled) =  0 ; 
      expand =  1 ; 


      _NILCHECKB (_z5 = oldBuckets);  _NILCHECKB (_z6 = newBuckets);  _z8 = IntegerToIntegerTable__CopyEntries (&(*t), &(*((_tbf05c01a*)  _z5)), &(*((_tbf05c01a*)  _z6)));
#line 580
 success = _z8; 


      oldBuckets = (_tf8a86f10) 0; 

      expand =  1 ;   if (! success) goto _L69; 



   _NILCHECKB (_z5 = ((*t).buckets));  _z4 = (*((_tbf05c01a*)  _z5)).size[0];  _z0 = _z4;  {  _LOCAL _tdfa73f81 M;
#line 589
 M = 0;  M = (_tdfa73f81) _z0; 
      _z7 = _CVTIF ((M +  1 ));  _z9 = _CVTIF (((M +  1 ) - ((*t).numFilled)));  ((*t).avgProbes) = (_z7 / _z9);
#line 590
  }   } /* APPROX FRAME SIZE: 132 bytes */ 

#line 595 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _t2b3260be IntegerToIntegerTable__CopyEntries (t, old, new)  _t056bf944 * t;  _tbf05c01a * old;  _tbf05c01a * new;
#line 595
 {  _LOCAL _tdfa73f81 probes;  _LOCAL _tdfa73f81 next;  _LOCAL _t2b3260be found;  _LOCAL _t2b3260be crowded;  _LOCAL _t2b3260be _result;
#line 595

#line 609
   _t223565b7 _z1;  _t223565b7 _z0;  _t223565b7 _z2; 
   _t352479bd _z4;  _t223565b7 _z5;  _t352479bd _z3; 







   _tdfa73f81 _z6; 
   _t352479bd _z7; 




   _t2b3260be _z12; 
#line 595 "IntegerToIntegerTable.m3"
 







   probes = 0;  next = 0; 
   found = 0;  crowded = 0; 
#line 595
   _result = 0; 
#line 606
   crowded =  0 ; 
   next =  0 ; 

   _z1 =  0 ;  _z0 = (*old).size[0] - 1;  _z2 = _z0;  {  _LOCAL _t223565b7 i;  for (; _z1 <= _z2; _z1 += 1){
#line 609
 i = (_t223565b7) _z1; 
         {  _tbf05c01a* _array = & (*old);  _z5 = i;  if (_z5 >= (_array->size[0])) _RANGEFAULT(&__file.str,610);  _z4 = (_ADDRESS) (_array->elts + _z5);
#line 610
  }  _z3 = (_ADDRESS) & (*(_t5e18e439*)_z4);  {  _LOCAL _t5e18e439 * e;  e = (_t5e18e439*) _z3; 
            if ((((*e).key) == ((_t223565b7) 0 ))) {  goto _L74;   } 

            if ((((*e).key) == ((_t223565b7) -1 ))) { 
               ((*e).key) =  0 ;  goto _L74;   }   

               if (crowded) { 

                  _L76:   {  _tbf05c01a* _array = & (*new);  _z6 = next;  if (_z6 >= (_array->size[0])) _RANGEFAULT(&__file.str,618);
#line 618
 _z4 = (_ADDRESS) (_array->elts + _z6);   }  if (!((!(((*(_t5e18e439*)_z4).key) == ((_t223565b7) 0 ))))) goto _L77;
#line 618
 next +=  1 ;  goto _L76;   _L77:; 
                  {  _tbf05c01a* _array = & (*new);  _z6 = next;  if (_z6 >= (_array->size[0])) _RANGEFAULT(&__file.str,619);
#line 619
 _z7 = (_ADDRESS) (_array->elts + _z6);   }  (*(_t5e18e439*)_z7) = (*e);  next +=  1 ;  goto _L75;   }   



                  _z4 = (_ADDRESS) & ((*e).key);  {  _LOCAL _t223565b7 * hash;  hash = (_t223565b7*) _z4; 
                     _z12 = IntegerToIntegerTable__DoPut (&(*t), &(*new), (*hash), ((*e).key), &((*e).value), &probes, &crowded);
#line 624
 found = _z12;   }    _L75:; 








               (*e) = IntegerToIntegerTable__NullEntry;    _L74:;   }   }   } 



   return (!crowded);   } /* APPROX FRAME SIZE: 144 bytes */ 

#line 640 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _t95a227bb IntegerToIntegerTable__Clear (table)  _tbb8a9dbe table;  { 

   _tbb8a9dbe _z1;  _t352479bd _z3; 
   _t352479bd _z2;  _LOCK_HANDLER _h79; 




   _tf8a86f10 _z4; 
   _t223565b7 _z5;  _t223565b7 _z0;  _t223565b7 _z6; 
   _t223565b7 _z7;  _t352479bd _z8; 
#line 640 "IntegerToIntegerTable.m3"
 

   _NILCHECKB (_z1 = table);  _z3 = (_ADDRESS) & (((_tbb8a9dbe_fields*)(((_ADDRESS)_z1)+4))->rec);  {  _LOCAL _t056bf944 * t;
#line 642
 t = (_t056bf944*) _z3; 
      _z2 = (_ADDRESS) ((*t).mutex);  Thread__Acquire (_z2);  _PUSH_LOCK (_h79, _z2); 
         ((*t).nullKeyPresent) =  0 ; 
         ((*t).nullKeyValue) =  0 ; 
         ((*t).deletedKeyPresent) =  0 ; 
         ((*t).deletedKeyValue) =  0 ; 
         _NILCHECKB (_z4 = ((*t).buckets));  _z3 = (_ADDRESS) & (*((_tbf05c01a*)  _z4));  {  _LOCAL _tbf05c01a buck;
#line 648
 _COPY (_z3, &buck, sizeof (_tbf05c01a)); 
            _z5 =  0 ;  _z0 = buck.size[0] - 1;  _z6 = _z0;  {  _LOCAL _t223565b7 i;  for (; _z5 <= _z6; _z5 += 1){
#line 649
 i = (_t223565b7) _z5; 
                  {  _tbf05c01a* _array = & buck;  _z7 = i;  if (_z7 >= (_array->size[0])) _RANGEFAULT(&__file.str,650);
#line 650
 _z3 = (_ADDRESS) (_array->elts + _z7);   }  _z8 = (_ADDRESS) & (*(_t5e18e439*)_z3);  {  _LOCAL _t5e18e439 * e;  e = (_t5e18e439*) _z8;
#line 650

                     if ((!(((*e).key) == ((_t223565b7) 0 )))) {  (*e) = IntegerToIntegerTable__NullEntry;   }   }   } 
#line 651
 }   } 



         ((*t).avgProbes) = _real[0]; 
         ((*t).numDeleted) =  0 ; 
         ((*t).numFilled) =  0 ;    _CUT_TO_NEXT_HANDLER (_h79);  Thread__Release (_z2);   }   } /* APPROX FRAME SIZE: 160 bytes */
#line 657


#line 664 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _t96076584 IntegerToIntegerTable__Copy (table)  _tbb8a9dbe table;  {  _LOCAL _t96076584 _result; 


   _tbb8a9dbe _z0;  _tbb8a9dbe _z1; 
   _t352479bd _z3; 


   _t352479bd _z2;  _LOCK_HANDLER _h83; 

   _t91096db0 _z4; 
   _tdfa73f81 _z5;  _tf8a86f10 _z6; 
   _tf8a86f10 _z7; 
#line 664 "IntegerToIntegerTable.m3"
  _result = _NIL; 


   {  _ADDRESS _ptr = (_ADDRESS)_TNEWOBJ (_tbb8a9dbe_TC);  _z0 = (_tbb8a9dbe) _ptr;   }  _z1 = _z0;  {  _LOCAL _tbb8a9dbe copy;
#line 667
 copy = _NIL;  copy = (_tbb8a9dbe) _z1; 
      _NILCHECKB (_z1 = copy);  _z3 = (_ADDRESS) & (((_tbb8a9dbe_fields*)(((_ADDRESS)_z1)+4))->rec);  {  _LOCAL _t056bf944 * c;
#line 668
 c = (_t056bf944*) _z3; 
         _NILCHECKB (_z1 = table);  _z3 = (_ADDRESS) & (((_tbb8a9dbe_fields*)(((_ADDRESS)_z1)+4))->rec);  {  _LOCAL _t056bf944 * t;
#line 669
 t = (_t056bf944*) _z3; 

            _z2 = (_ADDRESS) ((*t).mutex);  Thread__Acquire (_z2);  _PUSH_LOCK (_h83, _z2); 
               (*c) = (*t); 
               {  _ADDRESS _ptr = (_ADDRESS)_TNEWOBJ (_t91096db0_TC);  _z4 = (_t91096db0) _ptr;   }  ((*c).mutex) = _z4;
#line 673

               {  _tbf05c01a* _ptr;  struct {int *elts; int nb_dims; int dim[1];} _sizes;  _sizes.elts = _sizes.dim; _sizes.nb_dims = 1;
#line 674
 _NILCHECKB (_z6 = ((*t).buckets));  _z5 = (*((_tbf05c01a*)  _z6)).size[0];  _sizes.dim[0] = _z5;  _ptr = (_tbf05c01a*) _TNEWA (_tf8a86f10_TC, &_sizes);
#line 674
 _z6 = (_tf8a86f10) _ptr;   }  ((*c).buckets) = _z6; 
               _NILCHECKB (_z6 = ((*t).buckets));  _NILCHECKB (_z7 = ((*c).buckets));  {  _tbf05c01a* _src = &(*((_tbf05c01a*)  _z6));
#line 675
 _tbf05c01a* _dest = &(*((_tbf05c01a*)  _z7));  if (_dest->size[0] != _src->size[0]) _NARROWFAULT(&__file.str,675);
#line 675
 _COPY (_src->elts, _dest->elts, (_src->size[0]) * 8);   } 
               Thread__Release (_h83.mutex);  _CUT_TO_NEXT_HANDLER (_h83);  return (_t96076584)copy;     }   }   }   } /* APPROX FRAME SIZE: 208 bytes */
#line 676


#line 681 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _t92850976 IntegerToIntegerTable__ToKeyList (table)  _tbb8a9dbe table;  {  _LOCAL _t92850976 list;  _LOCAL _tc0059bc6 refKey;
#line 681
 _LOCAL _t92850976 _result; 



   _tbb8a9dbe _z1;  _t352479bd _z3; 
   _t352479bd _z2;  _LOCK_HANDLER _h85; 


   _tc0059bc6 _z0;  _tc0059bc6 _z4; 
   _t92850976 _z5; 





   _tf8a86f10 _z6; 
   _t223565b7 _z7;  _t223565b7 _z8;  _t223565b7 _z9; 
   _t352479bd _z10; 
   _t2b3260be _z11; 
#line 681 "IntegerToIntegerTable.m3"
 
   list = _NIL; 
   refKey = _NIL; 
#line 681
   _result = _NIL; 



   _NILCHECKB (_z1 = table);  _z3 = (_ADDRESS) & (((_tbb8a9dbe_fields*)(((_ADDRESS)_z1)+4))->rec);  {  _LOCAL _t056bf944 * t;
#line 685
 t = (_t056bf944*) _z3; 
      _z2 = (_ADDRESS) ((*t).mutex);  Thread__Acquire (_z2);  _PUSH_LOCK (_h85, _z2); 
         list = (_t92850976) 0; 
         if (((*t).nullKeyPresent)) { 
            _z0 = (_tc0059bc6) _TNEW (_tc0059bc6_TC);  refKey = _z0;  _NILCHECKB (_z4 = refKey);  (*((_t223565b7*)  _z4)) =  0 ;
#line 689

            _z5 = List__New (refKey, list);  list = _z5;   } 

         if (((*t).deletedKeyPresent)) { 
            _z0 = (_tc0059bc6) _TNEW (_tc0059bc6_TC);  refKey = _z0;  _NILCHECKB (_z4 = refKey);  (*((_t223565b7*)  _z4)) =  -1 ;
#line 693

            _z5 = List__New (refKey, list);  list = _z5;   } 

         _NILCHECKB (_z6 = ((*t).buckets));  _z3 = (_ADDRESS) & (*((_tbf05c01a*)  _z6));  {  _LOCAL _tbf05c01a buck;
#line 696
 _COPY (_z3, &buck, sizeof (_tbf05c01a)); 
            _z7 =  0 ;  _z8 = buck.size[0] - 1;  _z9 = _z8;  {  _LOCAL _t223565b7 i;  for (; _z7 <= _z9; _z7 += 1){
#line 697
 i = (_t223565b7) _z7; 
                  {  _tbf05c01a* _array = & buck;  _z8 = i;  if (_z8 >= (_array->size[0])) _RANGEFAULT(&__file.str,698);
#line 698
 _z3 = (_ADDRESS) (_array->elts + _z8);   }  _z10 = (_ADDRESS) & (*(_t5e18e439*)_z3);  {  _LOCAL _t5e18e439 * e;  e = (_t5e18e439*) _z10;
#line 698

                     _z11 = 0; if ((!(((*e).key) == ((_t223565b7) 0 )))) {  _z11 = (!(((*e).key) == ((_t223565b7) -1 )));
#line 699
 }  if (_z11) { 

                        _z0 = (_tc0059bc6) _TNEW (_tc0059bc6_TC);  refKey = _z0;  _NILCHECKB (_z4 = refKey);  (*((_t223565b7*)  _z4)) = ((*e).key);
#line 701

                        _z5 = List__New (refKey, list);  list = _z5;   }   }   }   }   } 




         Thread__Release (_h85.mutex);  _CUT_TO_NEXT_HANDLER (_h85);  return list;     }   } /* APPROX FRAME SIZE: 184 bytes */
#line 707


#line 712 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _t92850976 IntegerToIntegerTable__ToValueList (table)  _tbb8a9dbe table;  {  _LOCAL _t92850976 list;  _LOCAL _tc0059bc6 refValue;
#line 712
 _LOCAL _t92850976 _result; 



   _tbb8a9dbe _z1;  _t352479bd _z3; 
   _t352479bd _z2;  _LOCK_HANDLER _h91; 


   _tc0059bc6 _z0;  _tc0059bc6 _z4; 
   _t92850976 _z5; 





   _tf8a86f10 _z6; 
   _t223565b7 _z7;  _t223565b7 _z8;  _t223565b7 _z9; 
   _t352479bd _z10; 
   _t2b3260be _z11; 
#line 712 "IntegerToIntegerTable.m3"
 
   list = _NIL; 
   refValue = _NIL; 
#line 712
   _result = _NIL; 



   _NILCHECKB (_z1 = table);  _z3 = (_ADDRESS) & (((_tbb8a9dbe_fields*)(((_ADDRESS)_z1)+4))->rec);  {  _LOCAL _t056bf944 * t;
#line 716
 t = (_t056bf944*) _z3; 
      _z2 = (_ADDRESS) ((*t).mutex);  Thread__Acquire (_z2);  _PUSH_LOCK (_h91, _z2); 
         list = (_t92850976) 0; 
         if (((*t).nullKeyPresent)) { 
            _z0 = (_tc0059bc6) _TNEW (_tc0059bc6_TC);  refValue = _z0;  _NILCHECKB (_z4 = refValue);  (*((_t223565b7*)  _z4)) = ((*t).nullKeyValue);
#line 720

            _z5 = List__New (refValue, list);  list = _z5;   } 

         if (((*t).deletedKeyPresent)) { 
            _z0 = (_tc0059bc6) _TNEW (_tc0059bc6_TC);  refValue = _z0;  _NILCHECKB (_z4 = refValue);  (*((_t223565b7*)  _z4)) = ((*t).deletedKeyValue);
#line 724

            _z5 = List__New (refValue, list);  list = _z5;   } 

         _NILCHECKB (_z6 = ((*t).buckets));  _z3 = (_ADDRESS) & (*((_tbf05c01a*)  _z6));  {  _LOCAL _tbf05c01a buck;
#line 727
 _COPY (_z3, &buck, sizeof (_tbf05c01a)); 
            _z7 =  0 ;  _z8 = buck.size[0] - 1;  _z9 = _z8;  {  _LOCAL _t223565b7 i;  for (; _z7 <= _z9; _z7 += 1){
#line 728
 i = (_t223565b7) _z7; 
                  {  _tbf05c01a* _array = & buck;  _z8 = i;  if (_z8 >= (_array->size[0])) _RANGEFAULT(&__file.str,729);
#line 729
 _z3 = (_ADDRESS) (_array->elts + _z8);   }  _z10 = (_ADDRESS) & (*(_t5e18e439*)_z3);  {  _LOCAL _t5e18e439 * e;  e = (_t5e18e439*) _z10;
#line 729

                     _z11 = 0; if ((!(((*e).key) == ((_t223565b7) 0 )))) {  _z11 = (!(((*e).key) == ((_t223565b7) -1 )));
#line 730
 }  if (_z11) { 

                        _z0 = (_tc0059bc6) _TNEW (_tc0059bc6_TC);  refValue = _z0;  _NILCHECKB (_z4 = refValue);  (*((_t223565b7*)  _z4)) = ((*e).value);
#line 732

                        _z5 = List__New (refValue, list);  list = _z5;   }   }   }   }   } 




         Thread__Release (_h91.mutex);  _CUT_TO_NEXT_HANDLER (_h91);  return list;     }   } /* APPROX FRAME SIZE: 184 bytes */
#line 738


#line 743 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _t92850976 IntegerToIntegerTable__ToAssocList (table)  _tbb8a9dbe table;  {  _LOCAL _t92850976 list;  _LOCAL _tc0059bc6 refKey;
#line 743
 _LOCAL _tc0059bc6 refValue;  _LOCAL _t92850976 _result; 




   _tbb8a9dbe _z1;  _t352479bd _z3; 
   _t352479bd _z2;  _LOCK_HANDLER _h97; 


   _tc0059bc6 _z0;  _tc0059bc6 _z4; 

   _t92850976 _z5;  _t92850976 _z6; 






   _tf8a86f10 _z7; 
   _t223565b7 _z8;  _t223565b7 _z9;  _t223565b7 _z10; 
   _t352479bd _z11; 
   _t2b3260be _z12; 
#line 743 "IntegerToIntegerTable.m3"
 
   list = _NIL; 
   refKey = _NIL; 
   refValue = _NIL; 
#line 743
   _result = _NIL; 




   _NILCHECKB (_z1 = table);  _z3 = (_ADDRESS) & (((_tbb8a9dbe_fields*)(((_ADDRESS)_z1)+4))->rec);  {  _LOCAL _t056bf944 * t;
#line 748
 t = (_t056bf944*) _z3; 
      _z2 = (_ADDRESS) ((*t).mutex);  Thread__Acquire (_z2);  _PUSH_LOCK (_h97, _z2); 
         list = (_t92850976) 0; 
         if (((*t).nullKeyPresent)) { 
            _z0 = (_tc0059bc6) _TNEW (_tc0059bc6_TC);  refKey = _z0;  _NILCHECKB (_z4 = refKey);  (*((_t223565b7*)  _z4)) =  0 ;
#line 752

            _z0 = (_tc0059bc6) _TNEW (_tc0059bc6_TC);  refValue = _z0;  _NILCHECKB (_z4 = refValue);  (*((_t223565b7*)  _z4)) = ((*t).nullKeyValue);
#line 753

            _z5 = List__List2 (refKey, refValue);  _z6 = List__New (_z5, list);  list = _z6;   } 

         if (((*t).deletedKeyPresent)) { 
            _z0 = (_tc0059bc6) _TNEW (_tc0059bc6_TC);  refKey = _z0;  _NILCHECKB (_z4 = refKey);  (*((_t223565b7*)  _z4)) =  -1 ;
#line 757

            _z0 = (_tc0059bc6) _TNEW (_tc0059bc6_TC);  refValue = _z0;  _NILCHECKB (_z4 = refValue);  (*((_t223565b7*)  _z4)) = ((*t).deletedKeyValue);
#line 758

            _z5 = List__List2 (refKey, refValue);  _z6 = List__New (_z5, list);  list = _z6;   } 

         _NILCHECKB (_z7 = ((*t).buckets));  _z3 = (_ADDRESS) & (*((_tbf05c01a*)  _z7));  {  _LOCAL _tbf05c01a buck;
#line 761
 _COPY (_z3, &buck, sizeof (_tbf05c01a)); 
            _z8 =  0 ;  _z9 = buck.size[0] - 1;  _z10 = _z9;  {  _LOCAL _t223565b7 i;  for (; _z8 <= _z10; _z8 += 1){
#line 762
 i = (_t223565b7) _z8; 
                  {  _tbf05c01a* _array = & buck;  _z9 = i;  if (_z9 >= (_array->size[0])) _RANGEFAULT(&__file.str,763);
#line 763
 _z3 = (_ADDRESS) (_array->elts + _z9);   }  _z11 = (_ADDRESS) & (*(_t5e18e439*)_z3);  {  _LOCAL _t5e18e439 * e;  e = (_t5e18e439*) _z11;
#line 763

                     _z12 = 0; if ((!(((*e).key) == ((_t223565b7) 0 )))) {  _z12 = (!(((*e).key) == ((_t223565b7) -1 )));
#line 764
 }  if (_z12) { 

                        _z0 = (_tc0059bc6) _TNEW (_tc0059bc6_TC);  refKey = _z0;  _NILCHECKB (_z4 = refKey);  (*((_t223565b7*)  _z4)) = ((*e).key);
#line 766

                        _z0 = (_tc0059bc6) _TNEW (_tc0059bc6_TC);  refValue = _z0;  _NILCHECKB (_z4 = refValue);  (*((_t223565b7*)  _z4)) = ((*e).value);
#line 767

                        _z5 = List__List2 (refKey, refValue);  _z6 = List__New (_z5, list);  list = _z6;   }   } 
#line 768
 }   }   } 




         Thread__Release (_h97.mutex);  _CUT_TO_NEXT_HANDLER (_h97);  return list;     }   } /* APPROX FRAME SIZE: 192 bytes */
#line 773


#line 778 "IntegerToIntegerTable.m3"
  _LOCAL_PROC _t2b3260be IntegerToIntegerTable__Enumerate (table, proc, data, key, value)  _tbb8a9dbe table;  _t592a3657 proc;
#line 778
 _t76b14e78 data;  _t223565b7 * key;  _t223565b7 * value;  {  _LOCAL _t2b3260be _result; 








   _tbb8a9dbe _z1;  _t352479bd _z3; 
   _t352479bd _z2;  _LOCK_HANDLER _h103; 



   _t2b3260be _z6; 








   _tf8a86f10 _z4; 
   _t223565b7 _z5;  _t223565b7 _z0;  _t223565b7 _z7; 
   _t223565b7 _z8;  _t352479bd _z9; 
   _t2b3260be _z10; 
#line 778 "IntegerToIntegerTable.m3"
  _result = 0; 








   _NILCHECKB (_z1 = table);  _z3 = (_ADDRESS) & (((_tbb8a9dbe_fields*)(((_ADDRESS)_z1)+4))->rec);  {  _LOCAL _t056bf944 * t;
#line 787
 t = (_t056bf944*) _z3; 
      _z2 = (_ADDRESS) ((*t).mutex);  Thread__Acquire (_z2);  _PUSH_LOCK (_h103, _z2); 
         if (((*t).nullKeyPresent)) { 
            (*key) =  0 ; 

            {  _t592a3657 _proc = proc;  if (!_IS_CLOSURE(_proc)) {  _z6 = _proc (data, (*key), &((*t).nullKeyValue)); 
#line 792
  } else {  _z6 = ((_t592a3657) _CLOSURE_PROC(_proc)) (_CLOSURE_FRAME(_proc), data, (*key), &((*t).nullKeyValue));   } 
#line 792
 }  if (_z6) {  (*value) = ((*t).nullKeyValue);  Thread__Release (_h103.mutex);  _CUT_TO_NEXT_HANDLER (_h103);  return  1 ;
#line 792
  }   } 


         if (((*t).deletedKeyPresent)) { 
            (*key) =  -1 ; 

            {  _t592a3657 _proc = proc;  if (!_IS_CLOSURE(_proc)) {  _z6 = _proc (data, (*key), &((*t).deletedKeyValue));
#line 798
   } else {  _z6 = ((_t592a3657) _CLOSURE_PROC(_proc)) (_CLOSURE_FRAME(_proc), data, (*key), &((*t).deletedKeyValue)); 
#line 798
 }   }  if (_z6) {  (*value) = ((*t).deletedKeyValue);  Thread__Release (_h103.mutex);  _CUT_TO_NEXT_HANDLER (_h103);  return  1 ;
#line 798
  }   } 


         _NILCHECKB (_z4 = ((*t).buckets));  _z3 = (_ADDRESS) & (*((_tbf05c01a*)  _z4));  {  _LOCAL _tbf05c01a buck;
#line 801
 _COPY (_z3, &buck, sizeof (_tbf05c01a)); 
            _z5 =  0 ;  _z0 = buck.size[0] - 1;  _z7 = _z0;  {  _LOCAL _t223565b7 i;  for (; _z5 <= _z7; _z5 += 1){
#line 802
 i = (_t223565b7) _z5; 
                  {  _tbf05c01a* _array = & buck;  _z8 = i;  if (_z8 >= (_array->size[0])) _RANGEFAULT(&__file.str,803);
#line 803
 _z3 = (_ADDRESS) (_array->elts + _z8);   }  _z9 = (_ADDRESS) & (*(_t5e18e439*)_z3);  {  _LOCAL _t5e18e439 * e;  e = (_t5e18e439*) _z9;
#line 803

                     _z10 = 0; if ((!(((*e).key) == ((_t223565b7) 0 )))) {  _z10 = (!(((*e).key) == ((_t223565b7) -1 )));
#line 804
 }  if (_z10) { 

                        (*key) = ((*e).key); 

                        {  _t592a3657 _proc = proc;  if (!_IS_CLOSURE(_proc)) {  _z10 = _proc (data, (*key), &((*e).value));
#line 808
   } else {  _z10 = ((_t592a3657) _CLOSURE_PROC(_proc)) (_CLOSURE_FRAME(_proc), data, (*key), &((*e).value));   }   }  if (_z10) {
#line 808
 (*value) = ((*e).value);  Thread__Release (_h103.mutex);  _CUT_TO_NEXT_HANDLER (_h103);  return  1 ;   }   }   }   }  
#line 808
            }   } 





         (*key) =  0 ; 
         (*value) =  0 ; 
         Thread__Release (_h103.mutex);  _CUT_TO_NEXT_HANDLER (_h103);  return  0 ;     }   } /* APPROX FRAME SIZE: 200 bytes */
#line 816


#line 816 "IntegerToIntegerTable.m3"
   _LOCAL_PROC _VOID _init_ ()  {  
#line 816 "IntegerToIntegerTable.m3"
   } /* APPROX FRAME SIZE: 48 bytes */ 
/*------------------*/
/*------------------*/
/*------------------*/
/*------------------*/
/*------------------*/
/*------------------*/
/*------------------*/
/*------------------*/
/*------------------*/
/*------------------*/
/*------------------*/
/*------------------*/
/*------------------*/
/*------------------*/
/*------------------*/
/*------------------*/
/*------------------*/
_PRIVATE int _fp_data[] = {
  0x339cd845, 0x28db3f55, 	/* _t5e18e439 IntegerToIntegerTable.Entry */
    0x223565b7, 0x223565b7,
  0xd91e2a1c, 0x2b6fce28, 	/* _tbf05c01a  */
    0x5e18e439,
  0x52800000, 0x2a204645, 	/* _tf8a86f10 IntegerToIntegerTable.Buckets */
    0xbf05c01a,
  0x4f5590c5, 0x373c263a, 	/* _t056bf944 IntegerToIntegerTable.TableRec */
    0x91096db0, 0xf8a86f10, 0x2b3260be, 0x223565b7, 0x2b3260be, 0x223565b7, 0x91aa2fb1, 0xdfa73f81, 0xdfa73f81,
  0x4e36eb09, 0x2ff8b944, 	/* _tbb8a9dbe IntegerToIntegerTable.TT */
    0x96076584, 0x056bf944, 0xe472781b, 0x09d96bff, 0xe287e46a, 0xacecfc6b, 0x281f5950, 0x5cb85ad0, 0xe472781b, 0x09d96bff,
    0x89e7331d, 0x1e5e876a, 0x6113ebc8, 0xab3bb066, 0x0a69263d, 0x8646f1d7, 0x0a69263d, 0x8646f1d7, 0x0a69263d, 0x8646f1d7,
    0x6c8d469b, 0x055138be,
  0xd91e2a1c, 0x2b6fce28, 	/* _t36adabfd  */
    0xdfa73f81,
  0x22ac1275, 0x3a243844, 	/* _t9bc60a63  */
    0xdfa73f81, 0xf8a86f10,
  0xcc0b033a, 0x3528946a, 	/* _t5cb85ad0  */
    0xbb8a9dbe, 0x223565b7, 0x223565b7, 0x2b3260be,
  0xcd7d6c4d, 0x38d9244d, 	/* _t6d6219e1  */
    0x056bf944, 0xbf05c01a, 0x223565b7, 0x223565b7, 0x223565b7, 0xdfa73f81, 0x2b3260be, 0x2b3260be,
  0xba89e8e3, 0x252bb757, 	/* _tacecfc6b  */
    0xbb8a9dbe, 0x223565b7, 0x223565b7,
  0xe8e258a2, 0x260f2ddd, 	/* _t09d96bff  */
    0xbb8a9dbe, 0x223565b7, 0x223565b7, 0x2b3260be,
  0x1370f386, 0x21842c10, 	/* _t57c9f068  */
    0x056bf944, 0xbf05c01a, 0x223565b7, 0x223565b7, 0x223565b7, 0xdfa73f81, 0x2b3260be,
  0x815ed3a4, 0x2ba5a3d3, 	/* _td8791be0  */
    0x056bf944, 0xdfa73f81,
  0xfb5d2d5c, 0x3068127c, 	/* _t6f18d764  */
    0x056bf944, 0x2b3260be,
  0xefcc8961, 0x20421f01, 	/* _ta9afb6a2  */
    0x056bf944, 0xbf05c01a, 0xbf05c01a, 0x2b3260be,
  0x1880254c, 0x2ecc12db, 	/* _t1e5e876a  */
    0xbb8a9dbe,
  0x3cc55c4c, 0x20a019be, 	/* _tab3bb066  */
    0xbb8a9dbe, 0x96076584,
  0x3cc55c4c, 0x20a019be, 	/* _t8646f1d7  */
    0xbb8a9dbe, 0x92850976,
  0x5484b9be, 0x304dd89e, 	/* _t055138be  */
    0xbb8a9dbe, 0x592a3657, 0x76b14e78, 0x223565b7, 0x223565b7, 0x2b3260be,
  0x52800000, 0x2a204645, 	/* _tc0059bc6  */
    0x223565b7,
  0
};
/*------------------*/

_PRIVATE _TYPE _tf8a86f10_tc = {
  0, 0,
  0xf8a86f10,
  &_tf8a86f10_TC,
  0, 1,
  0, 8, 4,
  0, 0,
  1, 8,
  0,
  0,
  0,
  0,
  0,
  "IntegerToIntegerTable.Buckets",
  0,
  0, 0, 0
};



_LOCAL_PROC _VOID _tbb8a9dbe_setup ()
{
   _ADDRESS _defaults;
   _defaults = (_ADDRESS) _tbb8a9dbe_TC->defaultMethods;
   *((_PROC*) (_defaults + _t96076584_TC->methodOffset + 0)) = (_PROC) IntegerToIntegerTable__In;
   *((_PROC*) (_defaults + _t96076584_TC->methodOffset + 4)) = (_PROC) IntegerToIntegerTable__Get;
   *((_PROC*) (_defaults + _t96076584_TC->methodOffset + 8)) = (_PROC) IntegerToIntegerTable__Put;
   *((_PROC*) (_defaults + _t96076584_TC->methodOffset + 12)) = (_PROC) IntegerToIntegerTable__Delete;
   *((_PROC*) (_defaults + _t96076584_TC->methodOffset + 16)) = (_PROC) IntegerToIntegerTable__Clear;
   *((_PROC*) (_defaults + _t96076584_TC->methodOffset + 20)) = (_PROC) IntegerToIntegerTable__Copy;
   *((_PROC*) (_defaults + _t96076584_TC->methodOffset + 24)) = (_PROC) IntegerToIntegerTable__ToKeyList;
   *((_PROC*) (_defaults + _t96076584_TC->methodOffset + 28)) = (_PROC) IntegerToIntegerTable__ToValueList;
   *((_PROC*) (_defaults + _t96076584_TC->methodOffset + 32)) = (_PROC) IntegerToIntegerTable__ToAssocList;
   *((_PROC*) (_defaults + _t96076584_TC->methodOffset + 36)) = (_PROC) IntegerToIntegerTable__Enumerate;
} /* APPROX FRAME SIZE: 52 bytes */
#define _tbb8a9dbe_init 0



_LOCAL_PROC _VOID _tbb8a9dbe_map (_p, _arg, _r, _mask)
_VOID (*_p) ();
_ADDRESS _arg;
_ADDRESS _r;
_MAPPROC_MASK _mask;
{
   _tbb8a9dbe_fields* _o;
   _t96076584_TC->mapProc (_p, _arg, _r, _mask);
   _o = (_tbb8a9dbe_fields*) (_r + _tbb8a9dbe_TC->dataOffset);
   if (_MASK_TRACED (_mask)) _p (_arg, &(_o->rec.mutex), _r, _VAL_TRACED);
   if (_MASK_TRACED (_mask)) _p (_arg, &(_o->rec.buckets), _r, _VAL_TRACED);
} /* APPROX FRAME SIZE: 68 bytes */
_PRIVATE _TYPE _tbb8a9dbe_tc = {
  0, 0,
  0xbb8a9dbe,
  &_tbb8a9dbe_TC,
  0, 1,
  0, 36, 4,
  0, 0,
  0, 0,
  0,
  _tbb8a9dbe_setup,
  _tbb8a9dbe_map,
  _tbb8a9dbe_init,
  "IntegerToIntegerTable_#$%^_IntegerToIntegerTable_0001M",
  "IntegerToIntegerTable.TT",
  &_t96076584_TC,
  0, 0, 0
};

_PRIVATE _TYPE _tc0059bc6_tc = {
  0, 0,
  0xc0059bc6,
  &_tc0059bc6_TC,
  0, 1,
  0, 4, 4,
  0, 0,
  0, 0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0, 0, 0
};
/*------------------*/
#define _exported_full_revelations 0
#define _exported_partial_revelations 0
#define _imported_full_revelations 0
#define _imported_partial_revelations 0

_PRIVATE _PROC_INFO _proc_info [] = {
  { (_PROC) IntegerToIntegerTable__New, 0x5f7b13c1, "IntegerToIntegerTable.New", 0, 0 },
  { (_PROC) IntegerToIntegerTable__NewBuckets, 0x9bc60a63, "IntegerToIntegerTable.NewBuckets", 0, 0 },
  { (_PROC) IntegerToIntegerTable__Put, 0x5cb85ad0, "IntegerToIntegerTable.Put", 0, 0 },
  { (_PROC) IntegerToIntegerTable__DoPut, 0x6d6219e1, "IntegerToIntegerTable.DoPut", 0, 0 },
  { (_PROC) IntegerToIntegerTable__Get, 0xacecfc6b, "IntegerToIntegerTable.Get", 0, 0 },
  { (_PROC) IntegerToIntegerTable__In, 0x09d96bff, "IntegerToIntegerTable.In", 0, 0 },
  { (_PROC) IntegerToIntegerTable__DoIn, 0x57c9f068, "IntegerToIntegerTable.DoIn", 0, 0 },
  { (_PROC) IntegerToIntegerTable__Delete, 0x09d96bff, "IntegerToIntegerTable.Delete", 0, 0 },
  { (_PROC) IntegerToIntegerTable__DoDelete, 0x57c9f068, "IntegerToIntegerTable.DoDelete", 0, 0 },
  { (_PROC) IntegerToIntegerTable__AvgProbesTooHigh, 0xd8791be0, "IntegerToIntegerTable.AvgProbesTooHigh", 0, 0 },
  { (_PROC) IntegerToIntegerTable__Rehash, 0x6f18d764, "IntegerToIntegerTable.Rehash", 0, 0 },
  { (_PROC) IntegerToIntegerTable__CopyEntries, 0xa9afb6a2, "IntegerToIntegerTable.CopyEntries", 0, 0 },
  { (_PROC) IntegerToIntegerTable__Clear, 0x1e5e876a, "IntegerToIntegerTable.Clear", 0, 0 },
  { (_PROC) IntegerToIntegerTable__Copy, 0xab3bb066, "IntegerToIntegerTable.Copy", 0, 0 },
  { (_PROC) IntegerToIntegerTable__ToKeyList, 0x8646f1d7, "IntegerToIntegerTable.ToKeyList", 0, 0 },
  { (_PROC) IntegerToIntegerTable__ToValueList, 0x8646f1d7, "IntegerToIntegerTable.ToValueList", 0, 0 },
  { (_PROC) IntegerToIntegerTable__ToAssocList, 0x8646f1d7, "IntegerToIntegerTable.ToAssocList", 0, 0 },
  { (_PROC) IntegerToIntegerTable__Enumerate, 0x055138be, "IntegerToIntegerTable.Enumerate", 0, 0 },
  { (_PROC)0, 0, 0, 0, 0 }
};
_PRIVATE _TYPE_INFO _type_info [] = {
  { 0x5e18e439, 0, 0, _fp_data + 0, 4, 0, 8 }, 	/* IntegerToIntegerTable.Entry */
  { 0xbf05c01a, 0, 0, _fp_data + 4, 3, 0, 5 }, 	/*  */
  { 0xf8a86f10, 0, 0, _fp_data + 7, 3, 0, 9 }, 	/* IntegerToIntegerTable.Buckets */
  { 0x056bf944, 0, 0, _fp_data + 10, 11, 0, 8 }, 	/* IntegerToIntegerTable.TableRec */
  { 0xbb8a9dbe, 0, 0, _fp_data + 21, 24, 0, 3 }, 	/* IntegerToIntegerTable.TT */
  { 0x36adabfd, 0, 0, _fp_data + 45, 3, 0, 5 }, 	/*  */
  { 0x9bc60a63, 0, 0, _fp_data + 48, 4, 0, 7 }, 	/*  */
  { 0x5cb85ad0, 0, 0, _fp_data + 52, 6, 0, 7 }, 	/*  */
  { 0x6d6219e1, 0, 0, _fp_data + 58, 10, 0, 7 }, 	/*  */
  { 0xacecfc6b, 0, 0, _fp_data + 68, 5, 0, 7 }, 	/*  */
  { 0x09d96bff, 0, 0, _fp_data + 73, 6, 0, 7 }, 	/*  */
  { 0x57c9f068, 0, 0, _fp_data + 79, 9, 0, 7 }, 	/*  */
  { 0xd8791be0, 0, 0, _fp_data + 88, 4, 0, 7 }, 	/*  */
  { 0x6f18d764, 0, 0, _fp_data + 92, 4, 0, 7 }, 	/*  */
  { 0xa9afb6a2, 0, 0, _fp_data + 96, 6, 0, 7 }, 	/*  */
  { 0x1e5e876a, 0, 0, _fp_data + 102, 3, 0, 7 }, 	/*  */
  { 0xab3bb066, 0, 0, _fp_data + 105, 4, 0, 7 }, 	/*  */
  { 0x8646f1d7, 0, 0, _fp_data + 109, 4, 0, 7 }, 	/*  */
  { 0x055138be, 0, 0, _fp_data + 113, 8, 0, 7 }, 	/*  */
  { 0xc0059bc6, 0, 0, _fp_data + 121, 3, 0, 9 }, 	/*  */
  { 0, 0, 0, 0, 0, 0, 0 }
};
_PRIVATE _TYPE* _type_cells [] = {
  &_tf8a86f10_tc, 	/* IntegerToIntegerTable.Buckets */
  &_tbb8a9dbe_tc, 	/* IntegerToIntegerTable.TT */
  &_tc0059bc6_tc, 	/*  */
  0
};
_EXPORT _LINK_INFO _M_IntegerToIntegerTable = {
  "../../libm3/table/src/IntegerToIntegerTable.m3",
  _type_info,
  _fp_data,
  _type_cells,
  _exported_full_revelations,
  _exported_partial_revelations,
  _imported_full_revelations,
  _imported_partial_revelations,
  _proc_info,
  _init_,
  0
};
