
UNSAFE MODULE SQLext;

FROM SQLtypes IMPORT SQLRETURN, SQLHSTMT, SQLUSMALLINT;

PROCEDURE SQL_LEN_DATA_AT_EXEC (length: INTEGER): INTEGER =
  BEGIN
    RETURN -length + SQL_LEN_DATA_AT_EXEC_OFFSET;
  END SQL_LEN_DATA_AT_EXEC;

PROCEDURE SQL_POSITION_TO (hstmt: SQLHSTMT;  irow: SQLUSMALLINT): SQLRETURN =
  BEGIN
    RETURN SQLSetPos (hstmt, irow, SQL_POSITION, SQL_LOCK_NO_CHANGE);
  END SQL_POSITION_TO;

PROCEDURE SQL_LOCK_RECORD (hstmt: SQLHSTMT;  irow, fLock: SQLUSMALLINT): SQLRETURN =
  BEGIN
    RETURN SQLSetPos (hstmt, irow, SQL_POSITION, fLock);
  END SQL_LOCK_RECORD;

PROCEDURE SQL_REFRESH_RECORD (hstmt: SQLHSTMT;  irow, fLock: SQLUSMALLINT): SQLRETURN =
  BEGIN
    RETURN SQLSetPos (hstmt, irow, SQL_REFRESH, fLock);
  END SQL_REFRESH_RECORD;

PROCEDURE SQL_UPDATE_RECORD (hstmt: SQLHSTMT;  irow: SQLUSMALLINT): SQLRETURN =
  BEGIN
    RETURN SQLSetPos (hstmt, irow, SQL_UPDATE, SQL_LOCK_NO_CHANGE);
  END SQL_UPDATE_RECORD;

PROCEDURE SQL_DELETE_RECORD (hstmt: SQLHSTMT;  irow: SQLUSMALLINT): SQLRETURN =
  BEGIN
    RETURN SQLSetPos (hstmt, irow, SQL_DELETE, SQL_LOCK_NO_CHANGE);
  END SQL_DELETE_RECORD;

PROCEDURE SQL_ADD_RECORD (hstmt: SQLHSTMT;  irow: SQLUSMALLINT): SQLRETURN =
  BEGIN
    RETURN SQLSetPos (hstmt, irow, SQL_ADD, SQL_LOCK_NO_CHANGE);
  END SQL_ADD_RECORD;

BEGIN
END SQLext.

