MODULE PklFontsBundle;
(* Generated by m3bundle; see its manpage. *)

IMPORT Bundle, BundleRep, Text;
IMPORT Thread, Wr, TextWr;

TYPE T = Bundle.T OBJECT OVERRIDES
           get      := LookUp;
           getNames := GetNames;
         END;

TYPE Texts = REF ARRAY OF TEXT;

VAR
  bundle: T     := NIL;
  names : Texts := NIL;

PROCEDURE Get(): Bundle.T =
  BEGIN
    IF (bundle = NIL) THEN bundle := NEW (T) END;
    RETURN bundle;
  END Get;

PROCEDURE GetNames (<*UNUSED*> self: T): Texts = 
  BEGIN
    IF names = NIL THEN
      names := NEW (Texts, NUMBER (Names));
      names^ := Names;
    END;
    RETURN names;
  END GetNames;

PROCEDURE LookUp (<*UNUSED*> self: T;  element: TEXT): TEXT = 
  BEGIN
    FOR i := 0 TO LAST (Names)-1 DO
      IF Text.Equal (Names[i], element) THEN
        IF Elements[i] = NIL THEN Elements[i] := GetElt (i) END;
        RETURN Elements[i];
      END;
    END;
    RETURN NIL;
  END LookUp;

CONST Names = ARRAY [0..16] OF TEXT {
  "ISOLatin1Encoding",
  "Courier-BoldOblique.afm",
  "Times-BoldItalic.afm",
  "Courier.afm",
  "Times-Roman.afm",
  "Helvetica-Bold.afm",
  "StandardEncoding",
  "Courier-Oblique.afm",
  "Times-Italic.afm",
  "Helvetica-BoldOblique.afm",
  "SymbolEncoding",
  "Symbol.afm",
  "Helvetica.afm",
  "Courier-Bold.afm",
  "Times-Bold.afm",
  "Helvetica-Oblique.afm",
  NIL
};

VAR Elements := ARRAY [0..16] OF TEXT {
  NIL (* E0 .. E0_0 *),
  NIL (* E1 .. E1_6 *),
  NIL (* E2 .. E2_8 *),
  NIL (* E3 .. E3_6 *),
  NIL (* E4 .. E4_7 *),
  NIL (* E5 .. E5_7 *),
  NIL (* E6 .. E6_0 *),
  NIL (* E7 .. E7_6 *),
  NIL (* E8 .. E8_8 *),
  NIL (* E9 .. E9_7 *),
  NIL (* E10 .. E10_0 *),
  NIL (* E11 .. E11_3 *),
  NIL (* E12 .. E12_7 *),
  NIL (* E13 .. E13_6 *),
  NIL (* E14 .. E14_7 *),
  NIL (* E15 .. E15_7 *),
  NIL
};

PROCEDURE GetElt (n: INTEGER): TEXT =
  <*FATAL Thread.Alerted, Wr.Failure *>
  VAR wr := TextWr.New ();
  BEGIN
    CASE n OF
    | 0 =>
        Wr.PutText (wr, E0);
        Wr.PutText (wr, E0_0);
    | 1 =>
        Wr.PutText (wr, E1);
        Wr.PutText (wr, E1_0);
        Wr.PutText (wr, E1_1);
        Wr.PutText (wr, E1_2);
        Wr.PutText (wr, E1_3);
        Wr.PutText (wr, E1_4);
        Wr.PutText (wr, E1_5);
        Wr.PutText (wr, E1_6);
    | 2 =>
        Wr.PutText (wr, E2);
        Wr.PutText (wr, E2_0);
        Wr.PutText (wr, E2_1);
        Wr.PutText (wr, E2_2);
        Wr.PutText (wr, E2_3);
        Wr.PutText (wr, E2_4);
        Wr.PutText (wr, E2_5);
        Wr.PutText (wr, E2_6);
        Wr.PutText (wr, E2_7);
        Wr.PutText (wr, E2_8);
    | 3 =>
        Wr.PutText (wr, E3);
        Wr.PutText (wr, E3_0);
        Wr.PutText (wr, E3_1);
        Wr.PutText (wr, E3_2);
        Wr.PutText (wr, E3_3);
        Wr.PutText (wr, E3_4);
        Wr.PutText (wr, E3_5);
        Wr.PutText (wr, E3_6);
    | 4 =>
        Wr.PutText (wr, E4);
        Wr.PutText (wr, E4_0);
        Wr.PutText (wr, E4_1);
        Wr.PutText (wr, E4_2);
        Wr.PutText (wr, E4_3);
        Wr.PutText (wr, E4_4);
        Wr.PutText (wr, E4_5);
        Wr.PutText (wr, E4_6);
        Wr.PutText (wr, E4_7);
    | 5 =>
        Wr.PutText (wr, E5);
        Wr.PutText (wr, E5_0);
        Wr.PutText (wr, E5_1);
        Wr.PutText (wr, E5_2);
        Wr.PutText (wr, E5_3);
        Wr.PutText (wr, E5_4);
        Wr.PutText (wr, E5_5);
        Wr.PutText (wr, E5_6);
        Wr.PutText (wr, E5_7);
    | 6 =>
        Wr.PutText (wr, E6);
        Wr.PutText (wr, E6_0);
    | 7 =>
        Wr.PutText (wr, E7);
        Wr.PutText (wr, E7_0);
        Wr.PutText (wr, E7_1);
        Wr.PutText (wr, E7_2);
        Wr.PutText (wr, E7_3);
        Wr.PutText (wr, E7_4);
        Wr.PutText (wr, E7_5);
        Wr.PutText (wr, E7_6);
    | 8 =>
        Wr.PutText (wr, E8);
        Wr.PutText (wr, E8_0);
        Wr.PutText (wr, E8_1);
        Wr.PutText (wr, E8_2);
        Wr.PutText (wr, E8_3);
        Wr.PutText (wr, E8_4);
        Wr.PutText (wr, E8_5);
        Wr.PutText (wr, E8_6);
        Wr.PutText (wr, E8_7);
        Wr.PutText (wr, E8_8);
    | 9 =>
        Wr.PutText (wr, E9);
        Wr.PutText (wr, E9_0);
        Wr.PutText (wr, E9_1);
        Wr.PutText (wr, E9_2);
        Wr.PutText (wr, E9_3);
        Wr.PutText (wr, E9_4);
        Wr.PutText (wr, E9_5);
        Wr.PutText (wr, E9_6);
        Wr.PutText (wr, E9_7);
    | 10 =>
        Wr.PutText (wr, E10);
        Wr.PutText (wr, E10_0);
    | 11 =>
        Wr.PutText (wr, E11);
        Wr.PutText (wr, E11_0);
        Wr.PutText (wr, E11_1);
        Wr.PutText (wr, E11_2);
        Wr.PutText (wr, E11_3);
    | 12 =>
        Wr.PutText (wr, E12);
        Wr.PutText (wr, E12_0);
        Wr.PutText (wr, E12_1);
        Wr.PutText (wr, E12_2);
        Wr.PutText (wr, E12_3);
        Wr.PutText (wr, E12_4);
        Wr.PutText (wr, E12_5);
        Wr.PutText (wr, E12_6);
        Wr.PutText (wr, E12_7);
    | 13 =>
        Wr.PutText (wr, E13);
        Wr.PutText (wr, E13_0);
        Wr.PutText (wr, E13_1);
        Wr.PutText (wr, E13_2);
        Wr.PutText (wr, E13_3);
        Wr.PutText (wr, E13_4);
        Wr.PutText (wr, E13_5);
        Wr.PutText (wr, E13_6);
    | 14 =>
        Wr.PutText (wr, E14);
        Wr.PutText (wr, E14_0);
        Wr.PutText (wr, E14_1);
        Wr.PutText (wr, E14_2);
        Wr.PutText (wr, E14_3);
        Wr.PutText (wr, E14_4);
        Wr.PutText (wr, E14_5);
        Wr.PutText (wr, E14_6);
        Wr.PutText (wr, E14_7);
    | 15 =>
        Wr.PutText (wr, E15);
        Wr.PutText (wr, E15_0);
        Wr.PutText (wr, E15_1);
        Wr.PutText (wr, E15_2);
        Wr.PutText (wr, E15_3);
        Wr.PutText (wr, E15_4);
        Wr.PutText (wr, E15_5);
        Wr.PutText (wr, E15_6);
        Wr.PutText (wr, E15_7);
    ELSE (*skip*)
    END;
    RETURN TextWr.ToText (wr);
  END GetElt;

CONST E0 = 
   "# Last modified on Wed Dec 21 10:59:47 PST 1994 by heydon\n#\n# This fi"
 & "le maps character names to their octal codes for the\n# PostScript ISOL"
 & "atin1 encoding. See section E.5 of the \"PostScript\n# Language Referen"
 & "ce Manual\", 2nd Edition, pp 596-597.\n\n# Names mapped to negative val"
 & "ues are unencoded in ISOLatin1. Those\n# mapped to -1 are listed in app"
 & "endix E; those mapped to -2 are not\n# listed in appendix E, but appear"
 & " in the metric files for Courier.\n\nA\t\t101\nAE\t\t306\nAacute\t\t301"
 & "\nAcircumflex\t302\nAdieresis\t304\nAgrave\t\t300\nAring\t\t305\nAtilde"
 & "\t\t303\nB\t\t102\nC\t\t103\nCcedilla\t307\nD\t\t104\nE\t\t105\nEacute\t"
 & "\t311\nEcircumflex\t312\nEdieresis\t313\nEgrave\t\t310\nEth\t\t320\nF\t"
 & "\t106\nG\t\t107\nGcaron\t\t -2\nH\t\t110\nI\t\t111\nIJ\t\t -2\nIacute\t"
 & "\t315\nIcircumflex\t316\nIdieresis\t317\nIdot\t\t -2\nIgrave\t\t314\nJ\t"
 & "\t112\nK\t\t113\nL\t\t114\nLL\t\t -2\nLslash\t\t -1\nM\t\t115\nN\t\t116"
 & "\nNtilde\t\t321\nO\t\t117\nOE\t\t -1\nOacute\t\t323\nOcircumflex\t324\n"
 & "Odieresis\t326\nOgrave\t\t322\nOslash\t\t330\nOtilde\t\t325\nP\t\t120\n"
 & "Q\t\t121\nR\t\t122\nS\t\t123\nScaron\t\t -1\nScedilla\t -2\nT\t\t124\nT"
 & "horn\t\t336\nU\t\t125\nUacute\t\t332\nUcircumflex\t333\nUdieresis\t334\n"
 & "Ugrave\t\t331\nV\t\t126\nW\t\t127\nX\t\t130\nY\t\t131\nYacute\t\t335\nY"
 & "dieresis\t -1\nZ\t\t132\nZcaron\t\t -1\na\t\t141\naacute\t\t341\nacircu"
 & "mflex\t342\nacute\t\t222\nacute\t\t264\nadieresis\t344\nae\t\t346\nagra"
 & "ve\t\t340\nampersand\t046\naring\t\t345\narrowboth\t -2\narrowdown\t -2"
 & "\narrowleft\t -2\narrowright\t -2\narrowup\t\t -2\nasciicircum\t136\nas"
 & "ciitilde\t176\nasterisk\t052\nat\t\t100\natilde\t\t343\nb\t\t142\nbacks"
 & "lash\t134\nbar\t\t174\nbraceleft\t173\nbraceright\t175\nbracketleft\t13"
 & "3\nbracketright\t135\nbreve\t\t226\nbrokenbar\t246\nbullet\t\t -1\nc\t\t"
 & "143\ncaron\t\t237\nccedilla\t347\ncedilla\t\t233\ncedilla\t\t270\ncent\t"
 & "\t242\ncenter\t\t -2\ncircumflex\t223\ncolon\t\t072\ncomma\t\t054\ncopy"
 & "right\t251\ncurrency\t244\nd\t\t144\ndagger\t\t -1\ndaggerdbl\t -1\ndec"
 & "tab\t\t -2\ndegree\t\t260\ndieresis\t230\ndieresis\t250\ndivide\t\t367\n"
 & "dollar\t\t044\ndotaccent\t227\ndotlessi\t220\ndown\t\t -2\ne\t\t145\nea"
 & "cute\t\t351\necircumflex\t352\nedieresis\t353\negrave\t\t350\neight\t\t"
 & "070\nellipsis\t -1\nemdash\t\t -1\nendash\t\t -1\nequal\t\t075\neth\t\t"
 & "360\nexclam\t\t041\nexclamdown\t241\nf\t\t146\nfi\t\t -1\nfive\t\t065\n"
 & "fl\t\t -1\nflorin\t\t -1\nformat\t\t ";

CONST E0_0 = 
   "-2\nfour\t\t064\nfraction\t -1\ng\t\t147\ngcaron\t\t -2\ngermandbls\t33"
 & "7\ngrave\t\t221\ngraybox\t\t -2\ngreater\t\t076\nguillemotleft\t253\ngu"
 & "illemotright\t273\nguilsinglleft\t -1\nguilsinglright\t -1\nh\t\t150\nh"
 & "ungarumlaut\t235\nhyphen\t\t255\ni\t\t151\niacute\t\t355\nicircumflex\t"
 & "356\nidieresis\t357\nigrave\t\t354\nij\t\t -2\nindent\t\t -2\nj\t\t152\n"
 & "k\t\t153\nl\t\t154\nlargebullet\t -2\nleft\t\t -2\nless\t\t074\nlira\t\t"
 & " -2\nll\t\t -2\nlogicalnot\t254\nlslash\t\t -1\nm\t\t155\nmacron\t\t225"
 & "\nmacron\t\t257\nmerge\t\t -2\nminus\t\t055\nmu\t\t265\nmultiply\t327\n"
 & "n\t\t156\nnine\t\t071\nnotegraphic\t -2\nntilde\t\t361\nnumbersign\t043"
 & "\no\t\t157\noacute\t\t363\nocircumflex\t364\nodieresis\t366\noe\t\t -1\n"
 & "ogonek\t\t236\nograve\t\t362\none\t\t061\nonehalf\t\t275\nonequarter\t2"
 & "74\nonesuperior\t271\nordfeminine\t252\nordmasculine\t272\noslash\t\t37"
 & "0\notilde\t\t365\noverscore\t -2\np\t\t160\nparagraph\t266\nparenleft\t"
 & "050\nparenright\t051\npercent\t\t045\nperiod\t\t056\nperiodcentered\t26"
 & "7\nperthousand\t -1\nplus\t\t053\nplusminus\t261\nprescription\t -2\nq\t"
 & "\t161\nquestion\t077\nquestiondown\t277\nquotedbl\t042\nquotedblbase\t "
 & "-1\nquotedblleft\t -1\nquotedblright\t -1\nquoteleft\t140\nquoteright\t"
 & "047\nquotesinglbase\t -1\nquotesingle\t -1\nr\t\t162\nregistered\t256\n"
 & "return\t\t -2\nring\t\t232\ns\t\t163\nscaron\t\t -1\nscedilla\t -2\nsec"
 & "tion\t\t247\nsemicolon\t073\nseven\t\t067\nsix\t\t066\nslash\t\t057\nsp"
 & "ace\t\t040\nsquare\t\t -2\nsterling\t243\nstop\t\t -2\nt\t\t164\ntab\t\t"
 & " -2\nthorn\t\t376\nthree\t\t063\nthreequarters\t276\nthreesuperior\t263"
 & "\ntilde\t\t224\ntrademark\t -1\ntwo\t\t062\ntwosuperior\t262\nu\t\t165\n"
 & "uacute\t\t372\nucircumflex\t373\nudieresis\t374\nugrave\t\t371\nundersc"
 & "ore\t137\nup\t\t -2\nv\t\t166\nw\t\t167\nx\t\t170\ny\t\t171\nyacute\t\t"
 & "375\nydieresis\t377\nyen\t\t245\nz\t\t172\nzcaron\t\t -1\nzero\t\t060\n"
;

CONST E1 = 
   "StartFontMetrics 2.0\nComment Copyright (c) 1989, 1990, 1991, Adobe Sys"
 & "tems Incorporated. All rights reserved.\nComment Creation Date: Tue Sep"
 & " 17 14:13:24 1991\nComment UniqueID 36389\nComment VMusage 10055 54684\n"
 & "FontName Courier-BoldOblique\nFullName Courier Bold Oblique\nFamilyName"
 & " Courier\nWeight Bold\nItalicAngle -12\nIsFixedPitch true\nFontBBox -56"
 & " -250 868 801\nUnderlinePosition -100\nUnderlineThickness 50\nVersion 0"
 & "02.004\nNotice Copyright (c) 1989, 1990, 1991, Adobe Systems Incorporat"
 & "ed. All rights reserved.\nEncodingScheme AdobeStandardEncoding\nCapHeig"
 & "ht 562\nXHeight 439\nAscender 626\nDescender -142\nStartCharMetrics 260"
 & "\nC 32 ; WX 600 ; N space ; B 0 0 0 0 ;\nC 33 ; WX 600 ; N exclam ; B 2"
 & "16 -15 495 572 ;\nC 34 ; WX 600 ; N quotedbl ; B 212 277 584 562 ;\nC 3"
 & "5 ; WX 600 ; N numbersign ; B 88 -45 640 651 ;\nC 36 ; WX 600 ; N dolla"
 & "r ; B 87 -126 629 666 ;\nC 37 ; WX 600 ; N percent ; B 102 -15 624 616 "
 & ";\nC 38 ; WX 600 ; N ampersand ; B 62 -15 594 543 ;\nC 39 ; WX 600 ; N "
 & "quoteright ; B 230 277 542 562 ;\nC 40 ; WX 600 ; N parenleft ; B 266 -"
 & "102 592 616 ;\nC 41 ; WX 600 ; N parenright ; B 117 -102 444 616 ;\nC 4"
 & "2 ; WX 600 ; N asterisk ; B 179 219 597 601 ;\nC 43 ; WX 600 ; N plus ;"
 & " B 114 39 596 478 ;\nC 44 ; WX 600 ; N comma ; B 99 -111 430 174 ;\nC 4"
 & "5 ; WX 600 ; N hyphen ; B 143 203 567 313 ;\nC 46 ; WX 600 ; N period ;"
 & " B 207 -15 426 171 ;\nC 47 ; WX 600 ; N slash ; B 91 -77 626 626 ;\nC 4"
 & "8 ; WX 600 ; N zero ; B 136 -15 592 616 ;\nC 49 ; WX 600 ; N one ; B 93"
 & " 0 561 616 ;\nC 50 ; WX 600 ; N two ; B 61 0 593 616 ;\nC 51 ; WX 600 ;"
 & " N three ; B 72 -15 571 616 ;\nC 52 ; WX 600 ; N four ; B 82 0 558 616 "
 & ";\nC 53 ; WX 600 ; N five ; B 77 -15 621 601 ;\nC 54 ; WX 600 ; N six ;"
 & " B 136 -15 652 616 ;\nC 55 ; WX 600 ; N seven ; B 147 0 622 601 ;\nC 56"
 & " ; WX 600 ; N eight ; B 115 -15 604 616 ;\nC 57 ; WX 600 ; N nine ; B 7"
 & "6 -15 592 616 ;\nC 58 ; WX 600 ; N colon ; B 206 -15 479 425 ;\nC 59 ; "
 & "WX 600 ; N semicolon ; B 99 -111 480 425 ;\nC 60 ; WX 600 ; N less ; B "
 & "121 15 612 501 ;\nC 61 ; WX 600 ; N equal ; B 96 118 614 398 ;";

CONST E1_0 = 
   "\nC 62 ; WX 600 ; N greater ; B 97 15 589 501 ;\nC 63 ; WX 600 ; N ques"
 & "tion ; B 183 -14 591 580 ;\nC 64 ; WX 600 ; N at ; B 66 -15 641 616 ;\n"
 & "C 65 ; WX 600 ; N A ; B -9 0 631 562 ;\nC 66 ; WX 600 ; N B ; B 30 0 62"
 & "9 562 ;\nC 67 ; WX 600 ; N C ; B 75 -18 674 580 ;\nC 68 ; WX 600 ; N D "
 & "; B 30 0 664 562 ;\nC 69 ; WX 600 ; N E ; B 25 0 669 562 ;\nC 70 ; WX 6"
 & "00 ; N F ; B 39 0 683 562 ;\nC 71 ; WX 600 ; N G ; B 75 -18 674 580 ;\n"
 & "C 72 ; WX 600 ; N H ; B 20 0 699 562 ;\nC 73 ; WX 600 ; N I ; B 77 0 64"
 & "2 562 ;\nC 74 ; WX 600 ; N J ; B 59 -18 720 562 ;\nC 75 ; WX 600 ; N K "
 & "; B 21 0 691 562 ;\nC 76 ; WX 600 ; N L ; B 39 0 635 562 ;\nC 77 ; WX 6"
 & "00 ; N M ; B -2 0 721 562 ;\nC 78 ; WX 600 ; N N ; B 8 -12 729 562 ;\nC"
 & " 79 ; WX 600 ; N O ; B 74 -18 645 580 ;\nC 80 ; WX 600 ; N P ; B 48 0 6"
 & "42 562 ;\nC 81 ; WX 600 ; N Q ; B 84 -138 636 580 ;\nC 82 ; WX 600 ; N "
 & "R ; B 24 0 617 562 ;\nC 83 ; WX 600 ; N S ; B 54 -22 672 582 ;\nC 84 ; "
 & "WX 600 ; N T ; B 86 0 678 562 ;\nC 85 ; WX 600 ; N U ; B 101 -18 715 56"
 & "2 ;\nC 86 ; WX 600 ; N V ; B 84 0 732 562 ;\nC 87 ; WX 600 ; N W ; B 84"
 & " 0 737 562 ;\nC 88 ; WX 600 ; N X ; B 12 0 689 562 ;\nC 89 ; WX 600 ; N"
 & " Y ; B 109 0 708 562 ;\nC 90 ; WX 600 ; N Z ; B 62 0 636 562 ;\nC 91 ; "
 & "WX 600 ; N bracketleft ; B 223 -102 606 616 ;\nC 92 ; WX 600 ; N backsl"
 & "ash ; B 223 -77 496 626 ;\nC 93 ; WX 600 ; N bracketright ; B 103 -102 "
 & "486 616 ;\nC 94 ; WX 600 ; N asciicircum ; B 171 250 555 616 ;\nC 95 ; "
 & "WX 600 ; N underscore ; B -27 -125 584 -75 ;\nC 96 ; WX 600 ; N quotele"
 & "ft ; B 297 277 487 562 ;\nC 97 ; WX 600 ; N a ; B 62 -15 592 454 ;\nC 9"
 & "8 ; WX 600 ; N b ; B 13 -15 636 626 ;\nC 99 ; WX 600 ; N c ; B 81 -15 6"
 & "31 459 ;\nC 100 ; WX 600 ; N d ; B 61 -15 644 626 ;\nC 101 ; WX 600 ; N"
 & " e ; B 81 -15 604 454 ;\nC 102 ; WX 600 ; N f ; B 83 0 677 626 ; L i fi"
 & " ; L l fl ;\nC 103 ; WX 600 ; N g ; B 41 -146 673 454 ;\nC 104 ; WX 600"
 & " ; N h ; B 18 0 614 626 ;\nC 105 ; WX 600 ; N i ; B 77 0 545 658 ;\nC 1"
 & "06 ; WX 600 ; N j ; B 37 -146 580 658 ;\nC 107 ; WX 600 ; N k ; B 33 0 "
 & "642 626 ;\nC 108 ; WX 600 ; N l ; B 77 0 545 626 ;\nC 109 ; ";

CONST E1_1 = 
   "WX 600 ; N m ; B -22 0 648 454 ;\nC 110 ; WX 600 ; N n ; B 18 0 614 454"
 & " ;\nC 111 ; WX 600 ; N o ; B 71 -15 622 454 ;\nC 112 ; WX 600 ; N p ; B"
 & " -31 -142 622 454 ;\nC 113 ; WX 600 ; N q ; B 61 -142 684 454 ;\nC 114 "
 & "; WX 600 ; N r ; B 47 0 654 454 ;\nC 115 ; WX 600 ; N s ; B 67 -17 607 "
 & "459 ;\nC 116 ; WX 600 ; N t ; B 118 -15 566 562 ;\nC 117 ; WX 600 ; N u"
 & " ; B 70 -15 591 439 ;\nC 118 ; WX 600 ; N v ; B 70 0 694 439 ;\nC 119 ;"
 & " WX 600 ; N w ; B 53 0 711 439 ;\nC 120 ; WX 600 ; N x ; B 6 0 670 439 "
 & ";\nC 121 ; WX 600 ; N y ; B -20 -142 694 439 ;\nC 122 ; WX 600 ; N z ; "
 & "B 81 0 613 439 ;\nC 123 ; WX 600 ; N braceleft ; B 204 -102 595 616 ;\n"
 & "C 124 ; WX 600 ; N bar ; B 202 -250 504 750 ;\nC 125 ; WX 600 ; N brace"
 & "right ; B 114 -102 506 616 ;\nC 126 ; WX 600 ; N asciitilde ; B 120 153"
 & " 589 356 ;\nC 161 ; WX 600 ; N exclamdown ; B 197 -146 477 449 ;\nC 162"
 & " ; WX 600 ; N cent ; B 121 -49 604 614 ;\nC 163 ; WX 600 ; N sterling ;"
 & " B 107 -28 650 611 ;\nC 164 ; WX 600 ; N fraction ; B 22 -60 707 661 ;\n"
 & "C 165 ; WX 600 ; N yen ; B 98 0 709 562 ;\nC 166 ; WX 600 ; N florin ; "
 & "B -56 -131 701 616 ;\nC 167 ; WX 600 ; N section ; B 74 -70 619 580 ;\n"
 & "C 168 ; WX 600 ; N currency ; B 77 49 643 517 ;\nC 169 ; WX 600 ; N quo"
 & "tesingle ; B 304 277 492 562 ;\nC 170 ; WX 600 ; N quotedblleft ; B 190"
 & " 277 594 562 ;\nC 171 ; WX 600 ; N guillemotleft ; B 63 70 638 446 ;\nC"
 & " 172 ; WX 600 ; N guilsinglleft ; B 196 70 544 446 ;\nC 173 ; WX 600 ; "
 & "N guilsinglright ; B 166 70 514 446 ;\nC 174 ; WX 600 ; N fi ; B 12 0 6"
 & "43 626 ;\nC 175 ; WX 600 ; N fl ; B 12 0 643 626 ;\nC 177 ; WX 600 ; N "
 & "endash ; B 108 203 602 313 ;\nC 178 ; WX 600 ; N dagger ; B 176 -70 586"
 & " 580 ;\nC 179 ; WX 600 ; N daggerdbl ; B 122 -70 586 580 ;\nC 180 ; WX "
 & "600 ; N periodcentered ; B 249 165 461 351 ;\nC 182 ; WX 600 ; N paragr"
 & "aph ; B 61 -70 699 580 ;\nC 183 ; WX 600 ; N bullet ; B 197 132 523 430"
 & " ;\nC 184 ; WX 600 ; N quotesinglbase ; B 145 -142 457 143 ;\nC 185 ; W"
 & "X 600 ; N quotedblbase ; B 35 -142 559 143 ;\nC 186 ; WX 600 ; N quoted"
 & "blright ; B 120 277 644 562 ;\nC 187 ; WX 600 ; N gui";

CONST E1_2 = 
   "llemotright ; B 72 70 647 446 ;\nC 188 ; WX 600 ; N ellipsis ; B 35 -15"
 & " 586 116 ;\nC 189 ; WX 600 ; N perthousand ; B -44 -15 742 616 ;\nC 191"
 & " ; WX 600 ; N questiondown ; B 101 -146 509 449 ;\nC 193 ; WX 600 ; N g"
 & "rave ; B 272 508 503 661 ;\nC 194 ; WX 600 ; N acute ; B 313 508 608 66"
 & "1 ;\nC 195 ; WX 600 ; N circumflex ; B 212 483 606 657 ;\nC 196 ; WX 60"
 & "0 ; N tilde ; B 200 493 642 636 ;\nC 197 ; WX 600 ; N macron ; B 195 50"
 & "5 636 585 ;\nC 198 ; WX 600 ; N breve ; B 217 468 651 631 ;\nC 199 ; WX"
 & " 600 ; N dotaccent ; B 346 485 490 625 ;\nC 200 ; WX 600 ; N dieresis ;"
 & " B 244 485 592 625 ;\nC 202 ; WX 600 ; N ring ; B 319 481 528 678 ;\nC "
 & "203 ; WX 600 ; N cedilla ; B 169 -206 367 0 ;\nC 205 ; WX 600 ; N hunga"
 & "rumlaut ; B 172 488 728 661 ;\nC 206 ; WX 600 ; N ogonek ; B 144 -199 3"
 & "50 0 ;\nC 207 ; WX 600 ; N caron ; B 238 493 632 667 ;\nC 208 ; WX 600 "
 & "; N emdash ; B 33 203 677 313 ;\nC 225 ; WX 600 ; N AE ; B -29 0 707 56"
 & "2 ;\nC 227 ; WX 600 ; N ordfeminine ; B 189 196 526 580 ;\nC 232 ; WX 6"
 & "00 ; N Lslash ; B 39 0 635 562 ;\nC 233 ; WX 600 ; N Oslash ; B 48 -22 "
 & "672 584 ;\nC 234 ; WX 600 ; N OE ; B 26 0 700 562 ;\nC 235 ; WX 600 ; N"
 & " ordmasculine ; B 189 196 542 580 ;\nC 241 ; WX 600 ; N ae ; B 21 -15 6"
 & "51 454 ;\nC 245 ; WX 600 ; N dotlessi ; B 77 0 545 439 ;\nC 248 ; WX 60"
 & "0 ; N lslash ; B 77 0 578 626 ;\nC 249 ; WX 600 ; N oslash ; B 55 -24 6"
 & "37 463 ;\nC 250 ; WX 600 ; N oe ; B 19 -15 661 454 ;\nC 251 ; WX 600 ; "
 & "N germandbls ; B 22 -15 628 626 ;\nC -1 ; WX 600 ; N Odieresis ; B 74 -"
 & "18 645 748 ;\nC -1 ; WX 600 ; N logicalnot ; B 135 103 617 413 ;\nC -1 "
 & "; WX 600 ; N minus ; B 114 203 596 313 ;\nC -1 ; WX 600 ; N merge ; B 1"
 & "68 -15 533 487 ;\nC -1 ; WX 600 ; N degree ; B 173 243 569 616 ;\nC -1 "
 & "; WX 600 ; N dectab ; B 8 0 615 320 ;\nC -1 ; WX 600 ; N ll ; B 1 0 653"
 & " 626 ;\nC -1 ; WX 600 ; N IJ ; B -8 -18 741 562 ;\nC -1 ; WX 600 ; N Ea"
 & "cute ; B 25 0 669 784 ;\nC -1 ; WX 600 ; N Ocircumflex ; B 74 -18 645 7"
 & "80 ;\nC -1 ; WX 600 ; N ucircumflex ; B 70 -15 591 657 ;\nC -1 ; WX 600"
 & " ; N left ; B 109 44 589 371 ;\nC -1 ; WX 600 ; N thre";

CONST E1_3 = 
   "esuperior ; B 193 222 525 616 ;\nC -1 ; WX 600 ; N up ; B 196 0 523 447"
 & " ;\nC -1 ; WX 600 ; N multiply ; B 105 39 606 478 ;\nC -1 ; WX 600 ; N "
 & "Scaron ; B 54 -22 672 790 ;\nC -1 ; WX 600 ; N tab ; B 19 0 641 562 ;\n"
 & "C -1 ; WX 600 ; N Ucircumflex ; B 101 -18 715 780 ;\nC -1 ; WX 600 ; N "
 & "divide ; B 114 16 596 500 ;\nC -1 ; WX 600 ; N Acircumflex ; B -9 0 631"
 & " 780 ;\nC -1 ; WX 600 ; N eacute ; B 81 -15 608 661 ;\nC -1 ; WX 600 ; "
 & "N uacute ; B 70 -15 608 661 ;\nC -1 ; WX 600 ; N Aacute ; B -9 0 665 78"
 & "4 ;\nC -1 ; WX 600 ; N copyright ; B 53 -18 667 580 ;\nC -1 ; WX 600 ; "
 & "N twosuperior ; B 192 230 541 616 ;\nC -1 ; WX 600 ; N Ecircumflex ; B "
 & "25 0 669 780 ;\nC -1 ; WX 600 ; N ntilde ; B 18 0 642 636 ;\nC -1 ; WX "
 & "600 ; N down ; B 168 -15 496 439 ;\nC -1 ; WX 600 ; N center ; B 103 14"
 & " 623 580 ;\nC -1 ; WX 600 ; N onesuperior ; B 213 230 514 616 ;\nC -1 ;"
 & " WX 600 ; N ij ; B 6 -146 714 658 ;\nC -1 ; WX 600 ; N edieresis ; B 81"
 & " -15 604 625 ;\nC -1 ; WX 600 ; N graybox ; B 76 0 652 599 ;\nC -1 ; WX"
 & " 600 ; N odieresis ; B 71 -15 622 625 ;\nC -1 ; WX 600 ; N Ograve ; B 7"
 & "4 -18 645 784 ;\nC -1 ; WX 600 ; N threequarters ; B 8 -60 698 661 ;\nC"
 & " -1 ; WX 600 ; N plusminus ; B 76 24 614 515 ;\nC -1 ; WX 600 ; N presc"
 & "ription ; B 24 -15 632 562 ;\nC -1 ; WX 600 ; N eth ; B 93 -27 661 626 "
 & ";\nC -1 ; WX 600 ; N largebullet ; B 307 229 413 333 ;\nC -1 ; WX 600 ;"
 & " N egrave ; B 81 -15 604 661 ;\nC -1 ; WX 600 ; N ccedilla ; B 81 -206 "
 & "631 459 ;\nC -1 ; WX 600 ; N notegraphic ; B 91 -15 619 572 ;\nC -1 ; W"
 & "X 600 ; N Udieresis ; B 101 -18 715 748 ;\nC -1 ; WX 600 ; N Gcaron ; B"
 & " 75 -18 674 790 ;\nC -1 ; WX 600 ; N arrowdown ; B 174 -15 486 608 ;\nC"
 & " -1 ; WX 600 ; N format ; B -26 -146 243 601 ;\nC -1 ; WX 600 ; N Otild"
 & "e ; B 74 -18 668 759 ;\nC -1 ; WX 600 ; N Idieresis ; B 77 0 642 748 ;\n"
 & "C -1 ; WX 600 ; N adieresis ; B 62 -15 592 625 ;\nC -1 ; WX 600 ; N eci"
 & "rcumflex ; B 81 -15 606 657 ;\nC -1 ; WX 600 ; N Eth ; B 30 0 664 562 ;"
 & "\nC -1 ; WX 600 ; N onequarter ; B 14 -60 706 661 ;\nC -1 ; WX 600 ; N "
 & "LL ; B -45 0 694 562 ;\nC -1 ; WX 600 ; N agrave ; B ";

CONST E1_4 = 
   "62 -15 592 661 ;\nC -1 ; WX 600 ; N Zcaron ; B 62 0 659 790 ;\nC -1 ; W"
 & "X 600 ; N Scedilla ; B 54 -206 672 582 ;\nC -1 ; WX 600 ; N Idot ; B 77"
 & " 0 642 748 ;\nC -1 ; WX 600 ; N Iacute ; B 77 0 642 784 ;\nC -1 ; WX 60"
 & "0 ; N indent ; B 99 45 579 372 ;\nC -1 ; WX 600 ; N Ugrave ; B 101 -18 "
 & "715 784 ;\nC -1 ; WX 600 ; N scaron ; B 67 -17 632 667 ;\nC -1 ; WX 600"
 & " ; N overscore ; B 123 579 734 629 ;\nC -1 ; WX 600 ; N Aring ; B -9 0 "
 & "631 801 ;\nC -1 ; WX 600 ; N Ccedilla ; B 74 -206 674 580 ;\nC -1 ; WX "
 & "600 ; N Igrave ; B 77 0 642 784 ;\nC -1 ; WX 600 ; N brokenbar ; B 218 "
 & "-175 488 675 ;\nC -1 ; WX 600 ; N Oacute ; B 74 -18 645 784 ;\nC -1 ; W"
 & "X 600 ; N otilde ; B 71 -15 642 636 ;\nC -1 ; WX 600 ; N Yacute ; B 109"
 & " 0 708 784 ;\nC -1 ; WX 600 ; N lira ; B 107 -28 650 611 ;\nC -1 ; WX 6"
 & "00 ; N Icircumflex ; B 77 0 642 780 ;\nC -1 ; WX 600 ; N Atilde ; B -9 "
 & "0 638 759 ;\nC -1 ; WX 600 ; N Uacute ; B 101 -18 715 784 ;\nC -1 ; WX "
 & "600 ; N Ydieresis ; B 109 0 708 748 ;\nC -1 ; WX 600 ; N ydieresis ; B "
 & "-20 -142 694 625 ;\nC -1 ; WX 600 ; N idieresis ; B 77 0 552 625 ;\nC -"
 & "1 ; WX 600 ; N Adieresis ; B -9 0 631 748 ;\nC -1 ; WX 600 ; N mu ; B 5"
 & "0 -142 591 439 ;\nC -1 ; WX 600 ; N trademark ; B 86 230 868 562 ;\nC -"
 & "1 ; WX 600 ; N oacute ; B 71 -15 622 661 ;\nC -1 ; WX 600 ; N acircumfl"
 & "ex ; B 62 -15 592 657 ;\nC -1 ; WX 600 ; N Agrave ; B -9 0 631 784 ;\nC"
 & " -1 ; WX 600 ; N return ; B 79 0 700 562 ;\nC -1 ; WX 600 ; N atilde ; "
 & "B 62 -15 642 636 ;\nC -1 ; WX 600 ; N square ; B 19 0 700 562 ;\nC -1 ;"
 & " WX 600 ; N registered ; B 53 -18 667 580 ;\nC -1 ; WX 600 ; N stop ; B"
 & " 19 0 700 562 ;\nC -1 ; WX 600 ; N udieresis ; B 70 -15 591 625 ;\nC -1"
 & " ; WX 600 ; N arrowup ; B 244 3 556 626 ;\nC -1 ; WX 600 ; N igrave ; B"
 & " 77 0 545 661 ;\nC -1 ; WX 600 ; N Edieresis ; B 25 0 669 748 ;\nC -1 ;"
 & " WX 600 ; N zcaron ; B 81 0 632 667 ;\nC -1 ; WX 600 ; N arrowboth ; B "
 & "40 143 688 455 ;\nC -1 ; WX 600 ; N gcaron ; B 41 -146 673 667 ;\nC -1 "
 & "; WX 600 ; N arrowleft ; B 40 143 708 455 ;\nC -1 ; WX 600 ; N aacute ;"
 & " B 62 -15 608 661 ;\nC -1 ; WX 600 ; N ocircumflex ; B ";

CONST E1_5 = 
   "71 -15 622 657 ;\nC -1 ; WX 600 ; N scedilla ; B 67 -206 607 459 ;\nC -"
 & "1 ; WX 600 ; N ograve ; B 71 -15 622 661 ;\nC -1 ; WX 600 ; N onehalf ;"
 & " B 23 -60 715 661 ;\nC -1 ; WX 600 ; N ugrave ; B 70 -15 591 661 ;\nC -"
 & "1 ; WX 600 ; N Ntilde ; B 8 -12 729 759 ;\nC -1 ; WX 600 ; N iacute ; B"
 & " 77 0 608 661 ;\nC -1 ; WX 600 ; N arrowright ; B 20 143 688 455 ;\nC -"
 & "1 ; WX 600 ; N Thorn ; B 48 0 619 562 ;\nC -1 ; WX 600 ; N Egrave ; B 2"
 & "5 0 669 784 ;\nC -1 ; WX 600 ; N thorn ; B -31 -142 622 626 ;\nC -1 ; W"
 & "X 600 ; N aring ; B 62 -15 592 678 ;\nC -1 ; WX 600 ; N yacute ; B -20 "
 & "-142 694 661 ;\nC -1 ; WX 600 ; N icircumflex ; B 77 0 566 657 ;\nEndCh"
 & "arMetrics\nStartComposites 58\nCC Aacute 2 ; PCC A 0 0 ; PCC acute 56 1"
 & "23 ;\nCC Acircumflex 2 ; PCC A 0 0 ; PCC circumflex -4 123 ;\nCC Adiere"
 & "sis 2 ; PCC A 0 0 ; PCC dieresis 6 123 ;\nCC Agrave 2 ; PCC A 0 0 ; PCC"
 & " grave -24 123 ;\nCC Aring 2 ; PCC A 0 0 ; PCC ring 16 123 ;\nCC Atilde"
 & " 2 ; PCC A 0 0 ; PCC tilde -4 123 ;\nCC Eacute 2 ; PCC E 0 0 ; PCC acut"
 & "e 56 123 ;\nCC Ecircumflex 2 ; PCC E 0 0 ; PCC circumflex 26 123 ;\nCC "
 & "Edieresis 2 ; PCC E 0 0 ; PCC dieresis 26 123 ;\nCC Egrave 2 ; PCC E 0 "
 & "0 ; PCC grave 26 123 ;\nCC Gcaron 2 ; PCC G 0 0 ; PCC caron 36 123 ;\nC"
 & "C Iacute 2 ; PCC I 0 0 ; PCC acute 26 123 ;\nCC Icircumflex 2 ; PCC I 0"
 & " 0 ; PCC circumflex 26 123 ;\nCC Idieresis 2 ; PCC I 0 0 ; PCC dieresis"
 & " 26 123 ;\nCC Igrave 2 ; PCC I 0 0 ; PCC grave 26 123 ;\nCC Ntilde 2 ; "
 & "PCC N 0 0 ; PCC tilde 26 123 ;\nCC Oacute 2 ; PCC O 0 0 ; PCC acute 26 "
 & "123 ;\nCC Ocircumflex 2 ; PCC O 0 0 ; PCC circumflex 26 123 ;\nCC Odier"
 & "esis 2 ; PCC O 0 0 ; PCC dieresis 26 123 ;\nCC Ograve 2 ; PCC O 0 0 ; P"
 & "CC grave 26 123 ;\nCC Otilde 2 ; PCC O 0 0 ; PCC tilde 26 123 ;\nCC Sca"
 & "ron 2 ; PCC S 0 0 ; PCC caron 26 123 ;\nCC Uacute 2 ; PCC U 0 0 ; PCC a"
 & "cute 56 123 ;\nCC Ucircumflex 2 ; PCC U 0 0 ; PCC circumflex 26 123 ;\n"
 & "CC Udieresis 2 ; PCC U 0 0 ; PCC dieresis 26 123 ;\nCC Ugrave 2 ; PCC U"
 & " 0 0 ; PCC grave -4 123 ;\nCC Yacute 2 ; PCC Y 0 0 ; PCC acute 56 123 ;"
 & "\nCC Ydieresis 2 ; PCC Y 0 0 ; PCC dieresis 26 123 ;\nCC";

CONST E1_6 = 
   " Zcaron 2 ; PCC Z 0 0 ; PCC caron 26 123 ;\nCC aacute 2 ; PCC a 0 0 ; P"
 & "CC acute 0 0 ;\nCC acircumflex 2 ; PCC a 0 0 ; PCC circumflex -20 0 ;\n"
 & "CC adieresis 2 ; PCC a 0 0 ; PCC dieresis -10 0 ;\nCC agrave 2 ; PCC a "
 & "0 0 ; PCC grave -30 0 ;\nCC aring 2 ; PCC a 0 0 ; PCC ring 0 0 ;\nCC at"
 & "ilde 2 ; PCC a 0 0 ; PCC tilde 0 0 ;\nCC eacute 2 ; PCC e 0 0 ; PCC acu"
 & "te 0 0 ;\nCC ecircumflex 2 ; PCC e 0 0 ; PCC circumflex 0 0 ;\nCC edier"
 & "esis 2 ; PCC e 0 0 ; PCC dieresis 0 0 ;\nCC egrave 2 ; PCC e 0 0 ; PCC "
 & "grave 0 0 ;\nCC gcaron 2 ; PCC g 0 0 ; PCC caron -40 0 ;\nCC iacute 2 ;"
 & " PCC dotlessi 0 0 ; PCC acute 0 0 ;\nCC icircumflex 2 ; PCC dotlessi 0 "
 & "0 ; PCC circumflex -40 0 ;\nCC idieresis 2 ; PCC dotlessi 0 0 ; PCC die"
 & "resis -40 0 ;\nCC igrave 2 ; PCC dotlessi 0 0 ; PCC grave 0 0 ;\nCC nti"
 & "lde 2 ; PCC n 0 0 ; PCC tilde 0 0 ;\nCC oacute 2 ; PCC o 0 0 ; PCC acut"
 & "e 0 0 ;\nCC ocircumflex 2 ; PCC o 0 0 ; PCC circumflex 0 0 ;\nCC odiere"
 & "sis 2 ; PCC o 0 0 ; PCC dieresis 0 0 ;\nCC ograve 2 ; PCC o 0 0 ; PCC g"
 & "rave 0 0 ;\nCC otilde 2 ; PCC o 0 0 ; PCC tilde 0 0 ;\nCC scaron 2 ; PC"
 & "C s 0 0 ; PCC caron 0 0 ;\nCC uacute 2 ; PCC u 0 0 ; PCC acute 0 0 ;\nC"
 & "C ucircumflex 2 ; PCC u 0 0 ; PCC circumflex -20 0 ;\nCC udieresis 2 ; "
 & "PCC u 0 0 ; PCC dieresis -20 0 ;\nCC ugrave 2 ; PCC u 0 0 ; PCC grave -"
 & "30 0 ;\nCC yacute 2 ; PCC y 0 0 ; PCC acute 30 0 ;\nCC ydieresis 2 ; PC"
 & "C y 0 0 ; PCC dieresis 10 0 ;\nCC zcaron 2 ; PCC z 0 0 ; PCC caron 0 0 "
 & ";\nEndComposites\nEndFontMetrics\n";

CONST E2 = 
   "StartFontMetrics 2.0\nComment Copyright (c) 1985, 1987, 1989, 1990 Adob"
 & "e Systems Incorporated.  All Rights Reserved.\nComment Creation Date: T"
 & "ue Mar 20 13:14:55 1990\nComment UniqueID 28425\nComment VMusage 32721 "
 & "39613\nFontName Times-BoldItalic\nFullName Times Bold Italic\nFamilyNam"
 & "e Times\nWeight Bold\nItalicAngle -15\nIsFixedPitch false\nFontBBox -20"
 & "0 -218 996 921\nUnderlinePosition -100\nUnderlineThickness 50\nVersion "
 & "001.009\nNotice Copyright (c) 1985, 1987, 1989, 1990 Adobe Systems Inco"
 & "rporated.  All Rights Reserved.Times is a trademark of Linotype AG and/"
 & "or its subsidiaries.\nEncodingScheme AdobeStandardEncoding\nCapHeight 6"
 & "69\nXHeight 462\nAscender 699\nDescender -205\nStartCharMetrics 228\nC "
 & "32 ; WX 250 ; N space ; B 0 0 0 0 ;\nC 33 ; WX 389 ; N exclam ; B 67 -1"
 & "3 370 684 ;\nC 34 ; WX 555 ; N quotedbl ; B 136 398 536 685 ;\nC 35 ; W"
 & "X 500 ; N numbersign ; B -33 0 533 700 ;\nC 36 ; WX 500 ; N dollar ; B "
 & "-20 -100 497 733 ;\nC 37 ; WX 833 ; N percent ; B 39 -10 793 692 ;\nC 3"
 & "8 ; WX 778 ; N ampersand ; B 5 -19 699 682 ;\nC 39 ; WX 333 ; N quoteri"
 & "ght ; B 98 369 302 685 ;\nC 40 ; WX 333 ; N parenleft ; B 28 -179 344 6"
 & "85 ;\nC 41 ; WX 333 ; N parenright ; B -44 -179 271 685 ;\nC 42 ; WX 50"
 & "0 ; N asterisk ; B 65 249 456 685 ;\nC 43 ; WX 570 ; N plus ; B 33 0 53"
 & "7 506 ;\nC 44 ; WX 250 ; N comma ; B -60 -182 144 134 ;\nC 45 ; WX 333 "
 & "; N hyphen ; B 2 166 271 282 ;\nC 46 ; WX 250 ; N period ; B -9 -13 139"
 & " 135 ;\nC 47 ; WX 278 ; N slash ; B -64 -18 342 685 ;\nC 48 ; WX 500 ; "
 & "N zero ; B 17 -14 477 683 ;\nC 49 ; WX 500 ; N one ; B 5 0 419 683 ;\nC"
 & " 50 ; WX 500 ; N two ; B -27 0 446 683 ;\nC 51 ; WX 500 ; N three ; B -"
 & "15 -13 450 683 ;\nC 52 ; WX 500 ; N four ; B -15 0 503 683 ;\nC 53 ; WX"
 & " 500 ; N five ; B -11 -13 487 669 ;\nC 54 ; WX 500 ; N six ; B 23 -15 5"
 & "09 679 ;\nC 55 ; WX 500 ; N seven ; B 52 0 525 669 ;\nC 56 ; WX 500 ; N"
 & " eight ; B 3 -13 476 683 ;\nC 57 ; WX 500 ; N nine ; B -12 -10 475 683 "
 & ";\nC 58 ; WX 333 ; N colon ; B 23 -13 264 459 ;\nC 59 ; WX 333 ; N semi"
 & "colon ; B -25 -183 264 459 ;\nC 60 ; WX 570 ; N less ; B 31 -8";

CONST E2_0 = 
   " 539 514 ;\nC 61 ; WX 570 ; N equal ; B 33 107 537 399 ;\nC 62 ; WX 570"
 & " ; N greater ; B 31 -8 539 514 ;\nC 63 ; WX 500 ; N question ; B 79 -13"
 & " 470 684 ;\nC 64 ; WX 832 ; N at ; B 63 -18 770 685 ;\nC 65 ; WX 667 ; "
 & "N A ; B -67 0 593 683 ;\nC 66 ; WX 667 ; N B ; B -24 0 624 669 ;\nC 67 "
 & "; WX 667 ; N C ; B 32 -18 677 685 ;\nC 68 ; WX 722 ; N D ; B -46 0 685 "
 & "669 ;\nC 69 ; WX 667 ; N E ; B -27 0 653 669 ;\nC 70 ; WX 667 ; N F ; B"
 & " -13 0 660 669 ;\nC 71 ; WX 722 ; N G ; B 21 -18 706 685 ;\nC 72 ; WX 7"
 & "78 ; N H ; B -24 0 799 669 ;\nC 73 ; WX 389 ; N I ; B -32 0 406 669 ;\n"
 & "C 74 ; WX 500 ; N J ; B -46 -99 524 669 ;\nC 75 ; WX 667 ; N K ; B -21 "
 & "0 702 669 ;\nC 76 ; WX 611 ; N L ; B -22 0 590 669 ;\nC 77 ; WX 889 ; N"
 & " M ; B -29 -12 917 669 ;\nC 78 ; WX 722 ; N N ; B -27 -15 748 669 ;\nC "
 & "79 ; WX 722 ; N O ; B 27 -18 691 685 ;\nC 80 ; WX 611 ; N P ; B -27 0 6"
 & "13 669 ;\nC 81 ; WX 722 ; N Q ; B 27 -208 691 685 ;\nC 82 ; WX 667 ; N "
 & "R ; B -29 0 623 669 ;\nC 83 ; WX 556 ; N S ; B 2 -18 526 685 ;\nC 84 ; "
 & "WX 611 ; N T ; B 50 0 650 669 ;\nC 85 ; WX 722 ; N U ; B 67 -18 744 669"
 & " ;\nC 86 ; WX 667 ; N V ; B 65 -18 715 669 ;\nC 87 ; WX 889 ; N W ; B 6"
 & "5 -18 940 669 ;\nC 88 ; WX 667 ; N X ; B -24 0 694 669 ;\nC 89 ; WX 611"
 & " ; N Y ; B 73 0 659 669 ;\nC 90 ; WX 611 ; N Z ; B -11 0 590 669 ;\nC 9"
 & "1 ; WX 333 ; N bracketleft ; B -37 -159 362 674 ;\nC 92 ; WX 278 ; N ba"
 & "ckslash ; B -1 -18 279 685 ;\nC 93 ; WX 333 ; N bracketright ; B -56 -1"
 & "57 343 674 ;\nC 94 ; WX 570 ; N asciicircum ; B 67 304 503 669 ;\nC 95 "
 & "; WX 500 ; N underscore ; B 0 -125 500 -75 ;\nC 96 ; WX 333 ; N quotele"
 & "ft ; B 128 369 332 685 ;\nC 97 ; WX 500 ; N a ; B -21 -14 455 462 ;\nC "
 & "98 ; WX 500 ; N b ; B -14 -13 444 699 ;\nC 99 ; WX 444 ; N c ; B -5 -13"
 & " 392 462 ;\nC 100 ; WX 500 ; N d ; B -21 -13 517 699 ;\nC 101 ; WX 444 "
 & "; N e ; B 5 -13 398 462 ;\nC 102 ; WX 333 ; N f ; B -169 -205 446 698 ;"
 & " L i fi ; L l fl ;\nC 103 ; WX 500 ; N g ; B -52 -203 478 462 ;\nC 104 "
 & "; WX 556 ; N h ; B -13 -9 498 699 ;\nC 105 ; WX 278 ; N i ; B 2 -9 263 "
 & "684 ;\nC 106 ; WX 278 ; N j ; B -189 -207 279 684 ;\nC 107 ";

CONST E2_1 = 
   "; WX 500 ; N k ; B -23 -8 483 699 ;\nC 108 ; WX 278 ; N l ; B 2 -9 290 "
 & "699 ;\nC 109 ; WX 778 ; N m ; B -14 -9 722 462 ;\nC 110 ; WX 556 ; N n "
 & "; B -6 -9 493 462 ;\nC 111 ; WX 500 ; N o ; B -3 -13 441 462 ;\nC 112 ;"
 & " WX 500 ; N p ; B -120 -205 446 462 ;\nC 113 ; WX 500 ; N q ; B 1 -205 "
 & "471 462 ;\nC 114 ; WX 389 ; N r ; B -21 0 389 462 ;\nC 115 ; WX 389 ; N"
 & " s ; B -19 -13 333 462 ;\nC 116 ; WX 278 ; N t ; B -11 -9 281 594 ;\nC "
 & "117 ; WX 556 ; N u ; B 15 -9 492 462 ;\nC 118 ; WX 444 ; N v ; B 16 -13"
 & " 401 462 ;\nC 119 ; WX 667 ; N w ; B 16 -13 614 462 ;\nC 120 ; WX 500 ;"
 & " N x ; B -46 -13 469 462 ;\nC 121 ; WX 444 ; N y ; B -94 -205 392 462 ;"
 & "\nC 122 ; WX 389 ; N z ; B -43 -78 368 449 ;\nC 123 ; WX 348 ; N bracel"
 & "eft ; B 5 -187 436 686 ;\nC 124 ; WX 220 ; N bar ; B 66 -18 154 685 ;\n"
 & "C 125 ; WX 348 ; N braceright ; B -129 -187 302 686 ;\nC 126 ; WX 570 ;"
 & " N asciitilde ; B 54 173 516 333 ;\nC 161 ; WX 389 ; N exclamdown ; B 1"
 & "9 -205 322 492 ;\nC 162 ; WX 500 ; N cent ; B 42 -143 439 576 ;\nC 163 "
 & "; WX 500 ; N sterling ; B -32 -12 510 683 ;\nC 164 ; WX 167 ; N fractio"
 & "n ; B -169 -14 324 683 ;\nC 165 ; WX 500 ; N yen ; B 33 0 628 669 ;\nC "
 & "166 ; WX 500 ; N florin ; B -87 -156 537 707 ;\nC 167 ; WX 500 ; N sect"
 & "ion ; B 36 -143 459 685 ;\nC 168 ; WX 500 ; N currency ; B -26 34 526 5"
 & "86 ;\nC 169 ; WX 278 ; N quotesingle ; B 128 398 268 685 ;\nC 170 ; WX "
 & "500 ; N quotedblleft ; B 53 369 513 685 ;\nC 171 ; WX 500 ; N guillemot"
 & "left ; B 12 32 468 415 ;\nC 172 ; WX 333 ; N guilsinglleft ; B 32 32 30"
 & "3 415 ;\nC 173 ; WX 333 ; N guilsinglright ; B 10 32 281 415 ;\nC 174 ;"
 & " WX 556 ; N fi ; B -188 -205 514 703 ;\nC 175 ; WX 556 ; N fl ; B -186 "
 & "-205 553 704 ;\nC 177 ; WX 500 ; N endash ; B -40 178 477 269 ;\nC 178 "
 & "; WX 500 ; N dagger ; B 91 -145 494 685 ;\nC 179 ; WX 500 ; N daggerdbl"
 & " ; B 10 -139 493 685 ;\nC 180 ; WX 250 ; N periodcentered ; B 51 257 19"
 & "9 405 ;\nC 182 ; WX 500 ; N paragraph ; B -57 -193 562 669 ;\nC 183 ; W"
 & "X 350 ; N bullet ; B 0 175 350 525 ;\nC 184 ; WX 333 ; N quotesinglbase"
 & " ; B -5 -182 199 134 ;\nC 185 ; WX 500 ; N quotedblbas";

CONST E2_2 = 
   "e ; B -57 -182 403 134 ;\nC 186 ; WX 500 ; N quotedblright ; B 53 369 5"
 & "13 685 ;\nC 187 ; WX 500 ; N guillemotright ; B 12 32 468 415 ;\nC 188 "
 & "; WX 1000 ; N ellipsis ; B 40 -13 852 135 ;\nC 189 ; WX 1000 ; N pertho"
 & "usand ; B 7 -29 996 706 ;\nC 191 ; WX 500 ; N questiondown ; B 30 -205 "
 & "421 492 ;\nC 193 ; WX 333 ; N grave ; B 85 516 297 697 ;\nC 194 ; WX 33"
 & "3 ; N acute ; B 139 516 379 697 ;\nC 195 ; WX 333 ; N circumflex ; B 40"
 & " 516 367 690 ;\nC 196 ; WX 333 ; N tilde ; B 48 536 407 655 ;\nC 197 ; "
 & "WX 333 ; N macron ; B 51 553 393 623 ;\nC 198 ; WX 333 ; N breve ; B 71"
 & " 516 387 678 ;\nC 199 ; WX 333 ; N dotaccent ; B 163 525 293 655 ;\nC 2"
 & "00 ; WX 333 ; N dieresis ; B 55 525 397 655 ;\nC 202 ; WX 333 ; N ring "
 & "; B 127 516 340 729 ;\nC 203 ; WX 333 ; N cedilla ; B -80 -218 156 5 ;\n"
 & "C 205 ; WX 333 ; N hungarumlaut ; B 69 516 498 697 ;\nC 206 ; WX 333 ; "
 & "N ogonek ; B -40 -173 189 44 ;\nC 207 ; WX 333 ; N caron ; B 79 516 411"
 & " 690 ;\nC 208 ; WX 1000 ; N emdash ; B -40 178 977 269 ;\nC 225 ; WX 94"
 & "4 ; N AE ; B -64 0 918 669 ;\nC 227 ; WX 266 ; N ordfeminine ; B 16 399"
 & " 330 685 ;\nC 232 ; WX 611 ; N Lslash ; B -22 0 590 669 ;\nC 233 ; WX 7"
 & "22 ; N Oslash ; B 27 -125 691 764 ;\nC 234 ; WX 944 ; N OE ; B 23 -8 94"
 & "6 677 ;\nC 235 ; WX 300 ; N ordmasculine ; B 56 400 347 685 ;\nC 241 ; "
 & "WX 722 ; N ae ; B -5 -13 673 462 ;\nC 245 ; WX 278 ; N dotlessi ; B 2 -"
 & "9 238 462 ;\nC 248 ; WX 278 ; N lslash ; B -13 -9 301 699 ;\nC 249 ; WX"
 & " 500 ; N oslash ; B -3 -119 441 560 ;\nC 250 ; WX 722 ; N oe ; B 6 -13 "
 & "674 462 ;\nC 251 ; WX 500 ; N germandbls ; B -200 -200 473 705 ;\nC -1 "
 & "; WX 611 ; N Zcaron ; B -11 0 590 897 ;\nC -1 ; WX 444 ; N ccedilla ; B"
 & " -24 -218 392 462 ;\nC -1 ; WX 444 ; N ydieresis ; B -94 -205 438 655 ;"
 & "\nC -1 ; WX 500 ; N atilde ; B -21 -14 491 655 ;\nC -1 ; WX 278 ; N ici"
 & "rcumflex ; B -2 -9 325 690 ;\nC -1 ; WX 300 ; N threesuperior ; B 17 26"
 & "5 321 683 ;\nC -1 ; WX 444 ; N ecircumflex ; B 5 -13 423 690 ;\nC -1 ; "
 & "WX 500 ; N thorn ; B -120 -205 446 699 ;\nC -1 ; WX 444 ; N egrave ; B "
 & "5 -13 398 697 ;\nC -1 ; WX 300 ; N twosuperior ; B 2";

CONST E2_3 = 
   " 274 313 683 ;\nC -1 ; WX 444 ; N eacute ; B 5 -13 435 697 ;\nC -1 ; WX"
 & " 500 ; N otilde ; B -3 -13 491 655 ;\nC -1 ; WX 667 ; N Aacute ; B -67 "
 & "0 593 904 ;\nC -1 ; WX 500 ; N ocircumflex ; B -3 -13 451 690 ;\nC -1 ;"
 & " WX 444 ; N yacute ; B -94 -205 435 697 ;\nC -1 ; WX 556 ; N udieresis "
 & "; B 15 -9 494 655 ;\nC -1 ; WX 750 ; N threequarters ; B 7 -14 726 683 "
 & ";\nC -1 ; WX 500 ; N acircumflex ; B -21 -14 455 690 ;\nC -1 ; WX 722 ;"
 & " N Eth ; B -31 0 700 669 ;\nC -1 ; WX 444 ; N edieresis ; B 5 -13 443 6"
 & "55 ;\nC -1 ; WX 556 ; N ugrave ; B 15 -9 492 697 ;\nC -1 ; WX 1000 ; N "
 & "trademark ; B 32 263 968 669 ;\nC -1 ; WX 500 ; N ograve ; B -3 -13 441"
 & " 697 ;\nC -1 ; WX 389 ; N scaron ; B -19 -13 439 690 ;\nC -1 ; WX 389 ;"
 & " N Idieresis ; B -32 0 445 862 ;\nC -1 ; WX 556 ; N uacute ; B 15 -9 49"
 & "2 697 ;\nC -1 ; WX 500 ; N agrave ; B -21 -14 455 697 ;\nC -1 ; WX 556 "
 & "; N ntilde ; B -6 -9 504 655 ;\nC -1 ; WX 500 ; N aring ; B -21 -14 455"
 & " 729 ;\nC -1 ; WX 389 ; N zcaron ; B -43 -78 424 690 ;\nC -1 ; WX 389 ;"
 & " N Icircumflex ; B -32 0 420 897 ;\nC -1 ; WX 722 ; N Ntilde ; B -27 -1"
 & "5 748 862 ;\nC -1 ; WX 556 ; N ucircumflex ; B 15 -9 492 690 ;\nC -1 ; "
 & "WX 667 ; N Ecircumflex ; B -27 0 653 897 ;\nC -1 ; WX 389 ; N Iacute ; "
 & "B -32 0 412 904 ;\nC -1 ; WX 667 ; N Ccedilla ; B 32 -218 677 685 ;\nC "
 & "-1 ; WX 722 ; N Odieresis ; B 27 -18 691 862 ;\nC -1 ; WX 556 ; N Scaro"
 & "n ; B 2 -18 526 897 ;\nC -1 ; WX 667 ; N Edieresis ; B -27 0 653 862 ;\n"
 & "C -1 ; WX 389 ; N Igrave ; B -32 0 406 904 ;\nC -1 ; WX 500 ; N adieres"
 & "is ; B -21 -14 471 655 ;\nC -1 ; WX 722 ; N Ograve ; B 27 -18 691 904 ;"
 & "\nC -1 ; WX 667 ; N Egrave ; B -27 0 653 904 ;\nC -1 ; WX 611 ; N Ydier"
 & "esis ; B 73 0 659 862 ;\nC -1 ; WX 747 ; N registered ; B 30 -18 718 68"
 & "5 ;\nC -1 ; WX 722 ; N Otilde ; B 27 -18 691 862 ;\nC -1 ; WX 750 ; N o"
 & "nequarter ; B 7 -14 721 683 ;\nC -1 ; WX 722 ; N Ugrave ; B 67 -18 744 "
 & "904 ;\nC -1 ; WX 722 ; N Ucircumflex ; B 67 -18 744 897 ;\nC -1 ; WX 61"
 & "1 ; N Thorn ; B -27 0 573 669 ;\nC -1 ; WX 570 ; N divide ; B 33 -29 53"
 & "7 535 ;\nC -1 ; WX 667 ; N Atilde ; B -67 0 593 862 ;";

CONST E2_4 = 
   "\nC -1 ; WX 722 ; N Uacute ; B 67 -18 744 904 ;\nC -1 ; WX 722 ; N Ocir"
 & "cumflex ; B 27 -18 691 897 ;\nC -1 ; WX 606 ; N logicalnot ; B 51 108 5"
 & "55 399 ;\nC -1 ; WX 667 ; N Aring ; B -67 0 593 921 ;\nC -1 ; WX 278 ; "
 & "N idieresis ; B 2 -9 360 655 ;\nC -1 ; WX 278 ; N iacute ; B 2 -9 352 6"
 & "97 ;\nC -1 ; WX 500 ; N aacute ; B -21 -14 463 697 ;\nC -1 ; WX 570 ; N"
 & " plusminus ; B 33 0 537 506 ;\nC -1 ; WX 570 ; N multiply ; B 48 16 522"
 & " 490 ;\nC -1 ; WX 722 ; N Udieresis ; B 67 -18 744 862 ;\nC -1 ; WX 606"
 & " ; N minus ; B 51 209 555 297 ;\nC -1 ; WX 300 ; N onesuperior ; B 30 2"
 & "74 301 683 ;\nC -1 ; WX 667 ; N Eacute ; B -27 0 653 904 ;\nC -1 ; WX 6"
 & "67 ; N Acircumflex ; B -67 0 593 897 ;\nC -1 ; WX 747 ; N copyright ; B"
 & " 30 -18 718 685 ;\nC -1 ; WX 667 ; N Agrave ; B -67 0 593 904 ;\nC -1 ;"
 & " WX 500 ; N odieresis ; B -3 -13 466 655 ;\nC -1 ; WX 500 ; N oacute ; "
 & "B -3 -13 463 697 ;\nC -1 ; WX 400 ; N degree ; B 83 397 369 683 ;\nC -1"
 & " ; WX 278 ; N igrave ; B 2 -9 260 697 ;\nC -1 ; WX 576 ; N mu ; B -60 -"
 & "207 516 449 ;\nC -1 ; WX 722 ; N Oacute ; B 27 -18 691 904 ;\nC -1 ; WX"
 & " 500 ; N eth ; B -3 -13 454 699 ;\nC -1 ; WX 667 ; N Adieresis ; B -67 "
 & "0 593 862 ;\nC -1 ; WX 611 ; N Yacute ; B 73 0 659 904 ;\nC -1 ; WX 220"
 & " ; N brokenbar ; B 66 -18 154 685 ;\nC -1 ; WX 750 ; N onehalf ; B -9 -"
 & "14 723 683 ;\nEndCharMetrics\nStartKernData\nStartKernPairs 283\n\nKPX "
 & "A y -74\nKPX A w -74\nKPX A v -74\nKPX A u -30\nKPX A quoteright -74\nK"
 & "PX A quotedblright 0\nKPX A p 0\nKPX A Y -70\nKPX A W -100\nKPX A V -95"
 & "\nKPX A U -50\nKPX A T -55\nKPX A Q -55\nKPX A O -50\nKPX A G -60\nKPX "
 & "A C -65\n\nKPX B period 0\nKPX B comma 0\nKPX B U -10\nKPX B A -25\n\nK"
 & "PX D period 0\nKPX D comma 0\nKPX D Y -50\nKPX D W -40\nKPX D V -50\nKP"
 & "X D A -25\n\nKPX F r -50\nKPX F period -129\nKPX F o -70\nKPX F i -40\n"
 & "KPX F e -100\nKPX F comma -129\nKPX F a -95\nKPX F A -100\n\nKPX G peri"
 & "od 0\nKPX G comma 0\n\nKPX J u -40\nKPX J period -10\nKPX J o -40\nKPX "
 & "J e -40\nKPX J comma -10\nKPX J a -40\nKPX J A -25\n\nKPX K y -20\nKPX "
 & "K u -20\nKPX K o -25\nKPX K e -25\nKPX K O -30\n\nKPX L y -37\nKPX L qu"
 & "oteright -55\nKPX L quotedblri";

CONST E2_5 = 
   "ght 0\nKPX L Y -37\nKPX L W -37\nKPX L V -37\nKPX L T -18\n\nKPX N peri"
 & "od 0\nKPX N comma 0\nKPX N A -30\n\nKPX O period 0\nKPX O comma 0\nKPX "
 & "O Y -50\nKPX O X -40\nKPX O W -50\nKPX O V -50\nKPX O T -40\nKPX O A -4"
 & "0\n\nKPX P period -129\nKPX P o -55\nKPX P e -50\nKPX P comma -129\nKPX"
 & " P a -40\nKPX P A -85\n\nKPX Q period 0\nKPX Q comma 0\nKPX Q U -10\n\n"
 & "KPX R Y -18\nKPX R W -18\nKPX R V -18\nKPX R U -40\nKPX R T -30\nKPX R "
 & "O -40\n\nKPX S period 0\nKPX S comma 0\n\nKPX T y -37\nKPX T w -37\nKPX"
 & " T u -37\nKPX T semicolon -74\nKPX T r -37\nKPX T period -92\nKPX T o -"
 & "95\nKPX T i -37\nKPX T hyphen -92\nKPX T h 0\nKPX T e -92\nKPX T comma "
 & "-92\nKPX T colon -74\nKPX T a -92\nKPX T O -18\nKPX T A -55\n\nKPX U pe"
 & "riod 0\nKPX U comma 0\nKPX U A -45\n\nKPX V u -55\nKPX V semicolon -74\n"
 & "KPX V period -129\nKPX V o -111\nKPX V i -55\nKPX V hyphen -70\nKPX V e"
 & " -111\nKPX V comma -129\nKPX V colon -74\nKPX V a -111\nKPX V O -30\nKP"
 & "X V G -10\nKPX V A -85\n\nKPX W y -55\nKPX W u -55\nKPX W semicolon -55"
 & "\nKPX W period -74\nKPX W o -80\nKPX W i -37\nKPX W hyphen -50\nKPX W h"
 & " 0\nKPX W e -90\nKPX W comma -74\nKPX W colon -55\nKPX W a -85\nKPX W O"
 & " -15\nKPX W A -74\n\nKPX Y u -92\nKPX Y semicolon -92\nKPX Y period -74"
 & "\nKPX Y o -111\nKPX Y i -55\nKPX Y hyphen -92\nKPX Y e -111\nKPX Y comm"
 & "a -92\nKPX Y colon -92\nKPX Y a -92\nKPX Y O -25\nKPX Y A -74\n\nKPX a "
 & "y 0\nKPX a w 0\nKPX a v 0\nKPX a t 0\nKPX a p 0\nKPX a g 0\nKPX a b 0\n"
 & "\nKPX b y 0\nKPX b v 0\nKPX b u -20\nKPX b period -40\nKPX b l 0\nKPX b"
 & " comma 0\nKPX b b -10\n\nKPX c y 0\nKPX c period 0\nKPX c l 0\nKPX c k "
 & "-10\nKPX c h -10\nKPX c comma 0\n\nKPX colon space 0\n\nKPX comma space"
 & " 0\nKPX comma quoteright -95\nKPX comma quotedblright -95\n\nKPX d y 0\n"
 & "KPX d w 0\nKPX d v 0\nKPX d period 0\nKPX d d 0\nKPX d comma 0\n\nKPX e"
 & " y 0\nKPX e x 0\nKPX e w 0\nKPX e v 0\nKPX e period 0\nKPX e p 0\nKPX e"
 & " g 0\nKPX e comma 0\nKPX e b -10\n\nKPX f quoteright 55\nKPX f quotedbl"
 & "right 0\nKPX f period -10\nKPX f o -10\nKPX f l 0\nKPX f i 0\nKPX f f -"
 & "18\nKPX f e -10\nKPX f dotlessi -30\nKPX f comma -10\nKPX f a 0\n\nKPX "
 & "g y 0\nKPX g r 0\nKPX g period 0\nKPX g o 0\nKPX g i 0\nKPX g g 0\nKPX "
 & "g e 0\nKPX g comma 0\nKPX g a 0\n\nKPX ";

CONST E2_6 = 
   "h y 0\n\nKPX i v 0\n\nKPX k y 0\nKPX k o -10\nKPX k e -30\n\nKPX l y 0\n"
 & "KPX l w 0\n\nKPX m y 0\nKPX m u 0\n\nKPX n y 0\nKPX n v -40\nKPX n u 0\n"
 & "\nKPX o y -10\nKPX o x -10\nKPX o w -25\nKPX o v -15\nKPX o g 0\n\nKPX "
 & "p y 0\n\nKPX period quoteright -95\nKPX period quotedblright -95\n\nKPX"
 & " quotedblleft quoteleft 0\nKPX quotedblleft A 0\n\nKPX quotedblright sp"
 & "ace 0\n\nKPX quoteleft quoteleft -74\nKPX quoteleft A 0\n\nKPX quoterig"
 & "ht v -15\nKPX quoteright t -37\nKPX quoteright space -74\nKPX quoterigh"
 & "t s -74\nKPX quoteright r -15\nKPX quoteright quoteright -74\nKPX quote"
 & "right quotedblright 0\nKPX quoteright l 0\nKPX quoteright d -15\n\nKPX "
 & "r y 0\nKPX r v 0\nKPX r u 0\nKPX r t 0\nKPX r s 0\nKPX r r 0\nKPX r q 0"
 & "\nKPX r period -65\nKPX r p 0\nKPX r o 0\nKPX r n 0\nKPX r m 0\nKPX r l"
 & " 0\nKPX r k 0\nKPX r i 0\nKPX r hyphen 0\nKPX r g 0\nKPX r e 0\nKPX r d"
 & " 0\nKPX r comma -65\nKPX r c 0\nKPX r a 0\n\nKPX s w 0\n\nKPX space quo"
 & "teleft 0\nKPX space quotedblleft 0\nKPX space Y -70\nKPX space W -70\nK"
 & "PX space V -70\nKPX space T 0\nKPX space A -37\n\nKPX v period -37\nKPX"
 & " v o -15\nKPX v e -15\nKPX v comma -37\nKPX v a 0\n\nKPX w period -37\n"
 & "KPX w o -15\nKPX w h 0\nKPX w e -10\nKPX w comma -37\nKPX w a -10\n\nKP"
 & "X x e -10\n\nKPX y period -37\nKPX y o 0\nKPX y e 0\nKPX y comma -37\nK"
 & "PX y a 0\n\nKPX z o 0\nKPX z e 0\nEndKernPairs\nEndKernData\nStartCompo"
 & "sites 58\nCC Aacute 2 ; PCC A 0 0 ; PCC acute 172 207 ;\nCC Acircumflex"
 & " 2 ; PCC A 0 0 ; PCC circumflex 187 207 ;\nCC Adieresis 2 ; PCC A 0 0 ;"
 & " PCC dieresis 167 207 ;\nCC Agrave 2 ; PCC A 0 0 ; PCC grave 172 207 ;\n"
 & "CC Aring 2 ; PCC A 0 0 ; PCC ring 157 192 ;\nCC Atilde 2 ; PCC A 0 0 ; "
 & "PCC tilde 167 207 ;\nCC Ccedilla 2 ; PCC C 0 0 ; PCC cedilla 167 0 ;\nC"
 & "C Eacute 2 ; PCC E 0 0 ; PCC acute 172 207 ;\nCC Ecircumflex 2 ; PCC E "
 & "0 0 ; PCC circumflex 187 207 ;\nCC Edieresis 2 ; PCC E 0 0 ; PCC dieres"
 & "is 187 207 ;\nCC Egrave 2 ; PCC E 0 0 ; PCC grave 172 207 ;\nCC Iacute "
 & "2 ; PCC I 0 0 ; PCC acute 33 207 ;\nCC Icircumflex 2 ; PCC I 0 0 ; PCC "
 & "circumflex 53 207 ;\nCC Idieresis 2 ; PCC I 0 0 ; PCC dieresis 48 207 ;"
 & "\nCC Igrave 2 ; PCC I 0 0 ; PCC grave 33 207 ;\nCC Ntilde 2";

CONST E2_7 = 
   " ; PCC N 0 0 ; PCC tilde 210 207 ;\nCC Oacute 2 ; PCC O 0 0 ; PCC acute"
 & " 200 207 ;\nCC Ocircumflex 2 ; PCC O 0 0 ; PCC circumflex 230 207 ;\nCC"
 & " Odieresis 2 ; PCC O 0 0 ; PCC dieresis 215 207 ;\nCC Ograve 2 ; PCC O "
 & "0 0 ; PCC grave 200 207 ;\nCC Otilde 2 ; PCC O 0 0 ; PCC tilde 215 207 "
 & ";\nCC Scaron 2 ; PCC S 0 0 ; PCC caron 112 207 ;\nCC Uacute 2 ; PCC U 0"
 & " 0 ; PCC acute 210 207 ;\nCC Ucircumflex 2 ; PCC U 0 0 ; PCC circumflex"
 & " 230 207 ;\nCC Udieresis 2 ; PCC U 0 0 ; PCC dieresis 230 207 ;\nCC Ugr"
 & "ave 2 ; PCC U 0 0 ; PCC grave 200 207 ;\nCC Yacute 2 ; PCC Y 0 0 ; PCC "
 & "acute 154 207 ;\nCC Ydieresis 2 ; PCC Y 0 0 ; PCC dieresis 169 207 ;\nC"
 & "C Zcaron 2 ; PCC Z 0 0 ; PCC caron 139 207 ;\nCC aacute 2 ; PCC a 0 0 ;"
 & " PCC acute 84 0 ;\nCC acircumflex 2 ; PCC a 0 0 ; PCC circumflex 84 0 ;"
 & "\nCC adieresis 2 ; PCC a 0 0 ; PCC dieresis 74 0 ;\nCC agrave 2 ; PCC a"
 & " 0 0 ; PCC grave 74 0 ;\nCC aring 2 ; PCC a 0 0 ; PCC ring 84 0 ;\nCC a"
 & "tilde 2 ; PCC a 0 0 ; PCC tilde 84 0 ;\nCC ccedilla 2 ; PCC c 0 0 ; PCC"
 & " cedilla 56 0 ;\nCC eacute 2 ; PCC e 0 0 ; PCC acute 56 0 ;\nCC ecircum"
 & "flex 2 ; PCC e 0 0 ; PCC circumflex 56 0 ;\nCC edieresis 2 ; PCC e 0 0 "
 & "; PCC dieresis 46 0 ;\nCC egrave 2 ; PCC e 0 0 ; PCC grave 46 0 ;\nCC i"
 & "acute 2 ; PCC dotlessi 0 0 ; PCC acute -27 0 ;\nCC icircumflex 2 ; PCC "
 & "dotlessi 0 0 ; PCC circumflex -42 0 ;\nCC idieresis 2 ; PCC dotlessi 0 "
 & "0 ; PCC dieresis -37 0 ;\nCC igrave 2 ; PCC dotlessi 0 0 ; PCC grave -3"
 & "7 0 ;\nCC ntilde 2 ; PCC n 0 0 ; PCC tilde 97 0 ;\nCC oacute 2 ; PCC o "
 & "0 0 ; PCC acute 84 0 ;\nCC ocircumflex 2 ; PCC o 0 0 ; PCC circumflex 8"
 & "4 0 ;\nCC odieresis 2 ; PCC o 0 0 ; PCC dieresis 69 0 ;\nCC ograve 2 ; "
 & "PCC o 0 0 ; PCC grave 74 0 ;\nCC otilde 2 ; PCC o 0 0 ; PCC tilde 84 0 "
 & ";\nCC scaron 2 ; PCC s 0 0 ; PCC caron 28 0 ;\nCC uacute 2 ; PCC u 0 0 "
 & "; PCC acute 112 0 ;\nCC ucircumflex 2 ; PCC u 0 0 ; PCC circumflex 112 "
 & "0 ;\nCC udieresis 2 ; PCC u 0 0 ; PCC dieresis 97 0 ;\nCC ugrave 2 ; PC"
 & "C u 0 0 ; PCC grave 102 0 ;\nCC yacute 2 ; PCC y 0 0 ; PCC acute 56 0 ;"
 & "\nCC ydieresis 2 ; PCC y 0 0 ; PCC dieresis 41 0 ;\nCC";

CONST E2_8 = 
   " zcaron 2 ; PCC z 0 0 ; PCC caron 13 0 ;\nEndComposites\nEndFontMetrics"
 & "\n";

CONST E3 = 
   "StartFontMetrics 2.0\nComment Copyright (c) 1989, 1990, 1991 Adobe Syst"
 & "ems Incorporated. All rights reserved.\nComment Creation Date: Tue Sep "
 & "17 07:47:21 1991\nComment UniqueID 36347\nComment VMusage 31037 39405\n"
 & "FontName Courier\nFullName Courier\nFamilyName Courier\nWeight Medium\n"
 & "ItalicAngle 0\nIsFixedPitch true\nFontBBox -28 -250 628 805\nUnderlineP"
 & "osition -100\nUnderlineThickness 50\nVersion 002.004\nNotice Copyright "
 & "(c) 1989, 1990, 1991 Adobe Systems Incorporated. All rights reserved.\n"
 & "EncodingScheme AdobeStandardEncoding\nCapHeight 562\nXHeight 426\nAscen"
 & "der 629\nDescender -157\nStartCharMetrics 260\nC 32 ; WX 600 ; N space "
 & "; B 0 0 0 0 ;\nC 33 ; WX 600 ; N exclam ; B 236 -15 364 572 ;\nC 34 ; W"
 & "X 600 ; N quotedbl ; B 187 328 413 562 ;\nC 35 ; WX 600 ; N numbersign "
 & "; B 93 -32 507 639 ;\nC 36 ; WX 600 ; N dollar ; B 105 -126 496 662 ;\n"
 & "C 37 ; WX 600 ; N percent ; B 81 -15 518 622 ;\nC 38 ; WX 600 ; N amper"
 & "sand ; B 63 -15 538 543 ;\nC 39 ; WX 600 ; N quoteright ; B 213 328 376"
 & " 562 ;\nC 40 ; WX 600 ; N parenleft ; B 269 -108 440 622 ;\nC 41 ; WX 6"
 & "00 ; N parenright ; B 160 -108 331 622 ;\nC 42 ; WX 600 ; N asterisk ; "
 & "B 116 257 484 607 ;\nC 43 ; WX 600 ; N plus ; B 80 44 520 470 ;\nC 44 ;"
 & " WX 600 ; N comma ; B 181 -112 344 122 ;\nC 45 ; WX 600 ; N hyphen ; B "
 & "103 231 497 285 ;\nC 46 ; WX 600 ; N period ; B 229 -15 371 109 ;\nC 47"
 & " ; WX 600 ; N slash ; B 125 -80 475 629 ;\nC 48 ; WX 600 ; N zero ; B 1"
 & "06 -15 494 622 ;\nC 49 ; WX 600 ; N one ; B 96 0 505 622 ;\nC 50 ; WX 6"
 & "00 ; N two ; B 70 0 471 622 ;\nC 51 ; WX 600 ; N three ; B 75 -15 466 6"
 & "22 ;\nC 52 ; WX 600 ; N four ; B 78 0 500 622 ;\nC 53 ; WX 600 ; N five"
 & " ; B 92 -15 497 607 ;\nC 54 ; WX 600 ; N six ; B 111 -15 497 622 ;\nC 5"
 & "5 ; WX 600 ; N seven ; B 82 0 483 607 ;\nC 56 ; WX 600 ; N eight ; B 10"
 & "2 -15 498 622 ;\nC 57 ; WX 600 ; N nine ; B 96 -15 489 622 ;\nC 58 ; WX"
 & " 600 ; N colon ; B 229 -15 371 385 ;\nC 59 ; WX 600 ; N semicolon ; B 1"
 & "81 -112 371 385 ;\nC 60 ; WX 600 ; N less ; B 41 42 519 472 ;\nC 61 ; W"
 & "X 600 ; N equal ; B 80 138 520 376 ;\nC 62 ; WX 600 ; N greater ";

CONST E3_0 = 
   "; B 66 42 544 472 ;\nC 63 ; WX 600 ; N question ; B 129 -15 492 572 ;\n"
 & "C 64 ; WX 600 ; N at ; B 77 -15 533 622 ;\nC 65 ; WX 600 ; N A ; B 3 0 "
 & "597 562 ;\nC 66 ; WX 600 ; N B ; B 43 0 559 562 ;\nC 67 ; WX 600 ; N C "
 & "; B 41 -18 540 580 ;\nC 68 ; WX 600 ; N D ; B 43 0 574 562 ;\nC 69 ; WX"
 & " 600 ; N E ; B 53 0 550 562 ;\nC 70 ; WX 600 ; N F ; B 53 0 545 562 ;\n"
 & "C 71 ; WX 600 ; N G ; B 31 -18 575 580 ;\nC 72 ; WX 600 ; N H ; B 32 0 "
 & "568 562 ;\nC 73 ; WX 600 ; N I ; B 96 0 504 562 ;\nC 74 ; WX 600 ; N J "
 & "; B 34 -18 566 562 ;\nC 75 ; WX 600 ; N K ; B 38 0 582 562 ;\nC 76 ; WX"
 & " 600 ; N L ; B 47 0 554 562 ;\nC 77 ; WX 600 ; N M ; B 4 0 596 562 ;\nC"
 & " 78 ; WX 600 ; N N ; B 7 -13 593 562 ;\nC 79 ; WX 600 ; N O ; B 43 -18 "
 & "557 580 ;\nC 80 ; WX 600 ; N P ; B 79 0 558 562 ;\nC 81 ; WX 600 ; N Q "
 & "; B 43 -138 557 580 ;\nC 82 ; WX 600 ; N R ; B 38 0 588 562 ;\nC 83 ; W"
 & "X 600 ; N S ; B 72 -20 529 580 ;\nC 84 ; WX 600 ; N T ; B 38 0 563 562 "
 & ";\nC 85 ; WX 600 ; N U ; B 17 -18 583 562 ;\nC 86 ; WX 600 ; N V ; B -4"
 & " -13 604 562 ;\nC 87 ; WX 600 ; N W ; B -3 -13 603 562 ;\nC 88 ; WX 600"
 & " ; N X ; B 23 0 577 562 ;\nC 89 ; WX 600 ; N Y ; B 24 0 576 562 ;\nC 90"
 & " ; WX 600 ; N Z ; B 86 0 514 562 ;\nC 91 ; WX 600 ; N bracketleft ; B 2"
 & "69 -108 442 622 ;\nC 92 ; WX 600 ; N backslash ; B 118 -80 482 629 ;\nC"
 & " 93 ; WX 600 ; N bracketright ; B 158 -108 331 622 ;\nC 94 ; WX 600 ; N"
 & " asciicircum ; B 94 354 506 622 ;\nC 95 ; WX 600 ; N underscore ; B 0 -"
 & "125 600 -75 ;\nC 96 ; WX 600 ; N quoteleft ; B 224 328 387 562 ;\nC 97 "
 & "; WX 600 ; N a ; B 53 -15 559 441 ;\nC 98 ; WX 600 ; N b ; B 14 -15 575"
 & " 629 ;\nC 99 ; WX 600 ; N c ; B 66 -15 529 441 ;\nC 100 ; WX 600 ; N d "
 & "; B 45 -15 591 629 ;\nC 101 ; WX 600 ; N e ; B 66 -15 548 441 ;\nC 102 "
 & "; WX 600 ; N f ; B 114 0 531 629 ; L i fi ; L l fl ;\nC 103 ; WX 600 ; "
 & "N g ; B 45 -157 566 441 ;\nC 104 ; WX 600 ; N h ; B 18 0 582 629 ;\nC 1"
 & "05 ; WX 600 ; N i ; B 95 0 505 657 ;\nC 106 ; WX 600 ; N j ; B 82 -157 "
 & "410 657 ;\nC 107 ; WX 600 ; N k ; B 43 0 580 629 ;\nC 108 ; WX 600 ; N "
 & "l ; B 95 0 505 629 ;\nC 109 ; WX 600 ; N m ; B -5 0 605 441";

CONST E3_1 = 
   " ;\nC 110 ; WX 600 ; N n ; B 26 0 575 441 ;\nC 111 ; WX 600 ; N o ; B 6"
 & "2 -15 538 441 ;\nC 112 ; WX 600 ; N p ; B 9 -157 555 441 ;\nC 113 ; WX "
 & "600 ; N q ; B 45 -157 591 441 ;\nC 114 ; WX 600 ; N r ; B 60 0 559 441 "
 & ";\nC 115 ; WX 600 ; N s ; B 80 -15 513 441 ;\nC 116 ; WX 600 ; N t ; B "
 & "87 -15 530 561 ;\nC 117 ; WX 600 ; N u ; B 21 -15 562 426 ;\nC 118 ; WX"
 & " 600 ; N v ; B 10 -10 590 426 ;\nC 119 ; WX 600 ; N w ; B -4 -10 604 42"
 & "6 ;\nC 120 ; WX 600 ; N x ; B 20 0 580 426 ;\nC 121 ; WX 600 ; N y ; B "
 & "7 -157 592 426 ;\nC 122 ; WX 600 ; N z ; B 99 0 502 426 ;\nC 123 ; WX 6"
 & "00 ; N braceleft ; B 182 -108 437 622 ;\nC 124 ; WX 600 ; N bar ; B 275"
 & " -250 326 750 ;\nC 125 ; WX 600 ; N braceright ; B 163 -108 418 622 ;\n"
 & "C 126 ; WX 600 ; N asciitilde ; B 63 197 540 320 ;\nC 161 ; WX 600 ; N "
 & "exclamdown ; B 236 -157 364 430 ;\nC 162 ; WX 600 ; N cent ; B 96 -49 5"
 & "00 614 ;\nC 163 ; WX 600 ; N sterling ; B 84 -21 521 611 ;\nC 164 ; WX "
 & "600 ; N fraction ; B 92 -57 509 665 ;\nC 165 ; WX 600 ; N yen ; B 26 0 "
 & "574 562 ;\nC 166 ; WX 600 ; N florin ; B 4 -143 539 622 ;\nC 167 ; WX 6"
 & "00 ; N section ; B 113 -78 488 580 ;\nC 168 ; WX 600 ; N currency ; B 7"
 & "3 58 527 506 ;\nC 169 ; WX 600 ; N quotesingle ; B 259 328 341 562 ;\nC"
 & " 170 ; WX 600 ; N quotedblleft ; B 143 328 471 562 ;\nC 171 ; WX 600 ; "
 & "N guillemotleft ; B 37 70 563 446 ;\nC 172 ; WX 600 ; N guilsinglleft ;"
 & " B 149 70 451 446 ;\nC 173 ; WX 600 ; N guilsinglright ; B 149 70 451 4"
 & "46 ;\nC 174 ; WX 600 ; N fi ; B 3 0 597 629 ;\nC 175 ; WX 600 ; N fl ; "
 & "B 3 0 597 629 ;\nC 177 ; WX 600 ; N endash ; B 75 231 525 285 ;\nC 178 "
 & "; WX 600 ; N dagger ; B 141 -78 459 580 ;\nC 179 ; WX 600 ; N daggerdbl"
 & " ; B 141 -78 459 580 ;\nC 180 ; WX 600 ; N periodcentered ; B 222 189 3"
 & "78 327 ;\nC 182 ; WX 600 ; N paragraph ; B 50 -78 511 562 ;\nC 183 ; WX"
 & " 600 ; N bullet ; B 172 130 428 383 ;\nC 184 ; WX 600 ; N quotesinglbas"
 & "e ; B 213 -134 376 100 ;\nC 185 ; WX 600 ; N quotedblbase ; B 143 -134 "
 & "457 100 ;\nC 186 ; WX 600 ; N quotedblright ; B 143 328 457 562 ;\nC 18"
 & "7 ; WX 600 ; N guillemotright ; B 37 70 563 446 ;\nC 18";

CONST E3_2 = 
   "8 ; WX 600 ; N ellipsis ; B 37 -15 563 111 ;\nC 189 ; WX 600 ; N pertho"
 & "usand ; B 3 -15 600 622 ;\nC 191 ; WX 600 ; N questiondown ; B 108 -157"
 & " 471 430 ;\nC 193 ; WX 600 ; N grave ; B 151 497 378 672 ;\nC 194 ; WX "
 & "600 ; N acute ; B 242 497 469 672 ;\nC 195 ; WX 600 ; N circumflex ; B "
 & "124 477 476 654 ;\nC 196 ; WX 600 ; N tilde ; B 105 489 503 606 ;\nC 19"
 & "7 ; WX 600 ; N macron ; B 120 525 480 565 ;\nC 198 ; WX 600 ; N breve ;"
 & " B 153 501 447 609 ;\nC 199 ; WX 600 ; N dotaccent ; B 249 477 352 580 "
 & ";\nC 200 ; WX 600 ; N dieresis ; B 148 492 453 595 ;\nC 202 ; WX 600 ; "
 & "N ring ; B 218 463 382 627 ;\nC 203 ; WX 600 ; N cedilla ; B 224 -151 3"
 & "62 10 ;\nC 205 ; WX 600 ; N hungarumlaut ; B 133 497 540 672 ;\nC 206 ;"
 & " WX 600 ; N ogonek ; B 227 -151 370 0 ;\nC 207 ; WX 600 ; N caron ; B 1"
 & "24 492 476 669 ;\nC 208 ; WX 600 ; N emdash ; B 0 231 600 285 ;\nC 225 "
 & "; WX 600 ; N AE ; B 3 0 550 562 ;\nC 227 ; WX 600 ; N ordfeminine ; B 1"
 & "56 249 442 580 ;\nC 232 ; WX 600 ; N Lslash ; B 47 0 554 562 ;\nC 233 ;"
 & " WX 600 ; N Oslash ; B 43 -80 557 629 ;\nC 234 ; WX 600 ; N OE ; B 7 0 "
 & "567 562 ;\nC 235 ; WX 600 ; N ordmasculine ; B 157 249 443 580 ;\nC 241"
 & " ; WX 600 ; N ae ; B 19 -15 570 441 ;\nC 245 ; WX 600 ; N dotlessi ; B "
 & "95 0 505 426 ;\nC 248 ; WX 600 ; N lslash ; B 95 0 505 629 ;\nC 249 ; W"
 & "X 600 ; N oslash ; B 62 -80 538 506 ;\nC 250 ; WX 600 ; N oe ; B 19 -15"
 & " 559 441 ;\nC 251 ; WX 600 ; N germandbls ; B 48 -15 588 629 ;\nC -1 ; "
 & "WX 600 ; N Odieresis ; B 43 -18 557 731 ;\nC -1 ; WX 600 ; N logicalnot"
 & " ; B 87 108 513 369 ;\nC -1 ; WX 600 ; N minus ; B 80 232 520 283 ;\nC "
 & "-1 ; WX 600 ; N merge ; B 160 -15 440 436 ;\nC -1 ; WX 600 ; N degree ;"
 & " B 123 269 477 622 ;\nC -1 ; WX 600 ; N dectab ; B 18 0 582 227 ;\nC -1"
 & " ; WX 600 ; N ll ; B 18 0 567 629 ;\nC -1 ; WX 600 ; N IJ ; B 32 -18 58"
 & "3 562 ;\nC -1 ; WX 600 ; N Eacute ; B 53 0 550 793 ;\nC -1 ; WX 600 ; N"
 & " Ocircumflex ; B 43 -18 557 775 ;\nC -1 ; WX 600 ; N ucircumflex ; B 21"
 & " -15 562 654 ;\nC -1 ; WX 600 ; N left ; B 70 68 530 348 ;\nC -1 ; WX 6"
 & "00 ; N threesuperior ; B 155 240 406 622 ;\nC -1 ; WX ";

CONST E3_3 = 
   "600 ; N up ; B 160 0 440 437 ;\nC -1 ; WX 600 ; N multiply ; B 87 43 51"
 & "5 470 ;\nC -1 ; WX 600 ; N Scaron ; B 72 -20 529 805 ;\nC -1 ; WX 600 ;"
 & " N tab ; B 19 0 581 562 ;\nC -1 ; WX 600 ; N Ucircumflex ; B 17 -18 583"
 & " 775 ;\nC -1 ; WX 600 ; N divide ; B 87 48 513 467 ;\nC -1 ; WX 600 ; N"
 & " Acircumflex ; B 3 0 597 775 ;\nC -1 ; WX 600 ; N eacute ; B 66 -15 548"
 & " 672 ;\nC -1 ; WX 600 ; N uacute ; B 21 -15 562 672 ;\nC -1 ; WX 600 ; "
 & "N Aacute ; B 3 0 597 793 ;\nC -1 ; WX 600 ; N copyright ; B 0 -18 600 5"
 & "80 ;\nC -1 ; WX 600 ; N twosuperior ; B 177 249 424 622 ;\nC -1 ; WX 60"
 & "0 ; N Ecircumflex ; B 53 0 550 775 ;\nC -1 ; WX 600 ; N ntilde ; B 26 0"
 & " 575 606 ;\nC -1 ; WX 600 ; N down ; B 160 -15 440 426 ;\nC -1 ; WX 600"
 & " ; N center ; B 40 14 560 580 ;\nC -1 ; WX 600 ; N onesuperior ; B 172 "
 & "249 428 622 ;\nC -1 ; WX 600 ; N ij ; B 37 -157 490 657 ;\nC -1 ; WX 60"
 & "0 ; N edieresis ; B 66 -15 548 595 ;\nC -1 ; WX 600 ; N graybox ; B 76 "
 & "0 525 599 ;\nC -1 ; WX 600 ; N odieresis ; B 62 -15 538 595 ;\nC -1 ; W"
 & "X 600 ; N Ograve ; B 43 -18 557 793 ;\nC -1 ; WX 600 ; N threequarters "
 & "; B 8 -56 593 666 ;\nC -1 ; WX 600 ; N plusminus ; B 87 44 513 558 ;\nC"
 & " -1 ; WX 600 ; N prescription ; B 27 -15 577 562 ;\nC -1 ; WX 600 ; N e"
 & "th ; B 62 -15 538 629 ;\nC -1 ; WX 600 ; N largebullet ; B 261 220 339 "
 & "297 ;\nC -1 ; WX 600 ; N egrave ; B 66 -15 548 672 ;\nC -1 ; WX 600 ; N"
 & " ccedilla ; B 66 -151 529 441 ;\nC -1 ; WX 600 ; N notegraphic ; B 136 "
 & "-15 464 572 ;\nC -1 ; WX 600 ; N Udieresis ; B 17 -18 583 731 ;\nC -1 ;"
 & " WX 600 ; N Gcaron ; B 31 -18 575 805 ;\nC -1 ; WX 600 ; N arrowdown ; "
 & "B 116 -15 484 608 ;\nC -1 ; WX 600 ; N format ; B 5 -157 56 607 ;\nC -1"
 & " ; WX 600 ; N Otilde ; B 43 -18 557 732 ;\nC -1 ; WX 600 ; N Idieresis "
 & "; B 96 0 504 731 ;\nC -1 ; WX 600 ; N adieresis ; B 53 -15 559 595 ;\nC"
 & " -1 ; WX 600 ; N ecircumflex ; B 66 -15 548 654 ;\nC -1 ; WX 600 ; N Et"
 & "h ; B 30 0 574 562 ;\nC -1 ; WX 600 ; N onequarter ; B 0 -57 600 665 ;\n"
 & "C -1 ; WX 600 ; N LL ; B 8 0 592 562 ;\nC -1 ; WX 600 ; N agrave ; B 53"
 & " -15 559 672 ;\nC -1 ; WX 600 ; N Zcaron ; B 86 0 514";

CONST E3_4 = 
   " 805 ;\nC -1 ; WX 600 ; N Scedilla ; B 72 -151 529 580 ;\nC -1 ; WX 600"
 & " ; N Idot ; B 96 0 504 716 ;\nC -1 ; WX 600 ; N Iacute ; B 96 0 504 793"
 & " ;\nC -1 ; WX 600 ; N indent ; B 70 68 530 348 ;\nC -1 ; WX 600 ; N Ugr"
 & "ave ; B 17 -18 583 793 ;\nC -1 ; WX 600 ; N scaron ; B 80 -15 513 669 ;"
 & "\nC -1 ; WX 600 ; N overscore ; B 0 579 600 629 ;\nC -1 ; WX 600 ; N Ar"
 & "ing ; B 3 0 597 753 ;\nC -1 ; WX 600 ; N Ccedilla ; B 41 -151 540 580 ;"
 & "\nC -1 ; WX 600 ; N Igrave ; B 96 0 504 793 ;\nC -1 ; WX 600 ; N broken"
 & "bar ; B 275 -175 326 675 ;\nC -1 ; WX 600 ; N Oacute ; B 43 -18 557 793"
 & " ;\nC -1 ; WX 600 ; N otilde ; B 62 -15 538 606 ;\nC -1 ; WX 600 ; N Ya"
 & "cute ; B 24 0 576 793 ;\nC -1 ; WX 600 ; N lira ; B 73 -21 521 611 ;\nC"
 & " -1 ; WX 600 ; N Icircumflex ; B 96 0 504 775 ;\nC -1 ; WX 600 ; N Atil"
 & "de ; B 3 0 597 732 ;\nC -1 ; WX 600 ; N Uacute ; B 17 -18 583 793 ;\nC "
 & "-1 ; WX 600 ; N Ydieresis ; B 24 0 576 731 ;\nC -1 ; WX 600 ; N ydieres"
 & "is ; B 7 -157 592 595 ;\nC -1 ; WX 600 ; N idieresis ; B 95 0 505 595 ;"
 & "\nC -1 ; WX 600 ; N Adieresis ; B 3 0 597 731 ;\nC -1 ; WX 600 ; N mu ;"
 & " B 21 -157 562 426 ;\nC -1 ; WX 600 ; N trademark ; B -23 263 623 562 ;"
 & "\nC -1 ; WX 600 ; N oacute ; B 62 -15 538 672 ;\nC -1 ; WX 600 ; N acir"
 & "cumflex ; B 53 -15 559 654 ;\nC -1 ; WX 600 ; N Agrave ; B 3 0 597 793 "
 & ";\nC -1 ; WX 600 ; N return ; B 19 0 581 562 ;\nC -1 ; WX 600 ; N atild"
 & "e ; B 53 -15 559 606 ;\nC -1 ; WX 600 ; N square ; B 19 0 581 562 ;\nC "
 & "-1 ; WX 600 ; N registered ; B 0 -18 600 580 ;\nC -1 ; WX 600 ; N stop "
 & "; B 19 0 581 562 ;\nC -1 ; WX 600 ; N udieresis ; B 21 -15 562 595 ;\nC"
 & " -1 ; WX 600 ; N arrowup ; B 116 0 484 623 ;\nC -1 ; WX 600 ; N igrave "
 & "; B 95 0 505 672 ;\nC -1 ; WX 600 ; N Edieresis ; B 53 0 550 731 ;\nC -"
 & "1 ; WX 600 ; N zcaron ; B 99 0 502 669 ;\nC -1 ; WX 600 ; N arrowboth ;"
 & " B -28 115 628 483 ;\nC -1 ; WX 600 ; N gcaron ; B 45 -157 566 669 ;\nC"
 & " -1 ; WX 600 ; N arrowleft ; B -24 115 624 483 ;\nC -1 ; WX 600 ; N aac"
 & "ute ; B 53 -15 559 672 ;\nC -1 ; WX 600 ; N ocircumflex ; B 62 -15 538 "
 & "654 ;\nC -1 ; WX 600 ; N scedilla ; B 80 -151 513 441 ;";

CONST E3_5 = 
   "\nC -1 ; WX 600 ; N ograve ; B 62 -15 538 672 ;\nC -1 ; WX 600 ; N oneh"
 & "alf ; B 0 -57 611 665 ;\nC -1 ; WX 600 ; N ugrave ; B 21 -15 562 672 ;\n"
 & "C -1 ; WX 600 ; N Ntilde ; B 7 -13 593 732 ;\nC -1 ; WX 600 ; N iacute "
 & "; B 95 0 505 672 ;\nC -1 ; WX 600 ; N arrowright ; B -24 115 624 483 ;\n"
 & "C -1 ; WX 600 ; N Thorn ; B 79 0 538 562 ;\nC -1 ; WX 600 ; N Egrave ; "
 & "B 53 0 550 793 ;\nC -1 ; WX 600 ; N thorn ; B -6 -157 555 629 ;\nC -1 ;"
 & " WX 600 ; N aring ; B 53 -15 559 627 ;\nC -1 ; WX 600 ; N yacute ; B 7 "
 & "-157 592 672 ;\nC -1 ; WX 600 ; N icircumflex ; B 94 0 505 654 ;\nEndCh"
 & "arMetrics\nStartComposites 58\nCC Aacute 2 ; PCC A 0 0 ; PCC acute 20 1"
 & "21 ;\nCC Acircumflex 2 ; PCC A 0 0 ; PCC circumflex -30 121 ;\nCC Adier"
 & "esis 2 ; PCC A 0 0 ; PCC dieresis -30 136 ;\nCC Agrave 2 ; PCC A 0 0 ; "
 & "PCC grave -30 121 ;\nCC Aring 2 ; PCC A 0 0 ; PCC ring -15 126 ;\nCC At"
 & "ilde 2 ; PCC A 0 0 ; PCC tilde 0 126 ;\nCC Eacute 2 ; PCC E 0 0 ; PCC a"
 & "cute 30 121 ;\nCC Ecircumflex 2 ; PCC E 0 0 ; PCC circumflex 0 121 ;\nC"
 & "C Edieresis 2 ; PCC E 0 0 ; PCC dieresis 0 136 ;\nCC Egrave 2 ; PCC E 0"
 & " 0 ; PCC grave 0 121 ;\nCC Gcaron 2 ; PCC G 0 0 ; PCC caron 0 136 ;\nCC"
 & " Iacute 2 ; PCC I 0 0 ; PCC acute 0 121 ;\nCC Icircumflex 2 ; PCC I 0 0"
 & " ; PCC circumflex 0 121 ;\nCC Idieresis 2 ; PCC I 0 0 ; PCC dieresis 0 "
 & "136 ;\nCC Igrave 2 ; PCC I 0 0 ; PCC grave 0 121 ;\nCC Ntilde 2 ; PCC N"
 & " 0 0 ; PCC tilde 0 126 ;\nCC Oacute 2 ; PCC O 0 0 ; PCC acute 0 121 ;\n"
 & "CC Ocircumflex 2 ; PCC O 0 0 ; PCC circumflex 0 121 ;\nCC Odieresis 2 ;"
 & " PCC O 0 0 ; PCC dieresis 0 136 ;\nCC Ograve 2 ; PCC O 0 0 ; PCC grave "
 & "0 121 ;\nCC Otilde 2 ; PCC O 0 0 ; PCC tilde 0 126 ;\nCC Scaron 2 ; PCC"
 & " S 0 0 ; PCC caron 30 136 ;\nCC Uacute 2 ; PCC U 0 0 ; PCC acute 30 121"
 & " ;\nCC Ucircumflex 2 ; PCC U 0 0 ; PCC circumflex 0 121 ;\nCC Udieresis"
 & " 2 ; PCC U 0 0 ; PCC dieresis 0 136 ;\nCC Ugrave 2 ; PCC U 0 0 ; PCC gr"
 & "ave -30 121 ;\nCC Yacute 2 ; PCC Y 0 0 ; PCC acute 30 121 ;\nCC Ydieres"
 & "is 2 ; PCC Y 0 0 ; PCC dieresis 0 136 ;\nCC Zcaron 2 ; PCC Z 0 0 ; PCC "
 & "caron 0 136 ;\nCC aacute 2 ; PCC a 0 0 ; PCC acute 0 0";

CONST E3_6 = 
   " ;\nCC acircumflex 2 ; PCC a 0 0 ; PCC circumflex 0 0 ;\nCC adieresis 2"
 & " ; PCC a 0 0 ; PCC dieresis 0 0 ;\nCC agrave 2 ; PCC a 0 0 ; PCC grave "
 & "0 0 ;\nCC aring 2 ; PCC a 0 0 ; PCC ring 0 0 ;\nCC atilde 2 ; PCC a 0 0"
 & " ; PCC tilde 0 0 ;\nCC eacute 2 ; PCC e 0 0 ; PCC acute 0 0 ;\nCC ecirc"
 & "umflex 2 ; PCC e 0 0 ; PCC circumflex 0 0 ;\nCC edieresis 2 ; PCC e 0 0"
 & " ; PCC dieresis 0 0 ;\nCC egrave 2 ; PCC e 0 0 ; PCC grave 0 0 ;\nCC gc"
 & "aron 2 ; PCC g 0 0 ; PCC caron -30 0 ;\nCC iacute 2 ; PCC dotlessi 0 0 "
 & "; PCC acute 0 0 ;\nCC icircumflex 2 ; PCC dotlessi 0 0 ; PCC circumflex"
 & " -30 0 ;\nCC idieresis 2 ; PCC dotlessi 0 0 ; PCC dieresis -30 0 ;\nCC "
 & "igrave 2 ; PCC dotlessi 0 0 ; PCC grave -30 0 ;\nCC ntilde 2 ; PCC n 0 "
 & "0 ; PCC tilde 0 0 ;\nCC oacute 2 ; PCC o 0 0 ; PCC acute 0 0 ;\nCC ocir"
 & "cumflex 2 ; PCC o 0 0 ; PCC circumflex 0 0 ;\nCC odieresis 2 ; PCC o 0 "
 & "0 ; PCC dieresis 0 0 ;\nCC ograve 2 ; PCC o 0 0 ; PCC grave 0 0 ;\nCC o"
 & "tilde 2 ; PCC o 0 0 ; PCC tilde 0 0 ;\nCC scaron 2 ; PCC s 0 0 ; PCC ca"
 & "ron 0 0 ;\nCC uacute 2 ; PCC u 0 0 ; PCC acute -10 0 ;\nCC ucircumflex "
 & "2 ; PCC u 0 0 ; PCC circumflex -10 0 ;\nCC udieresis 2 ; PCC u 0 0 ; PC"
 & "C dieresis 0 0 ;\nCC ugrave 2 ; PCC u 0 0 ; PCC grave -30 0 ;\nCC yacut"
 & "e 2 ; PCC y 0 0 ; PCC acute -20 0 ;\nCC ydieresis 2 ; PCC y 0 0 ; PCC d"
 & "ieresis -10 0 ;\nCC zcaron 2 ; PCC z 0 0 ; PCC caron 10 0 ;\nEndComposi"
 & "tes\nEndFontMetrics\n";

CONST E4 = 
   "StartFontMetrics 2.0\nComment Copyright (c) 1985, 1987, 1989, 1990 Adob"
 & "e Systems Incorporated.  All Rights Reserved.\nComment Creation Date: T"
 & "ue Mar 20 12:15:44 1990\nComment UniqueID 28416\nComment VMusage 30487 "
 & "37379\nFontName Times-Roman\nFullName Times Roman\nFamilyName Times\nWe"
 & "ight Roman\nItalicAngle 0\nIsFixedPitch false\nFontBBox -168 -218 1000 "
 & "898\nUnderlinePosition -100\nUnderlineThickness 50\nVersion 001.007\nNo"
 & "tice Copyright (c) 1985, 1987, 1989, 1990 Adobe Systems Incorporated.  "
 & "All Rights Reserved.Times is a trademark of Linotype AG and/or its subs"
 & "idiaries.\nEncodingScheme AdobeStandardEncoding\nCapHeight 662\nXHeight"
 & " 450\nAscender 683\nDescender -217\nStartCharMetrics 228\nC 32 ; WX 250"
 & " ; N space ; B 0 0 0 0 ;\nC 33 ; WX 333 ; N exclam ; B 130 -9 238 676 ;"
 & "\nC 34 ; WX 408 ; N quotedbl ; B 77 431 331 676 ;\nC 35 ; WX 500 ; N nu"
 & "mbersign ; B 5 0 496 662 ;\nC 36 ; WX 500 ; N dollar ; B 44 -87 457 727"
 & " ;\nC 37 ; WX 833 ; N percent ; B 61 -13 772 676 ;\nC 38 ; WX 778 ; N a"
 & "mpersand ; B 42 -13 750 676 ;\nC 39 ; WX 333 ; N quoteright ; B 79 433 "
 & "218 676 ;\nC 40 ; WX 333 ; N parenleft ; B 48 -177 304 676 ;\nC 41 ; WX"
 & " 333 ; N parenright ; B 29 -177 285 676 ;\nC 42 ; WX 500 ; N asterisk ;"
 & " B 69 265 432 676 ;\nC 43 ; WX 564 ; N plus ; B 30 0 534 506 ;\nC 44 ; "
 & "WX 250 ; N comma ; B 56 -141 195 102 ;\nC 45 ; WX 333 ; N hyphen ; B 39"
 & " 194 285 257 ;\nC 46 ; WX 250 ; N period ; B 70 -11 181 100 ;\nC 47 ; W"
 & "X 278 ; N slash ; B -9 -14 287 676 ;\nC 48 ; WX 500 ; N zero ; B 24 -14"
 & " 476 676 ;\nC 49 ; WX 500 ; N one ; B 111 0 394 676 ;\nC 50 ; WX 500 ; "
 & "N two ; B 30 0 475 676 ;\nC 51 ; WX 500 ; N three ; B 43 -14 431 676 ;\n"
 & "C 52 ; WX 500 ; N four ; B 12 0 472 676 ;\nC 53 ; WX 500 ; N five ; B 3"
 & "2 -14 438 688 ;\nC 54 ; WX 500 ; N six ; B 34 -14 468 684 ;\nC 55 ; WX "
 & "500 ; N seven ; B 20 -8 449 662 ;\nC 56 ; WX 500 ; N eight ; B 56 -14 4"
 & "45 676 ;\nC 57 ; WX 500 ; N nine ; B 30 -22 459 676 ;\nC 58 ; WX 278 ; "
 & "N colon ; B 81 -11 192 459 ;\nC 59 ; WX 278 ; N semicolon ; B 80 -141 2"
 & "19 459 ;\nC 60 ; WX 564 ; N less ; B 28 -8 536 514 ;\nC 61 ; W";

CONST E4_0 = 
   "X 564 ; N equal ; B 30 120 534 386 ;\nC 62 ; WX 564 ; N greater ; B 28 "
 & "-8 536 514 ;\nC 63 ; WX 444 ; N question ; B 68 -8 414 676 ;\nC 64 ; WX"
 & " 921 ; N at ; B 116 -14 809 676 ;\nC 65 ; WX 722 ; N A ; B 15 0 706 674"
 & " ;\nC 66 ; WX 667 ; N B ; B 17 0 593 662 ;\nC 67 ; WX 667 ; N C ; B 28 "
 & "-14 633 676 ;\nC 68 ; WX 722 ; N D ; B 16 0 685 662 ;\nC 69 ; WX 611 ; "
 & "N E ; B 12 0 597 662 ;\nC 70 ; WX 556 ; N F ; B 12 0 546 662 ;\nC 71 ; "
 & "WX 722 ; N G ; B 32 -14 709 676 ;\nC 72 ; WX 722 ; N H ; B 19 0 702 662"
 & " ;\nC 73 ; WX 333 ; N I ; B 18 0 315 662 ;\nC 74 ; WX 389 ; N J ; B 10 "
 & "-14 370 662 ;\nC 75 ; WX 722 ; N K ; B 34 0 723 662 ;\nC 76 ; WX 611 ; "
 & "N L ; B 12 0 598 662 ;\nC 77 ; WX 889 ; N M ; B 12 0 863 662 ;\nC 78 ; "
 & "WX 722 ; N N ; B 12 -11 707 662 ;\nC 79 ; WX 722 ; N O ; B 34 -14 688 6"
 & "76 ;\nC 80 ; WX 556 ; N P ; B 16 0 542 662 ;\nC 81 ; WX 722 ; N Q ; B 3"
 & "4 -178 701 676 ;\nC 82 ; WX 667 ; N R ; B 17 0 659 662 ;\nC 83 ; WX 556"
 & " ; N S ; B 42 -14 491 676 ;\nC 84 ; WX 611 ; N T ; B 17 0 593 662 ;\nC "
 & "85 ; WX 722 ; N U ; B 14 -14 705 662 ;\nC 86 ; WX 722 ; N V ; B 16 -11 "
 & "697 662 ;\nC 87 ; WX 944 ; N W ; B 5 -11 932 662 ;\nC 88 ; WX 722 ; N X"
 & " ; B 10 0 704 662 ;\nC 89 ; WX 722 ; N Y ; B 22 0 703 662 ;\nC 90 ; WX "
 & "611 ; N Z ; B 9 0 597 662 ;\nC 91 ; WX 333 ; N bracketleft ; B 88 -156 "
 & "299 662 ;\nC 92 ; WX 278 ; N backslash ; B -9 -14 287 676 ;\nC 93 ; WX "
 & "333 ; N bracketright ; B 34 -156 245 662 ;\nC 94 ; WX 469 ; N asciicirc"
 & "um ; B 24 297 446 662 ;\nC 95 ; WX 500 ; N underscore ; B 0 -125 500 -7"
 & "5 ;\nC 96 ; WX 333 ; N quoteleft ; B 115 433 254 676 ;\nC 97 ; WX 444 ;"
 & " N a ; B 37 -10 442 460 ;\nC 98 ; WX 500 ; N b ; B 3 -10 468 683 ;\nC 9"
 & "9 ; WX 444 ; N c ; B 25 -10 412 460 ;\nC 100 ; WX 500 ; N d ; B 27 -10 "
 & "491 683 ;\nC 101 ; WX 444 ; N e ; B 25 -10 424 460 ;\nC 102 ; WX 333 ; "
 & "N f ; B 20 0 383 683 ; L i fi ; L l fl ;\nC 103 ; WX 500 ; N g ; B 28 -"
 & "218 470 460 ;\nC 104 ; WX 500 ; N h ; B 9 0 487 683 ;\nC 105 ; WX 278 ;"
 & " N i ; B 16 0 253 683 ;\nC 106 ; WX 278 ; N j ; B -70 -218 194 683 ;\nC"
 & " 107 ; WX 500 ; N k ; B 7 0 505 683 ;\nC 108 ; WX 278 ; N l";

CONST E4_1 = 
   " ; B 19 0 257 683 ;\nC 109 ; WX 778 ; N m ; B 16 0 775 460 ;\nC 110 ; W"
 & "X 500 ; N n ; B 16 0 485 460 ;\nC 111 ; WX 500 ; N o ; B 29 -10 470 460"
 & " ;\nC 112 ; WX 500 ; N p ; B 5 -217 470 460 ;\nC 113 ; WX 500 ; N q ; B"
 & " 24 -217 488 460 ;\nC 114 ; WX 333 ; N r ; B 5 0 335 460 ;\nC 115 ; WX "
 & "389 ; N s ; B 51 -10 348 460 ;\nC 116 ; WX 278 ; N t ; B 13 -10 279 579"
 & " ;\nC 117 ; WX 500 ; N u ; B 9 -10 479 450 ;\nC 118 ; WX 500 ; N v ; B "
 & "19 -14 477 450 ;\nC 119 ; WX 722 ; N w ; B 21 -14 694 450 ;\nC 120 ; WX"
 & " 500 ; N x ; B 17 0 479 450 ;\nC 121 ; WX 500 ; N y ; B 14 -218 475 450"
 & " ;\nC 122 ; WX 444 ; N z ; B 27 0 418 450 ;\nC 123 ; WX 480 ; N bracele"
 & "ft ; B 100 -181 350 680 ;\nC 124 ; WX 200 ; N bar ; B 67 -14 133 676 ;\n"
 & "C 125 ; WX 480 ; N braceright ; B 130 -181 380 680 ;\nC 126 ; WX 541 ; "
 & "N asciitilde ; B 40 183 502 323 ;\nC 161 ; WX 333 ; N exclamdown ; B 97"
 & " -218 205 467 ;\nC 162 ; WX 500 ; N cent ; B 53 -138 448 579 ;\nC 163 ;"
 & " WX 500 ; N sterling ; B 12 -8 490 676 ;\nC 164 ; WX 167 ; N fraction ;"
 & " B -168 -14 331 676 ;\nC 165 ; WX 500 ; N yen ; B -53 0 512 662 ;\nC 16"
 & "6 ; WX 500 ; N florin ; B 7 -189 490 676 ;\nC 167 ; WX 500 ; N section "
 & "; B 70 -148 426 676 ;\nC 168 ; WX 500 ; N currency ; B -22 58 522 602 ;"
 & "\nC 169 ; WX 180 ; N quotesingle ; B 48 431 133 676 ;\nC 170 ; WX 444 ;"
 & " N quotedblleft ; B 43 433 414 676 ;\nC 171 ; WX 500 ; N guillemotleft "
 & "; B 42 33 456 416 ;\nC 172 ; WX 333 ; N guilsinglleft ; B 63 33 285 416"
 & " ;\nC 173 ; WX 333 ; N guilsinglright ; B 48 33 270 416 ;\nC 174 ; WX 5"
 & "56 ; N fi ; B 31 0 521 683 ;\nC 175 ; WX 556 ; N fl ; B 32 0 521 683 ;\n"
 & "C 177 ; WX 500 ; N endash ; B 0 201 500 250 ;\nC 178 ; WX 500 ; N dagge"
 & "r ; B 59 -149 442 676 ;\nC 179 ; WX 500 ; N daggerdbl ; B 58 -153 442 6"
 & "76 ;\nC 180 ; WX 250 ; N periodcentered ; B 70 199 181 310 ;\nC 182 ; W"
 & "X 453 ; N paragraph ; B -22 -154 450 662 ;\nC 183 ; WX 350 ; N bullet ;"
 & " B 40 196 310 466 ;\nC 184 ; WX 333 ; N quotesinglbase ; B 79 -141 218 "
 & "102 ;\nC 185 ; WX 444 ; N quotedblbase ; B 45 -141 416 102 ;\nC 186 ; W"
 & "X 444 ; N quotedblright ; B 30 433 401 676 ;\nC 187 ;";

CONST E4_2 = 
   " WX 500 ; N guillemotright ; B 44 33 458 416 ;\nC 188 ; WX 1000 ; N ell"
 & "ipsis ; B 111 -11 888 100 ;\nC 189 ; WX 1000 ; N perthousand ; B 7 -19 "
 & "994 706 ;\nC 191 ; WX 444 ; N questiondown ; B 30 -218 376 466 ;\nC 193"
 & " ; WX 333 ; N grave ; B 19 507 242 678 ;\nC 194 ; WX 333 ; N acute ; B "
 & "93 507 317 678 ;\nC 195 ; WX 333 ; N circumflex ; B 11 507 322 674 ;\nC"
 & " 196 ; WX 333 ; N tilde ; B 1 532 331 638 ;\nC 197 ; WX 333 ; N macron "
 & "; B 11 547 322 601 ;\nC 198 ; WX 333 ; N breve ; B 26 507 307 664 ;\nC "
 & "199 ; WX 333 ; N dotaccent ; B 118 523 216 623 ;\nC 200 ; WX 333 ; N di"
 & "eresis ; B 18 523 315 623 ;\nC 202 ; WX 333 ; N ring ; B 67 512 266 711"
 & " ;\nC 203 ; WX 333 ; N cedilla ; B 52 -215 261 0 ;\nC 205 ; WX 333 ; N "
 & "hungarumlaut ; B -3 507 377 678 ;\nC 206 ; WX 333 ; N ogonek ; B 64 -16"
 & "5 249 0 ;\nC 207 ; WX 333 ; N caron ; B 11 507 322 674 ;\nC 208 ; WX 10"
 & "00 ; N emdash ; B 0 201 1000 250 ;\nC 225 ; WX 889 ; N AE ; B 0 0 863 6"
 & "62 ;\nC 227 ; WX 276 ; N ordfeminine ; B 4 394 270 676 ;\nC 232 ; WX 61"
 & "1 ; N Lslash ; B 12 0 598 662 ;\nC 233 ; WX 722 ; N Oslash ; B 34 -80 6"
 & "88 734 ;\nC 234 ; WX 889 ; N OE ; B 30 -6 885 668 ;\nC 235 ; WX 310 ; N"
 & " ordmasculine ; B 6 394 304 676 ;\nC 241 ; WX 667 ; N ae ; B 38 -10 632"
 & " 460 ;\nC 245 ; WX 278 ; N dotlessi ; B 16 0 253 460 ;\nC 248 ; WX 278 "
 & "; N lslash ; B 19 0 259 683 ;\nC 249 ; WX 500 ; N oslash ; B 29 -112 47"
 & "0 551 ;\nC 250 ; WX 722 ; N oe ; B 30 -10 690 460 ;\nC 251 ; WX 500 ; N"
 & " germandbls ; B 12 -9 468 683 ;\nC -1 ; WX 611 ; N Zcaron ; B 9 0 597 8"
 & "86 ;\nC -1 ; WX 444 ; N ccedilla ; B 25 -215 412 460 ;\nC -1 ; WX 500 ;"
 & " N ydieresis ; B 14 -218 475 623 ;\nC -1 ; WX 444 ; N atilde ; B 37 -10"
 & " 442 638 ;\nC -1 ; WX 278 ; N icircumflex ; B -16 0 295 674 ;\nC -1 ; W"
 & "X 300 ; N threesuperior ; B 15 262 291 676 ;\nC -1 ; WX 444 ; N ecircum"
 & "flex ; B 25 -10 424 674 ;\nC -1 ; WX 500 ; N thorn ; B 5 -217 470 683 ;"
 & "\nC -1 ; WX 444 ; N egrave ; B 25 -10 424 678 ;\nC -1 ; WX 300 ; N twos"
 & "uperior ; B 1 270 296 676 ;\nC -1 ; WX 444 ; N eacute ; B 25 -10 424 67"
 & "8 ;\nC -1 ; WX 500 ; N otilde ; B 29 -10 470 638 ;\nC ";

CONST E4_3 = 
   "-1 ; WX 722 ; N Aacute ; B 15 0 706 890 ;\nC -1 ; WX 500 ; N ocircumfle"
 & "x ; B 29 -10 470 674 ;\nC -1 ; WX 500 ; N yacute ; B 14 -218 475 678 ;\n"
 & "C -1 ; WX 500 ; N udieresis ; B 9 -10 479 623 ;\nC -1 ; WX 750 ; N thre"
 & "equarters ; B 15 -14 718 676 ;\nC -1 ; WX 444 ; N acircumflex ; B 37 -1"
 & "0 442 674 ;\nC -1 ; WX 722 ; N Eth ; B 16 0 685 662 ;\nC -1 ; WX 444 ; "
 & "N edieresis ; B 25 -10 424 623 ;\nC -1 ; WX 500 ; N ugrave ; B 9 -10 47"
 & "9 678 ;\nC -1 ; WX 980 ; N trademark ; B 30 256 957 662 ;\nC -1 ; WX 50"
 & "0 ; N ograve ; B 29 -10 470 678 ;\nC -1 ; WX 389 ; N scaron ; B 39 -10 "
 & "350 674 ;\nC -1 ; WX 333 ; N Idieresis ; B 18 0 315 835 ;\nC -1 ; WX 50"
 & "0 ; N uacute ; B 9 -10 479 678 ;\nC -1 ; WX 444 ; N agrave ; B 37 -10 4"
 & "42 678 ;\nC -1 ; WX 500 ; N ntilde ; B 16 0 485 638 ;\nC -1 ; WX 444 ; "
 & "N aring ; B 37 -10 442 711 ;\nC -1 ; WX 444 ; N zcaron ; B 27 0 418 674"
 & " ;\nC -1 ; WX 333 ; N Icircumflex ; B 11 0 322 886 ;\nC -1 ; WX 722 ; N"
 & " Ntilde ; B 12 -11 707 850 ;\nC -1 ; WX 500 ; N ucircumflex ; B 9 -10 4"
 & "79 674 ;\nC -1 ; WX 611 ; N Ecircumflex ; B 12 0 597 886 ;\nC -1 ; WX 3"
 & "33 ; N Iacute ; B 18 0 317 890 ;\nC -1 ; WX 667 ; N Ccedilla ; B 28 -21"
 & "5 633 676 ;\nC -1 ; WX 722 ; N Odieresis ; B 34 -14 688 835 ;\nC -1 ; W"
 & "X 556 ; N Scaron ; B 42 -14 491 886 ;\nC -1 ; WX 611 ; N Edieresis ; B "
 & "12 0 597 835 ;\nC -1 ; WX 333 ; N Igrave ; B 18 0 315 890 ;\nC -1 ; WX "
 & "444 ; N adieresis ; B 37 -10 442 623 ;\nC -1 ; WX 722 ; N Ograve ; B 34"
 & " -14 688 890 ;\nC -1 ; WX 611 ; N Egrave ; B 12 0 597 890 ;\nC -1 ; WX "
 & "722 ; N Ydieresis ; B 22 0 703 835 ;\nC -1 ; WX 760 ; N registered ; B "
 & "38 -14 722 676 ;\nC -1 ; WX 722 ; N Otilde ; B 34 -14 688 850 ;\nC -1 ;"
 & " WX 750 ; N onequarter ; B 37 -14 718 676 ;\nC -1 ; WX 722 ; N Ugrave ;"
 & " B 14 -14 705 890 ;\nC -1 ; WX 722 ; N Ucircumflex ; B 14 -14 705 886 ;"
 & "\nC -1 ; WX 556 ; N Thorn ; B 16 0 542 662 ;\nC -1 ; WX 564 ; N divide "
 & "; B 30 -10 534 516 ;\nC -1 ; WX 722 ; N Atilde ; B 15 0 706 850 ;\nC -1"
 & " ; WX 722 ; N Uacute ; B 14 -14 705 890 ;\nC -1 ; WX 722 ; N Ocircumfle"
 & "x ; B 34 -14 688 886 ;\nC -1 ; WX 564 ; N logicalnot ";

CONST E4_4 = 
   "; B 30 108 534 386 ;\nC -1 ; WX 722 ; N Aring ; B 15 0 706 898 ;\nC -1 "
 & "; WX 278 ; N idieresis ; B -9 0 288 623 ;\nC -1 ; WX 278 ; N iacute ; B"
 & " 16 0 290 678 ;\nC -1 ; WX 444 ; N aacute ; B 37 -10 442 678 ;\nC -1 ; "
 & "WX 564 ; N plusminus ; B 30 0 534 506 ;\nC -1 ; WX 564 ; N multiply ; B"
 & " 38 8 527 497 ;\nC -1 ; WX 722 ; N Udieresis ; B 14 -14 705 835 ;\nC -1"
 & " ; WX 564 ; N minus ; B 30 220 534 286 ;\nC -1 ; WX 300 ; N onesuperior"
 & " ; B 57 270 248 676 ;\nC -1 ; WX 611 ; N Eacute ; B 12 0 597 890 ;\nC -"
 & "1 ; WX 722 ; N Acircumflex ; B 15 0 706 886 ;\nC -1 ; WX 760 ; N copyri"
 & "ght ; B 38 -14 722 676 ;\nC -1 ; WX 722 ; N Agrave ; B 15 0 706 890 ;\n"
 & "C -1 ; WX 500 ; N odieresis ; B 29 -10 470 623 ;\nC -1 ; WX 500 ; N oac"
 & "ute ; B 29 -10 470 678 ;\nC -1 ; WX 400 ; N degree ; B 57 390 343 676 ;"
 & "\nC -1 ; WX 278 ; N igrave ; B -8 0 253 678 ;\nC -1 ; WX 500 ; N mu ; B"
 & " 36 -218 512 450 ;\nC -1 ; WX 722 ; N Oacute ; B 34 -14 688 890 ;\nC -1"
 & " ; WX 500 ; N eth ; B 29 -10 471 686 ;\nC -1 ; WX 722 ; N Adieresis ; B"
 & " 15 0 706 835 ;\nC -1 ; WX 722 ; N Yacute ; B 22 0 703 890 ;\nC -1 ; WX"
 & " 200 ; N brokenbar ; B 67 -14 133 676 ;\nC -1 ; WX 750 ; N onehalf ; B "
 & "31 -14 746 676 ;\nEndCharMetrics\nStartKernData\nStartKernPairs 283\n\n"
 & "KPX A y -92\nKPX A w -92\nKPX A v -74\nKPX A u 0\nKPX A quoteright -111"
 & "\nKPX A quotedblright 0\nKPX A p 0\nKPX A Y -105\nKPX A W -90\nKPX A V "
 & "-135\nKPX A U -55\nKPX A T -111\nKPX A Q -55\nKPX A O -55\nKPX A G -40\n"
 & "KPX A C -40\n\nKPX B period 0\nKPX B comma 0\nKPX B U -10\nKPX B A -35\n"
 & "\nKPX D period 0\nKPX D comma 0\nKPX D Y -55\nKPX D W -30\nKPX D V -40\n"
 & "KPX D A -40\n\nKPX F r 0\nKPX F period -80\nKPX F o -15\nKPX F i 0\nKPX"
 & " F e 0\nKPX F comma -80\nKPX F a -15\nKPX F A -74\n\nKPX G period 0\nKP"
 & "X G comma 0\n\nKPX J u 0\nKPX J period 0\nKPX J o 0\nKPX J e 0\nKPX J c"
 & "omma 0\nKPX J a 0\nKPX J A -60\n\nKPX K y -25\nKPX K u -15\nKPX K o -35"
 & "\nKPX K e -25\nKPX K O -30\n\nKPX L y -55\nKPX L quoteright -92\nKPX L "
 & "quotedblright 0\nKPX L Y -100\nKPX L W -74\nKPX L V -100\nKPX L T -92\n"
 & "\nKPX N period 0\nKPX N comma 0\nKPX N A -35\n\nKPX O period 0\nKPX O c"
 & "omma 0\nKPX O Y -50\nKPX O X -40\nKPX ";

CONST E4_5 = 
   "O W -35\nKPX O V -50\nKPX O T -40\nKPX O A -35\n\nKPX P period -111\nKP"
 & "X P o 0\nKPX P e 0\nKPX P comma -111\nKPX P a -15\nKPX P A -92\n\nKPX Q"
 & " period 0\nKPX Q comma 0\nKPX Q U -10\n\nKPX R Y -65\nKPX R W -55\nKPX "
 & "R V -80\nKPX R U -40\nKPX R T -60\nKPX R O -40\n\nKPX S period 0\nKPX S"
 & " comma 0\n\nKPX T y -80\nKPX T w -80\nKPX T u -45\nKPX T semicolon -55\n"
 & "KPX T r -35\nKPX T period -74\nKPX T o -80\nKPX T i -35\nKPX T hyphen -"
 & "92\nKPX T h 0\nKPX T e -70\nKPX T comma -74\nKPX T colon -50\nKPX T a -"
 & "80\nKPX T O -18\nKPX T A -93\n\nKPX U period 0\nKPX U comma 0\nKPX U A "
 & "-40\n\nKPX V u -75\nKPX V semicolon -74\nKPX V period -129\nKPX V o -12"
 & "9\nKPX V i -60\nKPX V hyphen -100\nKPX V e -111\nKPX V comma -129\nKPX "
 & "V colon -74\nKPX V a -111\nKPX V O -40\nKPX V G -15\nKPX V A -135\n\nKP"
 & "X W y -73\nKPX W u -50\nKPX W semicolon -37\nKPX W period -92\nKPX W o "
 & "-80\nKPX W i -40\nKPX W hyphen -65\nKPX W h 0\nKPX W e -80\nKPX W comma"
 & " -92\nKPX W colon -37\nKPX W a -80\nKPX W O -10\nKPX W A -120\n\nKPX Y "
 & "u -111\nKPX Y semicolon -92\nKPX Y period -129\nKPX Y o -110\nKPX Y i -"
 & "55\nKPX Y hyphen -111\nKPX Y e -100\nKPX Y comma -129\nKPX Y colon -92\n"
 & "KPX Y a -100\nKPX Y O -30\nKPX Y A -120\n\nKPX a y 0\nKPX a w -15\nKPX "
 & "a v -20\nKPX a t 0\nKPX a p 0\nKPX a g 0\nKPX a b 0\n\nKPX b y 0\nKPX b"
 & " v -15\nKPX b u -20\nKPX b period -40\nKPX b l 0\nKPX b comma 0\nKPX b "
 & "b 0\n\nKPX c y -15\nKPX c period 0\nKPX c l 0\nKPX c k 0\nKPX c h 0\nKP"
 & "X c comma 0\n\nKPX colon space 0\n\nKPX comma space 0\nKPX comma quoter"
 & "ight -70\nKPX comma quotedblright -70\n\nKPX d y 0\nKPX d w 0\nKPX d v "
 & "0\nKPX d period 0\nKPX d d 0\nKPX d comma 0\n\nKPX e y -15\nKPX e x -15"
 & "\nKPX e w -25\nKPX e v -25\nKPX e period 0\nKPX e p 0\nKPX e g -15\nKPX"
 & " e comma 0\nKPX e b 0\n\nKPX f quoteright 55\nKPX f quotedblright 0\nKP"
 & "X f period 0\nKPX f o 0\nKPX f l 0\nKPX f i -20\nKPX f f -25\nKPX f e 0"
 & "\nKPX f dotlessi -50\nKPX f comma 0\nKPX f a -10\n\nKPX g y 0\nKPX g r "
 & "0\nKPX g period 0\nKPX g o 0\nKPX g i 0\nKPX g g 0\nKPX g e 0\nKPX g co"
 & "mma 0\nKPX g a -5\n\nKPX h y -5\n\nKPX i v -25\n\nKPX k y -15\nKPX k o "
 & "-10\nKPX k e -10\n\nKPX l y 0\nKPX l w -10\n\nKPX m y 0\nKPX m u 0\n\nK"
 & "PX n y -15\nKPX n v -40\nKPX n u 0\n\nKPX o";

CONST E4_6 = 
   " y -10\nKPX o x 0\nKPX o w -25\nKPX o v -15\nKPX o g 0\n\nKPX p y -10\n"
 & "\nKPX period quoteright -70\nKPX period quotedblright -70\n\nKPX quoted"
 & "blleft quoteleft 0\nKPX quotedblleft A -80\n\nKPX quotedblright space 0"
 & "\n\nKPX quoteleft quoteleft -74\nKPX quoteleft A -80\n\nKPX quoteright "
 & "v -50\nKPX quoteright t -18\nKPX quoteright space -74\nKPX quoteright s"
 & " -55\nKPX quoteright r -50\nKPX quoteright quoteright -74\nKPX quoterig"
 & "ht quotedblright 0\nKPX quoteright l -10\nKPX quoteright d -50\n\nKPX r"
 & " y 0\nKPX r v 0\nKPX r u 0\nKPX r t 0\nKPX r s 0\nKPX r r 0\nKPX r q 0\n"
 & "KPX r period -55\nKPX r p 0\nKPX r o 0\nKPX r n 0\nKPX r m 0\nKPX r l 0"
 & "\nKPX r k 0\nKPX r i 0\nKPX r hyphen -20\nKPX r g -18\nKPX r e 0\nKPX r"
 & " d 0\nKPX r comma -40\nKPX r c 0\nKPX r a 0\n\nKPX s w 0\n\nKPX space q"
 & "uoteleft 0\nKPX space quotedblleft 0\nKPX space Y -90\nKPX space W -30\n"
 & "KPX space V -50\nKPX space T -18\nKPX space A -55\n\nKPX v period -65\n"
 & "KPX v o -20\nKPX v e -15\nKPX v comma -65\nKPX v a -25\n\nKPX w period "
 & "-65\nKPX w o -10\nKPX w h 0\nKPX w e 0\nKPX w comma -65\nKPX w a -10\n\n"
 & "KPX x e -15\n\nKPX y period -65\nKPX y o 0\nKPX y e 0\nKPX y comma -65\n"
 & "KPX y a 0\n\nKPX z o 0\nKPX z e 0\nEndKernPairs\nEndKernData\nStartComp"
 & "osites 58\nCC Aacute 2 ; PCC A 0 0 ; PCC acute 195 212 ;\nCC Acircumfle"
 & "x 2 ; PCC A 0 0 ; PCC circumflex 195 212 ;\nCC Adieresis 2 ; PCC A 0 0 "
 & "; PCC dieresis 195 212 ;\nCC Agrave 2 ; PCC A 0 0 ; PCC grave 195 212 ;"
 & "\nCC Aring 2 ; PCC A 0 0 ; PCC ring 185 187 ;\nCC Atilde 2 ; PCC A 0 0 "
 & "; PCC tilde 195 212 ;\nCC Ccedilla 2 ; PCC C 0 0 ; PCC cedilla 167 0 ;\n"
 & "CC Eacute 2 ; PCC E 0 0 ; PCC acute 139 212 ;\nCC Ecircumflex 2 ; PCC E"
 & " 0 0 ; PCC circumflex 139 212 ;\nCC Edieresis 2 ; PCC E 0 0 ; PCC diere"
 & "sis 139 212 ;\nCC Egrave 2 ; PCC E 0 0 ; PCC grave 139 212 ;\nCC Iacute"
 & " 2 ; PCC I 0 0 ; PCC acute 0 212 ;\nCC Icircumflex 2 ; PCC I 0 0 ; PCC "
 & "circumflex 0 212 ;\nCC Idieresis 2 ; PCC I 0 0 ; PCC dieresis 0 212 ;\n"
 & "CC Igrave 2 ; PCC I 0 0 ; PCC grave 0 212 ;\nCC Ntilde 2 ; PCC N 0 0 ; "
 & "PCC tilde 195 212 ;\nCC Oacute 2 ; PCC O 0 0 ; PCC acute 195 212 ;\nCC "
 & "Ocircumflex 2 ; PCC O 0 0 ; PCC circumfle";

CONST E4_7 = 
   "x 195 212 ;\nCC Odieresis 2 ; PCC O 0 0 ; PCC dieresis 195 212 ;\nCC Og"
 & "rave 2 ; PCC O 0 0 ; PCC grave 195 212 ;\nCC Otilde 2 ; PCC O 0 0 ; PCC"
 & " tilde 195 212 ;\nCC Scaron 2 ; PCC S 0 0 ; PCC caron 112 212 ;\nCC Uac"
 & "ute 2 ; PCC U 0 0 ; PCC acute 195 212 ;\nCC Ucircumflex 2 ; PCC U 0 0 ;"
 & " PCC circumflex 195 212 ;\nCC Udieresis 2 ; PCC U 0 0 ; PCC dieresis 19"
 & "5 212 ;\nCC Ugrave 2 ; PCC U 0 0 ; PCC grave 195 212 ;\nCC Yacute 2 ; P"
 & "CC Y 0 0 ; PCC acute 195 212 ;\nCC Ydieresis 2 ; PCC Y 0 0 ; PCC dieres"
 & "is 195 212 ;\nCC Zcaron 2 ; PCC Z 0 0 ; PCC caron 139 212 ;\nCC aacute "
 & "2 ; PCC a 0 0 ; PCC acute 56 0 ;\nCC acircumflex 2 ; PCC a 0 0 ; PCC ci"
 & "rcumflex 56 0 ;\nCC adieresis 2 ; PCC a 0 0 ; PCC dieresis 56 0 ;\nCC a"
 & "grave 2 ; PCC a 0 0 ; PCC grave 56 0 ;\nCC aring 2 ; PCC a 0 0 ; PCC ri"
 & "ng 56 0 ;\nCC atilde 2 ; PCC a 0 0 ; PCC tilde 56 0 ;\nCC ccedilla 2 ; "
 & "PCC c 0 0 ; PCC cedilla 56 0 ;\nCC eacute 2 ; PCC e 0 0 ; PCC acute 56 "
 & "0 ;\nCC ecircumflex 2 ; PCC e 0 0 ; PCC circumflex 56 0 ;\nCC edieresis"
 & " 2 ; PCC e 0 0 ; PCC dieresis 56 0 ;\nCC egrave 2 ; PCC e 0 0 ; PCC gra"
 & "ve 56 0 ;\nCC iacute 2 ; PCC dotlessi 0 0 ; PCC acute -27 0 ;\nCC icirc"
 & "umflex 2 ; PCC dotlessi 0 0 ; PCC circumflex -27 0 ;\nCC idieresis 2 ; "
 & "PCC dotlessi 0 0 ; PCC dieresis -27 0 ;\nCC igrave 2 ; PCC dotlessi 0 0"
 & " ; PCC grave -27 0 ;\nCC ntilde 2 ; PCC n 0 0 ; PCC tilde 84 0 ;\nCC oa"
 & "cute 2 ; PCC o 0 0 ; PCC acute 84 0 ;\nCC ocircumflex 2 ; PCC o 0 0 ; P"
 & "CC circumflex 84 0 ;\nCC odieresis 2 ; PCC o 0 0 ; PCC dieresis 84 0 ;\n"
 & "CC ograve 2 ; PCC o 0 0 ; PCC grave 84 0 ;\nCC otilde 2 ; PCC o 0 0 ; P"
 & "CC tilde 84 0 ;\nCC scaron 2 ; PCC s 0 0 ; PCC caron 28 0 ;\nCC uacute "
 & "2 ; PCC u 0 0 ; PCC acute 84 0 ;\nCC ucircumflex 2 ; PCC u 0 0 ; PCC ci"
 & "rcumflex 84 0 ;\nCC udieresis 2 ; PCC u 0 0 ; PCC dieresis 84 0 ;\nCC u"
 & "grave 2 ; PCC u 0 0 ; PCC grave 84 0 ;\nCC yacute 2 ; PCC y 0 0 ; PCC a"
 & "cute 84 0 ;\nCC ydieresis 2 ; PCC y 0 0 ; PCC dieresis 84 0 ;\nCC zcaro"
 & "n 2 ; PCC z 0 0 ; PCC caron 56 0 ;\nEndComposites\nEndFontMetrics\n";

CONST E5 = 
   "StartFontMetrics 2.0\nComment Copyright (c) 1985, 1987, 1989, 1990 Adob"
 & "e Systems Incorporated.  All Rights Reserved.\nComment Creation Date: T"
 & "hu Mar 15 09:43:00 1990\nComment UniqueID 28357\nComment VMusage 26878 "
 & "33770\nFontName Helvetica-Bold\nFullName Helvetica Bold\nFamilyName Hel"
 & "vetica\nWeight Bold\nItalicAngle 0\nIsFixedPitch false\nFontBBox -170 -"
 & "228 1003 962\nUnderlinePosition -100\nUnderlineThickness 50\nVersion 00"
 & "1.007\nNotice Copyright (c) 1985, 1987, 1989, 1990 Adobe Systems Incorp"
 & "orated.  All Rights Reserved.Helvetica is a trademark of Linotype AG an"
 & "d/or its subsidiaries.\nEncodingScheme AdobeStandardEncoding\nCapHeight"
 & " 718\nXHeight 532\nAscender 718\nDescender -207\nStartCharMetrics 228\n"
 & "C 32 ; WX 278 ; N space ; B 0 0 0 0 ;\nC 33 ; WX 333 ; N exclam ; B 90 "
 & "0 244 718 ;\nC 34 ; WX 474 ; N quotedbl ; B 98 447 376 718 ;\nC 35 ; WX"
 & " 556 ; N numbersign ; B 18 0 538 698 ;\nC 36 ; WX 556 ; N dollar ; B 30"
 & " -115 523 775 ;\nC 37 ; WX 889 ; N percent ; B 28 -19 861 710 ;\nC 38 ;"
 & " WX 722 ; N ampersand ; B 54 -19 701 718 ;\nC 39 ; WX 278 ; N quoterigh"
 & "t ; B 69 445 209 718 ;\nC 40 ; WX 333 ; N parenleft ; B 35 -208 314 734"
 & " ;\nC 41 ; WX 333 ; N parenright ; B 19 -208 298 734 ;\nC 42 ; WX 389 ;"
 & " N asterisk ; B 27 387 362 718 ;\nC 43 ; WX 584 ; N plus ; B 40 0 544 5"
 & "06 ;\nC 44 ; WX 278 ; N comma ; B 64 -168 214 146 ;\nC 45 ; WX 333 ; N "
 & "hyphen ; B 27 215 306 345 ;\nC 46 ; WX 278 ; N period ; B 64 0 214 146 "
 & ";\nC 47 ; WX 278 ; N slash ; B -33 -19 311 737 ;\nC 48 ; WX 556 ; N zer"
 & "o ; B 32 -19 524 710 ;\nC 49 ; WX 556 ; N one ; B 69 0 378 710 ;\nC 50 "
 & "; WX 556 ; N two ; B 26 0 511 710 ;\nC 51 ; WX 556 ; N three ; B 27 -19"
 & " 516 710 ;\nC 52 ; WX 556 ; N four ; B 27 0 526 710 ;\nC 53 ; WX 556 ; "
 & "N five ; B 27 -19 516 698 ;\nC 54 ; WX 556 ; N six ; B 31 -19 520 710 ;"
 & "\nC 55 ; WX 556 ; N seven ; B 25 0 528 698 ;\nC 56 ; WX 556 ; N eight ;"
 & " B 32 -19 524 710 ;\nC 57 ; WX 556 ; N nine ; B 30 -19 522 710 ;\nC 58 "
 & "; WX 333 ; N colon ; B 92 0 242 512 ;\nC 59 ; WX 333 ; N semicolon ; B "
 & "92 -168 242 512 ;\nC 60 ; WX 584 ; N less ; B 38 -8 546 514 ;\n";

CONST E5_0 = 
   "C 61 ; WX 584 ; N equal ; B 40 87 544 419 ;\nC 62 ; WX 584 ; N greater "
 & "; B 38 -8 546 514 ;\nC 63 ; WX 611 ; N question ; B 60 0 556 727 ;\nC 6"
 & "4 ; WX 975 ; N at ; B 118 -19 856 737 ;\nC 65 ; WX 722 ; N A ; B 20 0 7"
 & "02 718 ;\nC 66 ; WX 722 ; N B ; B 76 0 669 718 ;\nC 67 ; WX 722 ; N C ;"
 & " B 44 -19 684 737 ;\nC 68 ; WX 722 ; N D ; B 76 0 685 718 ;\nC 69 ; WX "
 & "667 ; N E ; B 76 0 621 718 ;\nC 70 ; WX 611 ; N F ; B 76 0 587 718 ;\nC"
 & " 71 ; WX 778 ; N G ; B 44 -19 713 737 ;\nC 72 ; WX 722 ; N H ; B 71 0 6"
 & "51 718 ;\nC 73 ; WX 278 ; N I ; B 64 0 214 718 ;\nC 74 ; WX 556 ; N J ;"
 & " B 22 -18 484 718 ;\nC 75 ; WX 722 ; N K ; B 87 0 722 718 ;\nC 76 ; WX "
 & "611 ; N L ; B 76 0 583 718 ;\nC 77 ; WX 833 ; N M ; B 69 0 765 718 ;\nC"
 & " 78 ; WX 722 ; N N ; B 69 0 654 718 ;\nC 79 ; WX 778 ; N O ; B 44 -19 7"
 & "34 737 ;\nC 80 ; WX 667 ; N P ; B 76 0 627 718 ;\nC 81 ; WX 778 ; N Q ;"
 & " B 44 -52 737 737 ;\nC 82 ; WX 722 ; N R ; B 76 0 677 718 ;\nC 83 ; WX "
 & "667 ; N S ; B 39 -19 629 737 ;\nC 84 ; WX 611 ; N T ; B 14 0 598 718 ;\n"
 & "C 85 ; WX 722 ; N U ; B 72 -19 651 718 ;\nC 86 ; WX 667 ; N V ; B 19 0 "
 & "648 718 ;\nC 87 ; WX 944 ; N W ; B 16 0 929 718 ;\nC 88 ; WX 667 ; N X "
 & "; B 14 0 653 718 ;\nC 89 ; WX 667 ; N Y ; B 15 0 653 718 ;\nC 90 ; WX 6"
 & "11 ; N Z ; B 25 0 586 718 ;\nC 91 ; WX 333 ; N bracketleft ; B 63 -196 "
 & "309 722 ;\nC 92 ; WX 278 ; N backslash ; B -33 -19 311 737 ;\nC 93 ; WX"
 & " 333 ; N bracketright ; B 24 -196 270 722 ;\nC 94 ; WX 584 ; N asciicir"
 & "cum ; B 62 323 522 698 ;\nC 95 ; WX 556 ; N underscore ; B 0 -125 556 -"
 & "75 ;\nC 96 ; WX 278 ; N quoteleft ; B 69 454 209 727 ;\nC 97 ; WX 556 ;"
 & " N a ; B 29 -14 527 546 ;\nC 98 ; WX 611 ; N b ; B 61 -14 578 718 ;\nC "
 & "99 ; WX 556 ; N c ; B 34 -14 524 546 ;\nC 100 ; WX 611 ; N d ; B 34 -14"
 & " 551 718 ;\nC 101 ; WX 556 ; N e ; B 23 -14 528 546 ;\nC 102 ; WX 333 ;"
 & " N f ; B 10 0 318 727 ; L i fi ; L l fl ;\nC 103 ; WX 611 ; N g ; B 40 "
 & "-217 553 546 ;\nC 104 ; WX 611 ; N h ; B 65 0 546 718 ;\nC 105 ; WX 278"
 & " ; N i ; B 69 0 209 725 ;\nC 106 ; WX 278 ; N j ; B 3 -214 209 725 ;\nC"
 & " 107 ; WX 556 ; N k ; B 69 0 562 718 ;\nC 108 ; WX 278 ; N";

CONST E5_1 = 
   " l ; B 69 0 209 718 ;\nC 109 ; WX 889 ; N m ; B 64 0 826 546 ;\nC 110 ;"
 & " WX 611 ; N n ; B 65 0 546 546 ;\nC 111 ; WX 611 ; N o ; B 34 -14 578 5"
 & "46 ;\nC 112 ; WX 611 ; N p ; B 62 -207 578 546 ;\nC 113 ; WX 611 ; N q "
 & "; B 34 -207 552 546 ;\nC 114 ; WX 389 ; N r ; B 64 0 373 546 ;\nC 115 ;"
 & " WX 556 ; N s ; B 30 -14 519 546 ;\nC 116 ; WX 333 ; N t ; B 10 -6 309 "
 & "676 ;\nC 117 ; WX 611 ; N u ; B 66 -14 545 532 ;\nC 118 ; WX 556 ; N v "
 & "; B 13 0 543 532 ;\nC 119 ; WX 778 ; N w ; B 10 0 769 532 ;\nC 120 ; WX"
 & " 556 ; N x ; B 15 0 541 532 ;\nC 121 ; WX 556 ; N y ; B 10 -214 539 532"
 & " ;\nC 122 ; WX 500 ; N z ; B 20 0 480 532 ;\nC 123 ; WX 389 ; N bracele"
 & "ft ; B 48 -196 365 722 ;\nC 124 ; WX 280 ; N bar ; B 84 -19 196 737 ;\n"
 & "C 125 ; WX 389 ; N braceright ; B 24 -196 341 722 ;\nC 126 ; WX 584 ; N"
 & " asciitilde ; B 61 163 523 343 ;\nC 161 ; WX 333 ; N exclamdown ; B 90 "
 & "-186 244 532 ;\nC 162 ; WX 556 ; N cent ; B 34 -118 524 628 ;\nC 163 ; "
 & "WX 556 ; N sterling ; B 28 -16 541 718 ;\nC 164 ; WX 167 ; N fraction ;"
 & " B -170 -19 336 710 ;\nC 165 ; WX 556 ; N yen ; B -9 0 565 698 ;\nC 166"
 & " ; WX 556 ; N florin ; B -10 -210 516 737 ;\nC 167 ; WX 556 ; N section"
 & " ; B 34 -184 522 727 ;\nC 168 ; WX 556 ; N currency ; B -3 76 559 636 ;"
 & "\nC 169 ; WX 238 ; N quotesingle ; B 70 447 168 718 ;\nC 170 ; WX 500 ;"
 & " N quotedblleft ; B 64 454 436 727 ;\nC 171 ; WX 556 ; N guillemotleft "
 & "; B 88 76 468 484 ;\nC 172 ; WX 333 ; N guilsinglleft ; B 83 76 250 484"
 & " ;\nC 173 ; WX 333 ; N guilsinglright ; B 83 76 250 484 ;\nC 174 ; WX 6"
 & "11 ; N fi ; B 10 0 542 727 ;\nC 175 ; WX 611 ; N fl ; B 10 0 542 727 ;\n"
 & "C 177 ; WX 556 ; N endash ; B 0 227 556 333 ;\nC 178 ; WX 556 ; N dagge"
 & "r ; B 36 -171 520 718 ;\nC 179 ; WX 556 ; N daggerdbl ; B 36 -171 520 7"
 & "18 ;\nC 180 ; WX 278 ; N periodcentered ; B 58 172 220 334 ;\nC 182 ; W"
 & "X 556 ; N paragraph ; B -8 -191 539 700 ;\nC 183 ; WX 350 ; N bullet ; "
 & "B 10 194 340 524 ;\nC 184 ; WX 278 ; N quotesinglbase ; B 69 -146 209 1"
 & "27 ;\nC 185 ; WX 500 ; N quotedblbase ; B 64 -146 436 127 ;\nC 186 ; WX"
 & " 500 ; N quotedblright ; B 64 445 436 718 ;\nC 187 ; W";

CONST E5_2 = 
   "X 556 ; N guillemotright ; B 88 76 468 484 ;\nC 188 ; WX 1000 ; N ellip"
 & "sis ; B 92 0 908 146 ;\nC 189 ; WX 1000 ; N perthousand ; B -3 -19 1003"
 & " 710 ;\nC 191 ; WX 611 ; N questiondown ; B 55 -195 551 532 ;\nC 193 ; "
 & "WX 333 ; N grave ; B -23 604 225 750 ;\nC 194 ; WX 333 ; N acute ; B 10"
 & "8 604 356 750 ;\nC 195 ; WX 333 ; N circumflex ; B -10 604 343 750 ;\nC"
 & " 196 ; WX 333 ; N tilde ; B -17 610 350 737 ;\nC 197 ; WX 333 ; N macro"
 & "n ; B -6 604 339 678 ;\nC 198 ; WX 333 ; N breve ; B -2 604 335 750 ;\n"
 & "C 199 ; WX 333 ; N dotaccent ; B 104 614 230 729 ;\nC 200 ; WX 333 ; N "
 & "dieresis ; B 6 614 327 729 ;\nC 202 ; WX 333 ; N ring ; B 59 568 275 77"
 & "6 ;\nC 203 ; WX 333 ; N cedilla ; B 6 -228 245 0 ;\nC 205 ; WX 333 ; N "
 & "hungarumlaut ; B 9 604 486 750 ;\nC 206 ; WX 333 ; N ogonek ; B 71 -228"
 & " 304 0 ;\nC 207 ; WX 333 ; N caron ; B -10 604 343 750 ;\nC 208 ; WX 10"
 & "00 ; N emdash ; B 0 227 1000 333 ;\nC 225 ; WX 1000 ; N AE ; B 5 0 954 "
 & "718 ;\nC 227 ; WX 370 ; N ordfeminine ; B 22 276 347 737 ;\nC 232 ; WX "
 & "611 ; N Lslash ; B -20 0 583 718 ;\nC 233 ; WX 778 ; N Oslash ; B 33 -2"
 & "7 744 745 ;\nC 234 ; WX 1000 ; N OE ; B 37 -19 961 737 ;\nC 235 ; WX 36"
 & "5 ; N ordmasculine ; B 6 276 360 737 ;\nC 241 ; WX 889 ; N ae ; B 29 -1"
 & "4 858 546 ;\nC 245 ; WX 278 ; N dotlessi ; B 69 0 209 532 ;\nC 248 ; WX"
 & " 278 ; N lslash ; B -18 0 296 718 ;\nC 249 ; WX 611 ; N oslash ; B 22 -"
 & "29 589 560 ;\nC 250 ; WX 944 ; N oe ; B 34 -14 912 546 ;\nC 251 ; WX 61"
 & "1 ; N germandbls ; B 69 -14 579 731 ;\nC -1 ; WX 611 ; N Zcaron ; B 25 "
 & "0 586 936 ;\nC -1 ; WX 556 ; N ccedilla ; B 34 -228 524 546 ;\nC -1 ; W"
 & "X 556 ; N ydieresis ; B 10 -214 539 729 ;\nC -1 ; WX 556 ; N atilde ; B"
 & " 29 -14 527 737 ;\nC -1 ; WX 278 ; N icircumflex ; B -37 0 316 750 ;\nC"
 & " -1 ; WX 333 ; N threesuperior ; B 8 271 326 710 ;\nC -1 ; WX 556 ; N e"
 & "circumflex ; B 23 -14 528 750 ;\nC -1 ; WX 611 ; N thorn ; B 62 -208 57"
 & "8 718 ;\nC -1 ; WX 556 ; N egrave ; B 23 -14 528 750 ;\nC -1 ; WX 333 ;"
 & " N twosuperior ; B 9 283 324 710 ;\nC -1 ; WX 556 ; N eacute ; B 23 -14"
 & " 528 750 ;\nC -1 ; WX 611 ; N otilde ; B 34 -14 578 7";

CONST E5_3 = 
   "37 ;\nC -1 ; WX 722 ; N Aacute ; B 20 0 702 936 ;\nC -1 ; WX 611 ; N oc"
 & "ircumflex ; B 34 -14 578 750 ;\nC -1 ; WX 556 ; N yacute ; B 10 -214 53"
 & "9 750 ;\nC -1 ; WX 611 ; N udieresis ; B 66 -14 545 729 ;\nC -1 ; WX 83"
 & "4 ; N threequarters ; B 16 -19 799 710 ;\nC -1 ; WX 556 ; N acircumflex"
 & " ; B 29 -14 527 750 ;\nC -1 ; WX 722 ; N Eth ; B -5 0 685 718 ;\nC -1 ;"
 & " WX 556 ; N edieresis ; B 23 -14 528 729 ;\nC -1 ; WX 611 ; N ugrave ; "
 & "B 66 -14 545 750 ;\nC -1 ; WX 1000 ; N trademark ; B 44 306 956 718 ;\n"
 & "C -1 ; WX 611 ; N ograve ; B 34 -14 578 750 ;\nC -1 ; WX 556 ; N scaron"
 & " ; B 30 -14 519 750 ;\nC -1 ; WX 278 ; N Idieresis ; B -21 0 300 915 ;\n"
 & "C -1 ; WX 611 ; N uacute ; B 66 -14 545 750 ;\nC -1 ; WX 556 ; N agrave"
 & " ; B 29 -14 527 750 ;\nC -1 ; WX 611 ; N ntilde ; B 65 0 546 737 ;\nC -"
 & "1 ; WX 556 ; N aring ; B 29 -14 527 776 ;\nC -1 ; WX 500 ; N zcaron ; B"
 & " 20 0 480 750 ;\nC -1 ; WX 278 ; N Icircumflex ; B -37 0 316 936 ;\nC -"
 & "1 ; WX 722 ; N Ntilde ; B 69 0 654 923 ;\nC -1 ; WX 611 ; N ucircumflex"
 & " ; B 66 -14 545 750 ;\nC -1 ; WX 667 ; N Ecircumflex ; B 76 0 621 936 ;"
 & "\nC -1 ; WX 278 ; N Iacute ; B 64 0 329 936 ;\nC -1 ; WX 722 ; N Ccedil"
 & "la ; B 44 -228 684 737 ;\nC -1 ; WX 778 ; N Odieresis ; B 44 -19 734 91"
 & "5 ;\nC -1 ; WX 667 ; N Scaron ; B 39 -19 629 936 ;\nC -1 ; WX 667 ; N E"
 & "dieresis ; B 76 0 621 915 ;\nC -1 ; WX 278 ; N Igrave ; B -50 0 214 936"
 & " ;\nC -1 ; WX 556 ; N adieresis ; B 29 -14 527 729 ;\nC -1 ; WX 778 ; N"
 & " Ograve ; B 44 -19 734 936 ;\nC -1 ; WX 667 ; N Egrave ; B 76 0 621 936"
 & " ;\nC -1 ; WX 667 ; N Ydieresis ; B 15 0 653 915 ;\nC -1 ; WX 737 ; N r"
 & "egistered ; B -11 -19 748 737 ;\nC -1 ; WX 778 ; N Otilde ; B 44 -19 73"
 & "4 923 ;\nC -1 ; WX 834 ; N onequarter ; B 26 -19 766 710 ;\nC -1 ; WX 7"
 & "22 ; N Ugrave ; B 72 -19 651 936 ;\nC -1 ; WX 722 ; N Ucircumflex ; B 7"
 & "2 -19 651 936 ;\nC -1 ; WX 667 ; N Thorn ; B 76 0 627 718 ;\nC -1 ; WX "
 & "584 ; N divide ; B 40 -42 544 548 ;\nC -1 ; WX 722 ; N Atilde ; B 20 0 "
 & "702 923 ;\nC -1 ; WX 722 ; N Uacute ; B 72 -19 651 936 ;\nC -1 ; WX 778"
 & " ; N Ocircumflex ; B 44 -19 734 936 ;\nC -1 ; WX 584 ;";

CONST E5_4 = 
   " N logicalnot ; B 40 108 544 419 ;\nC -1 ; WX 722 ; N Aring ; B 20 0 70"
 & "2 962 ;\nC -1 ; WX 278 ; N idieresis ; B -21 0 300 729 ;\nC -1 ; WX 278"
 & " ; N iacute ; B 69 0 329 750 ;\nC -1 ; WX 556 ; N aacute ; B 29 -14 527"
 & " 750 ;\nC -1 ; WX 584 ; N plusminus ; B 40 0 544 506 ;\nC -1 ; WX 584 ;"
 & " N multiply ; B 40 1 545 505 ;\nC -1 ; WX 722 ; N Udieresis ; B 72 -19 "
 & "651 915 ;\nC -1 ; WX 584 ; N minus ; B 40 197 544 309 ;\nC -1 ; WX 333 "
 & "; N onesuperior ; B 26 283 237 710 ;\nC -1 ; WX 667 ; N Eacute ; B 76 0"
 & " 621 936 ;\nC -1 ; WX 722 ; N Acircumflex ; B 20 0 702 936 ;\nC -1 ; WX"
 & " 737 ; N copyright ; B -11 -19 749 737 ;\nC -1 ; WX 722 ; N Agrave ; B "
 & "20 0 702 936 ;\nC -1 ; WX 611 ; N odieresis ; B 34 -14 578 729 ;\nC -1 "
 & "; WX 611 ; N oacute ; B 34 -14 578 750 ;\nC -1 ; WX 400 ; N degree ; B "
 & "57 426 343 712 ;\nC -1 ; WX 278 ; N igrave ; B -50 0 209 750 ;\nC -1 ; "
 & "WX 611 ; N mu ; B 66 -207 545 532 ;\nC -1 ; WX 778 ; N Oacute ; B 44 -1"
 & "9 734 936 ;\nC -1 ; WX 611 ; N eth ; B 34 -14 578 737 ;\nC -1 ; WX 722 "
 & "; N Adieresis ; B 20 0 702 915 ;\nC -1 ; WX 667 ; N Yacute ; B 15 0 653"
 & " 936 ;\nC -1 ; WX 280 ; N brokenbar ; B 84 -19 196 737 ;\nC -1 ; WX 834"
 & " ; N onehalf ; B 26 -19 794 710 ;\nEndCharMetrics\nStartKernData\nStart"
 & "KernPairs 209\n\nKPX A y -30\nKPX A w -30\nKPX A v -40\nKPX A u -30\nKP"
 & "X A Y -110\nKPX A W -60\nKPX A V -80\nKPX A U -50\nKPX A T -90\nKPX A Q"
 & " -40\nKPX A O -40\nKPX A G -50\nKPX A C -40\n\nKPX B U -10\nKPX B A -30"
 & "\n\nKPX D period -30\nKPX D comma -30\nKPX D Y -70\nKPX D W -40\nKPX D "
 & "V -40\nKPX D A -40\n\nKPX F period -100\nKPX F comma -100\nKPX F a -20\n"
 & "KPX F A -80\n\nKPX J u -20\nKPX J period -20\nKPX J comma -20\nKPX J A "
 & "-20\n\nKPX K y -40\nKPX K u -30\nKPX K o -35\nKPX K e -15\nKPX K O -30\n"
 & "\nKPX L y -30\nKPX L quoteright -140\nKPX L quotedblright -140\nKPX L Y"
 & " -120\nKPX L W -80\nKPX L V -110\nKPX L T -90\n\nKPX O period -40\nKPX "
 & "O comma -40\nKPX O Y -70\nKPX O X -50\nKPX O W -50\nKPX O V -50\nKPX O "
 & "T -40\nKPX O A -50\n\nKPX P period -120\nKPX P o -40\nKPX P e -30\nKPX "
 & "P comma -120\nKPX P a -30\nKPX P A -100\n\nKPX Q period 20\nKPX Q comma"
 & " 20\nKPX Q U -10\n\nKPX R Y -50\nKPX ";

CONST E5_5 = 
   "R W -40\nKPX R V -50\nKPX R U -20\nKPX R T -20\nKPX R O -20\n\nKPX T y "
 & "-60\nKPX T w -60\nKPX T u -90\nKPX T semicolon -40\nKPX T r -80\nKPX T "
 & "period -80\nKPX T o -80\nKPX T hyphen -120\nKPX T e -60\nKPX T comma -8"
 & "0\nKPX T colon -40\nKPX T a -80\nKPX T O -40\nKPX T A -90\n\nKPX U peri"
 & "od -30\nKPX U comma -30\nKPX U A -50\n\nKPX V u -60\nKPX V semicolon -4"
 & "0\nKPX V period -120\nKPX V o -90\nKPX V hyphen -80\nKPX V e -50\nKPX V"
 & " comma -120\nKPX V colon -40\nKPX V a -60\nKPX V O -50\nKPX V G -50\nKP"
 & "X V A -80\n\nKPX W y -20\nKPX W u -45\nKPX W semicolon -10\nKPX W perio"
 & "d -80\nKPX W o -60\nKPX W hyphen -40\nKPX W e -35\nKPX W comma -80\nKPX"
 & " W colon -10\nKPX W a -40\nKPX W O -20\nKPX W A -60\n\nKPX Y u -100\nKP"
 & "X Y semicolon -50\nKPX Y period -100\nKPX Y o -100\nKPX Y e -80\nKPX Y "
 & "comma -100\nKPX Y colon -50\nKPX Y a -90\nKPX Y O -70\nKPX Y A -110\n\n"
 & "KPX a y -20\nKPX a w -15\nKPX a v -15\nKPX a g -10\n\nKPX b y -20\nKPX "
 & "b v -20\nKPX b u -20\nKPX b l -10\n\nKPX c y -10\nKPX c l -20\nKPX c k "
 & "-20\nKPX c h -10\n\nKPX colon space -40\n\nKPX comma space -40\nKPX com"
 & "ma quoteright -120\nKPX comma quotedblright -120\n\nKPX d y -15\nKPX d "
 & "w -15\nKPX d v -15\nKPX d d -10\n\nKPX e y -15\nKPX e x -15\nKPX e w -1"
 & "5\nKPX e v -15\nKPX e period 20\nKPX e comma 10\n\nKPX f quoteright 30\n"
 & "KPX f quotedblright 30\nKPX f period -10\nKPX f o -20\nKPX f e -10\nKPX"
 & " f comma -10\n\nKPX g g -10\nKPX g e 10\n\nKPX h y -20\n\nKPX k o -15\n"
 & "\nKPX l y -15\nKPX l w -15\n\nKPX m y -30\nKPX m u -20\n\nKPX n y -20\n"
 & "KPX n v -40\nKPX n u -10\n\nKPX o y -20\nKPX o x -30\nKPX o w -15\nKPX "
 & "o v -20\n\nKPX p y -15\n\nKPX period space -40\nKPX period quoteright -"
 & "120\nKPX period quotedblright -120\n\nKPX quotedblright space -80\n\nKP"
 & "X quoteleft quoteleft -46\n\nKPX quoteright v -20\nKPX quoteright space"
 & " -80\nKPX quoteright s -60\nKPX quoteright r -40\nKPX quoteright quoter"
 & "ight -46\nKPX quoteright l -20\nKPX quoteright d -80\n\nKPX r y 10\nKPX"
 & " r v 10\nKPX r t 20\nKPX r s -15\nKPX r q -20\nKPX r period -60\nKPX r "
 & "o -20\nKPX r hyphen -20\nKPX r g -15\nKPX r d -20\nKPX r comma -60\nKPX"
 & " r c -20\n\nKPX s w -15\n\nKPX semicolon space -40\n\nKPX space quotele"
 & "ft -60\nKPX space quotedbllef";

CONST E5_6 = 
   "t -80\nKPX space Y -120\nKPX space W -80\nKPX space V -80\nKPX space T "
 & "-100\n\nKPX v period -80\nKPX v o -30\nKPX v comma -80\nKPX v a -20\n\n"
 & "KPX w period -40\nKPX w o -20\nKPX w comma -40\n\nKPX x e -10\n\nKPX y "
 & "period -80\nKPX y o -25\nKPX y e -10\nKPX y comma -80\nKPX y a -30\n\nK"
 & "PX z e 10\nEndKernPairs\nEndKernData\nStartComposites 58\nCC Aacute 2 ;"
 & " PCC A 0 0 ; PCC acute 195 186 ;\nCC Acircumflex 2 ; PCC A 0 0 ; PCC ci"
 & "rcumflex 195 186 ;\nCC Adieresis 2 ; PCC A 0 0 ; PCC dieresis 195 186 ;"
 & "\nCC Agrave 2 ; PCC A 0 0 ; PCC grave 195 186 ;\nCC Aring 2 ; PCC A 0 0"
 & " ; PCC ring 195 186 ;\nCC Atilde 2 ; PCC A 0 0 ; PCC tilde 195 186 ;\nC"
 & "C Ccedilla 2 ; PCC C 0 0 ; PCC cedilla 215 0 ;\nCC Eacute 2 ; PCC E 0 0"
 & " ; PCC acute 167 186 ;\nCC Ecircumflex 2 ; PCC E 0 0 ; PCC circumflex 1"
 & "67 186 ;\nCC Edieresis 2 ; PCC E 0 0 ; PCC dieresis 167 186 ;\nCC Egrav"
 & "e 2 ; PCC E 0 0 ; PCC grave 167 186 ;\nCC Iacute 2 ; PCC I 0 0 ; PCC ac"
 & "ute -27 186 ;\nCC Icircumflex 2 ; PCC I 0 0 ; PCC circumflex -27 186 ;\n"
 & "CC Idieresis 2 ; PCC I 0 0 ; PCC dieresis -27 186 ;\nCC Igrave 2 ; PCC "
 & "I 0 0 ; PCC grave -27 186 ;\nCC Ntilde 2 ; PCC N 0 0 ; PCC tilde 195 18"
 & "6 ;\nCC Oacute 2 ; PCC O 0 0 ; PCC acute 223 186 ;\nCC Ocircumflex 2 ; "
 & "PCC O 0 0 ; PCC circumflex 223 186 ;\nCC Odieresis 2 ; PCC O 0 0 ; PCC "
 & "dieresis 223 186 ;\nCC Ograve 2 ; PCC O 0 0 ; PCC grave 223 186 ;\nCC O"
 & "tilde 2 ; PCC O 0 0 ; PCC tilde 223 186 ;\nCC Scaron 2 ; PCC S 0 0 ; PC"
 & "C caron 167 186 ;\nCC Uacute 2 ; PCC U 0 0 ; PCC acute 195 186 ;\nCC Uc"
 & "ircumflex 2 ; PCC U 0 0 ; PCC circumflex 195 186 ;\nCC Udieresis 2 ; PC"
 & "C U 0 0 ; PCC dieresis 195 186 ;\nCC Ugrave 2 ; PCC U 0 0 ; PCC grave 1"
 & "95 186 ;\nCC Yacute 2 ; PCC Y 0 0 ; PCC acute 167 186 ;\nCC Ydieresis 2"
 & " ; PCC Y 0 0 ; PCC dieresis 167 186 ;\nCC Zcaron 2 ; PCC Z 0 0 ; PCC ca"
 & "ron 139 186 ;\nCC aacute 2 ; PCC a 0 0 ; PCC acute 112 0 ;\nCC acircumf"
 & "lex 2 ; PCC a 0 0 ; PCC circumflex 112 0 ;\nCC adieresis 2 ; PCC a 0 0 "
 & "; PCC dieresis 112 0 ;\nCC agrave 2 ; PCC a 0 0 ; PCC grave 112 0 ;\nCC"
 & " aring 2 ; PCC a 0 0 ; PCC ring 112 0 ;\nCC atilde 2 ; PCC a 0 0 ; PCC "
 & "t";

CONST E5_7 = 
   "ilde 112 0 ;\nCC ccedilla 2 ; PCC c 0 0 ; PCC cedilla 132 0 ;\nCC eacut"
 & "e 2 ; PCC e 0 0 ; PCC acute 112 0 ;\nCC ecircumflex 2 ; PCC e 0 0 ; PCC"
 & " circumflex 112 0 ;\nCC edieresis 2 ; PCC e 0 0 ; PCC dieresis 112 0 ;\n"
 & "CC egrave 2 ; PCC e 0 0 ; PCC grave 112 0 ;\nCC iacute 2 ; PCC dotlessi"
 & " 0 0 ; PCC acute -27 0 ;\nCC icircumflex 2 ; PCC dotlessi 0 0 ; PCC cir"
 & "cumflex -27 0 ;\nCC idieresis 2 ; PCC dotlessi 0 0 ; PCC dieresis -27 0"
 & " ;\nCC igrave 2 ; PCC dotlessi 0 0 ; PCC grave -27 0 ;\nCC ntilde 2 ; P"
 & "CC n 0 0 ; PCC tilde 139 0 ;\nCC oacute 2 ; PCC o 0 0 ; PCC acute 139 0"
 & " ;\nCC ocircumflex 2 ; PCC o 0 0 ; PCC circumflex 139 0 ;\nCC odieresis"
 & " 2 ; PCC o 0 0 ; PCC dieresis 139 0 ;\nCC ograve 2 ; PCC o 0 0 ; PCC gr"
 & "ave 139 0 ;\nCC otilde 2 ; PCC o 0 0 ; PCC tilde 139 0 ;\nCC scaron 2 ;"
 & " PCC s 0 0 ; PCC caron 112 0 ;\nCC uacute 2 ; PCC u 0 0 ; PCC acute 139"
 & " 0 ;\nCC ucircumflex 2 ; PCC u 0 0 ; PCC circumflex 139 0 ;\nCC udieres"
 & "is 2 ; PCC u 0 0 ; PCC dieresis 139 0 ;\nCC ugrave 2 ; PCC u 0 0 ; PCC "
 & "grave 139 0 ;\nCC yacute 2 ; PCC y 0 0 ; PCC acute 112 0 ;\nCC ydieresi"
 & "s 2 ; PCC y 0 0 ; PCC dieresis 112 0 ;\nCC zcaron 2 ; PCC z 0 0 ; PCC c"
 & "aron 84 0 ;\nEndComposites\nEndFontMetrics\n";

CONST E6 = 
   "# Last modified on Wed Dec 21 11:16:22 PST 1994 by heydon\n#\n# This fi"
 & "le maps character names to their octal codes for the\n# PostScript stan"
 & "dard encoding. See section E.5 of the \"PostScript\n# Language Referenc"
 & "e Manual\", 2nd Edition, pp 596-597.\n\n# Names mapped to negative valu"
 & "es are unencoded in ISOLatin1. Those\n# mapped to -1 are listed in appe"
 & "ndix E; those mapped to -2 are not\n# listed in appendix E, but appear "
 & "in the metric files for Courier.\n\nA\t\t101\nAE\t\t341\nAacute\t\t -1\n"
 & "Acircumflex\t -1\nAdieresis\t -1\nAgrave\t\t -1\nAring\t\t -1\nAtilde\t"
 & "\t -1\nB\t\t102\nC\t\t103\nCcedilla\t -1\nD\t\t104\nE\t\t105\nEacute\t\t"
 & " -1\nEcircumflex\t -1\nEdieresis\t -1\nEgrave\t\t -1\nEth\t\t -1\nF\t\t"
 & "106\nG\t\t107\nGcaron\t\t -2\nH\t\t110\nI\t\t111\nIJ\t\t -2\nIacute\t\t"
 & " -1\nIcircumflex\t -1\nIdieresis\t -1\nIdot\t\t -2\nIgrave\t\t -1\nJ\t\t"
 & "112\nK\t\t113\nL\t\t114\nLL\t\t -2\nLslash\t\t350\nM\t\t115\nN\t\t116\n"
 & "Ntilde\t\t -1\nO\t\t117\nOE\t\t352\nOacute\t\t -1\nOcircumflex\t -1\nOd"
 & "ieresis\t -1\nOgrave\t\t -1\nOslash\t\t351\nOtilde\t\t -1\nP\t\t120\nQ\t"
 & "\t121\nR\t\t122\nS\t\t123\nScaron\t\t -1\nScedilla\t -2\nT\t\t124\nThor"
 & "n\t\t -1\nU\t\t125\nUacute\t\t -1\nUcircumflex\t -1\nUdieresis\t -1\nUg"
 & "rave\t\t -1\nV\t\t126\nW\t\t127\nX\t\t130\nY\t\t131\nYacute\t\t -1\nYdi"
 & "eresis\t -1\nZ\t\t132\nZcaron\t\t -1\na\t\t141\naacute\t\t -1\nacircumf"
 & "lex\t -1\nacute\t\t302\nadieresis\t -1\nae\t\t361\nagrave\t\t -1\namper"
 & "sand\t046\naring\t\t -1\narrowboth\t -2\narrowdown\t -2\narrowleft\t -2"
 & "\narrowright\t -2\narrowup\t\t -2\nasciicircum\t136\nasciitilde\t176\na"
 & "sterisk\t052\nat\t\t100\natilde\t\t -1\nb\t\t142\nbackslash\t134\nbar\t"
 & "\t174\nbraceleft\t173\nbraceright\t175\nbracketleft\t133\nbracketright\t"
 & "135\nbreve\t\t306\nbrokenbar\t -1\nbullet\t\t267\nc\t\t143\ncaron\t\t31"
 & "7\nccedilla\t -1\ncedilla\t\t313\ncent\t\t242\ncircumflex\t303\ncolon\t"
 & "\t072\ncomma\t\t054\ncopyright\t -1\ncurrency\t250\nd\t\t144\ndagger\t\t"
 & "262\ndaggerdbl\t263\ndectab\t\t -2\ndieresis\t310\ndivide\t\t -1\ndolla"
 & "r\t\t044\ndotaccent\t307\ndotlessi\t365\ndown\t\t -2\ne\t\t145\neacute\t"
 & "\t -1\necircumflex\t -1\nedieresis\t -1\negrave\t\t -1\neight\t\t070\ne"
 & "llipsis\t274\nemdash\t\t320\nendash\t\t261\nequal\t\t075\neth\t\t -1\ne"
 & "xclam\t\t041\nexclamdown\t241\nf\t\t146\nfi\t\t256\nfive\t\t065\nfl\t\t"
 & "257\nflorin\t\t246\nformat\t\t -2\nfour\t\t064\nfraction\t244\ng\t\t147"
 & "\ngcaron\t\t -2\ngermandbls\t373\ngr";

CONST E6_0 = 
   "ave\t\t301\ngraybox\t\t -2\ngreater\t\t076\nguillemotleft\t253\nguillem"
 & "otright\t273\nguilsinglleft\t254\nguilsinglright\t255\nh\t\t150\nhungar"
 & "umlaut\t315\nhyphen\t\t055\ni\t\t151\niacute\t\t -1\nicircumflex\t -1\n"
 & "idieresis\t -1\nigrave\t\t -1\nij\t\t -2\nindent\t\t -2\nj\t\t152\nk\t\t"
 & "153\nl\t\t154\nlargebullet\t -2\nleft\t\t -2\nless\t\t074\nlira\t\t -2\n"
 & "ll\t\t -2\nlogicalnot\t -1\nlslash\t\t370\nm\t\t155\nmacron\t\t305\nmer"
 & "ge\t\t -2\nminus\t\t -1\nmu\t\t -1\nmultiply\t -1\nn\t\t156\nnine\t\t07"
 & "1\nnotegraphic\t -2\nnumbersign\t043\no\t\t157\noacute\t\t -1\nocircumf"
 & "lex\t -1\nodieresis\t -1\noe\t\t372\nogonek\t\t316\nograve\t\t -1\none\t"
 & "\t061\nonehalf\t\t -1\nonequarter\t -1\nonesuperior\t -1\nordfeminine\t"
 & "343\nordmasculine\t353\noslash\t\t371\notilde\t\t -1\noverscore\t -2\np"
 & "\t\t160\nparagraph\t266\nparenleft\t050\nparenright\t051\npercent\t\t04"
 & "5\nperiod\t\t056\nperiodcentered\t264\nperthousand\t275\nplus\t\t053\np"
 & "lusminus\t -1\nprescription\t -2\nq\t\t161\nquestion\t077\nquestiondown"
 & "\t277\nquotedbl\t042\nquotedblbase\t271\nquotedblleft\t252\nquotedblrig"
 & "ht\t272\nquoteleft\t140\nquoteright\t047\nquotesinglbase\t270\nquotesin"
 & "gle\t251\nr\t\t162\nregistered\t -1\nreturn\t\t -2\nring\t\t312\ns\t\t1"
 & "63\nscaron\t\t -1\nscedilla\t -2\nsection\t\t247\nsemicolon\t073\nseven"
 & "\t\t067\nsix\t\t066\nslash\t\t057\nspace\t\t040\nsquare\t\t -2\nsterlin"
 & "g\t243\nstop\t\t -2\nt\t\t164\ntab\t\t -2\nthorn\t\t -1\nthree\t\t063\n"
 & "threequarters\t -1\nthreesuperior\t -1\ntilde\t\t304\ntrademark\t -1\nt"
 & "wo\t\t062\ntwosuperior\t -1\nu\t\t165\nuacute\t\t -1\nucircumflex\t -1\n"
 & "udieresis\t -1\nugrave\t\t -1\nunderscore\t137\nup\t\t -2\nv\t\t166\nw\t"
 & "\t167\nx\t\t170\ny\t\t171\nyacute\t\t -1\nydieresis\t -1\nyen\t\t245\nz"
 & "\t\t172\nzcaron\t\t -1\nzero\t\t060\n";

CONST E7 = 
   "StartFontMetrics 2.0\nComment Copyright (c) 1989, 1990, 1991 Adobe Syst"
 & "ems Incorporated. All rights reserved.\nComment Creation Date: Tue Sep "
 & "17 09:42:19 1991\nComment UniqueID 36350\nComment VMusage 9174 52297\nF"
 & "ontName Courier-Oblique\nFullName Courier Oblique\nFamilyName Courier\n"
 & "Weight Medium\nItalicAngle -12\nIsFixedPitch true\nFontBBox -28 -250 74"
 & "2 805\nUnderlinePosition -100\nUnderlineThickness 50\nVersion 002.004\n"
 & "Notice Copyright (c) 1989, 1990, 1991 Adobe Systems Incorporated. All r"
 & "ights reserved.\nEncodingScheme AdobeStandardEncoding\nCapHeight 562\nX"
 & "Height 426\nAscender 629\nDescender -157\nStartCharMetrics 260\nC 32 ; "
 & "WX 600 ; N space ; B 0 0 0 0 ;\nC 33 ; WX 600 ; N exclam ; B 243 -15 46"
 & "4 572 ;\nC 34 ; WX 600 ; N quotedbl ; B 273 328 532 562 ;\nC 35 ; WX 60"
 & "0 ; N numbersign ; B 133 -32 596 639 ;\nC 36 ; WX 600 ; N dollar ; B 10"
 & "8 -126 596 662 ;\nC 37 ; WX 600 ; N percent ; B 134 -15 599 622 ;\nC 38"
 & " ; WX 600 ; N ampersand ; B 87 -15 580 543 ;\nC 39 ; WX 600 ; N quoteri"
 & "ght ; B 283 328 495 562 ;\nC 40 ; WX 600 ; N parenleft ; B 313 -108 572"
 & " 622 ;\nC 41 ; WX 600 ; N parenright ; B 137 -108 396 622 ;\nC 42 ; WX "
 & "600 ; N asterisk ; B 212 257 580 607 ;\nC 43 ; WX 600 ; N plus ; B 129 "
 & "44 580 470 ;\nC 44 ; WX 600 ; N comma ; B 157 -112 370 122 ;\nC 45 ; WX"
 & " 600 ; N hyphen ; B 152 231 558 285 ;\nC 46 ; WX 600 ; N period ; B 238"
 & " -15 382 109 ;\nC 47 ; WX 600 ; N slash ; B 112 -80 604 629 ;\nC 48 ; W"
 & "X 600 ; N zero ; B 154 -15 575 622 ;\nC 49 ; WX 600 ; N one ; B 98 0 51"
 & "5 622 ;\nC 50 ; WX 600 ; N two ; B 70 0 568 622 ;\nC 51 ; WX 600 ; N th"
 & "ree ; B 82 -15 538 622 ;\nC 52 ; WX 600 ; N four ; B 108 0 541 622 ;\nC"
 & " 53 ; WX 600 ; N five ; B 99 -15 589 607 ;\nC 54 ; WX 600 ; N six ; B 1"
 & "55 -15 629 622 ;\nC 55 ; WX 600 ; N seven ; B 182 0 612 607 ;\nC 56 ; W"
 & "X 600 ; N eight ; B 132 -15 588 622 ;\nC 57 ; WX 600 ; N nine ; B 93 -1"
 & "5 574 622 ;\nC 58 ; WX 600 ; N colon ; B 238 -15 441 385 ;\nC 59 ; WX 6"
 & "00 ; N semicolon ; B 157 -112 441 385 ;\nC 60 ; WX 600 ; N less ; B 96 "
 & "42 610 472 ;\nC 61 ; WX 600 ; N equal ; B 109 138 600 376 ;\nC 6";

CONST E7_0 = 
   "2 ; WX 600 ; N greater ; B 85 42 599 472 ;\nC 63 ; WX 600 ; N question "
 & "; B 222 -15 583 572 ;\nC 64 ; WX 600 ; N at ; B 127 -15 582 622 ;\nC 65"
 & " ; WX 600 ; N A ; B 3 0 607 562 ;\nC 66 ; WX 600 ; N B ; B 43 0 616 562"
 & " ;\nC 67 ; WX 600 ; N C ; B 93 -18 655 580 ;\nC 68 ; WX 600 ; N D ; B 4"
 & "3 0 645 562 ;\nC 69 ; WX 600 ; N E ; B 53 0 660 562 ;\nC 70 ; WX 600 ; "
 & "N F ; B 53 0 660 562 ;\nC 71 ; WX 600 ; N G ; B 83 -18 645 580 ;\nC 72 "
 & "; WX 600 ; N H ; B 32 0 687 562 ;\nC 73 ; WX 600 ; N I ; B 96 0 623 562"
 & " ;\nC 74 ; WX 600 ; N J ; B 52 -18 685 562 ;\nC 75 ; WX 600 ; N K ; B 3"
 & "8 0 671 562 ;\nC 76 ; WX 600 ; N L ; B 47 0 607 562 ;\nC 77 ; WX 600 ; "
 & "N M ; B 4 0 715 562 ;\nC 78 ; WX 600 ; N N ; B 7 -13 712 562 ;\nC 79 ; "
 & "WX 600 ; N O ; B 94 -18 625 580 ;\nC 80 ; WX 600 ; N P ; B 79 0 644 562"
 & " ;\nC 81 ; WX 600 ; N Q ; B 95 -138 625 580 ;\nC 82 ; WX 600 ; N R ; B "
 & "38 0 598 562 ;\nC 83 ; WX 600 ; N S ; B 76 -20 650 580 ;\nC 84 ; WX 600"
 & " ; N T ; B 108 0 665 562 ;\nC 85 ; WX 600 ; N U ; B 125 -18 702 562 ;\n"
 & "C 86 ; WX 600 ; N V ; B 105 -13 723 562 ;\nC 87 ; WX 600 ; N W ; B 106 "
 & "-13 722 562 ;\nC 88 ; WX 600 ; N X ; B 23 0 675 562 ;\nC 89 ; WX 600 ; "
 & "N Y ; B 133 0 695 562 ;\nC 90 ; WX 600 ; N Z ; B 86 0 610 562 ;\nC 91 ;"
 & " WX 600 ; N bracketleft ; B 246 -108 574 622 ;\nC 92 ; WX 600 ; N backs"
 & "lash ; B 249 -80 468 629 ;\nC 93 ; WX 600 ; N bracketright ; B 135 -108"
 & " 463 622 ;\nC 94 ; WX 600 ; N asciicircum ; B 175 354 587 622 ;\nC 95 ;"
 & " WX 600 ; N underscore ; B -27 -125 584 -75 ;\nC 96 ; WX 600 ; N quotel"
 & "eft ; B 343 328 457 562 ;\nC 97 ; WX 600 ; N a ; B 76 -15 569 441 ;\nC "
 & "98 ; WX 600 ; N b ; B 29 -15 625 629 ;\nC 99 ; WX 600 ; N c ; B 106 -15"
 & " 608 441 ;\nC 100 ; WX 600 ; N d ; B 85 -15 640 629 ;\nC 101 ; WX 600 ;"
 & " N e ; B 106 -15 598 441 ;\nC 102 ; WX 600 ; N f ; B 114 0 662 629 ; L "
 & "i fi ; L l fl ;\nC 103 ; WX 600 ; N g ; B 61 -157 657 441 ;\nC 104 ; WX"
 & " 600 ; N h ; B 33 0 592 629 ;\nC 105 ; WX 600 ; N i ; B 95 0 515 657 ;\n"
 & "C 106 ; WX 600 ; N j ; B 52 -157 550 657 ;\nC 107 ; WX 600 ; N k ; B 58"
 & " 0 633 629 ;\nC 108 ; WX 600 ; N l ; B 95 0 515 629 ;\nC 1";

CONST E7_1 = 
   "09 ; WX 600 ; N m ; B -5 0 615 441 ;\nC 110 ; WX 600 ; N n ; B 26 0 585"
 & " 441 ;\nC 111 ; WX 600 ; N o ; B 102 -15 588 441 ;\nC 112 ; WX 600 ; N "
 & "p ; B -24 -157 605 441 ;\nC 113 ; WX 600 ; N q ; B 85 -157 682 441 ;\nC"
 & " 114 ; WX 600 ; N r ; B 60 0 636 441 ;\nC 115 ; WX 600 ; N s ; B 78 -15"
 & " 584 441 ;\nC 116 ; WX 600 ; N t ; B 167 -15 561 561 ;\nC 117 ; WX 600 "
 & "; N u ; B 101 -15 572 426 ;\nC 118 ; WX 600 ; N v ; B 90 -10 681 426 ;\n"
 & "C 119 ; WX 600 ; N w ; B 76 -10 695 426 ;\nC 120 ; WX 600 ; N x ; B 20 "
 & "0 655 426 ;\nC 121 ; WX 600 ; N y ; B -4 -157 683 426 ;\nC 122 ; WX 600"
 & " ; N z ; B 99 0 593 426 ;\nC 123 ; WX 600 ; N braceleft ; B 233 -108 56"
 & "9 622 ;\nC 124 ; WX 600 ; N bar ; B 222 -250 485 750 ;\nC 125 ; WX 600 "
 & "; N braceright ; B 140 -108 477 622 ;\nC 126 ; WX 600 ; N asciitilde ; "
 & "B 116 197 600 320 ;\nC 161 ; WX 600 ; N exclamdown ; B 225 -157 445 430"
 & " ;\nC 162 ; WX 600 ; N cent ; B 151 -49 588 614 ;\nC 163 ; WX 600 ; N s"
 & "terling ; B 124 -21 621 611 ;\nC 164 ; WX 600 ; N fraction ; B 84 -57 6"
 & "46 665 ;\nC 165 ; WX 600 ; N yen ; B 120 0 693 562 ;\nC 166 ; WX 600 ; "
 & "N florin ; B -26 -143 671 622 ;\nC 167 ; WX 600 ; N section ; B 104 -78"
 & " 590 580 ;\nC 168 ; WX 600 ; N currency ; B 94 58 628 506 ;\nC 169 ; WX"
 & " 600 ; N quotesingle ; B 345 328 460 562 ;\nC 170 ; WX 600 ; N quotedbl"
 & "left ; B 262 328 541 562 ;\nC 171 ; WX 600 ; N guillemotleft ; B 92 70 "
 & "652 446 ;\nC 172 ; WX 600 ; N guilsinglleft ; B 204 70 540 446 ;\nC 173"
 & " ; WX 600 ; N guilsinglright ; B 170 70 506 446 ;\nC 174 ; WX 600 ; N f"
 & "i ; B 3 0 619 629 ;\nC 175 ; WX 600 ; N fl ; B 3 0 619 629 ;\nC 177 ; W"
 & "X 600 ; N endash ; B 124 231 586 285 ;\nC 178 ; WX 600 ; N dagger ; B 2"
 & "17 -78 546 580 ;\nC 179 ; WX 600 ; N daggerdbl ; B 163 -78 546 580 ;\nC"
 & " 180 ; WX 600 ; N periodcentered ; B 275 189 434 327 ;\nC 182 ; WX 600 "
 & "; N paragraph ; B 100 -78 630 562 ;\nC 183 ; WX 600 ; N bullet ; B 224 "
 & "130 485 383 ;\nC 184 ; WX 600 ; N quotesinglbase ; B 185 -134 397 100 ;"
 & "\nC 185 ; WX 600 ; N quotedblbase ; B 115 -134 478 100 ;\nC 186 ; WX 60"
 & "0 ; N quotedblright ; B 213 328 576 562 ;\nC 187 ; WX";

CONST E7_2 = 
   " 600 ; N guillemotright ; B 58 70 618 446 ;\nC 188 ; WX 600 ; N ellipsi"
 & "s ; B 46 -15 575 111 ;\nC 189 ; WX 600 ; N perthousand ; B 59 -15 627 6"
 & "22 ;\nC 191 ; WX 600 ; N questiondown ; B 105 -157 466 430 ;\nC 193 ; W"
 & "X 600 ; N grave ; B 294 497 484 672 ;\nC 194 ; WX 600 ; N acute ; B 348"
 & " 497 612 672 ;\nC 195 ; WX 600 ; N circumflex ; B 229 477 581 654 ;\nC "
 & "196 ; WX 600 ; N tilde ; B 212 489 629 606 ;\nC 197 ; WX 600 ; N macron"
 & " ; B 232 525 600 565 ;\nC 198 ; WX 600 ; N breve ; B 279 501 576 609 ;\n"
 & "C 199 ; WX 600 ; N dotaccent ; B 360 477 466 580 ;\nC 200 ; WX 600 ; N "
 & "dieresis ; B 262 492 570 595 ;\nC 202 ; WX 600 ; N ring ; B 332 463 500"
 & " 627 ;\nC 203 ; WX 600 ; N cedilla ; B 197 -151 344 10 ;\nC 205 ; WX 60"
 & "0 ; N hungarumlaut ; B 239 497 683 672 ;\nC 206 ; WX 600 ; N ogonek ; B"
 & " 207 -151 348 0 ;\nC 207 ; WX 600 ; N caron ; B 262 492 614 669 ;\nC 20"
 & "8 ; WX 600 ; N emdash ; B 49 231 661 285 ;\nC 225 ; WX 600 ; N AE ; B 3"
 & " 0 655 562 ;\nC 227 ; WX 600 ; N ordfeminine ; B 209 249 512 580 ;\nC 2"
 & "32 ; WX 600 ; N Lslash ; B 47 0 607 562 ;\nC 233 ; WX 600 ; N Oslash ; "
 & "B 94 -80 625 629 ;\nC 234 ; WX 600 ; N OE ; B 59 0 672 562 ;\nC 235 ; W"
 & "X 600 ; N ordmasculine ; B 210 249 535 580 ;\nC 241 ; WX 600 ; N ae ; B"
 & " 41 -15 626 441 ;\nC 245 ; WX 600 ; N dotlessi ; B 95 0 515 426 ;\nC 24"
 & "8 ; WX 600 ; N lslash ; B 95 0 583 629 ;\nC 249 ; WX 600 ; N oslash ; B"
 & " 102 -80 588 506 ;\nC 250 ; WX 600 ; N oe ; B 54 -15 615 441 ;\nC 251 ;"
 & " WX 600 ; N germandbls ; B 48 -15 617 629 ;\nC -1 ; WX 600 ; N Odieresi"
 & "s ; B 94 -18 625 731 ;\nC -1 ; WX 600 ; N logicalnot ; B 155 108 591 36"
 & "9 ;\nC -1 ; WX 600 ; N minus ; B 129 232 580 283 ;\nC -1 ; WX 600 ; N m"
 & "erge ; B 187 -15 503 436 ;\nC -1 ; WX 600 ; N degree ; B 214 269 576 62"
 & "2 ;\nC -1 ; WX 600 ; N dectab ; B 18 0 593 227 ;\nC -1 ; WX 600 ; N ll "
 & "; B 33 0 616 629 ;\nC -1 ; WX 600 ; N IJ ; B 32 -18 702 562 ;\nC -1 ; W"
 & "X 600 ; N Eacute ; B 53 0 668 793 ;\nC -1 ; WX 600 ; N Ocircumflex ; B "
 & "94 -18 625 775 ;\nC -1 ; WX 600 ; N ucircumflex ; B 101 -15 572 654 ;\n"
 & "C -1 ; WX 600 ; N left ; B 114 68 580 348 ;\nC -1 ; W";

CONST E7_3 = 
   "X 600 ; N threesuperior ; B 213 240 501 622 ;\nC -1 ; WX 600 ; N up ; B"
 & " 223 0 503 437 ;\nC -1 ; WX 600 ; N multiply ; B 103 43 607 470 ;\nC -1"
 & " ; WX 600 ; N Scaron ; B 76 -20 673 805 ;\nC -1 ; WX 600 ; N tab ; B 19"
 & " 0 641 562 ;\nC -1 ; WX 600 ; N Ucircumflex ; B 125 -18 702 775 ;\nC -1"
 & " ; WX 600 ; N divide ; B 136 48 573 467 ;\nC -1 ; WX 600 ; N Acircumfle"
 & "x ; B 3 0 607 775 ;\nC -1 ; WX 600 ; N eacute ; B 106 -15 612 672 ;\nC "
 & "-1 ; WX 600 ; N uacute ; B 101 -15 602 672 ;\nC -1 ; WX 600 ; N Aacute "
 & "; B 3 0 658 793 ;\nC -1 ; WX 600 ; N copyright ; B 53 -18 667 580 ;\nC "
 & "-1 ; WX 600 ; N twosuperior ; B 230 249 535 622 ;\nC -1 ; WX 600 ; N Ec"
 & "ircumflex ; B 53 0 660 775 ;\nC -1 ; WX 600 ; N ntilde ; B 26 0 629 606"
 & " ;\nC -1 ; WX 600 ; N down ; B 187 -15 467 426 ;\nC -1 ; WX 600 ; N cen"
 & "ter ; B 103 14 623 580 ;\nC -1 ; WX 600 ; N onesuperior ; B 231 249 491"
 & " 622 ;\nC -1 ; WX 600 ; N ij ; B 37 -157 630 657 ;\nC -1 ; WX 600 ; N e"
 & "dieresis ; B 106 -15 598 595 ;\nC -1 ; WX 600 ; N graybox ; B 76 0 652 "
 & "599 ;\nC -1 ; WX 600 ; N odieresis ; B 102 -15 588 595 ;\nC -1 ; WX 600"
 & " ; N Ograve ; B 94 -18 625 793 ;\nC -1 ; WX 600 ; N threequarters ; B 7"
 & "3 -56 659 666 ;\nC -1 ; WX 600 ; N plusminus ; B 96 44 594 558 ;\nC -1 "
 & "; WX 600 ; N prescription ; B 27 -15 617 562 ;\nC -1 ; WX 600 ; N eth ;"
 & " B 102 -15 639 629 ;\nC -1 ; WX 600 ; N largebullet ; B 315 220 395 297"
 & " ;\nC -1 ; WX 600 ; N egrave ; B 106 -15 598 672 ;\nC -1 ; WX 600 ; N c"
 & "cedilla ; B 106 -151 614 441 ;\nC -1 ; WX 600 ; N notegraphic ; B 143 -"
 & "15 564 572 ;\nC -1 ; WX 600 ; N Udieresis ; B 125 -18 702 731 ;\nC -1 ;"
 & " WX 600 ; N Gcaron ; B 83 -18 645 805 ;\nC -1 ; WX 600 ; N arrowdown ; "
 & "B 152 -15 520 608 ;\nC -1 ; WX 600 ; N format ; B -28 -157 185 607 ;\nC"
 & " -1 ; WX 600 ; N Otilde ; B 94 -18 656 732 ;\nC -1 ; WX 600 ; N Idieres"
 & "is ; B 96 0 623 731 ;\nC -1 ; WX 600 ; N adieresis ; B 76 -15 570 595 ;"
 & "\nC -1 ; WX 600 ; N ecircumflex ; B 106 -15 598 654 ;\nC -1 ; WX 600 ; "
 & "N Eth ; B 43 0 645 562 ;\nC -1 ; WX 600 ; N onequarter ; B 65 -57 674 6"
 & "65 ;\nC -1 ; WX 600 ; N LL ; B 8 0 647 562 ;\nC -1 ; W";

CONST E7_4 = 
   "X 600 ; N agrave ; B 76 -15 569 672 ;\nC -1 ; WX 600 ; N Zcaron ; B 86 "
 & "0 643 805 ;\nC -1 ; WX 600 ; N Scedilla ; B 76 -151 650 580 ;\nC -1 ; W"
 & "X 600 ; N Idot ; B 96 0 623 716 ;\nC -1 ; WX 600 ; N Iacute ; B 96 0 63"
 & "8 793 ;\nC -1 ; WX 600 ; N indent ; B 108 68 574 348 ;\nC -1 ; WX 600 ;"
 & " N Ugrave ; B 125 -18 702 793 ;\nC -1 ; WX 600 ; N scaron ; B 78 -15 61"
 & "4 669 ;\nC -1 ; WX 600 ; N overscore ; B 123 579 734 629 ;\nC -1 ; WX 6"
 & "00 ; N Aring ; B 3 0 607 753 ;\nC -1 ; WX 600 ; N Ccedilla ; B 93 -151 "
 & "658 580 ;\nC -1 ; WX 600 ; N Igrave ; B 96 0 623 793 ;\nC -1 ; WX 600 ;"
 & " N brokenbar ; B 238 -175 469 675 ;\nC -1 ; WX 600 ; N Oacute ; B 94 -1"
 & "8 638 793 ;\nC -1 ; WX 600 ; N otilde ; B 102 -15 629 606 ;\nC -1 ; WX "
 & "600 ; N Yacute ; B 133 0 695 793 ;\nC -1 ; WX 600 ; N lira ; B 118 -21 "
 & "621 611 ;\nC -1 ; WX 600 ; N Icircumflex ; B 96 0 623 775 ;\nC -1 ; WX "
 & "600 ; N Atilde ; B 3 0 656 732 ;\nC -1 ; WX 600 ; N Uacute ; B 125 -18 "
 & "702 793 ;\nC -1 ; WX 600 ; N Ydieresis ; B 133 0 695 731 ;\nC -1 ; WX 6"
 & "00 ; N ydieresis ; B -4 -157 683 595 ;\nC -1 ; WX 600 ; N idieresis ; B"
 & " 95 0 540 595 ;\nC -1 ; WX 600 ; N Adieresis ; B 3 0 607 731 ;\nC -1 ; "
 & "WX 600 ; N mu ; B 72 -157 572 426 ;\nC -1 ; WX 600 ; N trademark ; B 75"
 & " 263 742 562 ;\nC -1 ; WX 600 ; N oacute ; B 102 -15 612 672 ;\nC -1 ; "
 & "WX 600 ; N acircumflex ; B 76 -15 581 654 ;\nC -1 ; WX 600 ; N Agrave ;"
 & " B 3 0 607 793 ;\nC -1 ; WX 600 ; N return ; B 79 0 700 562 ;\nC -1 ; W"
 & "X 600 ; N atilde ; B 76 -15 629 606 ;\nC -1 ; WX 600 ; N square ; B 19 "
 & "0 700 562 ;\nC -1 ; WX 600 ; N registered ; B 53 -18 667 580 ;\nC -1 ; "
 & "WX 600 ; N stop ; B 19 0 700 562 ;\nC -1 ; WX 600 ; N udieresis ; B 101"
 & " -15 572 595 ;\nC -1 ; WX 600 ; N arrowup ; B 209 0 577 623 ;\nC -1 ; W"
 & "X 600 ; N igrave ; B 95 0 515 672 ;\nC -1 ; WX 600 ; N Edieresis ; B 53"
 & " 0 660 731 ;\nC -1 ; WX 600 ; N zcaron ; B 99 0 624 669 ;\nC -1 ; WX 60"
 & "0 ; N arrowboth ; B 36 115 692 483 ;\nC -1 ; WX 600 ; N gcaron ; B 61 -"
 & "157 657 669 ;\nC -1 ; WX 600 ; N arrowleft ; B 40 115 693 483 ;\nC -1 ;"
 & " WX 600 ; N aacute ; B 76 -15 612 672 ;\nC -1 ; WX 600 ";

CONST E7_5 = 
   "; N ocircumflex ; B 102 -15 588 654 ;\nC -1 ; WX 600 ; N scedilla ; B 7"
 & "8 -151 584 441 ;\nC -1 ; WX 600 ; N ograve ; B 102 -15 588 672 ;\nC -1 "
 & "; WX 600 ; N onehalf ; B 65 -57 669 665 ;\nC -1 ; WX 600 ; N ugrave ; B"
 & " 101 -15 572 672 ;\nC -1 ; WX 600 ; N Ntilde ; B 7 -13 712 732 ;\nC -1 "
 & "; WX 600 ; N iacute ; B 95 0 612 672 ;\nC -1 ; WX 600 ; N arrowright ; "
 & "B 34 115 688 483 ;\nC -1 ; WX 600 ; N Thorn ; B 79 0 606 562 ;\nC -1 ; "
 & "WX 600 ; N Egrave ; B 53 0 660 793 ;\nC -1 ; WX 600 ; N thorn ; B -24 -"
 & "157 605 629 ;\nC -1 ; WX 600 ; N aring ; B 76 -15 569 627 ;\nC -1 ; WX "
 & "600 ; N yacute ; B -4 -157 683 672 ;\nC -1 ; WX 600 ; N icircumflex ; B"
 & " 95 0 551 654 ;\nEndCharMetrics\nStartComposites 58\nCC Aacute 2 ; PCC "
 & "A 0 0 ; PCC acute 46 121 ;\nCC Acircumflex 2 ; PCC A 0 0 ; PCC circumfl"
 & "ex -4 121 ;\nCC Adieresis 2 ; PCC A 0 0 ; PCC dieresis -1 136 ;\nCC Agr"
 & "ave 2 ; PCC A 0 0 ; PCC grave -4 121 ;\nCC Aring 2 ; PCC A 0 0 ; PCC ri"
 & "ng 12 126 ;\nCC Atilde 2 ; PCC A 0 0 ; PCC tilde 27 126 ;\nCC Eacute 2 "
 & "; PCC E 0 0 ; PCC acute 56 121 ;\nCC Ecircumflex 2 ; PCC E 0 0 ; PCC ci"
 & "rcumflex 26 121 ;\nCC Edieresis 2 ; PCC E 0 0 ; PCC dieresis 29 136 ;\n"
 & "CC Egrave 2 ; PCC E 0 0 ; PCC grave 26 121 ;\nCC Gcaron 2 ; PCC G 0 0 ;"
 & " PCC caron 29 136 ;\nCC Iacute 2 ; PCC I 0 0 ; PCC acute 26 121 ;\nCC I"
 & "circumflex 2 ; PCC I 0 0 ; PCC circumflex 26 121 ;\nCC Idieresis 2 ; PC"
 & "C I 0 0 ; PCC dieresis 29 136 ;\nCC Igrave 2 ; PCC I 0 0 ; PCC grave 26"
 & " 121 ;\nCC Ntilde 2 ; PCC N 0 0 ; PCC tilde 27 126 ;\nCC Oacute 2 ; PCC"
 & " O 0 0 ; PCC acute 26 121 ;\nCC Ocircumflex 2 ; PCC O 0 0 ; PCC circumf"
 & "lex 26 121 ;\nCC Odieresis 2 ; PCC O 0 0 ; PCC dieresis 29 136 ;\nCC Og"
 & "rave 2 ; PCC O 0 0 ; PCC grave 26 121 ;\nCC Otilde 2 ; PCC O 0 0 ; PCC "
 & "tilde 27 126 ;\nCC Scaron 2 ; PCC S 0 0 ; PCC caron 59 136 ;\nCC Uacute"
 & " 2 ; PCC U 0 0 ; PCC acute 56 121 ;\nCC Ucircumflex 2 ; PCC U 0 0 ; PCC"
 & " circumflex 26 121 ;\nCC Udieresis 2 ; PCC U 0 0 ; PCC dieresis 29 136 "
 & ";\nCC Ugrave 2 ; PCC U 0 0 ; PCC grave -4 121 ;\nCC Yacute 2 ; PCC Y 0 "
 & "0 ; PCC acute 56 121 ;\nCC Ydieresis 2 ; PCC Y 0 0 ; PC";

CONST E7_6 = 
   "C dieresis 29 136 ;\nCC Zcaron 2 ; PCC Z 0 0 ; PCC caron 29 136 ;\nCC a"
 & "acute 2 ; PCC a 0 0 ; PCC acute 0 0 ;\nCC acircumflex 2 ; PCC a 0 0 ; P"
 & "CC circumflex 0 0 ;\nCC adieresis 2 ; PCC a 0 0 ; PCC dieresis 0 0 ;\nC"
 & "C agrave 2 ; PCC a 0 0 ; PCC grave 0 0 ;\nCC aring 2 ; PCC a 0 0 ; PCC "
 & "ring 0 0 ;\nCC atilde 2 ; PCC a 0 0 ; PCC tilde 0 0 ;\nCC eacute 2 ; PC"
 & "C e 0 0 ; PCC acute 0 0 ;\nCC ecircumflex 2 ; PCC e 0 0 ; PCC circumfle"
 & "x 0 0 ;\nCC edieresis 2 ; PCC e 0 0 ; PCC dieresis 0 0 ;\nCC egrave 2 ;"
 & " PCC e 0 0 ; PCC grave 0 0 ;\nCC gcaron 2 ; PCC g 0 0 ; PCC caron -30 0"
 & " ;\nCC iacute 2 ; PCC dotlessi 0 0 ; PCC acute 0 0 ;\nCC icircumflex 2 "
 & "; PCC dotlessi 0 0 ; PCC circumflex -30 0 ;\nCC idieresis 2 ; PCC dotle"
 & "ssi 0 0 ; PCC dieresis -30 0 ;\nCC igrave 2 ; PCC dotlessi 0 0 ; PCC gr"
 & "ave -30 0 ;\nCC ntilde 2 ; PCC n 0 0 ; PCC tilde 0 0 ;\nCC oacute 2 ; P"
 & "CC o 0 0 ; PCC acute 0 0 ;\nCC ocircumflex 2 ; PCC o 0 0 ; PCC circumfl"
 & "ex 0 0 ;\nCC odieresis 2 ; PCC o 0 0 ; PCC dieresis 0 0 ;\nCC ograve 2 "
 & "; PCC o 0 0 ; PCC grave 0 0 ;\nCC otilde 2 ; PCC o 0 0 ; PCC tilde 0 0 "
 & ";\nCC scaron 2 ; PCC s 0 0 ; PCC caron 0 0 ;\nCC uacute 2 ; PCC u 0 0 ;"
 & " PCC acute -10 0 ;\nCC ucircumflex 2 ; PCC u 0 0 ; PCC circumflex -10 0"
 & " ;\nCC udieresis 2 ; PCC u 0 0 ; PCC dieresis 0 0 ;\nCC ugrave 2 ; PCC "
 & "u 0 0 ; PCC grave -30 0 ;\nCC yacute 2 ; PCC y 0 0 ; PCC acute -20 0 ;\n"
 & "CC ydieresis 2 ; PCC y 0 0 ; PCC dieresis -10 0 ;\nCC zcaron 2 ; PCC z "
 & "0 0 ; PCC caron 10 0 ;\nEndComposites\nEndFontMetrics\n";

CONST E8 = 
   "StartFontMetrics 2.0\nComment Copyright (c) 1985, 1987, 1989, 1990 Adob"
 & "e Systems Incorporated.  All Rights Reserved.\nComment Creation Date: T"
 & "ue Mar 20 13:14:56 1990\nComment UniqueID 28427\nComment VMusage 32912 "
 & "39804\nFontName Times-Italic\nFullName Times Italic\nFamilyName Times\n"
 & "Weight Medium\nItalicAngle -15.5\nIsFixedPitch false\nFontBBox -169 -21"
 & "7 1010 883\nUnderlinePosition -100\nUnderlineThickness 50\nVersion 001."
 & "007\nNotice Copyright (c) 1985, 1987, 1989, 1990 Adobe Systems Incorpor"
 & "ated.  All Rights Reserved.Times is a trademark of Linotype AG and/or i"
 & "ts subsidiaries.\nEncodingScheme AdobeStandardEncoding\nCapHeight 653\n"
 & "XHeight 441\nAscender 683\nDescender -205\nStartCharMetrics 228\nC 32 ;"
 & " WX 250 ; N space ; B 0 0 0 0 ;\nC 33 ; WX 333 ; N exclam ; B 39 -11 30"
 & "2 667 ;\nC 34 ; WX 420 ; N quotedbl ; B 144 421 432 666 ;\nC 35 ; WX 50"
 & "0 ; N numbersign ; B 2 0 540 676 ;\nC 36 ; WX 500 ; N dollar ; B 31 -89"
 & " 497 731 ;\nC 37 ; WX 833 ; N percent ; B 79 -13 790 676 ;\nC 38 ; WX 7"
 & "78 ; N ampersand ; B 76 -18 723 666 ;\nC 39 ; WX 333 ; N quoteright ; B"
 & " 151 436 290 666 ;\nC 40 ; WX 333 ; N parenleft ; B 42 -181 315 669 ;\n"
 & "C 41 ; WX 333 ; N parenright ; B 16 -180 289 669 ;\nC 42 ; WX 500 ; N a"
 & "sterisk ; B 128 255 492 666 ;\nC 43 ; WX 675 ; N plus ; B 86 0 590 506 "
 & ";\nC 44 ; WX 250 ; N comma ; B -4 -129 135 101 ;\nC 45 ; WX 333 ; N hyp"
 & "hen ; B 49 192 282 255 ;\nC 46 ; WX 250 ; N period ; B 27 -11 138 100 ;"
 & "\nC 47 ; WX 278 ; N slash ; B -65 -18 386 666 ;\nC 48 ; WX 500 ; N zero"
 & " ; B 32 -7 497 676 ;\nC 49 ; WX 500 ; N one ; B 49 0 409 676 ;\nC 50 ; "
 & "WX 500 ; N two ; B 12 0 452 676 ;\nC 51 ; WX 500 ; N three ; B 15 -7 46"
 & "5 676 ;\nC 52 ; WX 500 ; N four ; B 1 0 479 676 ;\nC 53 ; WX 500 ; N fi"
 & "ve ; B 15 -7 491 666 ;\nC 54 ; WX 500 ; N six ; B 30 -7 521 686 ;\nC 55"
 & " ; WX 500 ; N seven ; B 75 -8 537 666 ;\nC 56 ; WX 500 ; N eight ; B 30"
 & " -7 493 676 ;\nC 57 ; WX 500 ; N nine ; B 23 -17 492 676 ;\nC 58 ; WX 3"
 & "33 ; N colon ; B 50 -11 261 441 ;\nC 59 ; WX 333 ; N semicolon ; B 27 -"
 & "129 261 441 ;\nC 60 ; WX 675 ; N less ; B 84 -8 592 514 ;\nC 61";

CONST E8_0 = 
   " ; WX 675 ; N equal ; B 86 120 590 386 ;\nC 62 ; WX 675 ; N greater ; B"
 & " 84 -8 592 514 ;\nC 63 ; WX 500 ; N question ; B 132 -12 472 664 ;\nC 6"
 & "4 ; WX 920 ; N at ; B 118 -18 806 666 ;\nC 65 ; WX 611 ; N A ; B -51 0 "
 & "564 668 ;\nC 66 ; WX 611 ; N B ; B -8 0 588 653 ;\nC 67 ; WX 667 ; N C "
 & "; B 66 -18 689 666 ;\nC 68 ; WX 722 ; N D ; B -8 0 700 653 ;\nC 69 ; WX"
 & " 611 ; N E ; B -1 0 634 653 ;\nC 70 ; WX 611 ; N F ; B 8 0 645 653 ;\nC"
 & " 71 ; WX 722 ; N G ; B 52 -18 722 666 ;\nC 72 ; WX 722 ; N H ; B -8 0 7"
 & "67 653 ;\nC 73 ; WX 333 ; N I ; B -8 0 384 653 ;\nC 74 ; WX 444 ; N J ;"
 & " B -6 -18 491 653 ;\nC 75 ; WX 667 ; N K ; B 7 0 722 653 ;\nC 76 ; WX 5"
 & "56 ; N L ; B -8 0 559 653 ;\nC 77 ; WX 833 ; N M ; B -18 0 873 653 ;\nC"
 & " 78 ; WX 667 ; N N ; B -20 -15 727 653 ;\nC 79 ; WX 722 ; N O ; B 60 -1"
 & "8 699 666 ;\nC 80 ; WX 611 ; N P ; B 0 0 605 653 ;\nC 81 ; WX 722 ; N Q"
 & " ; B 59 -182 699 666 ;\nC 82 ; WX 611 ; N R ; B -13 0 588 653 ;\nC 83 ;"
 & " WX 500 ; N S ; B 17 -18 508 667 ;\nC 84 ; WX 556 ; N T ; B 59 0 633 65"
 & "3 ;\nC 85 ; WX 722 ; N U ; B 102 -18 765 653 ;\nC 86 ; WX 611 ; N V ; B"
 & " 76 -18 688 653 ;\nC 87 ; WX 833 ; N W ; B 71 -18 906 653 ;\nC 88 ; WX "
 & "611 ; N X ; B -29 0 655 653 ;\nC 89 ; WX 556 ; N Y ; B 78 0 633 653 ;\n"
 & "C 90 ; WX 556 ; N Z ; B -6 0 606 653 ;\nC 91 ; WX 389 ; N bracketleft ;"
 & " B 21 -153 391 663 ;\nC 92 ; WX 278 ; N backslash ; B -41 -18 319 666 ;"
 & "\nC 93 ; WX 389 ; N bracketright ; B 12 -153 382 663 ;\nC 94 ; WX 422 ;"
 & " N asciicircum ; B 0 301 422 666 ;\nC 95 ; WX 500 ; N underscore ; B 0 "
 & "-125 500 -75 ;\nC 96 ; WX 333 ; N quoteleft ; B 171 436 310 666 ;\nC 97"
 & " ; WX 500 ; N a ; B 17 -11 476 441 ;\nC 98 ; WX 500 ; N b ; B 23 -11 47"
 & "3 683 ;\nC 99 ; WX 444 ; N c ; B 30 -11 425 441 ;\nC 100 ; WX 500 ; N d"
 & " ; B 15 -13 527 683 ;\nC 101 ; WX 444 ; N e ; B 31 -11 412 441 ;\nC 102"
 & " ; WX 278 ; N f ; B -147 -207 424 678 ; L i fi ; L l fl ;\nC 103 ; WX 5"
 & "00 ; N g ; B 8 -206 472 441 ;\nC 104 ; WX 500 ; N h ; B 19 -9 478 683 ;"
 & "\nC 105 ; WX 278 ; N i ; B 49 -11 264 654 ;\nC 106 ; WX 278 ; N j ; B -"
 & "124 -207 276 654 ;\nC 107 ; WX 444 ; N k ; B 14 -11 461 68";

CONST E8_1 = 
   "3 ;\nC 108 ; WX 278 ; N l ; B 41 -11 279 683 ;\nC 109 ; WX 722 ; N m ; "
 & "B 12 -9 704 441 ;\nC 110 ; WX 500 ; N n ; B 14 -9 474 441 ;\nC 111 ; WX"
 & " 500 ; N o ; B 27 -11 468 441 ;\nC 112 ; WX 500 ; N p ; B -75 -205 469 "
 & "441 ;\nC 113 ; WX 500 ; N q ; B 25 -209 483 441 ;\nC 114 ; WX 389 ; N r"
 & " ; B 45 0 412 441 ;\nC 115 ; WX 389 ; N s ; B 16 -13 366 442 ;\nC 116 ;"
 & " WX 278 ; N t ; B 37 -11 296 546 ;\nC 117 ; WX 500 ; N u ; B 42 -11 475"
 & " 441 ;\nC 118 ; WX 444 ; N v ; B 21 -18 426 441 ;\nC 119 ; WX 667 ; N w"
 & " ; B 16 -18 648 441 ;\nC 120 ; WX 444 ; N x ; B -27 -11 447 441 ;\nC 12"
 & "1 ; WX 444 ; N y ; B -24 -206 426 441 ;\nC 122 ; WX 389 ; N z ; B -2 -8"
 & "1 380 428 ;\nC 123 ; WX 400 ; N braceleft ; B 51 -177 407 687 ;\nC 124 "
 & "; WX 275 ; N bar ; B 105 -18 171 666 ;\nC 125 ; WX 400 ; N braceright ;"
 & " B -7 -177 349 687 ;\nC 126 ; WX 541 ; N asciitilde ; B 40 183 502 323 "
 & ";\nC 161 ; WX 389 ; N exclamdown ; B 59 -205 322 473 ;\nC 162 ; WX 500 "
 & "; N cent ; B 77 -143 472 560 ;\nC 163 ; WX 500 ; N sterling ; B 10 -6 5"
 & "17 670 ;\nC 164 ; WX 167 ; N fraction ; B -169 -10 337 676 ;\nC 165 ; W"
 & "X 500 ; N yen ; B 27 0 603 653 ;\nC 166 ; WX 500 ; N florin ; B 25 -182"
 & " 507 682 ;\nC 167 ; WX 500 ; N section ; B 53 -162 461 666 ;\nC 168 ; W"
 & "X 500 ; N currency ; B -22 53 522 597 ;\nC 169 ; WX 214 ; N quotesingle"
 & " ; B 132 421 241 666 ;\nC 170 ; WX 556 ; N quotedblleft ; B 166 436 514"
 & " 666 ;\nC 171 ; WX 500 ; N guillemotleft ; B 53 37 445 403 ;\nC 172 ; W"
 & "X 333 ; N guilsinglleft ; B 51 37 281 403 ;\nC 173 ; WX 333 ; N guilsin"
 & "glright ; B 52 37 282 403 ;\nC 174 ; WX 500 ; N fi ; B -141 -207 481 68"
 & "1 ;\nC 175 ; WX 500 ; N fl ; B -141 -204 518 682 ;\nC 177 ; WX 500 ; N "
 & "endash ; B -6 197 505 243 ;\nC 178 ; WX 500 ; N dagger ; B 101 -159 488"
 & " 666 ;\nC 179 ; WX 500 ; N daggerdbl ; B 22 -143 491 666 ;\nC 180 ; WX "
 & "250 ; N periodcentered ; B 70 199 181 310 ;\nC 182 ; WX 523 ; N paragra"
 & "ph ; B 55 -123 616 653 ;\nC 183 ; WX 350 ; N bullet ; B 40 191 310 461 "
 & ";\nC 184 ; WX 333 ; N quotesinglbase ; B 44 -129 183 101 ;\nC 185 ; WX "
 & "556 ; N quotedblbase ; B 57 -129 405 101 ;\nC 186 ; WX ";

CONST E8_2 = 
   "556 ; N quotedblright ; B 151 436 499 666 ;\nC 187 ; WX 500 ; N guillem"
 & "otright ; B 55 37 447 403 ;\nC 188 ; WX 889 ; N ellipsis ; B 57 -11 762"
 & " 100 ;\nC 189 ; WX 1000 ; N perthousand ; B 25 -19 1010 706 ;\nC 191 ; "
 & "WX 500 ; N questiondown ; B 28 -205 368 471 ;\nC 193 ; WX 333 ; N grave"
 & " ; B 121 492 311 664 ;\nC 194 ; WX 333 ; N acute ; B 180 494 403 664 ;\n"
 & "C 195 ; WX 333 ; N circumflex ; B 91 492 385 661 ;\nC 196 ; WX 333 ; N "
 & "tilde ; B 100 517 427 624 ;\nC 197 ; WX 333 ; N macron ; B 99 532 411 5"
 & "83 ;\nC 198 ; WX 333 ; N breve ; B 117 492 418 650 ;\nC 199 ; WX 333 ; "
 & "N dotaccent ; B 207 508 305 606 ;\nC 200 ; WX 333 ; N dieresis ; B 107 "
 & "508 405 606 ;\nC 202 ; WX 333 ; N ring ; B 155 492 355 691 ;\nC 203 ; W"
 & "X 333 ; N cedilla ; B -30 -217 182 0 ;\nC 205 ; WX 333 ; N hungarumlaut"
 & " ; B 93 494 486 664 ;\nC 206 ; WX 333 ; N ogonek ; B -20 -169 200 40 ;\n"
 & "C 207 ; WX 333 ; N caron ; B 121 492 426 661 ;\nC 208 ; WX 889 ; N emda"
 & "sh ; B -6 197 894 243 ;\nC 225 ; WX 889 ; N AE ; B -27 0 911 653 ;\nC 2"
 & "27 ; WX 276 ; N ordfeminine ; B 42 406 352 676 ;\nC 232 ; WX 556 ; N Ls"
 & "lash ; B -8 0 559 653 ;\nC 233 ; WX 722 ; N Oslash ; B 60 -105 699 722 "
 & ";\nC 234 ; WX 944 ; N OE ; B 49 -8 964 666 ;\nC 235 ; WX 310 ; N ordmas"
 & "culine ; B 67 406 362 676 ;\nC 241 ; WX 667 ; N ae ; B 23 -11 640 441 ;"
 & "\nC 245 ; WX 278 ; N dotlessi ; B 49 -11 235 441 ;\nC 248 ; WX 278 ; N "
 & "lslash ; B 37 -11 307 683 ;\nC 249 ; WX 500 ; N oslash ; B 28 -135 469 "
 & "554 ;\nC 250 ; WX 667 ; N oe ; B 20 -12 646 441 ;\nC 251 ; WX 500 ; N g"
 & "ermandbls ; B -168 -207 493 679 ;\nC -1 ; WX 556 ; N Zcaron ; B -6 0 60"
 & "6 873 ;\nC -1 ; WX 444 ; N ccedilla ; B 26 -217 425 441 ;\nC -1 ; WX 44"
 & "4 ; N ydieresis ; B -24 -206 441 606 ;\nC -1 ; WX 500 ; N atilde ; B 17"
 & " -11 511 624 ;\nC -1 ; WX 278 ; N icircumflex ; B 34 -11 328 661 ;\nC -"
 & "1 ; WX 300 ; N threesuperior ; B 43 268 339 676 ;\nC -1 ; WX 444 ; N ec"
 & "ircumflex ; B 31 -11 441 661 ;\nC -1 ; WX 500 ; N thorn ; B -75 -205 46"
 & "9 683 ;\nC -1 ; WX 444 ; N egrave ; B 31 -11 412 664 ;\nC -1 ; WX 300 ;"
 & " N twosuperior ; B 33 271 324 676 ;\nC -1 ; WX 444 ";

CONST E8_3 = 
   "; N eacute ; B 31 -11 459 664 ;\nC -1 ; WX 500 ; N otilde ; B 27 -11 49"
 & "6 624 ;\nC -1 ; WX 611 ; N Aacute ; B -51 0 564 876 ;\nC -1 ; WX 500 ; "
 & "N ocircumflex ; B 27 -11 468 661 ;\nC -1 ; WX 444 ; N yacute ; B -24 -2"
 & "06 459 664 ;\nC -1 ; WX 500 ; N udieresis ; B 42 -11 479 606 ;\nC -1 ; "
 & "WX 750 ; N threequarters ; B 23 -10 736 676 ;\nC -1 ; WX 500 ; N acircu"
 & "mflex ; B 17 -11 476 661 ;\nC -1 ; WX 722 ; N Eth ; B -8 0 700 653 ;\nC"
 & " -1 ; WX 444 ; N edieresis ; B 31 -11 451 606 ;\nC -1 ; WX 500 ; N ugra"
 & "ve ; B 42 -11 475 664 ;\nC -1 ; WX 980 ; N trademark ; B 30 247 957 653"
 & " ;\nC -1 ; WX 500 ; N ograve ; B 27 -11 468 664 ;\nC -1 ; WX 389 ; N sc"
 & "aron ; B 16 -13 454 661 ;\nC -1 ; WX 333 ; N Idieresis ; B -8 0 435 818"
 & " ;\nC -1 ; WX 500 ; N uacute ; B 42 -11 477 664 ;\nC -1 ; WX 500 ; N ag"
 & "rave ; B 17 -11 476 664 ;\nC -1 ; WX 500 ; N ntilde ; B 14 -9 476 624 ;"
 & "\nC -1 ; WX 500 ; N aring ; B 17 -11 476 691 ;\nC -1 ; WX 389 ; N zcaro"
 & "n ; B -2 -81 434 661 ;\nC -1 ; WX 333 ; N Icircumflex ; B -8 0 425 873 "
 & ";\nC -1 ; WX 667 ; N Ntilde ; B -20 -15 727 836 ;\nC -1 ; WX 500 ; N uc"
 & "ircumflex ; B 42 -11 475 661 ;\nC -1 ; WX 611 ; N Ecircumflex ; B -1 0 "
 & "634 873 ;\nC -1 ; WX 333 ; N Iacute ; B -8 0 413 876 ;\nC -1 ; WX 667 ;"
 & " N Ccedilla ; B 66 -217 689 666 ;\nC -1 ; WX 722 ; N Odieresis ; B 60 -"
 & "18 699 818 ;\nC -1 ; WX 500 ; N Scaron ; B 17 -18 520 873 ;\nC -1 ; WX "
 & "611 ; N Edieresis ; B -1 0 634 818 ;\nC -1 ; WX 333 ; N Igrave ; B -8 0"
 & " 384 876 ;\nC -1 ; WX 500 ; N adieresis ; B 17 -11 489 606 ;\nC -1 ; WX"
 & " 722 ; N Ograve ; B 60 -18 699 876 ;\nC -1 ; WX 611 ; N Egrave ; B -1 0"
 & " 634 876 ;\nC -1 ; WX 556 ; N Ydieresis ; B 78 0 633 818 ;\nC -1 ; WX 7"
 & "60 ; N registered ; B 41 -18 719 666 ;\nC -1 ; WX 722 ; N Otilde ; B 60"
 & " -18 699 836 ;\nC -1 ; WX 750 ; N onequarter ; B 33 -10 736 676 ;\nC -1"
 & " ; WX 722 ; N Ugrave ; B 102 -18 765 876 ;\nC -1 ; WX 722 ; N Ucircumfl"
 & "ex ; B 102 -18 765 873 ;\nC -1 ; WX 611 ; N Thorn ; B 0 0 569 653 ;\nC "
 & "-1 ; WX 675 ; N divide ; B 86 -11 590 517 ;\nC -1 ; WX 611 ; N Atilde ;"
 & " B -51 0 566 836 ;\nC -1 ; WX 722 ; N Uacute ; B 102 -";

CONST E8_4 = 
   "18 765 876 ;\nC -1 ; WX 722 ; N Ocircumflex ; B 60 -18 699 873 ;\nC -1 "
 & "; WX 675 ; N logicalnot ; B 86 108 590 386 ;\nC -1 ; WX 611 ; N Aring ;"
 & " B -51 0 564 883 ;\nC -1 ; WX 278 ; N idieresis ; B 49 -11 353 606 ;\nC"
 & " -1 ; WX 278 ; N iacute ; B 49 -11 356 664 ;\nC -1 ; WX 500 ; N aacute "
 & "; B 17 -11 487 664 ;\nC -1 ; WX 675 ; N plusminus ; B 86 0 590 506 ;\nC"
 & " -1 ; WX 675 ; N multiply ; B 93 8 582 497 ;\nC -1 ; WX 722 ; N Udieres"
 & "is ; B 102 -18 765 818 ;\nC -1 ; WX 675 ; N minus ; B 86 220 590 286 ;\n"
 & "C -1 ; WX 300 ; N onesuperior ; B 43 271 284 676 ;\nC -1 ; WX 611 ; N E"
 & "acute ; B -1 0 634 876 ;\nC -1 ; WX 611 ; N Acircumflex ; B -51 0 564 8"
 & "73 ;\nC -1 ; WX 760 ; N copyright ; B 41 -18 719 666 ;\nC -1 ; WX 611 ;"
 & " N Agrave ; B -51 0 564 876 ;\nC -1 ; WX 500 ; N odieresis ; B 27 -11 4"
 & "89 606 ;\nC -1 ; WX 500 ; N oacute ; B 27 -11 487 664 ;\nC -1 ; WX 400 "
 & "; N degree ; B 101 390 387 676 ;\nC -1 ; WX 278 ; N igrave ; B 49 -11 2"
 & "84 664 ;\nC -1 ; WX 500 ; N mu ; B -30 -209 497 428 ;\nC -1 ; WX 722 ; "
 & "N Oacute ; B 60 -18 699 876 ;\nC -1 ; WX 500 ; N eth ; B 27 -11 482 683"
 & " ;\nC -1 ; WX 611 ; N Adieresis ; B -51 0 564 818 ;\nC -1 ; WX 556 ; N "
 & "Yacute ; B 78 0 633 876 ;\nC -1 ; WX 275 ; N brokenbar ; B 105 -18 171 "
 & "666 ;\nC -1 ; WX 750 ; N onehalf ; B 34 -10 749 676 ;\nEndCharMetrics\n"
 & "StartKernData\nStartKernPairs 283\n\nKPX A y -55\nKPX A w -55\nKPX A v "
 & "-55\nKPX A u -20\nKPX A quoteright -37\nKPX A quotedblright 0\nKPX A p "
 & "0\nKPX A Y -55\nKPX A W -95\nKPX A V -105\nKPX A U -50\nKPX A T -37\nKP"
 & "X A Q -40\nKPX A O -40\nKPX A G -35\nKPX A C -30\n\nKPX B period 0\nKPX"
 & " B comma 0\nKPX B U -10\nKPX B A -25\n\nKPX D period 0\nKPX D comma 0\n"
 & "KPX D Y -40\nKPX D W -40\nKPX D V -40\nKPX D A -35\n\nKPX F r -55\nKPX "
 & "F period -135\nKPX F o -105\nKPX F i -45\nKPX F e -75\nKPX F comma -135"
 & "\nKPX F a -75\nKPX F A -115\n\nKPX G period 0\nKPX G comma 0\n\nKPX J u"
 & " -35\nKPX J period -25\nKPX J o -25\nKPX J e -25\nKPX J comma -25\nKPX "
 & "J a -35\nKPX J A -40\n\nKPX K y -40\nKPX K u -40\nKPX K o -40\nKPX K e "
 & "-35\nKPX K O -50\n\nKPX L y -30\nKPX L quoteright -37\nKPX L quotedblri"
 & "ght 0\nKPX L Y -20\nKPX L W -5";

CONST E8_5 = 
   "5\nKPX L V -55\nKPX L T -20\n\nKPX N period 0\nKPX N comma 0\nKPX N A -"
 & "27\n\nKPX O period 0\nKPX O comma 0\nKPX O Y -50\nKPX O X -40\nKPX O W "
 & "-50\nKPX O V -50\nKPX O T -40\nKPX O A -55\n\nKPX P period -135\nKPX P "
 & "o -80\nKPX P e -80\nKPX P comma -135\nKPX P a -80\nKPX P A -90\n\nKPX Q"
 & " period 0\nKPX Q comma 0\nKPX Q U -10\n\nKPX R Y -18\nKPX R W -18\nKPX "
 & "R V -18\nKPX R U -40\nKPX R T 0\nKPX R O -40\n\nKPX S period 0\nKPX S c"
 & "omma 0\n\nKPX T y -74\nKPX T w -74\nKPX T u -55\nKPX T semicolon -65\nK"
 & "PX T r -55\nKPX T period -74\nKPX T o -92\nKPX T i -55\nKPX T hyphen -7"
 & "4\nKPX T h 0\nKPX T e -92\nKPX T comma -74\nKPX T colon -55\nKPX T a -9"
 & "2\nKPX T O -18\nKPX T A -50\n\nKPX U period -25\nKPX U comma -25\nKPX U"
 & " A -40\n\nKPX V u -74\nKPX V semicolon -74\nKPX V period -129\nKPX V o "
 & "-111\nKPX V i -74\nKPX V hyphen -55\nKPX V e -111\nKPX V comma -129\nKP"
 & "X V colon -65\nKPX V a -111\nKPX V O -30\nKPX V G 0\nKPX V A -60\n\nKPX"
 & " W y -70\nKPX W u -55\nKPX W semicolon -65\nKPX W period -92\nKPX W o -"
 & "92\nKPX W i -55\nKPX W hyphen -37\nKPX W h 0\nKPX W e -92\nKPX W comma "
 & "-92\nKPX W colon -65\nKPX W a -92\nKPX W O -25\nKPX W A -60\n\nKPX Y u "
 & "-92\nKPX Y semicolon -65\nKPX Y period -92\nKPX Y o -92\nKPX Y i -74\nK"
 & "PX Y hyphen -74\nKPX Y e -92\nKPX Y comma -92\nKPX Y colon -65\nKPX Y a"
 & " -92\nKPX Y O -15\nKPX Y A -50\n\nKPX a y 0\nKPX a w 0\nKPX a v 0\nKPX "
 & "a t 0\nKPX a p 0\nKPX a g -10\nKPX a b 0\n\nKPX b y 0\nKPX b v 0\nKPX b"
 & " u -20\nKPX b period -40\nKPX b l 0\nKPX b comma 0\nKPX b b 0\n\nKPX c "
 & "y 0\nKPX c period 0\nKPX c l 0\nKPX c k -20\nKPX c h -15\nKPX c comma 0"
 & "\n\nKPX colon space 0\n\nKPX comma space 0\nKPX comma quoteright -140\n"
 & "KPX comma quotedblright -140\n\nKPX d y 0\nKPX d w 0\nKPX d v 0\nKPX d "
 & "period 0\nKPX d d 0\nKPX d comma 0\n\nKPX e y -30\nKPX e x -20\nKPX e w"
 & " -15\nKPX e v -15\nKPX e period -15\nKPX e p 0\nKPX e g -40\nKPX e comm"
 & "a -10\nKPX e b 0\n\nKPX f quoteright 92\nKPX f quotedblright 0\nKPX f p"
 & "eriod -15\nKPX f o 0\nKPX f l 0\nKPX f i -20\nKPX f f -18\nKPX f e 0\nK"
 & "PX f dotlessi -60\nKPX f comma -10\nKPX f a 0\n\nKPX g y 0\nKPX g r 0\n"
 & "KPX g period -15\nKPX g o 0\nKPX g i 0\nKPX g g -10\nKPX g e -10\nKPX g"
 & " comma -10\nKPX g a 0\n\nKPX h y 0\n\nKPX";

CONST E8_6 = 
   " i v 0\n\nKPX k y -10\nKPX k o -10\nKPX k e -10\n\nKPX l y 0\nKPX l w 0"
 & "\n\nKPX m y 0\nKPX m u 0\n\nKPX n y 0\nKPX n v -40\nKPX n u 0\n\nKPX o "
 & "y 0\nKPX o x 0\nKPX o w 0\nKPX o v -10\nKPX o g -10\n\nKPX p y 0\n\nKPX"
 & " period quoteright -140\nKPX period quotedblright -140\n\nKPX quotedbll"
 & "eft quoteleft 0\nKPX quotedblleft A 0\n\nKPX quotedblright space 0\n\nK"
 & "PX quoteleft quoteleft -111\nKPX quoteleft A 0\n\nKPX quoteright v -10\n"
 & "KPX quoteright t -30\nKPX quoteright space -111\nKPX quoteright s -40\n"
 & "KPX quoteright r -25\nKPX quoteright quoteright -111\nKPX quoteright qu"
 & "otedblright 0\nKPX quoteright l 0\nKPX quoteright d -25\n\nKPX r y 0\nK"
 & "PX r v 0\nKPX r u 0\nKPX r t 0\nKPX r s -10\nKPX r r 0\nKPX r q -37\nKP"
 & "X r period -111\nKPX r p 0\nKPX r o -45\nKPX r n 0\nKPX r m 0\nKPX r l "
 & "0\nKPX r k 0\nKPX r i 0\nKPX r hyphen -20\nKPX r g -37\nKPX r e -37\nKP"
 & "X r d -37\nKPX r comma -111\nKPX r c -37\nKPX r a -15\n\nKPX s w 0\n\nK"
 & "PX space quoteleft 0\nKPX space quotedblleft 0\nKPX space Y -75\nKPX sp"
 & "ace W -40\nKPX space V -35\nKPX space T -18\nKPX space A -18\n\nKPX v p"
 & "eriod -74\nKPX v o 0\nKPX v e 0\nKPX v comma -74\nKPX v a 0\n\nKPX w pe"
 & "riod -74\nKPX w o 0\nKPX w h 0\nKPX w e 0\nKPX w comma -74\nKPX w a 0\n"
 & "\nKPX x e 0\n\nKPX y period -55\nKPX y o 0\nKPX y e 0\nKPX y comma -55\n"
 & "KPX y a 0\n\nKPX z o 0\nKPX z e 0\nEndKernPairs\nEndKernData\nStartComp"
 & "osites 58\nCC Aacute 2 ; PCC A 0 0 ; PCC acute 139 212 ;\nCC Acircumfle"
 & "x 2 ; PCC A 0 0 ; PCC circumflex 144 212 ;\nCC Adieresis 2 ; PCC A 0 0 "
 & "; PCC dieresis 139 212 ;\nCC Agrave 2 ; PCC A 0 0 ; PCC grave 149 212 ;"
 & "\nCC Aring 2 ; PCC A 0 0 ; PCC ring 129 192 ;\nCC Atilde 2 ; PCC A 0 0 "
 & "; PCC tilde 139 212 ;\nCC Ccedilla 2 ; PCC C 0 0 ; PCC cedilla 167 0 ;\n"
 & "CC Eacute 2 ; PCC E 0 0 ; PCC acute 149 212 ;\nCC Ecircumflex 2 ; PCC E"
 & " 0 0 ; PCC circumflex 169 212 ;\nCC Edieresis 2 ; PCC E 0 0 ; PCC diere"
 & "sis 159 212 ;\nCC Egrave 2 ; PCC E 0 0 ; PCC grave 149 212 ;\nCC Iacute"
 & " 2 ; PCC I 0 0 ; PCC acute 10 212 ;\nCC Icircumflex 2 ; PCC I 0 0 ; PCC"
 & " circumflex 40 212 ;\nCC Idieresis 2 ; PCC I 0 0 ; PCC dieresis 30 212 "
 & ";\nCC Igrave 2 ; PCC I 0 0 ; PCC grave 10 212 ;\nCC Ntild";

CONST E8_7 = 
   "e 2 ; PCC N 0 0 ; PCC tilde 177 212 ;\nCC Oacute 2 ; PCC O 0 0 ; PCC ac"
 & "ute 195 212 ;\nCC Ocircumflex 2 ; PCC O 0 0 ; PCC circumflex 230 212 ;\n"
 & "CC Odieresis 2 ; PCC O 0 0 ; PCC dieresis 230 212 ;\nCC Ograve 2 ; PCC "
 & "O 0 0 ; PCC grave 205 212 ;\nCC Otilde 2 ; PCC O 0 0 ; PCC tilde 215 21"
 & "2 ;\nCC Scaron 2 ; PCC S 0 0 ; PCC caron 94 212 ;\nCC Uacute 2 ; PCC U "
 & "0 0 ; PCC acute 195 212 ;\nCC Ucircumflex 2 ; PCC U 0 0 ; PCC circumfle"
 & "x 215 212 ;\nCC Udieresis 2 ; PCC U 0 0 ; PCC dieresis 225 212 ;\nCC Ug"
 & "rave 2 ; PCC U 0 0 ; PCC grave 215 212 ;\nCC Yacute 2 ; PCC Y 0 0 ; PCC"
 & " acute 132 212 ;\nCC Ydieresis 2 ; PCC Y 0 0 ; PCC dieresis 142 212 ;\n"
 & "CC Zcaron 2 ; PCC Z 0 0 ; PCC caron 112 212 ;\nCC aacute 2 ; PCC a 0 0 "
 & "; PCC acute 84 0 ;\nCC acircumflex 2 ; PCC a 0 0 ; PCC circumflex 84 0 "
 & ";\nCC adieresis 2 ; PCC a 0 0 ; PCC dieresis 84 0 ;\nCC agrave 2 ; PCC "
 & "a 0 0 ; PCC grave 84 0 ;\nCC aring 2 ; PCC a 0 0 ; PCC ring 84 0 ;\nCC "
 & "atilde 2 ; PCC a 0 0 ; PCC tilde 84 0 ;\nCC ccedilla 2 ; PCC c 0 0 ; PC"
 & "C cedilla 56 0 ;\nCC eacute 2 ; PCC e 0 0 ; PCC acute 56 0 ;\nCC ecircu"
 & "mflex 2 ; PCC e 0 0 ; PCC circumflex 56 0 ;\nCC edieresis 2 ; PCC e 0 0"
 & " ; PCC dieresis 46 0 ;\nCC egrave 2 ; PCC e 0 0 ; PCC grave 56 0 ;\nCC "
 & "iacute 2 ; PCC dotlessi 0 0 ; PCC acute -47 0 ;\nCC icircumflex 2 ; PCC"
 & " dotlessi 0 0 ; PCC circumflex -57 0 ;\nCC idieresis 2 ; PCC dotlessi 0"
 & " 0 ; PCC dieresis -52 0 ;\nCC igrave 2 ; PCC dotlessi 0 0 ; PCC grave -"
 & "27 0 ;\nCC ntilde 2 ; PCC n 0 0 ; PCC tilde 49 0 ;\nCC oacute 2 ; PCC o"
 & " 0 0 ; PCC acute 84 0 ;\nCC ocircumflex 2 ; PCC o 0 0 ; PCC circumflex "
 & "74 0 ;\nCC odieresis 2 ; PCC o 0 0 ; PCC dieresis 84 0 ;\nCC ograve 2 ;"
 & " PCC o 0 0 ; PCC grave 84 0 ;\nCC otilde 2 ; PCC o 0 0 ; PCC tilde 69 0"
 & " ;\nCC scaron 2 ; PCC s 0 0 ; PCC caron 28 0 ;\nCC uacute 2 ; PCC u 0 0"
 & " ; PCC acute 74 0 ;\nCC ucircumflex 2 ; PCC u 0 0 ; PCC circumflex 74 0"
 & " ;\nCC udieresis 2 ; PCC u 0 0 ; PCC dieresis 74 0 ;\nCC ugrave 2 ; PCC"
 & " u 0 0 ; PCC grave 84 0 ;\nCC yacute 2 ; PCC y 0 0 ; PCC acute 56 0 ;\n"
 & "CC ydieresis 2 ; PCC y 0 0 ; PCC dieresis 36 0 ;\nCC ";

CONST E8_8 = 
   "zcaron 2 ; PCC z 0 0 ; PCC caron 8 0 ;\nEndComposites\nEndFontMetrics\n"
;

CONST E9 = 
   "StartFontMetrics 2.0\nComment Copyright (c) 1985, 1987, 1989, 1990 Adob"
 & "e Systems Incorporated.  All Rights Reserved.\nComment Creation Date: T"
 & "hu Mar 15 10:44:33 1990\nComment UniqueID 28371\nComment VMusage 7614 4"
 & "3068\nFontName Helvetica-BoldOblique\nFullName Helvetica Bold Oblique\n"
 & "FamilyName Helvetica\nWeight Bold\nItalicAngle -12\nIsFixedPitch false\n"
 & "FontBBox -174 -228 1114 962\nUnderlinePosition -100\nUnderlineThickness"
 & " 50\nVersion 001.007\nNotice Copyright (c) 1985, 1987, 1989, 1990 Adobe"
 & " Systems Incorporated.  All Rights Reserved.Helvetica is a trademark of"
 & " Linotype AG and/or its subsidiaries.\nEncodingScheme AdobeStandardEnco"
 & "ding\nCapHeight 718\nXHeight 532\nAscender 718\nDescender -207\nStartCh"
 & "arMetrics 228\nC 32 ; WX 278 ; N space ; B 0 0 0 0 ;\nC 33 ; WX 333 ; N"
 & " exclam ; B 94 0 397 718 ;\nC 34 ; WX 474 ; N quotedbl ; B 193 447 529 "
 & "718 ;\nC 35 ; WX 556 ; N numbersign ; B 60 0 644 698 ;\nC 36 ; WX 556 ;"
 & " N dollar ; B 67 -115 622 775 ;\nC 37 ; WX 889 ; N percent ; B 136 -19 "
 & "901 710 ;\nC 38 ; WX 722 ; N ampersand ; B 89 -19 732 718 ;\nC 39 ; WX "
 & "278 ; N quoteright ; B 167 445 362 718 ;\nC 40 ; WX 333 ; N parenleft ;"
 & " B 76 -208 470 734 ;\nC 41 ; WX 333 ; N parenright ; B -25 -208 369 734"
 & " ;\nC 42 ; WX 389 ; N asterisk ; B 146 387 481 718 ;\nC 43 ; WX 584 ; N"
 & " plus ; B 82 0 610 506 ;\nC 44 ; WX 278 ; N comma ; B 28 -168 245 146 ;"
 & "\nC 45 ; WX 333 ; N hyphen ; B 73 215 379 345 ;\nC 46 ; WX 278 ; N peri"
 & "od ; B 64 0 245 146 ;\nC 47 ; WX 278 ; N slash ; B -37 -19 468 737 ;\nC"
 & " 48 ; WX 556 ; N zero ; B 86 -19 617 710 ;\nC 49 ; WX 556 ; N one ; B 1"
 & "73 0 529 710 ;\nC 50 ; WX 556 ; N two ; B 26 0 619 710 ;\nC 51 ; WX 556"
 & " ; N three ; B 65 -19 608 710 ;\nC 52 ; WX 556 ; N four ; B 60 0 598 71"
 & "0 ;\nC 53 ; WX 556 ; N five ; B 64 -19 636 698 ;\nC 54 ; WX 556 ; N six"
 & " ; B 85 -19 619 710 ;\nC 55 ; WX 556 ; N seven ; B 125 0 676 698 ;\nC 5"
 & "6 ; WX 556 ; N eight ; B 69 -19 616 710 ;\nC 57 ; WX 556 ; N nine ; B 7"
 & "8 -19 615 710 ;\nC 58 ; WX 333 ; N colon ; B 92 0 351 512 ;\nC 59 ; WX "
 & "333 ; N semicolon ; B 56 -168 351 512 ;\nC 60 ; WX 584 ; N le";

CONST E9_0 = 
   "ss ; B 82 -8 655 514 ;\nC 61 ; WX 584 ; N equal ; B 58 87 633 419 ;\nC "
 & "62 ; WX 584 ; N greater ; B 36 -8 609 514 ;\nC 63 ; WX 611 ; N question"
 & " ; B 165 0 671 727 ;\nC 64 ; WX 975 ; N at ; B 186 -19 954 737 ;\nC 65 "
 & "; WX 722 ; N A ; B 20 0 702 718 ;\nC 66 ; WX 722 ; N B ; B 76 0 764 718"
 & " ;\nC 67 ; WX 722 ; N C ; B 107 -19 789 737 ;\nC 68 ; WX 722 ; N D ; B "
 & "76 0 777 718 ;\nC 69 ; WX 667 ; N E ; B 76 0 757 718 ;\nC 70 ; WX 611 ;"
 & " N F ; B 76 0 740 718 ;\nC 71 ; WX 778 ; N G ; B 108 -19 817 737 ;\nC 7"
 & "2 ; WX 722 ; N H ; B 71 0 804 718 ;\nC 73 ; WX 278 ; N I ; B 64 0 367 7"
 & "18 ;\nC 74 ; WX 556 ; N J ; B 60 -18 637 718 ;\nC 75 ; WX 722 ; N K ; B"
 & " 87 0 858 718 ;\nC 76 ; WX 611 ; N L ; B 76 0 611 718 ;\nC 77 ; WX 833 "
 & "; N M ; B 69 0 918 718 ;\nC 78 ; WX 722 ; N N ; B 69 0 807 718 ;\nC 79 "
 & "; WX 778 ; N O ; B 107 -19 823 737 ;\nC 80 ; WX 667 ; N P ; B 76 0 738 "
 & "718 ;\nC 81 ; WX 778 ; N Q ; B 107 -52 823 737 ;\nC 82 ; WX 722 ; N R ;"
 & " B 76 0 778 718 ;\nC 83 ; WX 667 ; N S ; B 81 -19 718 737 ;\nC 84 ; WX "
 & "611 ; N T ; B 140 0 751 718 ;\nC 85 ; WX 722 ; N U ; B 116 -19 804 718 "
 & ";\nC 86 ; WX 667 ; N V ; B 172 0 801 718 ;\nC 87 ; WX 944 ; N W ; B 169"
 & " 0 1082 718 ;\nC 88 ; WX 667 ; N X ; B 14 0 791 718 ;\nC 89 ; WX 667 ; "
 & "N Y ; B 168 0 806 718 ;\nC 90 ; WX 611 ; N Z ; B 25 0 737 718 ;\nC 91 ;"
 & " WX 333 ; N bracketleft ; B 21 -196 462 722 ;\nC 92 ; WX 278 ; N backsl"
 & "ash ; B 124 -19 307 737 ;\nC 93 ; WX 333 ; N bracketright ; B -18 -196 "
 & "423 722 ;\nC 94 ; WX 584 ; N asciicircum ; B 131 323 591 698 ;\nC 95 ; "
 & "WX 556 ; N underscore ; B -27 -125 540 -75 ;\nC 96 ; WX 278 ; N quotele"
 & "ft ; B 165 454 361 727 ;\nC 97 ; WX 556 ; N a ; B 55 -14 583 546 ;\nC 9"
 & "8 ; WX 611 ; N b ; B 61 -14 645 718 ;\nC 99 ; WX 556 ; N c ; B 79 -14 5"
 & "99 546 ;\nC 100 ; WX 611 ; N d ; B 82 -14 704 718 ;\nC 101 ; WX 556 ; N"
 & " e ; B 70 -14 593 546 ;\nC 102 ; WX 333 ; N f ; B 87 0 469 727 ; L i fi"
 & " ; L l fl ;\nC 103 ; WX 611 ; N g ; B 38 -217 666 546 ;\nC 104 ; WX 611"
 & " ; N h ; B 65 0 629 718 ;\nC 105 ; WX 278 ; N i ; B 69 0 363 725 ;\nC 1"
 & "06 ; WX 278 ; N j ; B -42 -214 363 725 ;\nC 107 ; WX 556 ; ";

CONST E9_1 = 
   "N k ; B 69 0 670 718 ;\nC 108 ; WX 278 ; N l ; B 69 0 362 718 ;\nC 109 "
 & "; WX 889 ; N m ; B 64 0 909 546 ;\nC 110 ; WX 611 ; N n ; B 65 0 629 54"
 & "6 ;\nC 111 ; WX 611 ; N o ; B 82 -14 643 546 ;\nC 112 ; WX 611 ; N p ; "
 & "B 18 -207 645 546 ;\nC 113 ; WX 611 ; N q ; B 80 -207 665 546 ;\nC 114 "
 & "; WX 389 ; N r ; B 64 0 489 546 ;\nC 115 ; WX 556 ; N s ; B 63 -14 584 "
 & "546 ;\nC 116 ; WX 333 ; N t ; B 100 -6 422 676 ;\nC 117 ; WX 611 ; N u "
 & "; B 98 -14 658 532 ;\nC 118 ; WX 556 ; N v ; B 126 0 656 532 ;\nC 119 ;"
 & " WX 778 ; N w ; B 123 0 882 532 ;\nC 120 ; WX 556 ; N x ; B 15 0 648 53"
 & "2 ;\nC 121 ; WX 556 ; N y ; B 42 -214 652 532 ;\nC 122 ; WX 500 ; N z ;"
 & " B 20 0 583 532 ;\nC 123 ; WX 389 ; N braceleft ; B 94 -196 518 722 ;\n"
 & "C 124 ; WX 280 ; N bar ; B 80 -19 353 737 ;\nC 125 ; WX 389 ; N braceri"
 & "ght ; B -18 -196 407 722 ;\nC 126 ; WX 584 ; N asciitilde ; B 115 163 5"
 & "77 343 ;\nC 161 ; WX 333 ; N exclamdown ; B 50 -186 353 532 ;\nC 162 ; "
 & "WX 556 ; N cent ; B 79 -118 599 628 ;\nC 163 ; WX 556 ; N sterling ; B "
 & "50 -16 635 718 ;\nC 164 ; WX 167 ; N fraction ; B -174 -19 487 710 ;\nC"
 & " 165 ; WX 556 ; N yen ; B 60 0 713 698 ;\nC 166 ; WX 556 ; N florin ; B"
 & " -50 -210 669 737 ;\nC 167 ; WX 556 ; N section ; B 61 -184 598 727 ;\n"
 & "C 168 ; WX 556 ; N currency ; B 27 76 680 636 ;\nC 169 ; WX 238 ; N quo"
 & "tesingle ; B 165 447 321 718 ;\nC 170 ; WX 500 ; N quotedblleft ; B 160"
 & " 454 588 727 ;\nC 171 ; WX 556 ; N guillemotleft ; B 135 76 571 484 ;\n"
 & "C 172 ; WX 333 ; N guilsinglleft ; B 130 76 353 484 ;\nC 173 ; WX 333 ;"
 & " N guilsinglright ; B 99 76 322 484 ;\nC 174 ; WX 611 ; N fi ; B 87 0 6"
 & "96 727 ;\nC 175 ; WX 611 ; N fl ; B 87 0 695 727 ;\nC 177 ; WX 556 ; N "
 & "endash ; B 48 227 627 333 ;\nC 178 ; WX 556 ; N dagger ; B 118 -171 626"
 & " 718 ;\nC 179 ; WX 556 ; N daggerdbl ; B 46 -171 628 718 ;\nC 180 ; WX "
 & "278 ; N periodcentered ; B 110 172 276 334 ;\nC 182 ; WX 556 ; N paragr"
 & "aph ; B 98 -191 688 700 ;\nC 183 ; WX 350 ; N bullet ; B 83 194 420 524"
 & " ;\nC 184 ; WX 278 ; N quotesinglbase ; B 41 -146 236 127 ;\nC 185 ; WX"
 & " 500 ; N quotedblbase ; B 36 -146 463 127 ;\nC 186 ; WX";

CONST E9_2 = 
   " 500 ; N quotedblright ; B 162 445 589 718 ;\nC 187 ; WX 556 ; N guille"
 & "motright ; B 104 76 540 484 ;\nC 188 ; WX 1000 ; N ellipsis ; B 92 0 93"
 & "9 146 ;\nC 189 ; WX 1000 ; N perthousand ; B 76 -19 1038 710 ;\nC 191 ;"
 & " WX 611 ; N questiondown ; B 53 -195 559 532 ;\nC 193 ; WX 333 ; N grav"
 & "e ; B 136 604 353 750 ;\nC 194 ; WX 333 ; N acute ; B 236 604 515 750 ;"
 & "\nC 195 ; WX 333 ; N circumflex ; B 118 604 471 750 ;\nC 196 ; WX 333 ;"
 & " N tilde ; B 113 610 507 737 ;\nC 197 ; WX 333 ; N macron ; B 122 604 4"
 & "83 678 ;\nC 198 ; WX 333 ; N breve ; B 156 604 494 750 ;\nC 199 ; WX 33"
 & "3 ; N dotaccent ; B 235 614 385 729 ;\nC 200 ; WX 333 ; N dieresis ; B "
 & "137 614 482 729 ;\nC 202 ; WX 333 ; N ring ; B 200 568 420 776 ;\nC 203"
 & " ; WX 333 ; N cedilla ; B -37 -228 220 0 ;\nC 205 ; WX 333 ; N hungarum"
 & "laut ; B 137 604 645 750 ;\nC 206 ; WX 333 ; N ogonek ; B 41 -228 264 0"
 & " ;\nC 207 ; WX 333 ; N caron ; B 149 604 502 750 ;\nC 208 ; WX 1000 ; N"
 & " emdash ; B 48 227 1071 333 ;\nC 225 ; WX 1000 ; N AE ; B 5 0 1100 718 "
 & ";\nC 227 ; WX 370 ; N ordfeminine ; B 92 276 465 737 ;\nC 232 ; WX 611 "
 & "; N Lslash ; B 34 0 611 718 ;\nC 233 ; WX 778 ; N Oslash ; B 35 -27 894"
 & " 745 ;\nC 234 ; WX 1000 ; N OE ; B 99 -19 1114 737 ;\nC 235 ; WX 365 ; "
 & "N ordmasculine ; B 92 276 485 737 ;\nC 241 ; WX 889 ; N ae ; B 56 -14 9"
 & "23 546 ;\nC 245 ; WX 278 ; N dotlessi ; B 69 0 322 532 ;\nC 248 ; WX 27"
 & "8 ; N lslash ; B 40 0 407 718 ;\nC 249 ; WX 611 ; N oslash ; B 22 -29 7"
 & "01 560 ;\nC 250 ; WX 944 ; N oe ; B 82 -14 977 546 ;\nC 251 ; WX 611 ; "
 & "N germandbls ; B 69 -14 657 731 ;\nC -1 ; WX 611 ; N Zcaron ; B 25 0 73"
 & "7 936 ;\nC -1 ; WX 556 ; N ccedilla ; B 79 -228 599 546 ;\nC -1 ; WX 55"
 & "6 ; N ydieresis ; B 42 -214 652 729 ;\nC -1 ; WX 556 ; N atilde ; B 55 "
 & "-14 619 737 ;\nC -1 ; WX 278 ; N icircumflex ; B 69 0 444 750 ;\nC -1 ;"
 & " WX 333 ; N threesuperior ; B 91 271 441 710 ;\nC -1 ; WX 556 ; N ecirc"
 & "umflex ; B 70 -14 593 750 ;\nC -1 ; WX 611 ; N thorn ; B 18 -208 645 71"
 & "8 ;\nC -1 ; WX 556 ; N egrave ; B 70 -14 593 750 ;\nC -1 ; WX 333 ; N t"
 & "wosuperior ; B 69 283 449 710 ;\nC -1 ; WX 556 ; N ea";

CONST E9_3 = 
   "cute ; B 70 -14 627 750 ;\nC -1 ; WX 611 ; N otilde ; B 82 -14 646 737 "
 & ";\nC -1 ; WX 722 ; N Aacute ; B 20 0 750 936 ;\nC -1 ; WX 611 ; N ocirc"
 & "umflex ; B 82 -14 643 750 ;\nC -1 ; WX 556 ; N yacute ; B 42 -214 652 7"
 & "50 ;\nC -1 ; WX 611 ; N udieresis ; B 98 -14 658 729 ;\nC -1 ; WX 834 ;"
 & " N threequarters ; B 99 -19 839 710 ;\nC -1 ; WX 556 ; N acircumflex ; "
 & "B 55 -14 583 750 ;\nC -1 ; WX 722 ; N Eth ; B 62 0 777 718 ;\nC -1 ; WX"
 & " 556 ; N edieresis ; B 70 -14 594 729 ;\nC -1 ; WX 611 ; N ugrave ; B 9"
 & "8 -14 658 750 ;\nC -1 ; WX 1000 ; N trademark ; B 179 306 1109 718 ;\nC"
 & " -1 ; WX 611 ; N ograve ; B 82 -14 643 750 ;\nC -1 ; WX 556 ; N scaron "
 & "; B 63 -14 614 750 ;\nC -1 ; WX 278 ; N Idieresis ; B 64 0 494 915 ;\nC"
 & " -1 ; WX 611 ; N uacute ; B 98 -14 658 750 ;\nC -1 ; WX 556 ; N agrave "
 & "; B 55 -14 583 750 ;\nC -1 ; WX 611 ; N ntilde ; B 65 0 646 737 ;\nC -1"
 & " ; WX 556 ; N aring ; B 55 -14 583 776 ;\nC -1 ; WX 500 ; N zcaron ; B "
 & "20 0 586 750 ;\nC -1 ; WX 278 ; N Icircumflex ; B 64 0 484 936 ;\nC -1 "
 & "; WX 722 ; N Ntilde ; B 69 0 807 923 ;\nC -1 ; WX 611 ; N ucircumflex ;"
 & " B 98 -14 658 750 ;\nC -1 ; WX 667 ; N Ecircumflex ; B 76 0 757 936 ;\n"
 & "C -1 ; WX 278 ; N Iacute ; B 64 0 528 936 ;\nC -1 ; WX 722 ; N Ccedilla"
 & " ; B 107 -228 789 737 ;\nC -1 ; WX 778 ; N Odieresis ; B 107 -19 823 91"
 & "5 ;\nC -1 ; WX 667 ; N Scaron ; B 81 -19 718 936 ;\nC -1 ; WX 667 ; N E"
 & "dieresis ; B 76 0 757 915 ;\nC -1 ; WX 278 ; N Igrave ; B 64 0 367 936 "
 & ";\nC -1 ; WX 556 ; N adieresis ; B 55 -14 594 729 ;\nC -1 ; WX 778 ; N "
 & "Ograve ; B 107 -19 823 936 ;\nC -1 ; WX 667 ; N Egrave ; B 76 0 757 936"
 & " ;\nC -1 ; WX 667 ; N Ydieresis ; B 168 0 806 915 ;\nC -1 ; WX 737 ; N "
 & "registered ; B 55 -19 834 737 ;\nC -1 ; WX 778 ; N Otilde ; B 107 -19 8"
 & "23 923 ;\nC -1 ; WX 834 ; N onequarter ; B 132 -19 806 710 ;\nC -1 ; WX"
 & " 722 ; N Ugrave ; B 116 -19 804 936 ;\nC -1 ; WX 722 ; N Ucircumflex ; "
 & "B 116 -19 804 936 ;\nC -1 ; WX 667 ; N Thorn ; B 76 0 716 718 ;\nC -1 ;"
 & " WX 584 ; N divide ; B 82 -42 610 548 ;\nC -1 ; WX 722 ; N Atilde ; B 2"
 & "0 0 741 923 ;\nC -1 ; WX 722 ; N Uacute ; B 116 -19 80";

CONST E9_4 = 
   "4 936 ;\nC -1 ; WX 778 ; N Ocircumflex ; B 107 -19 823 936 ;\nC -1 ; WX"
 & " 584 ; N logicalnot ; B 105 108 633 419 ;\nC -1 ; WX 722 ; N Aring ; B "
 & "20 0 702 962 ;\nC -1 ; WX 278 ; N idieresis ; B 69 0 455 729 ;\nC -1 ; "
 & "WX 278 ; N iacute ; B 69 0 488 750 ;\nC -1 ; WX 556 ; N aacute ; B 55 -"
 & "14 627 750 ;\nC -1 ; WX 584 ; N plusminus ; B 40 0 625 506 ;\nC -1 ; WX"
 & " 584 ; N multiply ; B 57 1 635 505 ;\nC -1 ; WX 722 ; N Udieresis ; B 1"
 & "16 -19 804 915 ;\nC -1 ; WX 584 ; N minus ; B 82 197 610 309 ;\nC -1 ; "
 & "WX 333 ; N onesuperior ; B 148 283 388 710 ;\nC -1 ; WX 667 ; N Eacute "
 & "; B 76 0 757 936 ;\nC -1 ; WX 722 ; N Acircumflex ; B 20 0 706 936 ;\nC"
 & " -1 ; WX 737 ; N copyright ; B 56 -19 835 737 ;\nC -1 ; WX 722 ; N Agra"
 & "ve ; B 20 0 702 936 ;\nC -1 ; WX 611 ; N odieresis ; B 82 -14 643 729 ;"
 & "\nC -1 ; WX 611 ; N oacute ; B 82 -14 654 750 ;\nC -1 ; WX 400 ; N degr"
 & "ee ; B 175 426 467 712 ;\nC -1 ; WX 278 ; N igrave ; B 69 0 326 750 ;\n"
 & "C -1 ; WX 611 ; N mu ; B 22 -207 658 532 ;\nC -1 ; WX 778 ; N Oacute ; "
 & "B 107 -19 823 936 ;\nC -1 ; WX 611 ; N eth ; B 82 -14 670 737 ;\nC -1 ;"
 & " WX 722 ; N Adieresis ; B 20 0 716 915 ;\nC -1 ; WX 667 ; N Yacute ; B "
 & "168 0 806 936 ;\nC -1 ; WX 280 ; N brokenbar ; B 80 -19 353 737 ;\nC -1"
 & " ; WX 834 ; N onehalf ; B 132 -19 858 710 ;\nEndCharMetrics\nStartKernD"
 & "ata\nStartKernPairs 209\n\nKPX A y -30\nKPX A w -30\nKPX A v -40\nKPX A"
 & " u -30\nKPX A Y -110\nKPX A W -60\nKPX A V -80\nKPX A U -50\nKPX A T -9"
 & "0\nKPX A Q -40\nKPX A O -40\nKPX A G -50\nKPX A C -40\n\nKPX B U -10\nK"
 & "PX B A -30\n\nKPX D period -30\nKPX D comma -30\nKPX D Y -70\nKPX D W -"
 & "40\nKPX D V -40\nKPX D A -40\n\nKPX F period -100\nKPX F comma -100\nKP"
 & "X F a -20\nKPX F A -80\n\nKPX J u -20\nKPX J period -20\nKPX J comma -2"
 & "0\nKPX J A -20\n\nKPX K y -40\nKPX K u -30\nKPX K o -35\nKPX K e -15\nK"
 & "PX K O -30\n\nKPX L y -30\nKPX L quoteright -140\nKPX L quotedblright -"
 & "140\nKPX L Y -120\nKPX L W -80\nKPX L V -110\nKPX L T -90\n\nKPX O peri"
 & "od -40\nKPX O comma -40\nKPX O Y -70\nKPX O X -50\nKPX O W -50\nKPX O V"
 & " -50\nKPX O T -40\nKPX O A -50\n\nKPX P period -120\nKPX P o -40\nKPX P"
 & " e -30\nKPX P comma -120\nKPX P a";

CONST E9_5 = 
   " -30\nKPX P A -100\n\nKPX Q period 20\nKPX Q comma 20\nKPX Q U -10\n\nK"
 & "PX R Y -50\nKPX R W -40\nKPX R V -50\nKPX R U -20\nKPX R T -20\nKPX R O"
 & " -20\n\nKPX T y -60\nKPX T w -60\nKPX T u -90\nKPX T semicolon -40\nKPX"
 & " T r -80\nKPX T period -80\nKPX T o -80\nKPX T hyphen -120\nKPX T e -60"
 & "\nKPX T comma -80\nKPX T colon -40\nKPX T a -80\nKPX T O -40\nKPX T A -"
 & "90\n\nKPX U period -30\nKPX U comma -30\nKPX U A -50\n\nKPX V u -60\nKP"
 & "X V semicolon -40\nKPX V period -120\nKPX V o -90\nKPX V hyphen -80\nKP"
 & "X V e -50\nKPX V comma -120\nKPX V colon -40\nKPX V a -60\nKPX V O -50\n"
 & "KPX V G -50\nKPX V A -80\n\nKPX W y -20\nKPX W u -45\nKPX W semicolon -"
 & "10\nKPX W period -80\nKPX W o -60\nKPX W hyphen -40\nKPX W e -35\nKPX W"
 & " comma -80\nKPX W colon -10\nKPX W a -40\nKPX W O -20\nKPX W A -60\n\nK"
 & "PX Y u -100\nKPX Y semicolon -50\nKPX Y period -100\nKPX Y o -100\nKPX "
 & "Y e -80\nKPX Y comma -100\nKPX Y colon -50\nKPX Y a -90\nKPX Y O -70\nK"
 & "PX Y A -110\n\nKPX a y -20\nKPX a w -15\nKPX a v -15\nKPX a g -10\n\nKP"
 & "X b y -20\nKPX b v -20\nKPX b u -20\nKPX b l -10\n\nKPX c y -10\nKPX c "
 & "l -20\nKPX c k -20\nKPX c h -10\n\nKPX colon space -40\n\nKPX comma spa"
 & "ce -40\nKPX comma quoteright -120\nKPX comma quotedblright -120\n\nKPX "
 & "d y -15\nKPX d w -15\nKPX d v -15\nKPX d d -10\n\nKPX e y -15\nKPX e x "
 & "-15\nKPX e w -15\nKPX e v -15\nKPX e period 20\nKPX e comma 10\n\nKPX f"
 & " quoteright 30\nKPX f quotedblright 30\nKPX f period -10\nKPX f o -20\n"
 & "KPX f e -10\nKPX f comma -10\n\nKPX g g -10\nKPX g e 10\n\nKPX h y -20\n"
 & "\nKPX k o -15\n\nKPX l y -15\nKPX l w -15\n\nKPX m y -30\nKPX m u -20\n"
 & "\nKPX n y -20\nKPX n v -40\nKPX n u -10\n\nKPX o y -20\nKPX o x -30\nKP"
 & "X o w -15\nKPX o v -20\n\nKPX p y -15\n\nKPX period space -40\nKPX peri"
 & "od quoteright -120\nKPX period quotedblright -120\n\nKPX quotedblright "
 & "space -80\n\nKPX quoteleft quoteleft -46\n\nKPX quoteright v -20\nKPX q"
 & "uoteright space -80\nKPX quoteright s -60\nKPX quoteright r -40\nKPX qu"
 & "oteright quoteright -46\nKPX quoteright l -20\nKPX quoteright d -80\n\n"
 & "KPX r y 10\nKPX r v 10\nKPX r t 20\nKPX r s -15\nKPX r q -20\nKPX r per"
 & "iod -60\nKPX r o -20\nKPX r hyphen -20\nKPX r g -15\nKPX r d -20\nKPX r"
 & " comma -60\nKPX r c -20\n\nKPX ";

CONST E9_6 = 
   "s w -15\n\nKPX semicolon space -40\n\nKPX space quoteleft -60\nKPX spac"
 & "e quotedblleft -80\nKPX space Y -120\nKPX space W -80\nKPX space V -80\n"
 & "KPX space T -100\n\nKPX v period -80\nKPX v o -30\nKPX v comma -80\nKPX"
 & " v a -20\n\nKPX w period -40\nKPX w o -20\nKPX w comma -40\n\nKPX x e -"
 & "10\n\nKPX y period -80\nKPX y o -25\nKPX y e -10\nKPX y comma -80\nKPX "
 & "y a -30\n\nKPX z e 10\nEndKernPairs\nEndKernData\nStartComposites 58\nC"
 & "C Aacute 2 ; PCC A 0 0 ; PCC acute 235 186 ;\nCC Acircumflex 2 ; PCC A "
 & "0 0 ; PCC circumflex 235 186 ;\nCC Adieresis 2 ; PCC A 0 0 ; PCC dieres"
 & "is 235 186 ;\nCC Agrave 2 ; PCC A 0 0 ; PCC grave 235 186 ;\nCC Aring 2"
 & " ; PCC A 0 0 ; PCC ring 235 186 ;\nCC Atilde 2 ; PCC A 0 0 ; PCC tilde "
 & "235 186 ;\nCC Ccedilla 2 ; PCC C 0 0 ; PCC cedilla 215 0 ;\nCC Eacute 2"
 & " ; PCC E 0 0 ; PCC acute 207 186 ;\nCC Ecircumflex 2 ; PCC E 0 0 ; PCC "
 & "circumflex 207 186 ;\nCC Edieresis 2 ; PCC E 0 0 ; PCC dieresis 207 186"
 & " ;\nCC Egrave 2 ; PCC E 0 0 ; PCC grave 207 186 ;\nCC Iacute 2 ; PCC I "
 & "0 0 ; PCC acute 13 186 ;\nCC Icircumflex 2 ; PCC I 0 0 ; PCC circumflex"
 & " 13 186 ;\nCC Idieresis 2 ; PCC I 0 0 ; PCC dieresis 13 186 ;\nCC Igrav"
 & "e 2 ; PCC I 0 0 ; PCC grave 13 186 ;\nCC Ntilde 2 ; PCC N 0 0 ; PCC til"
 & "de 235 186 ;\nCC Oacute 2 ; PCC O 0 0 ; PCC acute 263 186 ;\nCC Ocircum"
 & "flex 2 ; PCC O 0 0 ; PCC circumflex 263 186 ;\nCC Odieresis 2 ; PCC O 0"
 & " 0 ; PCC dieresis 263 186 ;\nCC Ograve 2 ; PCC O 0 0 ; PCC grave 263 18"
 & "6 ;\nCC Otilde 2 ; PCC O 0 0 ; PCC tilde 263 186 ;\nCC Scaron 2 ; PCC S"
 & " 0 0 ; PCC caron 207 186 ;\nCC Uacute 2 ; PCC U 0 0 ; PCC acute 235 186"
 & " ;\nCC Ucircumflex 2 ; PCC U 0 0 ; PCC circumflex 235 186 ;\nCC Udieres"
 & "is 2 ; PCC U 0 0 ; PCC dieresis 235 186 ;\nCC Ugrave 2 ; PCC U 0 0 ; PC"
 & "C grave 235 186 ;\nCC Yacute 2 ; PCC Y 0 0 ; PCC acute 207 186 ;\nCC Yd"
 & "ieresis 2 ; PCC Y 0 0 ; PCC dieresis 207 186 ;\nCC Zcaron 2 ; PCC Z 0 0"
 & " ; PCC caron 179 186 ;\nCC aacute 2 ; PCC a 0 0 ; PCC acute 112 0 ;\nCC"
 & " acircumflex 2 ; PCC a 0 0 ; PCC circumflex 112 0 ;\nCC adieresis 2 ; P"
 & "CC a 0 0 ; PCC dieresis 112 0 ;\nCC agrave 2 ; PCC a 0 0 ; PCC grave 11"
 & "2 0 ";

CONST E9_7 = 
   ";\nCC aring 2 ; PCC a 0 0 ; PCC ring 112 0 ;\nCC atilde 2 ; PCC a 0 0 ;"
 & " PCC tilde 112 0 ;\nCC ccedilla 2 ; PCC c 0 0 ; PCC cedilla 132 0 ;\nCC"
 & " eacute 2 ; PCC e 0 0 ; PCC acute 112 0 ;\nCC ecircumflex 2 ; PCC e 0 0"
 & " ; PCC circumflex 112 0 ;\nCC edieresis 2 ; PCC e 0 0 ; PCC dieresis 11"
 & "2 0 ;\nCC egrave 2 ; PCC e 0 0 ; PCC grave 112 0 ;\nCC iacute 2 ; PCC d"
 & "otlessi 0 0 ; PCC acute -27 0 ;\nCC icircumflex 2 ; PCC dotlessi 0 0 ; "
 & "PCC circumflex -27 0 ;\nCC idieresis 2 ; PCC dotlessi 0 0 ; PCC dieresi"
 & "s -27 0 ;\nCC igrave 2 ; PCC dotlessi 0 0 ; PCC grave -27 0 ;\nCC ntild"
 & "e 2 ; PCC n 0 0 ; PCC tilde 139 0 ;\nCC oacute 2 ; PCC o 0 0 ; PCC acut"
 & "e 139 0 ;\nCC ocircumflex 2 ; PCC o 0 0 ; PCC circumflex 139 0 ;\nCC od"
 & "ieresis 2 ; PCC o 0 0 ; PCC dieresis 139 0 ;\nCC ograve 2 ; PCC o 0 0 ;"
 & " PCC grave 139 0 ;\nCC otilde 2 ; PCC o 0 0 ; PCC tilde 139 0 ;\nCC sca"
 & "ron 2 ; PCC s 0 0 ; PCC caron 112 0 ;\nCC uacute 2 ; PCC u 0 0 ; PCC ac"
 & "ute 139 0 ;\nCC ucircumflex 2 ; PCC u 0 0 ; PCC circumflex 139 0 ;\nCC "
 & "udieresis 2 ; PCC u 0 0 ; PCC dieresis 139 0 ;\nCC ugrave 2 ; PCC u 0 0"
 & " ; PCC grave 139 0 ;\nCC yacute 2 ; PCC y 0 0 ; PCC acute 112 0 ;\nCC y"
 & "dieresis 2 ; PCC y 0 0 ; PCC dieresis 112 0 ;\nCC zcaron 2 ; PCC z 0 0 "
 & "; PCC caron 84 0 ;\nEndComposites\nEndFontMetrics\n";

CONST E10 = 
   "# Last modified on Wed Dec 21 11:02:12 PST 1994 by heydon\n#\n# This fi"
 & "le maps character names to their octal codes for the\n# PostScript symb"
 & "ol character set encoding. See section E.5 of the\n# \"PostScript Langu"
 & "age Reference Manual\", 2nd Edition, pp 604-605.\n\n# Names mapped to n"
 & "egative values are unendcoded in the Symbol\n# encoding. Those mapped t"
 & "o -2 are not listed in appendix E, but\n# appear in the metric file for"
 & " Symbol.\n\nAlpha\t\t101\nBeta\t\t102\nChi\t\t103\nDelta\t\t104\nEpsilo"
 & "n\t\t105\nEta\t\t110\nGamma\t\t107\nIfraktur\t301\nIota\t\t111\nKappa\t"
 & "\t113\nLambda\t\t114\nMu\t\t115\nNu\t\t116\nOmega\t\t127\nOmicron\t\t11"
 & "7\nPhi\t\t106\nPi\t\t120\nPsi\t\t131\nRfraktur\t302\nRho\t\t122\nSigma\t"
 & "\t123\nTau\t\t124\nTheta\t\t121\nUpsilon\t\t125\nUpsilon1\t241\nXi\t\t1"
 & "30\nZeta\t\t132\naleph\t\t300\nalpha\t\t141\nampersand\t046\nangle\t\t3"
 & "20\nangleleft\t341\nangleright\t361\napple\t\t -2\napproxequal\t273\nar"
 & "rowboth\t253\narrowdblboth\t333\narrowdbldown\t337\narrowdblleft\t334\n"
 & "arrowdblright\t336\narrowdblup\t335\narrowdown\t257\narrowhorizex\t276\n"
 & "arrowleft\t254\narrowright\t256\narrowup\t\t255\narrowvertex\t275\naste"
 & "riskmath\t052\nbar\t\t174\nbeta\t\t142\nbraceleft\t173\nbraceright\t175"
 & "\nbracelefttp\t354\nbraceleftmid\t355\nbraceleftbt\t356\nbracerighttp\t"
 & "374\nbracerightmid\t375\nbracerightbt\t376\nbraceex\t\t357\nbracketleft"
 & "\t133\nbracketright\t135\nbracketlefttp\t351\nbracketleftex\t372\nbrack"
 & "etleftbt\t353\nbracketrighttp\t371\nbracketrightex\t372\nbracketrightbt"
 & "\t373\nbullet\t\t267\ncarriagereturn\t277\nchi\t\t143\ncirclemultiply\t"
 & "304\ncircleplus\t305\nclub\t\t247\ncolon\t\t072\ncomma\t\t054\ncongruen"
 & "t\t100\ncopyrightsans\t343\ncopyrightserif\t323\ndegree\t\t260\ndelta\t"
 & "\t144\ndiamond\t\t250\ndivide\t\t270\ndotmath\t\t327\neight\t\t070\nele"
 & "ment\t\t316\nellipsis\t274\nemptyset\t306\nepsilon\t\t145\nequal\t\t075"
 & "\nequivalence\t272\neta\t\t150\nexclam\t\t041\nexistential\t044\nfive\t"
 & "\t065\nflorin\t\t246\nfour\t\t064\nfraction\t244\ngamma\t\t147\ngradien"
 & "t\t321\ngreater\t\t076\ngreaterequal\t263\nheart\t\t251\ninfinity\t245\n"
 & "integral\t362\nintegraltp\t363\nintegralex\t364\nintegralbt\t365\ninter"
 & "section\t307\niota\t\t151\nkappa\t\t153\nlambda\t\t154\nless\t\t074\nle"
 & "ssequal\t243\nlogicaland\t331\nlogicalnot\t330\nlogicalor\t332\nlozenge"
 & "\t\t340\nminus\t\t055\nminute\t\t24";

CONST E10_0 = 
   "2\nmu\t\t155\nmultiply\t264\nnine\t\t071\nnotelement\t317\nnotequal\t27"
 & "1\nnotsubset\t313\nnu\t\t156\nnumbersign\t043\nomega\t\t167\nomega1\t\t"
 & "166\nomicron\t\t157\none\t\t061\nparenleft\t050\nparenright\t051\nparen"
 & "lefttp\t346\nparenleftex\t347\nparenleftbt\t350\nparenrighttp\t366\npar"
 & "enrightex\t367\nparenrightbt\t370\npartialdiff\t266\npercent\t\t045\npe"
 & "riod\t\t056\nperpendicular\t136\nphi\t\t146\nphi1\t\t152\npi\t\t160\npl"
 & "us\t\t053\nplusminus\t261\nproduct\t\t325\npropersubset\t314\npropersup"
 & "erset\t311\nproportional\t265\npsi\t\t171\nquestion\t077\nradical\t\t32"
 & "6\nradicalex\t140\nreflexsubset\t315\nreflexsuperset\t312\nregistersans"
 & "\t342\nregisterserif\t322\nrho\t\t162\nsecond\t\t262\nsemicolon\t073\ns"
 & "even\t\t067\nsigma\t\t163\nsigma1\t\t126\nsimilar\t\t176\nsix\t\t066\ns"
 & "lash\t\t057\nspace\t\t040\nspade\t\t252\nsuchthat\t047\nsummation\t345\n"
 & "tau\t\t164\ntherefore\t134\ntheta\t\t161\ntheta1\t\t112\nthree\t\t063\n"
 & "trademarksans\t344\ntrademarkserif\t324\ntwo\t\t062\nunderscore\t137\nu"
 & "nion\t\t310\nuniversal\t042\nupsilon\t\t165\nweierstrass\t303\nxi\t\t17"
 & "0\nzero\t\t060\nzeta\t\t172\n";

CONST E11 = 
   "StartFontMetrics 2.0\nComment Copyright (c) 1985, 1987, 1989, 1990 Adob"
 & "e Systems Incorporated.  All rights reserved.\nComment Creation Date: W"
 & "ed Jan 17 21:48:26 1990\nComment UniqueID 27004\nComment VMusage 28489 "
 & "37622\nFontName Symbol\nFullName Symbol\nFamilyName Symbol\nWeight Medi"
 & "um\nItalicAngle 0\nIsFixedPitch false\nFontBBox -180 -293 1090 1010\nUn"
 & "derlinePosition -98\nUnderlineThickness 54\nVersion 001.007\nNotice Cop"
 & "yright (c) 1985, 1987, 1989, 1990 Adobe Systems Incorporated.  All righ"
 & "ts reserved.\nEncodingScheme FontSpecific\nStartCharMetrics 189\nC 32 ;"
 & " WX 250 ; N space ; B 0 0 0 0 ;\nC 33 ; WX 333 ; N exclam ; B 128 -17 2"
 & "40 672 ;\nC 34 ; WX 713 ; N universal ; B 31 0 681 705 ;\nC 35 ; WX 500"
 & " ; N numbersign ; B 20 -16 481 673 ;\nC 36 ; WX 549 ; N existential ; B"
 & " 25 0 478 707 ;\nC 37 ; WX 833 ; N percent ; B 63 -36 771 655 ;\nC 38 ;"
 & " WX 778 ; N ampersand ; B 41 -18 750 661 ;\nC 39 ; WX 439 ; N suchthat "
 & "; B 48 -17 414 500 ;\nC 40 ; WX 333 ; N parenleft ; B 53 -191 300 673 ;"
 & "\nC 41 ; WX 333 ; N parenright ; B 30 -191 277 673 ;\nC 42 ; WX 500 ; N"
 & " asteriskmath ; B 65 134 427 551 ;\nC 43 ; WX 549 ; N plus ; B 10 0 539"
 & " 533 ;\nC 44 ; WX 250 ; N comma ; B 56 -152 194 104 ;\nC 45 ; WX 549 ; "
 & "N minus ; B 11 233 535 288 ;\nC 46 ; WX 250 ; N period ; B 69 -17 181 9"
 & "5 ;\nC 47 ; WX 278 ; N slash ; B 0 -18 254 646 ;\nC 48 ; WX 500 ; N zer"
 & "o ; B 23 -17 471 685 ;\nC 49 ; WX 500 ; N one ; B 117 0 390 673 ;\nC 50"
 & " ; WX 500 ; N two ; B 25 0 475 686 ;\nC 51 ; WX 500 ; N three ; B 39 -1"
 & "7 435 685 ;\nC 52 ; WX 500 ; N four ; B 16 0 469 685 ;\nC 53 ; WX 500 ;"
 & " N five ; B 29 -17 443 685 ;\nC 54 ; WX 500 ; N six ; B 36 -17 467 685 "
 & ";\nC 55 ; WX 500 ; N seven ; B 24 -16 448 673 ;\nC 56 ; WX 500 ; N eigh"
 & "t ; B 54 -18 440 685 ;\nC 57 ; WX 500 ; N nine ; B 31 -18 460 685 ;\nC "
 & "58 ; WX 278 ; N colon ; B 81 -17 193 460 ;\nC 59 ; WX 278 ; N semicolon"
 & " ; B 83 -152 221 460 ;\nC 60 ; WX 549 ; N less ; B 26 0 523 522 ;\nC 61"
 & " ; WX 549 ; N equal ; B 11 141 537 390 ;\nC 62 ; WX 549 ; N greater ; B"
 & " 26 0 523 522 ;\nC 63 ; WX 444 ; N question ; B 70 -17 412 68";

CONST E11_0 = 
   "6 ;\nC 64 ; WX 549 ; N congruent ; B 11 0 537 475 ;\nC 65 ; WX 722 ; N "
 & "Alpha ; B 4 0 684 673 ;\nC 66 ; WX 667 ; N Beta ; B 29 0 592 673 ;\nC 6"
 & "7 ; WX 722 ; N Chi ; B -9 0 704 673 ;\nC 68 ; WX 612 ; N Delta ; B 6 0 "
 & "608 688 ;\nC 69 ; WX 611 ; N Epsilon ; B 32 0 617 673 ;\nC 70 ; WX 763 "
 & "; N Phi ; B 26 0 741 673 ;\nC 71 ; WX 603 ; N Gamma ; B 24 0 609 673 ;\n"
 & "C 72 ; WX 722 ; N Eta ; B 39 0 729 673 ;\nC 73 ; WX 333 ; N Iota ; B 32"
 & " 0 316 673 ;\nC 74 ; WX 631 ; N theta1 ; B 18 -18 623 689 ;\nC 75 ; WX "
 & "722 ; N Kappa ; B 35 0 722 673 ;\nC 76 ; WX 686 ; N Lambda ; B 6 0 680 "
 & "688 ;\nC 77 ; WX 889 ; N Mu ; B 28 0 887 673 ;\nC 78 ; WX 722 ; N Nu ; "
 & "B 29 -8 720 673 ;\nC 79 ; WX 722 ; N Omicron ; B 41 -17 715 685 ;\nC 80"
 & " ; WX 768 ; N Pi ; B 25 0 745 673 ;\nC 81 ; WX 741 ; N Theta ; B 41 -17"
 & " 715 685 ;\nC 82 ; WX 556 ; N Rho ; B 28 0 563 673 ;\nC 83 ; WX 592 ; N"
 & " Sigma ; B 5 0 589 673 ;\nC 84 ; WX 611 ; N Tau ; B 33 0 607 673 ;\nC 8"
 & "5 ; WX 690 ; N Upsilon ; B -8 0 694 673 ;\nC 86 ; WX 439 ; N sigma1 ; B"
 & " 40 -233 436 500 ;\nC 87 ; WX 768 ; N Omega ; B 34 0 736 688 ;\nC 88 ; "
 & "WX 645 ; N Xi ; B 40 0 599 673 ;\nC 89 ; WX 795 ; N Psi ; B 15 0 781 68"
 & "4 ;\nC 90 ; WX 611 ; N Zeta ; B 44 0 636 673 ;\nC 91 ; WX 333 ; N brack"
 & "etleft ; B 86 -155 299 674 ;\nC 92 ; WX 863 ; N therefore ; B 163 0 701"
 & " 478 ;\nC 93 ; WX 333 ; N bracketright ; B 33 -155 246 674 ;\nC 94 ; WX"
 & " 658 ; N perpendicular ; B 15 0 652 674 ;\nC 95 ; WX 500 ; N underscore"
 & " ; B -2 -252 502 -206 ;\nC 96 ; WX 500 ; N radicalex ; B 480 881 1090 9"
 & "17 ;\nC 97 ; WX 631 ; N alpha ; B 41 -18 622 500 ;\nC 98 ; WX 549 ; N b"
 & "eta ; B 61 -223 515 741 ;\nC 99 ; WX 549 ; N chi ; B 12 -231 522 499 ;\n"
 & "C 100 ; WX 494 ; N delta ; B 40 -19 481 740 ;\nC 101 ; WX 439 ; N epsil"
 & "on ; B 22 -19 427 502 ;\nC 102 ; WX 521 ; N phi ; B 27 -224 490 671 ;\n"
 & "C 103 ; WX 411 ; N gamma ; B 5 -225 484 499 ;\nC 104 ; WX 603 ; N eta ;"
 & " B 0 -202 527 514 ;\nC 105 ; WX 329 ; N iota ; B 0 -17 301 503 ;\nC 106"
 & " ; WX 603 ; N phi1 ; B 36 -224 587 499 ;\nC 107 ; WX 549 ; N kappa ; B "
 & "33 0 558 501 ;\nC 108 ; WX 549 ; N lambda ; B 24 -17 54";

CONST E11_1 = 
   "8 739 ;\nC 109 ; WX 576 ; N mu ; B 33 -223 567 500 ;\nC 110 ; WX 521 ; "
 & "N nu ; B -9 -16 475 507 ;\nC 111 ; WX 549 ; N omicron ; B 35 -19 501 49"
 & "9 ;\nC 112 ; WX 549 ; N pi ; B 10 -19 530 487 ;\nC 113 ; WX 521 ; N the"
 & "ta ; B 43 -17 485 690 ;\nC 114 ; WX 549 ; N rho ; B 50 -230 490 499 ;\n"
 & "C 115 ; WX 603 ; N sigma ; B 30 -21 588 500 ;\nC 116 ; WX 439 ; N tau ;"
 & " B 10 -19 418 500 ;\nC 117 ; WX 576 ; N upsilon ; B 7 -18 535 507 ;\nC "
 & "118 ; WX 713 ; N omega1 ; B 12 -18 671 583 ;\nC 119 ; WX 686 ; N omega "
 & "; B 42 -17 684 500 ;\nC 120 ; WX 493 ; N xi ; B 27 -224 469 766 ;\nC 12"
 & "1 ; WX 686 ; N psi ; B 12 -228 701 500 ;\nC 122 ; WX 494 ; N zeta ; B 6"
 & "0 -225 467 756 ;\nC 123 ; WX 480 ; N braceleft ; B 58 -183 397 673 ;\nC"
 & " 124 ; WX 200 ; N bar ; B 65 -177 135 673 ;\nC 125 ; WX 480 ; N braceri"
 & "ght ; B 79 -183 418 673 ;\nC 126 ; WX 549 ; N similar ; B 17 203 529 30"
 & "7 ;\nC 161 ; WX 620 ; N Upsilon1 ; B -2 0 610 685 ;\nC 162 ; WX 247 ; N"
 & " minute ; B 27 459 228 735 ;\nC 163 ; WX 549 ; N lessequal ; B 29 0 526"
 & " 639 ;\nC 164 ; WX 167 ; N fraction ; B -180 -12 340 677 ;\nC 165 ; WX "
 & "713 ; N infinity ; B 26 124 688 404 ;\nC 166 ; WX 500 ; N florin ; B 2 "
 & "-193 494 686 ;\nC 167 ; WX 753 ; N club ; B 86 -26 660 533 ;\nC 168 ; W"
 & "X 753 ; N diamond ; B 142 -36 600 550 ;\nC 169 ; WX 753 ; N heart ; B 1"
 & "17 -33 631 532 ;\nC 170 ; WX 753 ; N spade ; B 113 -36 629 548 ;\nC 171"
 & " ; WX 1042 ; N arrowboth ; B 24 -15 1024 511 ;\nC 172 ; WX 987 ; N arro"
 & "wleft ; B 32 -15 942 511 ;\nC 173 ; WX 603 ; N arrowup ; B 45 0 571 910"
 & " ;\nC 174 ; WX 987 ; N arrowright ; B 49 -15 959 511 ;\nC 175 ; WX 603 "
 & "; N arrowdown ; B 45 -22 571 888 ;\nC 176 ; WX 400 ; N degree ; B 50 38"
 & "5 350 685 ;\nC 177 ; WX 549 ; N plusminus ; B 10 0 539 645 ;\nC 178 ; W"
 & "X 411 ; N second ; B 20 459 413 737 ;\nC 179 ; WX 549 ; N greaterequal "
 & "; B 29 0 526 639 ;\nC 180 ; WX 549 ; N multiply ; B 17 8 533 524 ;\nC 1"
 & "81 ; WX 713 ; N proportional ; B 27 123 639 404 ;\nC 182 ; WX 494 ; N p"
 & "artialdiff ; B 26 -20 462 746 ;\nC 183 ; WX 460 ; N bullet ; B 50 113 4"
 & "10 473 ;\nC 184 ; WX 549 ; N divide ; B 10 71 536 456 ";

CONST E11_2 = 
   ";\nC 185 ; WX 549 ; N notequal ; B 15 -25 540 549 ;\nC 186 ; WX 549 ; N"
 & " equivalence ; B 14 82 538 443 ;\nC 187 ; WX 549 ; N approxequal ; B 14"
 & " 135 527 394 ;\nC 188 ; WX 1000 ; N ellipsis ; B 111 -17 889 95 ;\nC 18"
 & "9 ; WX 603 ; N arrowvertex ; B 280 -120 336 1010 ;\nC 190 ; WX 1000 ; N"
 & " arrowhorizex ; B -60 220 1050 276 ;\nC 191 ; WX 658 ; N carriagereturn"
 & " ; B 15 -16 602 629 ;\nC 192 ; WX 823 ; N aleph ; B 175 -18 661 658 ;\n"
 & "C 193 ; WX 686 ; N Ifraktur ; B 10 -53 578 740 ;\nC 194 ; WX 795 ; N Rf"
 & "raktur ; B 26 -15 759 734 ;\nC 195 ; WX 987 ; N weierstrass ; B 159 -21"
 & "1 870 573 ;\nC 196 ; WX 768 ; N circlemultiply ; B 43 -17 733 673 ;\nC "
 & "197 ; WX 768 ; N circleplus ; B 43 -15 733 675 ;\nC 198 ; WX 823 ; N em"
 & "ptyset ; B 39 -24 781 719 ;\nC 199 ; WX 768 ; N intersection ; B 40 0 7"
 & "32 509 ;\nC 200 ; WX 768 ; N union ; B 40 -17 732 492 ;\nC 201 ; WX 713"
 & " ; N propersuperset ; B 20 0 673 470 ;\nC 202 ; WX 713 ; N reflexsupers"
 & "et ; B 20 -125 673 470 ;\nC 203 ; WX 713 ; N notsubset ; B 36 -70 690 5"
 & "40 ;\nC 204 ; WX 713 ; N propersubset ; B 37 0 690 470 ;\nC 205 ; WX 71"
 & "3 ; N reflexsubset ; B 37 -125 690 470 ;\nC 206 ; WX 713 ; N element ; "
 & "B 45 0 505 468 ;\nC 207 ; WX 713 ; N notelement ; B 45 -58 505 555 ;\nC"
 & " 208 ; WX 768 ; N angle ; B 26 0 738 673 ;\nC 209 ; WX 713 ; N gradient"
 & " ; B 36 -19 681 718 ;\nC 210 ; WX 790 ; N registerserif ; B 50 -17 740 "
 & "673 ;\nC 211 ; WX 790 ; N copyrightserif ; B 51 -15 741 675 ;\nC 212 ; "
 & "WX 890 ; N trademarkserif ; B 18 293 855 673 ;\nC 213 ; WX 823 ; N prod"
 & "uct ; B 25 -101 803 751 ;\nC 214 ; WX 549 ; N radical ; B 10 -38 515 91"
 & "7 ;\nC 215 ; WX 250 ; N dotmath ; B 69 210 169 310 ;\nC 216 ; WX 713 ; "
 & "N logicalnot ; B 15 0 680 288 ;\nC 217 ; WX 603 ; N logicaland ; B 23 0"
 & " 583 454 ;\nC 218 ; WX 603 ; N logicalor ; B 30 0 578 477 ;\nC 219 ; WX"
 & " 1042 ; N arrowdblboth ; B 27 -20 1023 510 ;\nC 220 ; WX 987 ; N arrowd"
 & "blleft ; B 30 -15 939 513 ;\nC 221 ; WX 603 ; N arrowdblup ; B 39 2 567"
 & " 911 ;\nC 222 ; WX 987 ; N arrowdblright ; B 45 -20 954 508 ;\nC 223 ; "
 & "WX 603 ; N arrowdbldown ; B 44 -19 572 890 ;\nC 224 ";

CONST E11_3 = 
   "; WX 494 ; N lozenge ; B 18 0 466 745 ;\nC 225 ; WX 329 ; N angleleft ;"
 & " B 25 -198 306 746 ;\nC 226 ; WX 790 ; N registersans ; B 50 -20 740 67"
 & "0 ;\nC 227 ; WX 790 ; N copyrightsans ; B 49 -15 739 675 ;\nC 228 ; WX "
 & "786 ; N trademarksans ; B 5 293 725 673 ;\nC 229 ; WX 713 ; N summation"
 & " ; B 14 -108 695 752 ;\nC 230 ; WX 384 ; N parenlefttp ; B 40 -293 436 "
 & "926 ;\nC 231 ; WX 384 ; N parenleftex ; B 40 -85 92 925 ;\nC 232 ; WX 3"
 & "84 ; N parenleftbt ; B 40 -293 436 926 ;\nC 233 ; WX 384 ; N bracketlef"
 & "ttp ; B 0 -80 341 926 ;\nC 234 ; WX 384 ; N bracketleftex ; B 0 -79 55 "
 & "925 ;\nC 235 ; WX 384 ; N bracketleftbt ; B 0 -80 340 926 ;\nC 236 ; WX"
 & " 494 ; N bracelefttp ; B 201 -75 439 926 ;\nC 237 ; WX 494 ; N bracelef"
 & "tmid ; B 14 -85 255 935 ;\nC 238 ; WX 494 ; N braceleftbt ; B 201 -70 4"
 & "39 926 ;\nC 239 ; WX 494 ; N braceex ; B 201 -80 255 935 ;\nC 241 ; WX "
 & "329 ; N angleright ; B 21 -198 302 746 ;\nC 242 ; WX 274 ; N integral ;"
 & " B 2 -107 291 916 ;\nC 243 ; WX 686 ; N integraltp ; B 332 -83 715 921 "
 & ";\nC 244 ; WX 686 ; N integralex ; B 332 -88 415 975 ;\nC 245 ; WX 686 "
 & "; N integralbt ; B 39 -81 415 921 ;\nC 246 ; WX 384 ; N parenrighttp ; "
 & "B 54 -293 450 926 ;\nC 247 ; WX 384 ; N parenrightex ; B 398 -85 450 92"
 & "5 ;\nC 248 ; WX 384 ; N parenrightbt ; B 54 -293 450 926 ;\nC 249 ; WX "
 & "384 ; N bracketrighttp ; B 22 -80 360 926 ;\nC 250 ; WX 384 ; N bracket"
 & "rightex ; B 305 -79 360 925 ;\nC 251 ; WX 384 ; N bracketrightbt ; B 20"
 & " -80 360 926 ;\nC 252 ; WX 494 ; N bracerighttp ; B 17 -75 255 926 ;\nC"
 & " 253 ; WX 494 ; N bracerightmid ; B 201 -85 442 935 ;\nC 254 ; WX 494 ;"
 & " N bracerightbt ; B 17 -70 255 926 ;\nC -1 ; WX 790 ; N apple ; B 56 -3"
 & " 733 808 ;\nEndCharMetrics\nEndFontMetrics\n";

CONST E12 = 
   "StartFontMetrics 2.0\nComment Copyright (c) 1985, 1987, 1989, 1990 Adob"
 & "e Systems Incorporated.  All rights reserved.\nComment Creation Date: T"
 & "hu Mar 15 08:58:00 1990\nComment UniqueID 28352\nComment VMusage 26389 "
 & "33281\nFontName Helvetica\nFullName Helvetica\nFamilyName Helvetica\nWe"
 & "ight Medium\nItalicAngle 0\nIsFixedPitch false\nFontBBox -166 -225 1000"
 & " 931\nUnderlinePosition -100\nUnderlineThickness 50\nVersion 001.006\nN"
 & "otice Copyright (c) 1985, 1987, 1989, 1990 Adobe Systems Incorporated. "
 & " All rights reserved.Helvetica is a trademark of Linotype AG and/or its"
 & " subsidiaries.\nEncodingScheme AdobeStandardEncoding\nCapHeight 718\nXH"
 & "eight 523\nAscender 718\nDescender -207\nStartCharMetrics 228\nC 32 ; W"
 & "X 278 ; N space ; B 0 0 0 0 ;\nC 33 ; WX 278 ; N exclam ; B 90 0 187 71"
 & "8 ;\nC 34 ; WX 355 ; N quotedbl ; B 70 463 285 718 ;\nC 35 ; WX 556 ; N"
 & " numbersign ; B 28 0 529 688 ;\nC 36 ; WX 556 ; N dollar ; B 32 -115 52"
 & "0 775 ;\nC 37 ; WX 889 ; N percent ; B 39 -19 850 703 ;\nC 38 ; WX 667 "
 & "; N ampersand ; B 44 -15 645 718 ;\nC 39 ; WX 222 ; N quoteright ; B 53"
 & " 463 157 718 ;\nC 40 ; WX 333 ; N parenleft ; B 68 -207 299 733 ;\nC 41"
 & " ; WX 333 ; N parenright ; B 34 -207 265 733 ;\nC 42 ; WX 389 ; N aster"
 & "isk ; B 39 431 349 718 ;\nC 43 ; WX 584 ; N plus ; B 39 0 545 505 ;\nC "
 & "44 ; WX 278 ; N comma ; B 87 -147 191 106 ;\nC 45 ; WX 333 ; N hyphen ;"
 & " B 44 232 289 322 ;\nC 46 ; WX 278 ; N period ; B 87 0 191 106 ;\nC 47 "
 & "; WX 278 ; N slash ; B -17 -19 295 737 ;\nC 48 ; WX 556 ; N zero ; B 37"
 & " -19 519 703 ;\nC 49 ; WX 556 ; N one ; B 101 0 359 703 ;\nC 50 ; WX 55"
 & "6 ; N two ; B 26 0 507 703 ;\nC 51 ; WX 556 ; N three ; B 34 -19 522 70"
 & "3 ;\nC 52 ; WX 556 ; N four ; B 25 0 523 703 ;\nC 53 ; WX 556 ; N five "
 & "; B 32 -19 514 688 ;\nC 54 ; WX 556 ; N six ; B 38 -19 518 703 ;\nC 55 "
 & "; WX 556 ; N seven ; B 37 0 523 688 ;\nC 56 ; WX 556 ; N eight ; B 38 -"
 & "19 517 703 ;\nC 57 ; WX 556 ; N nine ; B 42 -19 514 703 ;\nC 58 ; WX 27"
 & "8 ; N colon ; B 87 0 191 516 ;\nC 59 ; WX 278 ; N semicolon ; B 87 -147"
 & " 191 516 ;\nC 60 ; WX 584 ; N less ; B 48 11 536 495 ;\nC 61 ; ";

CONST E12_0 = 
   "WX 584 ; N equal ; B 39 115 545 390 ;\nC 62 ; WX 584 ; N greater ; B 48"
 & " 11 536 495 ;\nC 63 ; WX 556 ; N question ; B 56 0 492 727 ;\nC 64 ; WX"
 & " 1015 ; N at ; B 147 -19 868 737 ;\nC 65 ; WX 667 ; N A ; B 14 0 654 71"
 & "8 ;\nC 66 ; WX 667 ; N B ; B 74 0 627 718 ;\nC 67 ; WX 722 ; N C ; B 44"
 & " -19 681 737 ;\nC 68 ; WX 722 ; N D ; B 81 0 674 718 ;\nC 69 ; WX 667 ;"
 & " N E ; B 86 0 616 718 ;\nC 70 ; WX 611 ; N F ; B 86 0 583 718 ;\nC 71 ;"
 & " WX 778 ; N G ; B 48 -19 704 737 ;\nC 72 ; WX 722 ; N H ; B 77 0 646 71"
 & "8 ;\nC 73 ; WX 278 ; N I ; B 91 0 188 718 ;\nC 74 ; WX 500 ; N J ; B 17"
 & " -19 428 718 ;\nC 75 ; WX 667 ; N K ; B 76 0 663 718 ;\nC 76 ; WX 556 ;"
 & " N L ; B 76 0 537 718 ;\nC 77 ; WX 833 ; N M ; B 73 0 761 718 ;\nC 78 ;"
 & " WX 722 ; N N ; B 76 0 646 718 ;\nC 79 ; WX 778 ; N O ; B 39 -19 739 73"
 & "7 ;\nC 80 ; WX 667 ; N P ; B 86 0 622 718 ;\nC 81 ; WX 778 ; N Q ; B 39"
 & " -56 739 737 ;\nC 82 ; WX 722 ; N R ; B 88 0 684 718 ;\nC 83 ; WX 667 ;"
 & " N S ; B 49 -19 620 737 ;\nC 84 ; WX 611 ; N T ; B 14 0 597 718 ;\nC 85"
 & " ; WX 722 ; N U ; B 79 -19 644 718 ;\nC 86 ; WX 667 ; N V ; B 20 0 647 "
 & "718 ;\nC 87 ; WX 944 ; N W ; B 16 0 928 718 ;\nC 88 ; WX 667 ; N X ; B "
 & "19 0 648 718 ;\nC 89 ; WX 667 ; N Y ; B 14 0 653 718 ;\nC 90 ; WX 611 ;"
 & " N Z ; B 23 0 588 718 ;\nC 91 ; WX 278 ; N bracketleft ; B 63 -196 250 "
 & "722 ;\nC 92 ; WX 278 ; N backslash ; B -17 -19 295 737 ;\nC 93 ; WX 278"
 & " ; N bracketright ; B 28 -196 215 722 ;\nC 94 ; WX 469 ; N asciicircum "
 & "; B -14 264 483 688 ;\nC 95 ; WX 556 ; N underscore ; B 0 -125 556 -75 "
 & ";\nC 96 ; WX 222 ; N quoteleft ; B 65 470 169 725 ;\nC 97 ; WX 556 ; N "
 & "a ; B 36 -15 530 538 ;\nC 98 ; WX 556 ; N b ; B 58 -15 517 718 ;\nC 99 "
 & "; WX 500 ; N c ; B 30 -15 477 538 ;\nC 100 ; WX 556 ; N d ; B 35 -15 49"
 & "9 718 ;\nC 101 ; WX 556 ; N e ; B 40 -15 516 538 ;\nC 102 ; WX 278 ; N "
 & "f ; B 14 0 262 728 ; L i fi ; L l fl ;\nC 103 ; WX 556 ; N g ; B 40 -22"
 & "0 499 538 ;\nC 104 ; WX 556 ; N h ; B 65 0 491 718 ;\nC 105 ; WX 222 ; "
 & "N i ; B 67 0 155 718 ;\nC 106 ; WX 222 ; N j ; B -16 -210 155 718 ;\nC "
 & "107 ; WX 500 ; N k ; B 67 0 501 718 ;\nC 108 ; WX 222 ; N l";

CONST E12_1 = 
   " ; B 67 0 155 718 ;\nC 109 ; WX 833 ; N m ; B 65 0 769 538 ;\nC 110 ; W"
 & "X 556 ; N n ; B 65 0 491 538 ;\nC 111 ; WX 556 ; N o ; B 35 -14 521 538"
 & " ;\nC 112 ; WX 556 ; N p ; B 58 -207 517 538 ;\nC 113 ; WX 556 ; N q ; "
 & "B 35 -207 494 538 ;\nC 114 ; WX 333 ; N r ; B 77 0 332 538 ;\nC 115 ; W"
 & "X 500 ; N s ; B 32 -15 464 538 ;\nC 116 ; WX 278 ; N t ; B 14 -7 257 66"
 & "9 ;\nC 117 ; WX 556 ; N u ; B 68 -15 489 523 ;\nC 118 ; WX 500 ; N v ; "
 & "B 8 0 492 523 ;\nC 119 ; WX 722 ; N w ; B 14 0 709 523 ;\nC 120 ; WX 50"
 & "0 ; N x ; B 11 0 490 523 ;\nC 121 ; WX 500 ; N y ; B 11 -214 489 523 ;\n"
 & "C 122 ; WX 500 ; N z ; B 31 0 469 523 ;\nC 123 ; WX 334 ; N braceleft ;"
 & " B 42 -196 292 722 ;\nC 124 ; WX 260 ; N bar ; B 94 -19 167 737 ;\nC 12"
 & "5 ; WX 334 ; N braceright ; B 42 -196 292 722 ;\nC 126 ; WX 584 ; N asc"
 & "iitilde ; B 61 180 523 326 ;\nC 161 ; WX 333 ; N exclamdown ; B 118 -19"
 & "5 215 523 ;\nC 162 ; WX 556 ; N cent ; B 51 -115 513 623 ;\nC 163 ; WX "
 & "556 ; N sterling ; B 33 -16 539 718 ;\nC 164 ; WX 167 ; N fraction ; B "
 & "-166 -19 333 703 ;\nC 165 ; WX 556 ; N yen ; B 3 0 553 688 ;\nC 166 ; W"
 & "X 556 ; N florin ; B -11 -207 501 737 ;\nC 167 ; WX 556 ; N section ; B"
 & " 43 -191 512 737 ;\nC 168 ; WX 556 ; N currency ; B 28 99 528 603 ;\nC "
 & "169 ; WX 191 ; N quotesingle ; B 59 463 132 718 ;\nC 170 ; WX 333 ; N q"
 & "uotedblleft ; B 38 470 307 725 ;\nC 171 ; WX 556 ; N guillemotleft ; B "
 & "97 108 459 446 ;\nC 172 ; WX 333 ; N guilsinglleft ; B 88 108 245 446 ;"
 & "\nC 173 ; WX 333 ; N guilsinglright ; B 88 108 245 446 ;\nC 174 ; WX 50"
 & "0 ; N fi ; B 14 0 434 728 ;\nC 175 ; WX 500 ; N fl ; B 14 0 432 728 ;\n"
 & "C 177 ; WX 556 ; N endash ; B 0 240 556 313 ;\nC 178 ; WX 556 ; N dagge"
 & "r ; B 43 -159 514 718 ;\nC 179 ; WX 556 ; N daggerdbl ; B 43 -159 514 7"
 & "18 ;\nC 180 ; WX 278 ; N periodcentered ; B 77 190 202 315 ;\nC 182 ; W"
 & "X 537 ; N paragraph ; B 18 -173 497 718 ;\nC 183 ; WX 350 ; N bullet ; "
 & "B 18 202 333 517 ;\nC 184 ; WX 222 ; N quotesinglbase ; B 53 -149 157 1"
 & "06 ;\nC 185 ; WX 333 ; N quotedblbase ; B 26 -149 295 106 ;\nC 186 ; WX"
 & " 333 ; N quotedblright ; B 26 463 295 718 ;\nC 187 ; W";

CONST E12_2 = 
   "X 556 ; N guillemotright ; B 97 108 459 446 ;\nC 188 ; WX 1000 ; N elli"
 & "psis ; B 115 0 885 106 ;\nC 189 ; WX 1000 ; N perthousand ; B 7 -19 994"
 & " 703 ;\nC 191 ; WX 611 ; N questiondown ; B 91 -201 527 525 ;\nC 193 ; "
 & "WX 333 ; N grave ; B 14 593 211 734 ;\nC 194 ; WX 333 ; N acute ; B 122"
 & " 593 319 734 ;\nC 195 ; WX 333 ; N circumflex ; B 21 593 312 734 ;\nC 1"
 & "96 ; WX 333 ; N tilde ; B -4 606 337 722 ;\nC 197 ; WX 333 ; N macron ;"
 & " B 10 627 323 684 ;\nC 198 ; WX 333 ; N breve ; B 13 595 321 731 ;\nC 1"
 & "99 ; WX 333 ; N dotaccent ; B 121 604 212 706 ;\nC 200 ; WX 333 ; N die"
 & "resis ; B 40 604 293 706 ;\nC 202 ; WX 333 ; N ring ; B 75 572 259 756 "
 & ";\nC 203 ; WX 333 ; N cedilla ; B 45 -225 259 0 ;\nC 205 ; WX 333 ; N h"
 & "ungarumlaut ; B 31 593 409 734 ;\nC 206 ; WX 333 ; N ogonek ; B 73 -225"
 & " 287 0 ;\nC 207 ; WX 333 ; N caron ; B 21 593 312 734 ;\nC 208 ; WX 100"
 & "0 ; N emdash ; B 0 240 1000 313 ;\nC 225 ; WX 1000 ; N AE ; B 8 0 951 7"
 & "18 ;\nC 227 ; WX 370 ; N ordfeminine ; B 24 304 346 737 ;\nC 232 ; WX 5"
 & "56 ; N Lslash ; B -20 0 537 718 ;\nC 233 ; WX 778 ; N Oslash ; B 39 -19"
 & " 740 737 ;\nC 234 ; WX 1000 ; N OE ; B 36 -19 965 737 ;\nC 235 ; WX 365"
 & " ; N ordmasculine ; B 25 304 341 737 ;\nC 241 ; WX 889 ; N ae ; B 36 -1"
 & "5 847 538 ;\nC 245 ; WX 278 ; N dotlessi ; B 95 0 183 523 ;\nC 248 ; WX"
 & " 222 ; N lslash ; B -20 0 242 718 ;\nC 249 ; WX 611 ; N oslash ; B 28 -"
 & "22 537 545 ;\nC 250 ; WX 944 ; N oe ; B 35 -15 902 538 ;\nC 251 ; WX 61"
 & "1 ; N germandbls ; B 67 -15 571 728 ;\nC -1 ; WX 611 ; N Zcaron ; B 23 "
 & "0 588 929 ;\nC -1 ; WX 500 ; N ccedilla ; B 30 -225 477 538 ;\nC -1 ; W"
 & "X 500 ; N ydieresis ; B 11 -214 489 706 ;\nC -1 ; WX 556 ; N atilde ; B"
 & " 36 -15 530 722 ;\nC -1 ; WX 278 ; N icircumflex ; B -6 0 285 734 ;\nC "
 & "-1 ; WX 333 ; N threesuperior ; B 5 270 325 703 ;\nC -1 ; WX 556 ; N ec"
 & "ircumflex ; B 40 -15 516 734 ;\nC -1 ; WX 556 ; N thorn ; B 58 -207 517"
 & " 718 ;\nC -1 ; WX 556 ; N egrave ; B 40 -15 516 734 ;\nC -1 ; WX 333 ; "
 & "N twosuperior ; B 4 281 323 703 ;\nC -1 ; WX 556 ; N eacute ; B 40 -15 "
 & "516 734 ;\nC -1 ; WX 556 ; N otilde ; B 35 -14 521 72";

CONST E12_3 = 
   "2 ;\nC -1 ; WX 667 ; N Aacute ; B 14 0 654 929 ;\nC -1 ; WX 556 ; N oci"
 & "rcumflex ; B 35 -14 521 734 ;\nC -1 ; WX 500 ; N yacute ; B 11 -214 489"
 & " 734 ;\nC -1 ; WX 556 ; N udieresis ; B 68 -15 489 706 ;\nC -1 ; WX 834"
 & " ; N threequarters ; B 45 -19 810 703 ;\nC -1 ; WX 556 ; N acircumflex "
 & "; B 36 -15 530 734 ;\nC -1 ; WX 722 ; N Eth ; B 0 0 674 718 ;\nC -1 ; W"
 & "X 556 ; N edieresis ; B 40 -15 516 706 ;\nC -1 ; WX 556 ; N ugrave ; B "
 & "68 -15 489 734 ;\nC -1 ; WX 1000 ; N trademark ; B 46 306 903 718 ;\nC "
 & "-1 ; WX 556 ; N ograve ; B 35 -14 521 734 ;\nC -1 ; WX 500 ; N scaron ;"
 & " B 32 -15 464 734 ;\nC -1 ; WX 278 ; N Idieresis ; B 13 0 266 901 ;\nC "
 & "-1 ; WX 556 ; N uacute ; B 68 -15 489 734 ;\nC -1 ; WX 556 ; N agrave ;"
 & " B 36 -15 530 734 ;\nC -1 ; WX 556 ; N ntilde ; B 65 0 491 722 ;\nC -1 "
 & "; WX 556 ; N aring ; B 36 -15 530 756 ;\nC -1 ; WX 500 ; N zcaron ; B 3"
 & "1 0 469 734 ;\nC -1 ; WX 278 ; N Icircumflex ; B -6 0 285 929 ;\nC -1 ;"
 & " WX 722 ; N Ntilde ; B 76 0 646 917 ;\nC -1 ; WX 556 ; N ucircumflex ; "
 & "B 68 -15 489 734 ;\nC -1 ; WX 667 ; N Ecircumflex ; B 86 0 616 929 ;\nC"
 & " -1 ; WX 278 ; N Iacute ; B 91 0 292 929 ;\nC -1 ; WX 722 ; N Ccedilla "
 & "; B 44 -225 681 737 ;\nC -1 ; WX 778 ; N Odieresis ; B 39 -19 739 901 ;"
 & "\nC -1 ; WX 667 ; N Scaron ; B 49 -19 620 929 ;\nC -1 ; WX 667 ; N Edie"
 & "resis ; B 86 0 616 901 ;\nC -1 ; WX 278 ; N Igrave ; B -13 0 188 929 ;\n"
 & "C -1 ; WX 556 ; N adieresis ; B 36 -15 530 706 ;\nC -1 ; WX 778 ; N Ogr"
 & "ave ; B 39 -19 739 929 ;\nC -1 ; WX 667 ; N Egrave ; B 86 0 616 929 ;\n"
 & "C -1 ; WX 667 ; N Ydieresis ; B 14 0 653 901 ;\nC -1 ; WX 737 ; N regis"
 & "tered ; B -14 -19 752 737 ;\nC -1 ; WX 778 ; N Otilde ; B 39 -19 739 91"
 & "7 ;\nC -1 ; WX 834 ; N onequarter ; B 73 -19 756 703 ;\nC -1 ; WX 722 ;"
 & " N Ugrave ; B 79 -19 644 929 ;\nC -1 ; WX 722 ; N Ucircumflex ; B 79 -1"
 & "9 644 929 ;\nC -1 ; WX 667 ; N Thorn ; B 86 0 622 718 ;\nC -1 ; WX 584 "
 & "; N divide ; B 39 -19 545 524 ;\nC -1 ; WX 667 ; N Atilde ; B 14 0 654 "
 & "917 ;\nC -1 ; WX 722 ; N Uacute ; B 79 -19 644 929 ;\nC -1 ; WX 778 ; N"
 & " Ocircumflex ; B 39 -19 739 929 ;\nC -1 ; WX 584 ; N l";

CONST E12_4 = 
   "ogicalnot ; B 39 108 545 390 ;\nC -1 ; WX 667 ; N Aring ; B 14 0 654 93"
 & "1 ;\nC -1 ; WX 278 ; N idieresis ; B 13 0 266 706 ;\nC -1 ; WX 278 ; N "
 & "iacute ; B 95 0 292 734 ;\nC -1 ; WX 556 ; N aacute ; B 36 -15 530 734 "
 & ";\nC -1 ; WX 584 ; N plusminus ; B 39 0 545 506 ;\nC -1 ; WX 584 ; N mu"
 & "ltiply ; B 39 0 545 506 ;\nC -1 ; WX 722 ; N Udieresis ; B 79 -19 644 9"
 & "01 ;\nC -1 ; WX 584 ; N minus ; B 39 216 545 289 ;\nC -1 ; WX 333 ; N o"
 & "nesuperior ; B 43 281 222 703 ;\nC -1 ; WX 667 ; N Eacute ; B 86 0 616 "
 & "929 ;\nC -1 ; WX 667 ; N Acircumflex ; B 14 0 654 929 ;\nC -1 ; WX 737 "
 & "; N copyright ; B -14 -19 752 737 ;\nC -1 ; WX 667 ; N Agrave ; B 14 0 "
 & "654 929 ;\nC -1 ; WX 556 ; N odieresis ; B 35 -14 521 706 ;\nC -1 ; WX "
 & "556 ; N oacute ; B 35 -14 521 734 ;\nC -1 ; WX 400 ; N degree ; B 54 41"
 & "1 346 703 ;\nC -1 ; WX 278 ; N igrave ; B -13 0 184 734 ;\nC -1 ; WX 55"
 & "6 ; N mu ; B 68 -207 489 523 ;\nC -1 ; WX 778 ; N Oacute ; B 39 -19 739"
 & " 929 ;\nC -1 ; WX 556 ; N eth ; B 35 -15 522 737 ;\nC -1 ; WX 667 ; N A"
 & "dieresis ; B 14 0 654 901 ;\nC -1 ; WX 667 ; N Yacute ; B 14 0 653 929 "
 & ";\nC -1 ; WX 260 ; N brokenbar ; B 94 -19 167 737 ;\nC -1 ; WX 834 ; N "
 & "onehalf ; B 43 -19 773 703 ;\nEndCharMetrics\nStartKernData\nStartKernP"
 & "airs 250\n\nKPX A y -40\nKPX A w -40\nKPX A v -40\nKPX A u -30\nKPX A Y"
 & " -100\nKPX A W -50\nKPX A V -70\nKPX A U -50\nKPX A T -120\nKPX A Q -30"
 & "\nKPX A O -30\nKPX A G -30\nKPX A C -30\n\nKPX B period -20\nKPX B comm"
 & "a -20\nKPX B U -10\n\nKPX C period -30\nKPX C comma -30\n\nKPX D period"
 & " -70\nKPX D comma -70\nKPX D Y -90\nKPX D W -40\nKPX D V -70\nKPX D A -"
 & "40\n\nKPX F r -45\nKPX F period -150\nKPX F o -30\nKPX F e -30\nKPX F c"
 & "omma -150\nKPX F a -50\nKPX F A -80\n\nKPX J u -20\nKPX J period -30\nK"
 & "PX J comma -30\nKPX J a -20\nKPX J A -20\n\nKPX K y -50\nKPX K u -30\nK"
 & "PX K o -40\nKPX K e -40\nKPX K O -50\n\nKPX L y -30\nKPX L quoteright -"
 & "160\nKPX L quotedblright -140\nKPX L Y -140\nKPX L W -70\nKPX L V -110\n"
 & "KPX L T -110\n\nKPX O period -40\nKPX O comma -40\nKPX O Y -70\nKPX O X"
 & " -60\nKPX O W -30\nKPX O V -50\nKPX O T -40\nKPX O A -20\n\nKPX P perio"
 & "d -180\nKPX P o -50\nKPX P e -50\nKPX";

CONST E12_5 = 
   " P comma -180\nKPX P a -40\nKPX P A -120\n\nKPX Q U -10\n\nKPX R Y -50\n"
 & "KPX R W -30\nKPX R V -50\nKPX R U -40\nKPX R T -30\nKPX R O -20\n\nKPX "
 & "S period -20\nKPX S comma -20\n\nKPX T y -120\nKPX T w -120\nKPX T u -1"
 & "20\nKPX T semicolon -20\nKPX T r -120\nKPX T period -120\nKPX T o -120\n"
 & "KPX T hyphen -140\nKPX T e -120\nKPX T comma -120\nKPX T colon -20\nKPX"
 & " T a -120\nKPX T O -40\nKPX T A -120\n\nKPX U period -40\nKPX U comma -"
 & "40\nKPX U A -40\n\nKPX V u -70\nKPX V semicolon -40\nKPX V period -125\n"
 & "KPX V o -80\nKPX V hyphen -80\nKPX V e -80\nKPX V comma -125\nKPX V col"
 & "on -40\nKPX V a -70\nKPX V O -40\nKPX V G -40\nKPX V A -80\n\nKPX W y -"
 & "20\nKPX W u -30\nKPX W period -80\nKPX W o -30\nKPX W hyphen -40\nKPX W"
 & " e -30\nKPX W comma -80\nKPX W a -40\nKPX W O -20\nKPX W A -50\n\nKPX Y"
 & " u -110\nKPX Y semicolon -60\nKPX Y period -140\nKPX Y o -140\nKPX Y i "
 & "-20\nKPX Y hyphen -140\nKPX Y e -140\nKPX Y comma -140\nKPX Y colon -60"
 & "\nKPX Y a -140\nKPX Y O -85\nKPX Y A -110\n\nKPX a y -30\nKPX a w -20\n"
 & "KPX a v -20\n\nKPX b y -20\nKPX b v -20\nKPX b u -20\nKPX b period -40\n"
 & "KPX b l -20\nKPX b comma -40\nKPX b b -10\n\nKPX c k -20\nKPX c comma -"
 & "15\n\nKPX colon space -50\n\nKPX comma quoteright -100\nKPX comma quote"
 & "dblright -100\n\nKPX e y -20\nKPX e x -30\nKPX e w -20\nKPX e v -30\nKP"
 & "X e period -15\nKPX e comma -15\n\nKPX f quoteright 50\nKPX f quotedblr"
 & "ight 60\nKPX f period -30\nKPX f o -30\nKPX f e -30\nKPX f dotlessi -28"
 & "\nKPX f comma -30\nKPX f a -30\n\nKPX g r -10\n\nKPX h y -30\n\nKPX k o"
 & " -20\nKPX k e -20\n\nKPX m y -15\nKPX m u -10\n\nKPX n y -15\nKPX n v -"
 & "20\nKPX n u -10\n\nKPX o y -30\nKPX o x -30\nKPX o w -15\nKPX o v -15\n"
 & "KPX o period -40\nKPX o comma -40\n\nKPX oslash z -55\nKPX oslash y -70"
 & "\nKPX oslash x -85\nKPX oslash w -70\nKPX oslash v -70\nKPX oslash u -5"
 & "5\nKPX oslash t -55\nKPX oslash s -55\nKPX oslash r -55\nKPX oslash q -"
 & "55\nKPX oslash period -95\nKPX oslash p -55\nKPX oslash o -55\nKPX osla"
 & "sh n -55\nKPX oslash m -55\nKPX oslash l -55\nKPX oslash k -55\nKPX osl"
 & "ash j -55\nKPX oslash i -55\nKPX oslash h -55\nKPX oslash g -55\nKPX os"
 & "lash f -55\nKPX oslash e -55\nKPX oslash d -55\nKPX oslash comma -95\nK"
 & "PX oslash c -55\nKPX ";

CONST E12_6 = 
   "oslash b -55\nKPX oslash a -55\n\nKPX p y -30\nKPX p period -35\nKPX p "
 & "comma -35\n\nKPX period space -60\nKPX period quoteright -100\nKPX peri"
 & "od quotedblright -100\n\nKPX quotedblright space -40\n\nKPX quoteleft q"
 & "uoteleft -57\n\nKPX quoteright space -70\nKPX quoteright s -50\nKPX quo"
 & "teright r -50\nKPX quoteright quoteright -57\nKPX quoteright d -50\n\nK"
 & "PX r y 30\nKPX r v 30\nKPX r u 15\nKPX r t 40\nKPX r semicolon 30\nKPX "
 & "r period -50\nKPX r p 30\nKPX r n 25\nKPX r m 25\nKPX r l 15\nKPX r k 1"
 & "5\nKPX r i 15\nKPX r comma -50\nKPX r colon 30\nKPX r a -10\n\nKPX s w "
 & "-30\nKPX s period -15\nKPX s comma -15\n\nKPX semicolon space -50\n\nKP"
 & "X space quoteleft -60\nKPX space quotedblleft -30\nKPX space Y -90\nKPX"
 & " space W -40\nKPX space V -50\nKPX space T -50\n\nKPX v period -80\nKPX"
 & " v o -25\nKPX v e -25\nKPX v comma -80\nKPX v a -25\n\nKPX w period -60"
 & "\nKPX w o -10\nKPX w e -10\nKPX w comma -60\nKPX w a -15\n\nKPX x e -30"
 & "\n\nKPX y period -100\nKPX y o -20\nKPX y e -20\nKPX y comma -100\nKPX "
 & "y a -20\n\nKPX z o -15\nKPX z e -15\nEndKernPairs\nEndKernData\nStartCo"
 & "mposites 58\nCC Aacute 2 ; PCC A 0 0 ; PCC acute 167 195 ;\nCC Acircumf"
 & "lex 2 ; PCC A 0 0 ; PCC circumflex 167 195 ;\nCC Adieresis 2 ; PCC A 0 "
 & "0 ; PCC dieresis 167 195 ;\nCC Agrave 2 ; PCC A 0 0 ; PCC grave 167 195"
 & " ;\nCC Aring 2 ; PCC A 0 0 ; PCC ring 167 175 ;\nCC Atilde 2 ; PCC A 0 "
 & "0 ; PCC tilde 167 195 ;\nCC Ccedilla 2 ; PCC C 0 0 ; PCC cedilla 195 0 "
 & ";\nCC Eacute 2 ; PCC E 0 0 ; PCC acute 167 195 ;\nCC Ecircumflex 2 ; PC"
 & "C E 0 0 ; PCC circumflex 167 195 ;\nCC Edieresis 2 ; PCC E 0 0 ; PCC di"
 & "eresis 167 195 ;\nCC Egrave 2 ; PCC E 0 0 ; PCC grave 167 195 ;\nCC Iac"
 & "ute 2 ; PCC I 0 0 ; PCC acute -27 195 ;\nCC Icircumflex 2 ; PCC I 0 0 ;"
 & " PCC circumflex -27 195 ;\nCC Idieresis 2 ; PCC I 0 0 ; PCC dieresis -2"
 & "7 195 ;\nCC Igrave 2 ; PCC I 0 0 ; PCC grave -27 195 ;\nCC Ntilde 2 ; P"
 & "CC N 0 0 ; PCC tilde 205 195 ;\nCC Oacute 2 ; PCC O 0 0 ; PCC acute 223"
 & " 195 ;\nCC Ocircumflex 2 ; PCC O 0 0 ; PCC circumflex 223 195 ;\nCC Odi"
 & "eresis 2 ; PCC O 0 0 ; PCC dieresis 223 195 ;\nCC Ograve 2 ; PCC O 0 0 "
 & "; PCC grave 223 195 ;\nCC Otilde 2 ;";

CONST E12_7 = 
   " PCC O 0 0 ; PCC tilde 223 195 ;\nCC Scaron 2 ; PCC S 0 0 ; PCC caron 1"
 & "67 195 ;\nCC Uacute 2 ; PCC U 0 0 ; PCC acute 195 195 ;\nCC Ucircumflex"
 & " 2 ; PCC U 0 0 ; PCC circumflex 195 195 ;\nCC Udieresis 2 ; PCC U 0 0 ;"
 & " PCC dieresis 195 195 ;\nCC Ugrave 2 ; PCC U 0 0 ; PCC grave 195 195 ;\n"
 & "CC Yacute 2 ; PCC Y 0 0 ; PCC acute 167 195 ;\nCC Ydieresis 2 ; PCC Y 0"
 & " 0 ; PCC dieresis 167 195 ;\nCC Zcaron 2 ; PCC Z 0 0 ; PCC caron 139 19"
 & "5 ;\nCC aacute 2 ; PCC a 0 0 ; PCC acute 112 0 ;\nCC acircumflex 2 ; PC"
 & "C a 0 0 ; PCC circumflex 112 0 ;\nCC adieresis 2 ; PCC a 0 0 ; PCC dier"
 & "esis 112 0 ;\nCC agrave 2 ; PCC a 0 0 ; PCC grave 112 0 ;\nCC aring 2 ;"
 & " PCC a 0 0 ; PCC ring 112 0 ;\nCC atilde 2 ; PCC a 0 0 ; PCC tilde 102 "
 & "0 ;\nCC ccedilla 2 ; PCC c 0 0 ; PCC cedilla 84 0 ;\nCC eacute 2 ; PCC "
 & "e 0 0 ; PCC acute 112 0 ;\nCC ecircumflex 2 ; PCC e 0 0 ; PCC circumfle"
 & "x 112 0 ;\nCC edieresis 2 ; PCC e 0 0 ; PCC dieresis 112 0 ;\nCC egrave"
 & " 2 ; PCC e 0 0 ; PCC grave 112 0 ;\nCC iacute 2 ; PCC dotlessi 0 0 ; PC"
 & "C acute -27 0 ;\nCC icircumflex 2 ; PCC dotlessi 0 0 ; PCC circumflex -"
 & "27 0 ;\nCC idieresis 2 ; PCC dotlessi 0 0 ; PCC dieresis -27 0 ;\nCC ig"
 & "rave 2 ; PCC dotlessi 0 0 ; PCC grave -27 0 ;\nCC ntilde 2 ; PCC n 0 0 "
 & "; PCC tilde 102 0 ;\nCC oacute 2 ; PCC o 0 0 ; PCC acute 112 0 ;\nCC oc"
 & "ircumflex 2 ; PCC o 0 0 ; PCC circumflex 112 0 ;\nCC odieresis 2 ; PCC "
 & "o 0 0 ; PCC dieresis 112 0 ;\nCC ograve 2 ; PCC o 0 0 ; PCC grave 112 0"
 & " ;\nCC otilde 2 ; PCC o 0 0 ; PCC tilde 112 0 ;\nCC scaron 2 ; PCC s 0 "
 & "0 ; PCC caron 84 0 ;\nCC uacute 2 ; PCC u 0 0 ; PCC acute 112 0 ;\nCC u"
 & "circumflex 2 ; PCC u 0 0 ; PCC circumflex 112 0 ;\nCC udieresis 2 ; PCC"
 & " u 0 0 ; PCC dieresis 112 0 ;\nCC ugrave 2 ; PCC u 0 0 ; PCC grave 112 "
 & "0 ;\nCC yacute 2 ; PCC y 0 0 ; PCC acute 84 0 ;\nCC ydieresis 2 ; PCC y"
 & " 0 0 ; PCC dieresis 84 0 ;\nCC zcaron 2 ; PCC z 0 0 ; PCC caron 84 0 ;\n"
 & "EndComposites\nEndFontMetrics\n";

CONST E13 = 
   "StartFontMetrics 2.0\nComment Copyright (c) 1989, 1990, 1991, Adobe Sys"
 & "tems Incorporated. All rights reserved.\nComment Creation Date: Tue Sep"
 & " 17 14:02:41 1991\nComment UniqueID 36384\nComment VMusage 31992 40360\n"
 & "FontName Courier-Bold\nFullName Courier Bold\nFamilyName Courier\nWeigh"
 & "t Bold\nItalicAngle 0\nIsFixedPitch true\nFontBBox -113 -250 749 801\nU"
 & "nderlinePosition -100\nUnderlineThickness 50\nVersion 002.004\nNotice C"
 & "opyright (c) 1989, 1990, 1991, Adobe Systems Incorporated. All rights r"
 & "eserved.\nEncodingScheme AdobeStandardEncoding\nCapHeight 562\nXHeight "
 & "439\nAscender 626\nDescender -142\nStartCharMetrics 260\nC 32 ; WX 600 "
 & "; N space ; B 0 0 0 0 ;\nC 33 ; WX 600 ; N exclam ; B 202 -15 398 572 ;"
 & "\nC 34 ; WX 600 ; N quotedbl ; B 135 277 465 562 ;\nC 35 ; WX 600 ; N n"
 & "umbersign ; B 56 -45 544 651 ;\nC 36 ; WX 600 ; N dollar ; B 82 -126 51"
 & "9 666 ;\nC 37 ; WX 600 ; N percent ; B 5 -15 595 616 ;\nC 38 ; WX 600 ;"
 & " N ampersand ; B 36 -15 546 543 ;\nC 39 ; WX 600 ; N quoteright ; B 171"
 & " 277 423 562 ;\nC 40 ; WX 600 ; N parenleft ; B 219 -102 461 616 ;\nC 4"
 & "1 ; WX 600 ; N parenright ; B 139 -102 381 616 ;\nC 42 ; WX 600 ; N ast"
 & "erisk ; B 91 219 509 601 ;\nC 43 ; WX 600 ; N plus ; B 71 39 529 478 ;\n"
 & "C 44 ; WX 600 ; N comma ; B 123 -111 393 174 ;\nC 45 ; WX 600 ; N hyphe"
 & "n ; B 100 203 500 313 ;\nC 46 ; WX 600 ; N period ; B 192 -15 408 171 ;"
 & "\nC 47 ; WX 600 ; N slash ; B 98 -77 502 626 ;\nC 48 ; WX 600 ; N zero "
 & "; B 87 -15 513 616 ;\nC 49 ; WX 600 ; N one ; B 81 0 539 616 ;\nC 50 ; "
 & "WX 600 ; N two ; B 61 0 499 616 ;\nC 51 ; WX 600 ; N three ; B 63 -15 5"
 & "01 616 ;\nC 52 ; WX 600 ; N four ; B 53 0 507 616 ;\nC 53 ; WX 600 ; N "
 & "five ; B 70 -15 521 601 ;\nC 54 ; WX 600 ; N six ; B 90 -15 521 616 ;\n"
 & "C 55 ; WX 600 ; N seven ; B 55 0 494 601 ;\nC 56 ; WX 600 ; N eight ; B"
 & " 83 -15 517 616 ;\nC 57 ; WX 600 ; N nine ; B 79 -15 510 616 ;\nC 58 ; "
 & "WX 600 ; N colon ; B 191 -15 407 425 ;\nC 59 ; WX 600 ; N semicolon ; B"
 & " 123 -111 408 425 ;\nC 60 ; WX 600 ; N less ; B 66 15 523 501 ;\nC 61 ;"
 & " WX 600 ; N equal ; B 71 118 529 398 ;\nC 62 ; WX 600 ; N grea";

CONST E13_0 = 
   "ter ; B 77 15 534 501 ;\nC 63 ; WX 600 ; N question ; B 98 -14 501 580 "
 & ";\nC 64 ; WX 600 ; N at ; B 16 -15 584 616 ;\nC 65 ; WX 600 ; N A ; B -"
 & "9 0 609 562 ;\nC 66 ; WX 600 ; N B ; B 30 0 573 562 ;\nC 67 ; WX 600 ; "
 & "N C ; B 22 -18 560 580 ;\nC 68 ; WX 600 ; N D ; B 30 0 594 562 ;\nC 69 "
 & "; WX 600 ; N E ; B 25 0 560 562 ;\nC 70 ; WX 600 ; N F ; B 39 0 570 562"
 & " ;\nC 71 ; WX 600 ; N G ; B 22 -18 594 580 ;\nC 72 ; WX 600 ; N H ; B 2"
 & "0 0 580 562 ;\nC 73 ; WX 600 ; N I ; B 77 0 523 562 ;\nC 74 ; WX 600 ; "
 & "N J ; B 37 -18 601 562 ;\nC 75 ; WX 600 ; N K ; B 21 0 599 562 ;\nC 76 "
 & "; WX 600 ; N L ; B 39 0 578 562 ;\nC 77 ; WX 600 ; N M ; B -2 0 602 562"
 & " ;\nC 78 ; WX 600 ; N N ; B 8 -12 610 562 ;\nC 79 ; WX 600 ; N O ; B 22"
 & " -18 578 580 ;\nC 80 ; WX 600 ; N P ; B 48 0 559 562 ;\nC 81 ; WX 600 ;"
 & " N Q ; B 32 -138 578 580 ;\nC 82 ; WX 600 ; N R ; B 24 0 599 562 ;\nC 8"
 & "3 ; WX 600 ; N S ; B 47 -22 553 582 ;\nC 84 ; WX 600 ; N T ; B 21 0 579"
 & " 562 ;\nC 85 ; WX 600 ; N U ; B 4 -18 596 562 ;\nC 86 ; WX 600 ; N V ; "
 & "B -13 0 613 562 ;\nC 87 ; WX 600 ; N W ; B -18 0 618 562 ;\nC 88 ; WX 6"
 & "00 ; N X ; B 12 0 588 562 ;\nC 89 ; WX 600 ; N Y ; B 12 0 589 562 ;\nC "
 & "90 ; WX 600 ; N Z ; B 62 0 539 562 ;\nC 91 ; WX 600 ; N bracketleft ; B"
 & " 245 -102 475 616 ;\nC 92 ; WX 600 ; N backslash ; B 99 -77 503 626 ;\n"
 & "C 93 ; WX 600 ; N bracketright ; B 125 -102 355 616 ;\nC 94 ; WX 600 ; "
 & "N asciicircum ; B 108 250 492 616 ;\nC 95 ; WX 600 ; N underscore ; B 0"
 & " -125 600 -75 ;\nC 96 ; WX 600 ; N quoteleft ; B 178 277 428 562 ;\nC 9"
 & "7 ; WX 600 ; N a ; B 35 -15 570 454 ;\nC 98 ; WX 600 ; N b ; B 0 -15 58"
 & "4 626 ;\nC 99 ; WX 600 ; N c ; B 40 -15 545 459 ;\nC 100 ; WX 600 ; N d"
 & " ; B 20 -15 591 626 ;\nC 101 ; WX 600 ; N e ; B 40 -15 563 454 ;\nC 102"
 & " ; WX 600 ; N f ; B 83 0 547 626 ; L i fi ; L l fl ;\nC 103 ; WX 600 ; "
 & "N g ; B 30 -146 580 454 ;\nC 104 ; WX 600 ; N h ; B 5 0 592 626 ;\nC 10"
 & "5 ; WX 600 ; N i ; B 77 0 523 658 ;\nC 106 ; WX 600 ; N j ; B 63 -146 4"
 & "40 658 ;\nC 107 ; WX 600 ; N k ; B 20 0 585 626 ;\nC 108 ; WX 600 ; N l"
 & " ; B 77 0 523 626 ;\nC 109 ; WX 600 ; N m ; B -22 0 626 454";

CONST E13_1 = 
   " ;\nC 110 ; WX 600 ; N n ; B 18 0 592 454 ;\nC 111 ; WX 600 ; N o ; B 3"
 & "0 -15 570 454 ;\nC 112 ; WX 600 ; N p ; B -1 -142 570 454 ;\nC 113 ; WX"
 & " 600 ; N q ; B 20 -142 591 454 ;\nC 114 ; WX 600 ; N r ; B 47 0 580 454"
 & " ;\nC 115 ; WX 600 ; N s ; B 68 -17 535 459 ;\nC 116 ; WX 600 ; N t ; B"
 & " 47 -15 532 562 ;\nC 117 ; WX 600 ; N u ; B -1 -15 569 439 ;\nC 118 ; W"
 & "X 600 ; N v ; B -1 0 601 439 ;\nC 119 ; WX 600 ; N w ; B -18 0 618 439 "
 & ";\nC 120 ; WX 600 ; N x ; B 6 0 594 439 ;\nC 121 ; WX 600 ; N y ; B -4 "
 & "-142 601 439 ;\nC 122 ; WX 600 ; N z ; B 81 0 520 439 ;\nC 123 ; WX 600"
 & " ; N braceleft ; B 160 -102 464 616 ;\nC 124 ; WX 600 ; N bar ; B 255 -"
 & "250 345 750 ;\nC 125 ; WX 600 ; N braceright ; B 136 -102 440 616 ;\nC "
 & "126 ; WX 600 ; N asciitilde ; B 71 153 530 356 ;\nC 161 ; WX 600 ; N ex"
 & "clamdown ; B 202 -146 398 449 ;\nC 162 ; WX 600 ; N cent ; B 66 -49 518"
 & " 614 ;\nC 163 ; WX 600 ; N sterling ; B 72 -28 558 611 ;\nC 164 ; WX 60"
 & "0 ; N fraction ; B 25 -60 576 661 ;\nC 165 ; WX 600 ; N yen ; B 10 0 59"
 & "0 562 ;\nC 166 ; WX 600 ; N florin ; B -30 -131 572 616 ;\nC 167 ; WX 6"
 & "00 ; N section ; B 83 -70 517 580 ;\nC 168 ; WX 600 ; N currency ; B 54"
 & " 49 546 517 ;\nC 169 ; WX 600 ; N quotesingle ; B 227 277 373 562 ;\nC "
 & "170 ; WX 600 ; N quotedblleft ; B 71 277 535 562 ;\nC 171 ; WX 600 ; N "
 & "guillemotleft ; B 8 70 553 446 ;\nC 172 ; WX 600 ; N guilsinglleft ; B "
 & "141 70 459 446 ;\nC 173 ; WX 600 ; N guilsinglright ; B 141 70 459 446 "
 & ";\nC 174 ; WX 600 ; N fi ; B 12 0 593 626 ;\nC 175 ; WX 600 ; N fl ; B "
 & "12 0 593 626 ;\nC 177 ; WX 600 ; N endash ; B 65 203 535 313 ;\nC 178 ;"
 & " WX 600 ; N dagger ; B 106 -70 494 580 ;\nC 179 ; WX 600 ; N daggerdbl "
 & "; B 106 -70 494 580 ;\nC 180 ; WX 600 ; N periodcentered ; B 196 165 40"
 & "4 351 ;\nC 182 ; WX 600 ; N paragraph ; B 6 -70 576 580 ;\nC 183 ; WX 6"
 & "00 ; N bullet ; B 140 132 460 430 ;\nC 184 ; WX 600 ; N quotesinglbase "
 & "; B 175 -142 427 143 ;\nC 185 ; WX 600 ; N quotedblbase ; B 65 -142 529"
 & " 143 ;\nC 186 ; WX 600 ; N quotedblright ; B 61 277 525 562 ;\nC 187 ; "
 & "WX 600 ; N guillemotright ; B 47 70 592 446 ;\nC 188 ; ";

CONST E13_2 = 
   "WX 600 ; N ellipsis ; B 26 -15 574 116 ;\nC 189 ; WX 600 ; N perthousan"
 & "d ; B -113 -15 713 616 ;\nC 191 ; WX 600 ; N questiondown ; B 99 -146 5"
 & "02 449 ;\nC 193 ; WX 600 ; N grave ; B 132 508 395 661 ;\nC 194 ; WX 60"
 & "0 ; N acute ; B 205 508 468 661 ;\nC 195 ; WX 600 ; N circumflex ; B 10"
 & "3 483 497 657 ;\nC 196 ; WX 600 ; N tilde ; B 89 493 512 636 ;\nC 197 ;"
 & " WX 600 ; N macron ; B 88 505 512 585 ;\nC 198 ; WX 600 ; N breve ; B 8"
 & "3 468 517 631 ;\nC 199 ; WX 600 ; N dotaccent ; B 230 485 370 625 ;\nC "
 & "200 ; WX 600 ; N dieresis ; B 128 485 472 625 ;\nC 202 ; WX 600 ; N rin"
 & "g ; B 198 481 402 678 ;\nC 203 ; WX 600 ; N cedilla ; B 205 -206 387 0 "
 & ";\nC 205 ; WX 600 ; N hungarumlaut ; B 68 488 588 661 ;\nC 206 ; WX 600"
 & " ; N ogonek ; B 169 -199 367 0 ;\nC 207 ; WX 600 ; N caron ; B 103 493 "
 & "497 667 ;\nC 208 ; WX 600 ; N emdash ; B -10 203 610 313 ;\nC 225 ; WX "
 & "600 ; N AE ; B -29 0 602 562 ;\nC 227 ; WX 600 ; N ordfeminine ; B 147 "
 & "196 453 580 ;\nC 232 ; WX 600 ; N Lslash ; B 39 0 578 562 ;\nC 233 ; WX"
 & " 600 ; N Oslash ; B 22 -22 578 584 ;\nC 234 ; WX 600 ; N OE ; B -25 0 5"
 & "95 562 ;\nC 235 ; WX 600 ; N ordmasculine ; B 147 196 453 580 ;\nC 241 "
 & "; WX 600 ; N ae ; B -4 -15 601 454 ;\nC 245 ; WX 600 ; N dotlessi ; B 7"
 & "7 0 523 439 ;\nC 248 ; WX 600 ; N lslash ; B 77 0 523 626 ;\nC 249 ; WX"
 & " 600 ; N oslash ; B 30 -24 570 463 ;\nC 250 ; WX 600 ; N oe ; B -18 -15"
 & " 611 454 ;\nC 251 ; WX 600 ; N germandbls ; B 22 -15 596 626 ;\nC -1 ; "
 & "WX 600 ; N Odieresis ; B 22 -18 578 748 ;\nC -1 ; WX 600 ; N logicalnot"
 & " ; B 71 103 529 413 ;\nC -1 ; WX 600 ; N minus ; B 71 203 529 313 ;\nC "
 & "-1 ; WX 600 ; N merge ; B 137 -15 464 487 ;\nC -1 ; WX 600 ; N degree ;"
 & " B 86 243 474 616 ;\nC -1 ; WX 600 ; N dectab ; B 8 0 592 320 ;\nC -1 ;"
 & " WX 600 ; N ll ; B -12 0 600 626 ;\nC -1 ; WX 600 ; N IJ ; B -8 -18 622"
 & " 562 ;\nC -1 ; WX 600 ; N Eacute ; B 25 0 560 784 ;\nC -1 ; WX 600 ; N "
 & "Ocircumflex ; B 22 -18 578 780 ;\nC -1 ; WX 600 ; N ucircumflex ; B -1 "
 & "-15 569 657 ;\nC -1 ; WX 600 ; N left ; B 65 44 535 371 ;\nC -1 ; WX 60"
 & "0 ; N threesuperior ; B 138 222 433 616 ;\nC -1 ; WX 6";

CONST E13_3 = 
   "00 ; N up ; B 136 0 463 447 ;\nC -1 ; WX 600 ; N multiply ; B 81 39 520"
 & " 478 ;\nC -1 ; WX 600 ; N Scaron ; B 47 -22 553 790 ;\nC -1 ; WX 600 ; "
 & "N tab ; B 19 0 581 562 ;\nC -1 ; WX 600 ; N Ucircumflex ; B 4 -18 596 7"
 & "80 ;\nC -1 ; WX 600 ; N divide ; B 71 16 529 500 ;\nC -1 ; WX 600 ; N A"
 & "circumflex ; B -9 0 609 780 ;\nC -1 ; WX 600 ; N eacute ; B 40 -15 563 "
 & "661 ;\nC -1 ; WX 600 ; N uacute ; B -1 -15 569 661 ;\nC -1 ; WX 600 ; N"
 & " Aacute ; B -9 0 609 784 ;\nC -1 ; WX 600 ; N copyright ; B 0 -18 600 5"
 & "80 ;\nC -1 ; WX 600 ; N twosuperior ; B 143 230 436 616 ;\nC -1 ; WX 60"
 & "0 ; N Ecircumflex ; B 25 0 560 780 ;\nC -1 ; WX 600 ; N ntilde ; B 18 0"
 & " 592 636 ;\nC -1 ; WX 600 ; N down ; B 137 -15 464 439 ;\nC -1 ; WX 600"
 & " ; N center ; B 40 14 560 580 ;\nC -1 ; WX 600 ; N onesuperior ; B 153 "
 & "230 447 616 ;\nC -1 ; WX 600 ; N ij ; B 6 -146 574 658 ;\nC -1 ; WX 600"
 & " ; N edieresis ; B 40 -15 563 625 ;\nC -1 ; WX 600 ; N graybox ; B 76 0"
 & " 525 599 ;\nC -1 ; WX 600 ; N odieresis ; B 30 -15 570 625 ;\nC -1 ; WX"
 & " 600 ; N Ograve ; B 22 -18 578 784 ;\nC -1 ; WX 600 ; N threequarters ;"
 & " B -47 -60 648 661 ;\nC -1 ; WX 600 ; N plusminus ; B 71 24 529 515 ;\n"
 & "C -1 ; WX 600 ; N prescription ; B 24 -15 599 562 ;\nC -1 ; WX 600 ; N "
 & "eth ; B 58 -27 543 626 ;\nC -1 ; WX 600 ; N largebullet ; B 248 229 352"
 & " 333 ;\nC -1 ; WX 600 ; N egrave ; B 40 -15 563 661 ;\nC -1 ; WX 600 ; "
 & "N ccedilla ; B 40 -206 545 459 ;\nC -1 ; WX 600 ; N notegraphic ; B 77 "
 & "-15 523 572 ;\nC -1 ; WX 600 ; N Udieresis ; B 4 -18 596 748 ;\nC -1 ; "
 & "WX 600 ; N Gcaron ; B 22 -18 594 790 ;\nC -1 ; WX 600 ; N arrowdown ; B"
 & " 144 -15 456 608 ;\nC -1 ; WX 600 ; N format ; B 5 -146 115 601 ;\nC -1"
 & " ; WX 600 ; N Otilde ; B 22 -18 578 759 ;\nC -1 ; WX 600 ; N Idieresis "
 & "; B 77 0 523 748 ;\nC -1 ; WX 600 ; N adieresis ; B 35 -15 570 625 ;\nC"
 & " -1 ; WX 600 ; N ecircumflex ; B 40 -15 563 657 ;\nC -1 ; WX 600 ; N Et"
 & "h ; B 30 0 594 562 ;\nC -1 ; WX 600 ; N onequarter ; B -56 -60 656 661 "
 & ";\nC -1 ; WX 600 ; N LL ; B -45 0 645 562 ;\nC -1 ; WX 600 ; N agrave ;"
 & " B 35 -15 570 661 ;\nC -1 ; WX 600 ; N Zcaron ; B 62 0";

CONST E13_4 = 
   " 539 790 ;\nC -1 ; WX 600 ; N Scedilla ; B 47 -206 553 582 ;\nC -1 ; WX"
 & " 600 ; N Idot ; B 77 0 523 748 ;\nC -1 ; WX 600 ; N Iacute ; B 77 0 523"
 & " 784 ;\nC -1 ; WX 600 ; N indent ; B 65 45 535 372 ;\nC -1 ; WX 600 ; N"
 & " Ugrave ; B 4 -18 596 784 ;\nC -1 ; WX 600 ; N scaron ; B 68 -17 535 66"
 & "7 ;\nC -1 ; WX 600 ; N overscore ; B 0 579 600 629 ;\nC -1 ; WX 600 ; N"
 & " Aring ; B -9 0 609 801 ;\nC -1 ; WX 600 ; N Ccedilla ; B 22 -206 560 5"
 & "80 ;\nC -1 ; WX 600 ; N Igrave ; B 77 0 523 784 ;\nC -1 ; WX 600 ; N br"
 & "okenbar ; B 255 -175 345 675 ;\nC -1 ; WX 600 ; N Oacute ; B 22 -18 578"
 & " 784 ;\nC -1 ; WX 600 ; N otilde ; B 30 -15 570 636 ;\nC -1 ; WX 600 ; "
 & "N Yacute ; B 12 0 589 784 ;\nC -1 ; WX 600 ; N lira ; B 72 -28 558 611 "
 & ";\nC -1 ; WX 600 ; N Icircumflex ; B 77 0 523 780 ;\nC -1 ; WX 600 ; N "
 & "Atilde ; B -9 0 609 759 ;\nC -1 ; WX 600 ; N Uacute ; B 4 -18 596 784 ;"
 & "\nC -1 ; WX 600 ; N Ydieresis ; B 12 0 589 748 ;\nC -1 ; WX 600 ; N ydi"
 & "eresis ; B -4 -142 601 625 ;\nC -1 ; WX 600 ; N idieresis ; B 77 0 523 "
 & "625 ;\nC -1 ; WX 600 ; N Adieresis ; B -9 0 609 748 ;\nC -1 ; WX 600 ; "
 & "N mu ; B -1 -142 569 439 ;\nC -1 ; WX 600 ; N trademark ; B -9 230 749 "
 & "562 ;\nC -1 ; WX 600 ; N oacute ; B 30 -15 570 661 ;\nC -1 ; WX 600 ; N"
 & " acircumflex ; B 35 -15 570 657 ;\nC -1 ; WX 600 ; N Agrave ; B -9 0 60"
 & "9 784 ;\nC -1 ; WX 600 ; N return ; B 19 0 581 562 ;\nC -1 ; WX 600 ; N"
 & " atilde ; B 35 -15 570 636 ;\nC -1 ; WX 600 ; N square ; B 19 0 581 562"
 & " ;\nC -1 ; WX 600 ; N registered ; B 0 -18 600 580 ;\nC -1 ; WX 600 ; N"
 & " stop ; B 19 0 581 562 ;\nC -1 ; WX 600 ; N udieresis ; B -1 -15 569 62"
 & "5 ;\nC -1 ; WX 600 ; N arrowup ; B 144 3 456 626 ;\nC -1 ; WX 600 ; N i"
 & "grave ; B 77 0 523 661 ;\nC -1 ; WX 600 ; N Edieresis ; B 25 0 560 748 "
 & ";\nC -1 ; WX 600 ; N zcaron ; B 81 0 520 667 ;\nC -1 ; WX 600 ; N arrow"
 & "both ; B -24 143 624 455 ;\nC -1 ; WX 600 ; N gcaron ; B 30 -146 580 66"
 & "7 ;\nC -1 ; WX 600 ; N arrowleft ; B -24 143 634 455 ;\nC -1 ; WX 600 ;"
 & " N aacute ; B 35 -15 570 661 ;\nC -1 ; WX 600 ; N ocircumflex ; B 30 -1"
 & "5 570 657 ;\nC -1 ; WX 600 ; N scedilla ; B 68 -206 535";

CONST E13_5 = 
   " 459 ;\nC -1 ; WX 600 ; N ograve ; B 30 -15 570 661 ;\nC -1 ; WX 600 ; "
 & "N onehalf ; B -47 -60 648 661 ;\nC -1 ; WX 600 ; N ugrave ; B -1 -15 56"
 & "9 661 ;\nC -1 ; WX 600 ; N Ntilde ; B 8 -12 610 759 ;\nC -1 ; WX 600 ; "
 & "N iacute ; B 77 0 523 661 ;\nC -1 ; WX 600 ; N arrowright ; B -34 143 6"
 & "24 455 ;\nC -1 ; WX 600 ; N Thorn ; B 48 0 557 562 ;\nC -1 ; WX 600 ; N"
 & " Egrave ; B 25 0 560 784 ;\nC -1 ; WX 600 ; N thorn ; B -14 -142 570 62"
 & "6 ;\nC -1 ; WX 600 ; N aring ; B 35 -15 570 678 ;\nC -1 ; WX 600 ; N ya"
 & "cute ; B -4 -142 601 661 ;\nC -1 ; WX 600 ; N icircumflex ; B 63 0 523 "
 & "657 ;\nEndCharMetrics\nStartComposites 58\nCC Aacute 2 ; PCC A 0 0 ; PC"
 & "C acute 30 123 ;\nCC Acircumflex 2 ; PCC A 0 0 ; PCC circumflex -30 123"
 & " ;\nCC Adieresis 2 ; PCC A 0 0 ; PCC dieresis -20 123 ;\nCC Agrave 2 ; "
 & "PCC A 0 0 ; PCC grave -50 123 ;\nCC Aring 2 ; PCC A 0 0 ; PCC ring -10 "
 & "123 ;\nCC Atilde 2 ; PCC A 0 0 ; PCC tilde -30 123 ;\nCC Eacute 2 ; PCC"
 & " E 0 0 ; PCC acute 30 123 ;\nCC Ecircumflex 2 ; PCC E 0 0 ; PCC circumf"
 & "lex 0 123 ;\nCC Edieresis 2 ; PCC E 0 0 ; PCC dieresis 0 123 ;\nCC Egra"
 & "ve 2 ; PCC E 0 0 ; PCC grave 0 123 ;\nCC Gcaron 2 ; PCC G 0 0 ; PCC car"
 & "on 10 123 ;\nCC Iacute 2 ; PCC I 0 0 ; PCC acute 0 123 ;\nCC Icircumfle"
 & "x 2 ; PCC I 0 0 ; PCC circumflex 0 123 ;\nCC Idieresis 2 ; PCC I 0 0 ; "
 & "PCC dieresis 0 123 ;\nCC Igrave 2 ; PCC I 0 0 ; PCC grave 0 123 ;\nCC N"
 & "tilde 2 ; PCC N 0 0 ; PCC tilde 0 123 ;\nCC Oacute 2 ; PCC O 0 0 ; PCC "
 & "acute 0 123 ;\nCC Ocircumflex 2 ; PCC O 0 0 ; PCC circumflex 0 123 ;\nC"
 & "C Odieresis 2 ; PCC O 0 0 ; PCC dieresis 0 123 ;\nCC Ograve 2 ; PCC O 0"
 & " 0 ; PCC grave 0 123 ;\nCC Otilde 2 ; PCC O 0 0 ; PCC tilde 0 123 ;\nCC"
 & " Scaron 2 ; PCC S 0 0 ; PCC caron 0 123 ;\nCC Uacute 2 ; PCC U 0 0 ; PC"
 & "C acute 30 123 ;\nCC Ucircumflex 2 ; PCC U 0 0 ; PCC circumflex 0 123 ;"
 & "\nCC Udieresis 2 ; PCC U 0 0 ; PCC dieresis 0 123 ;\nCC Ugrave 2 ; PCC "
 & "U 0 0 ; PCC grave -30 123 ;\nCC Yacute 2 ; PCC Y 0 0 ; PCC acute 30 123"
 & " ;\nCC Ydieresis 2 ; PCC Y 0 0 ; PCC dieresis 0 123 ;\nCC Zcaron 2 ; PC"
 & "C Z 0 0 ; PCC caron 0 123 ;\nCC aacute 2 ; PCC a 0 0 ; P";

CONST E13_6 = 
   "CC acute 0 0 ;\nCC acircumflex 2 ; PCC a 0 0 ; PCC circumflex -20 0 ;\n"
 & "CC adieresis 2 ; PCC a 0 0 ; PCC dieresis -10 0 ;\nCC agrave 2 ; PCC a "
 & "0 0 ; PCC grave -30 0 ;\nCC aring 2 ; PCC a 0 0 ; PCC ring 0 0 ;\nCC at"
 & "ilde 2 ; PCC a 0 0 ; PCC tilde 0 0 ;\nCC eacute 2 ; PCC e 0 0 ; PCC acu"
 & "te 0 0 ;\nCC ecircumflex 2 ; PCC e 0 0 ; PCC circumflex 0 0 ;\nCC edier"
 & "esis 2 ; PCC e 0 0 ; PCC dieresis 0 0 ;\nCC egrave 2 ; PCC e 0 0 ; PCC "
 & "grave 0 0 ;\nCC gcaron 2 ; PCC g 0 0 ; PCC caron -40 0 ;\nCC iacute 2 ;"
 & " PCC dotlessi 0 0 ; PCC acute 0 0 ;\nCC icircumflex 2 ; PCC dotlessi 0 "
 & "0 ; PCC circumflex -40 0 ;\nCC idieresis 2 ; PCC dotlessi 0 0 ; PCC die"
 & "resis -40 0 ;\nCC igrave 2 ; PCC dotlessi 0 0 ; PCC grave 0 0 ;\nCC nti"
 & "lde 2 ; PCC n 0 0 ; PCC tilde 0 0 ;\nCC oacute 2 ; PCC o 0 0 ; PCC acut"
 & "e 0 0 ;\nCC ocircumflex 2 ; PCC o 0 0 ; PCC circumflex 0 0 ;\nCC odiere"
 & "sis 2 ; PCC o 0 0 ; PCC dieresis 0 0 ;\nCC ograve 2 ; PCC o 0 0 ; PCC g"
 & "rave 0 0 ;\nCC otilde 2 ; PCC o 0 0 ; PCC tilde 0 0 ;\nCC scaron 2 ; PC"
 & "C s 0 0 ; PCC caron 0 0 ;\nCC uacute 2 ; PCC u 0 0 ; PCC acute 0 0 ;\nC"
 & "C ucircumflex 2 ; PCC u 0 0 ; PCC circumflex -20 0 ;\nCC udieresis 2 ; "
 & "PCC u 0 0 ; PCC dieresis -20 0 ;\nCC ugrave 2 ; PCC u 0 0 ; PCC grave -"
 & "30 0 ;\nCC yacute 2 ; PCC y 0 0 ; PCC acute 30 0 ;\nCC ydieresis 2 ; PC"
 & "C y 0 0 ; PCC dieresis 10 0 ;\nCC zcaron 2 ; PCC z 0 0 ; PCC caron 0 0 "
 & ";\nEndComposites\nEndFontMetrics\n";

CONST E14 = 
   "StartFontMetrics 2.0\nComment Copyright (c) 1985, 1987, 1989, 1990 Adob"
 & "e Systems Incorporated.  All Rights Reserved.\nComment Creation Date: T"
 & "ue Mar 20 12:17:14 1990\nComment UniqueID 28417\nComment VMusage 30458 "
 & "37350\nFontName Times-Bold\nFullName Times Bold\nFamilyName Times\nWeig"
 & "ht Bold\nItalicAngle 0\nIsFixedPitch false\nFontBBox -168 -218 1000 935"
 & "\nUnderlinePosition -100\nUnderlineThickness 50\nVersion 001.007\nNotic"
 & "e Copyright (c) 1985, 1987, 1989, 1990 Adobe Systems Incorporated.  All"
 & " Rights Reserved.Times is a trademark of Linotype AG and/or its subsidi"
 & "aries.\nEncodingScheme AdobeStandardEncoding\nCapHeight 676\nXHeight 46"
 & "1\nAscender 676\nDescender -205\nStartCharMetrics 228\nC 32 ; WX 250 ; "
 & "N space ; B 0 0 0 0 ;\nC 33 ; WX 333 ; N exclam ; B 81 -13 251 691 ;\nC"
 & " 34 ; WX 555 ; N quotedbl ; B 83 404 472 691 ;\nC 35 ; WX 500 ; N numbe"
 & "rsign ; B 4 0 496 700 ;\nC 36 ; WX 500 ; N dollar ; B 29 -99 472 750 ;\n"
 & "C 37 ; WX 1000 ; N percent ; B 124 -14 877 692 ;\nC 38 ; WX 833 ; N amp"
 & "ersand ; B 62 -16 787 691 ;\nC 39 ; WX 333 ; N quoteright ; B 79 356 26"
 & "3 691 ;\nC 40 ; WX 333 ; N parenleft ; B 46 -168 306 694 ;\nC 41 ; WX 3"
 & "33 ; N parenright ; B 27 -168 287 694 ;\nC 42 ; WX 500 ; N asterisk ; B"
 & " 56 255 447 691 ;\nC 43 ; WX 570 ; N plus ; B 33 0 537 506 ;\nC 44 ; WX"
 & " 250 ; N comma ; B 39 -180 223 155 ;\nC 45 ; WX 333 ; N hyphen ; B 44 1"
 & "71 287 287 ;\nC 46 ; WX 250 ; N period ; B 41 -13 210 156 ;\nC 47 ; WX "
 & "278 ; N slash ; B -24 -19 302 691 ;\nC 48 ; WX 500 ; N zero ; B 24 -13 "
 & "476 688 ;\nC 49 ; WX 500 ; N one ; B 65 0 442 688 ;\nC 50 ; WX 500 ; N "
 & "two ; B 17 0 478 688 ;\nC 51 ; WX 500 ; N three ; B 16 -14 468 688 ;\nC"
 & " 52 ; WX 500 ; N four ; B 19 0 475 688 ;\nC 53 ; WX 500 ; N five ; B 22"
 & " -8 470 676 ;\nC 54 ; WX 500 ; N six ; B 28 -13 475 688 ;\nC 55 ; WX 50"
 & "0 ; N seven ; B 17 0 477 676 ;\nC 56 ; WX 500 ; N eight ; B 28 -13 472 "
 & "688 ;\nC 57 ; WX 500 ; N nine ; B 26 -13 473 688 ;\nC 58 ; WX 333 ; N c"
 & "olon ; B 82 -13 251 472 ;\nC 59 ; WX 333 ; N semicolon ; B 82 -180 266 "
 & "472 ;\nC 60 ; WX 570 ; N less ; B 31 -8 539 514 ;\nC 61 ; WX 5";

CONST E14_0 = 
   "70 ; N equal ; B 33 107 537 399 ;\nC 62 ; WX 570 ; N greater ; B 31 -8 "
 & "539 514 ;\nC 63 ; WX 500 ; N question ; B 57 -13 445 689 ;\nC 64 ; WX 9"
 & "30 ; N at ; B 108 -19 822 691 ;\nC 65 ; WX 722 ; N A ; B 9 0 689 690 ;\n"
 & "C 66 ; WX 667 ; N B ; B 16 0 619 676 ;\nC 67 ; WX 722 ; N C ; B 49 -19 "
 & "687 691 ;\nC 68 ; WX 722 ; N D ; B 14 0 690 676 ;\nC 69 ; WX 667 ; N E "
 & "; B 16 0 641 676 ;\nC 70 ; WX 611 ; N F ; B 16 0 583 676 ;\nC 71 ; WX 7"
 & "78 ; N G ; B 37 -19 755 691 ;\nC 72 ; WX 778 ; N H ; B 21 0 759 676 ;\n"
 & "C 73 ; WX 389 ; N I ; B 20 0 370 676 ;\nC 74 ; WX 500 ; N J ; B 3 -96 4"
 & "79 676 ;\nC 75 ; WX 778 ; N K ; B 30 0 769 676 ;\nC 76 ; WX 667 ; N L ;"
 & " B 19 0 638 676 ;\nC 77 ; WX 944 ; N M ; B 14 0 921 676 ;\nC 78 ; WX 72"
 & "2 ; N N ; B 16 -18 701 676 ;\nC 79 ; WX 778 ; N O ; B 35 -19 743 691 ;\n"
 & "C 80 ; WX 611 ; N P ; B 16 0 600 676 ;\nC 81 ; WX 778 ; N Q ; B 35 -176"
 & " 743 691 ;\nC 82 ; WX 722 ; N R ; B 26 0 715 676 ;\nC 83 ; WX 556 ; N S"
 & " ; B 35 -19 513 692 ;\nC 84 ; WX 667 ; N T ; B 31 0 636 676 ;\nC 85 ; W"
 & "X 722 ; N U ; B 16 -19 701 676 ;\nC 86 ; WX 722 ; N V ; B 16 -18 701 67"
 & "6 ;\nC 87 ; WX 1000 ; N W ; B 19 -15 981 676 ;\nC 88 ; WX 722 ; N X ; B"
 & " 16 0 699 676 ;\nC 89 ; WX 722 ; N Y ; B 15 0 699 676 ;\nC 90 ; WX 667 "
 & "; N Z ; B 28 0 634 676 ;\nC 91 ; WX 333 ; N bracketleft ; B 67 -149 301"
 & " 678 ;\nC 92 ; WX 278 ; N backslash ; B -25 -19 303 691 ;\nC 93 ; WX 33"
 & "3 ; N bracketright ; B 32 -149 266 678 ;\nC 94 ; WX 581 ; N asciicircum"
 & " ; B 73 311 509 676 ;\nC 95 ; WX 500 ; N underscore ; B 0 -125 500 -75 "
 & ";\nC 96 ; WX 333 ; N quoteleft ; B 70 356 254 691 ;\nC 97 ; WX 500 ; N "
 & "a ; B 25 -14 488 473 ;\nC 98 ; WX 556 ; N b ; B 17 -14 521 676 ;\nC 99 "
 & "; WX 444 ; N c ; B 25 -14 430 473 ;\nC 100 ; WX 556 ; N d ; B 25 -14 53"
 & "4 676 ;\nC 101 ; WX 444 ; N e ; B 25 -14 426 473 ;\nC 102 ; WX 333 ; N "
 & "f ; B 14 0 389 691 ; L i fi ; L l fl ;\nC 103 ; WX 500 ; N g ; B 28 -20"
 & "6 483 473 ;\nC 104 ; WX 556 ; N h ; B 16 0 534 676 ;\nC 105 ; WX 278 ; "
 & "N i ; B 16 0 255 691 ;\nC 106 ; WX 333 ; N j ; B -57 -203 263 691 ;\nC "
 & "107 ; WX 556 ; N k ; B 22 0 543 676 ;\nC 108 ; WX 278 ; N";

CONST E14_1 = 
   " l ; B 16 0 255 676 ;\nC 109 ; WX 833 ; N m ; B 16 0 814 473 ;\nC 110 ;"
 & " WX 556 ; N n ; B 21 0 539 473 ;\nC 111 ; WX 500 ; N o ; B 25 -14 476 4"
 & "73 ;\nC 112 ; WX 556 ; N p ; B 19 -205 524 473 ;\nC 113 ; WX 556 ; N q "
 & "; B 34 -205 536 473 ;\nC 114 ; WX 444 ; N r ; B 29 0 434 473 ;\nC 115 ;"
 & " WX 389 ; N s ; B 25 -14 361 473 ;\nC 116 ; WX 333 ; N t ; B 20 -12 332"
 & " 630 ;\nC 117 ; WX 556 ; N u ; B 16 -14 537 461 ;\nC 118 ; WX 500 ; N v"
 & " ; B 21 -14 485 461 ;\nC 119 ; WX 722 ; N w ; B 23 -14 707 461 ;\nC 120"
 & " ; WX 500 ; N x ; B 12 0 484 461 ;\nC 121 ; WX 500 ; N y ; B 16 -205 48"
 & "0 461 ;\nC 122 ; WX 444 ; N z ; B 21 0 420 461 ;\nC 123 ; WX 394 ; N br"
 & "aceleft ; B 22 -175 340 698 ;\nC 124 ; WX 220 ; N bar ; B 66 -19 154 69"
 & "1 ;\nC 125 ; WX 394 ; N braceright ; B 54 -175 372 698 ;\nC 126 ; WX 52"
 & "0 ; N asciitilde ; B 29 173 491 333 ;\nC 161 ; WX 333 ; N exclamdown ; "
 & "B 82 -203 252 501 ;\nC 162 ; WX 500 ; N cent ; B 53 -140 458 588 ;\nC 1"
 & "63 ; WX 500 ; N sterling ; B 21 -14 477 684 ;\nC 164 ; WX 167 ; N fract"
 & "ion ; B -168 -12 329 688 ;\nC 165 ; WX 500 ; N yen ; B -64 0 547 676 ;\n"
 & "C 166 ; WX 500 ; N florin ; B 0 -155 498 706 ;\nC 167 ; WX 500 ; N sect"
 & "ion ; B 57 -132 443 691 ;\nC 168 ; WX 500 ; N currency ; B -26 61 526 6"
 & "13 ;\nC 169 ; WX 278 ; N quotesingle ; B 75 404 204 691 ;\nC 170 ; WX 5"
 & "00 ; N quotedblleft ; B 32 356 486 691 ;\nC 171 ; WX 500 ; N guillemotl"
 & "eft ; B 23 36 473 415 ;\nC 172 ; WX 333 ; N guilsinglleft ; B 51 36 305"
 & " 415 ;\nC 173 ; WX 333 ; N guilsinglright ; B 28 36 282 415 ;\nC 174 ; "
 & "WX 556 ; N fi ; B 14 0 536 691 ;\nC 175 ; WX 556 ; N fl ; B 14 0 536 69"
 & "1 ;\nC 177 ; WX 500 ; N endash ; B 0 181 500 271 ;\nC 178 ; WX 500 ; N "
 & "dagger ; B 47 -134 453 691 ;\nC 179 ; WX 500 ; N daggerdbl ; B 45 -132 "
 & "456 691 ;\nC 180 ; WX 250 ; N periodcentered ; B 41 248 210 417 ;\nC 18"
 & "2 ; WX 540 ; N paragraph ; B 0 -186 519 676 ;\nC 183 ; WX 350 ; N bulle"
 & "t ; B 35 198 315 478 ;\nC 184 ; WX 333 ; N quotesinglbase ; B 79 -180 2"
 & "63 155 ;\nC 185 ; WX 500 ; N quotedblbase ; B 14 -180 468 155 ;\nC 186 "
 & "; WX 500 ; N quotedblright ; B 14 356 468 691 ;\nC 187";

CONST E14_2 = 
   " ; WX 500 ; N guillemotright ; B 27 36 477 415 ;\nC 188 ; WX 1000 ; N e"
 & "llipsis ; B 82 -13 917 156 ;\nC 189 ; WX 1000 ; N perthousand ; B 7 -29"
 & " 995 706 ;\nC 191 ; WX 500 ; N questiondown ; B 55 -201 443 501 ;\nC 19"
 & "3 ; WX 333 ; N grave ; B 8 528 246 713 ;\nC 194 ; WX 333 ; N acute ; B "
 & "86 528 324 713 ;\nC 195 ; WX 333 ; N circumflex ; B -2 528 335 704 ;\nC"
 & " 196 ; WX 333 ; N tilde ; B -16 547 349 674 ;\nC 197 ; WX 333 ; N macro"
 & "n ; B 1 565 331 637 ;\nC 198 ; WX 333 ; N breve ; B 15 528 318 691 ;\nC"
 & " 199 ; WX 333 ; N dotaccent ; B 103 537 230 667 ;\nC 200 ; WX 333 ; N d"
 & "ieresis ; B -2 537 335 667 ;\nC 202 ; WX 333 ; N ring ; B 60 527 273 74"
 & "0 ;\nC 203 ; WX 333 ; N cedilla ; B 68 -218 294 0 ;\nC 205 ; WX 333 ; N"
 & " hungarumlaut ; B -13 528 425 713 ;\nC 206 ; WX 333 ; N ogonek ; B 90 -"
 & "173 319 44 ;\nC 207 ; WX 333 ; N caron ; B -2 528 335 704 ;\nC 208 ; WX"
 & " 1000 ; N emdash ; B 0 181 1000 271 ;\nC 225 ; WX 1000 ; N AE ; B 4 0 9"
 & "51 676 ;\nC 227 ; WX 300 ; N ordfeminine ; B -1 397 301 688 ;\nC 232 ; "
 & "WX 667 ; N Lslash ; B 19 0 638 676 ;\nC 233 ; WX 778 ; N Oslash ; B 35 "
 & "-74 743 737 ;\nC 234 ; WX 1000 ; N OE ; B 22 -5 981 684 ;\nC 235 ; WX 3"
 & "30 ; N ordmasculine ; B 18 397 312 688 ;\nC 241 ; WX 722 ; N ae ; B 33 "
 & "-14 693 473 ;\nC 245 ; WX 278 ; N dotlessi ; B 16 0 255 461 ;\nC 248 ; "
 & "WX 278 ; N lslash ; B -22 0 303 676 ;\nC 249 ; WX 500 ; N oslash ; B 25"
 & " -92 476 549 ;\nC 250 ; WX 722 ; N oe ; B 22 -14 696 473 ;\nC 251 ; WX "
 & "556 ; N germandbls ; B 19 -12 517 691 ;\nC -1 ; WX 667 ; N Zcaron ; B 2"
 & "8 0 634 914 ;\nC -1 ; WX 444 ; N ccedilla ; B 25 -218 430 473 ;\nC -1 ;"
 & " WX 500 ; N ydieresis ; B 16 -205 480 667 ;\nC -1 ; WX 500 ; N atilde ;"
 & " B 25 -14 488 674 ;\nC -1 ; WX 278 ; N icircumflex ; B -36 0 301 704 ;\n"
 & "C -1 ; WX 300 ; N threesuperior ; B 3 268 297 688 ;\nC -1 ; WX 444 ; N "
 & "ecircumflex ; B 25 -14 426 704 ;\nC -1 ; WX 556 ; N thorn ; B 19 -205 5"
 & "24 676 ;\nC -1 ; WX 444 ; N egrave ; B 25 -14 426 713 ;\nC -1 ; WX 300 "
 & "; N twosuperior ; B 0 275 300 688 ;\nC -1 ; WX 444 ; N eacute ; B 25 -1"
 & "4 426 713 ;\nC -1 ; WX 500 ; N otilde ; B 25 -14 476";

CONST E14_3 = 
   " 674 ;\nC -1 ; WX 722 ; N Aacute ; B 9 0 689 923 ;\nC -1 ; WX 500 ; N o"
 & "circumflex ; B 25 -14 476 704 ;\nC -1 ; WX 500 ; N yacute ; B 16 -205 4"
 & "80 713 ;\nC -1 ; WX 556 ; N udieresis ; B 16 -14 537 667 ;\nC -1 ; WX 7"
 & "50 ; N threequarters ; B 23 -12 733 688 ;\nC -1 ; WX 500 ; N acircumfle"
 & "x ; B 25 -14 488 704 ;\nC -1 ; WX 722 ; N Eth ; B 6 0 690 676 ;\nC -1 ;"
 & " WX 444 ; N edieresis ; B 25 -14 426 667 ;\nC -1 ; WX 556 ; N ugrave ; "
 & "B 16 -14 537 713 ;\nC -1 ; WX 1000 ; N trademark ; B 24 271 977 676 ;\n"
 & "C -1 ; WX 500 ; N ograve ; B 25 -14 476 713 ;\nC -1 ; WX 389 ; N scaron"
 & " ; B 25 -14 363 704 ;\nC -1 ; WX 389 ; N Idieresis ; B 20 0 370 877 ;\n"
 & "C -1 ; WX 556 ; N uacute ; B 16 -14 537 713 ;\nC -1 ; WX 500 ; N agrave"
 & " ; B 25 -14 488 713 ;\nC -1 ; WX 556 ; N ntilde ; B 21 0 539 674 ;\nC -"
 & "1 ; WX 500 ; N aring ; B 25 -14 488 740 ;\nC -1 ; WX 444 ; N zcaron ; B"
 & " 21 0 420 704 ;\nC -1 ; WX 389 ; N Icircumflex ; B 20 0 370 914 ;\nC -1"
 & " ; WX 722 ; N Ntilde ; B 16 -18 701 884 ;\nC -1 ; WX 556 ; N ucircumfle"
 & "x ; B 16 -14 537 704 ;\nC -1 ; WX 667 ; N Ecircumflex ; B 16 0 641 914 "
 & ";\nC -1 ; WX 389 ; N Iacute ; B 20 0 370 923 ;\nC -1 ; WX 722 ; N Ccedi"
 & "lla ; B 49 -218 687 691 ;\nC -1 ; WX 778 ; N Odieresis ; B 35 -19 743 8"
 & "77 ;\nC -1 ; WX 556 ; N Scaron ; B 35 -19 513 914 ;\nC -1 ; WX 667 ; N "
 & "Edieresis ; B 16 0 641 877 ;\nC -1 ; WX 389 ; N Igrave ; B 20 0 370 923"
 & " ;\nC -1 ; WX 500 ; N adieresis ; B 25 -14 488 667 ;\nC -1 ; WX 778 ; N"
 & " Ograve ; B 35 -19 743 923 ;\nC -1 ; WX 667 ; N Egrave ; B 16 0 641 923"
 & " ;\nC -1 ; WX 722 ; N Ydieresis ; B 15 0 699 877 ;\nC -1 ; WX 747 ; N r"
 & "egistered ; B 26 -19 721 691 ;\nC -1 ; WX 778 ; N Otilde ; B 35 -19 743"
 & " 884 ;\nC -1 ; WX 750 ; N onequarter ; B 28 -12 743 688 ;\nC -1 ; WX 72"
 & "2 ; N Ugrave ; B 16 -19 701 923 ;\nC -1 ; WX 722 ; N Ucircumflex ; B 16"
 & " -19 701 914 ;\nC -1 ; WX 611 ; N Thorn ; B 16 0 600 676 ;\nC -1 ; WX 5"
 & "70 ; N divide ; B 33 -31 537 537 ;\nC -1 ; WX 722 ; N Atilde ; B 9 0 68"
 & "9 884 ;\nC -1 ; WX 722 ; N Uacute ; B 16 -19 701 923 ;\nC -1 ; WX 778 ;"
 & " N Ocircumflex ; B 35 -19 743 914 ;\nC -1 ; WX 570 ; N ";

CONST E14_4 = 
   "logicalnot ; B 33 108 537 399 ;\nC -1 ; WX 722 ; N Aring ; B 9 0 689 93"
 & "5 ;\nC -1 ; WX 278 ; N idieresis ; B -36 0 301 667 ;\nC -1 ; WX 278 ; N"
 & " iacute ; B 16 0 290 713 ;\nC -1 ; WX 500 ; N aacute ; B 25 -14 488 713"
 & " ;\nC -1 ; WX 570 ; N plusminus ; B 33 0 537 506 ;\nC -1 ; WX 570 ; N m"
 & "ultiply ; B 48 16 522 490 ;\nC -1 ; WX 722 ; N Udieresis ; B 16 -19 701"
 & " 877 ;\nC -1 ; WX 570 ; N minus ; B 33 209 537 297 ;\nC -1 ; WX 300 ; N"
 & " onesuperior ; B 28 275 273 688 ;\nC -1 ; WX 667 ; N Eacute ; B 16 0 64"
 & "1 923 ;\nC -1 ; WX 722 ; N Acircumflex ; B 9 0 689 914 ;\nC -1 ; WX 747"
 & " ; N copyright ; B 26 -19 721 691 ;\nC -1 ; WX 722 ; N Agrave ; B 9 0 6"
 & "89 923 ;\nC -1 ; WX 500 ; N odieresis ; B 25 -14 476 667 ;\nC -1 ; WX 5"
 & "00 ; N oacute ; B 25 -14 476 713 ;\nC -1 ; WX 400 ; N degree ; B 57 402"
 & " 343 688 ;\nC -1 ; WX 278 ; N igrave ; B -26 0 255 713 ;\nC -1 ; WX 556"
 & " ; N mu ; B 33 -206 536 461 ;\nC -1 ; WX 778 ; N Oacute ; B 35 -19 743 "
 & "923 ;\nC -1 ; WX 500 ; N eth ; B 25 -14 476 691 ;\nC -1 ; WX 722 ; N Ad"
 & "ieresis ; B 9 0 689 877 ;\nC -1 ; WX 722 ; N Yacute ; B 15 0 699 928 ;\n"
 & "C -1 ; WX 220 ; N brokenbar ; B 66 -19 154 691 ;\nC -1 ; WX 750 ; N one"
 & "half ; B -7 -12 775 688 ;\nEndCharMetrics\nStartKernData\nStartKernPair"
 & "s 283\n\nKPX A y -74\nKPX A w -90\nKPX A v -100\nKPX A u -50\nKPX A quo"
 & "teright -74\nKPX A quotedblright 0\nKPX A p -25\nKPX A Y -100\nKPX A W "
 & "-130\nKPX A V -145\nKPX A U -50\nKPX A T -95\nKPX A Q -45\nKPX A O -45\n"
 & "KPX A G -55\nKPX A C -55\n\nKPX B period 0\nKPX B comma 0\nKPX B U -10\n"
 & "KPX B A -30\n\nKPX D period -20\nKPX D comma 0\nKPX D Y -40\nKPX D W -4"
 & "0\nKPX D V -40\nKPX D A -35\n\nKPX F r 0\nKPX F period -110\nKPX F o -2"
 & "5\nKPX F i 0\nKPX F e -25\nKPX F comma -92\nKPX F a -25\nKPX F A -90\n\n"
 & "KPX G period 0\nKPX G comma 0\n\nKPX J u -15\nKPX J period -20\nKPX J o"
 & " -15\nKPX J e -15\nKPX J comma 0\nKPX J a -15\nKPX J A -30\n\nKPX K y -"
 & "45\nKPX K u -15\nKPX K o -25\nKPX K e -25\nKPX K O -30\n\nKPX L y -55\n"
 & "KPX L quoteright -110\nKPX L quotedblright -20\nKPX L Y -92\nKPX L W -9"
 & "2\nKPX L V -92\nKPX L T -92\n\nKPX N period 0\nKPX N comma 0\nKPX N A -"
 & "20\n\nKPX O period 0\nKPX O comma ";

CONST E14_5 = 
   "0\nKPX O Y -50\nKPX O X -40\nKPX O W -50\nKPX O V -50\nKPX O T -40\nKPX"
 & " O A -40\n\nKPX P period -110\nKPX P o -20\nKPX P e -20\nKPX P comma -9"
 & "2\nKPX P a -10\nKPX P A -74\n\nKPX Q period -20\nKPX Q comma 0\nKPX Q U"
 & " -10\n\nKPX R Y -35\nKPX R W -35\nKPX R V -55\nKPX R U -30\nKPX R T -40"
 & "\nKPX R O -30\n\nKPX S period 0\nKPX S comma 0\n\nKPX T y -74\nKPX T w "
 & "-74\nKPX T u -92\nKPX T semicolon -74\nKPX T r -74\nKPX T period -90\nK"
 & "PX T o -92\nKPX T i -18\nKPX T hyphen -92\nKPX T h 0\nKPX T e -92\nKPX "
 & "T comma -74\nKPX T colon -74\nKPX T a -92\nKPX T O -18\nKPX T A -90\n\n"
 & "KPX U period -50\nKPX U comma -50\nKPX U A -60\n\nKPX V u -92\nKPX V se"
 & "micolon -92\nKPX V period -145\nKPX V o -100\nKPX V i -37\nKPX V hyphen"
 & " -74\nKPX V e -100\nKPX V comma -129\nKPX V colon -92\nKPX V a -92\nKPX"
 & " V O -45\nKPX V G -30\nKPX V A -135\n\nKPX W y -60\nKPX W u -50\nKPX W "
 & "semicolon -55\nKPX W period -92\nKPX W o -75\nKPX W i -18\nKPX W hyphen"
 & " -37\nKPX W h 0\nKPX W e -65\nKPX W comma -92\nKPX W colon -55\nKPX W a"
 & " -65\nKPX W O -10\nKPX W A -120\n\nKPX Y u -92\nKPX Y semicolon -92\nKP"
 & "X Y period -92\nKPX Y o -111\nKPX Y i -37\nKPX Y hyphen -92\nKPX Y e -1"
 & "11\nKPX Y comma -92\nKPX Y colon -92\nKPX Y a -85\nKPX Y O -35\nKPX Y A"
 & " -110\n\nKPX a y 0\nKPX a w 0\nKPX a v -25\nKPX a t 0\nKPX a p 0\nKPX a"
 & " g 0\nKPX a b 0\n\nKPX b y 0\nKPX b v -15\nKPX b u -20\nKPX b period -4"
 & "0\nKPX b l 0\nKPX b comma 0\nKPX b b -10\n\nKPX c y 0\nKPX c period 0\n"
 & "KPX c l 0\nKPX c k 0\nKPX c h 0\nKPX c comma 0\n\nKPX colon space 0\n\n"
 & "KPX comma space 0\nKPX comma quoteright -55\nKPX comma quotedblright -4"
 & "5\n\nKPX d y 0\nKPX d w -15\nKPX d v 0\nKPX d period 0\nKPX d d 0\nKPX "
 & "d comma 0\n\nKPX e y 0\nKPX e x 0\nKPX e w 0\nKPX e v -15\nKPX e period"
 & " 0\nKPX e p 0\nKPX e g 0\nKPX e comma 0\nKPX e b 0\n\nKPX f quoteright "
 & "55\nKPX f quotedblright 50\nKPX f period -15\nKPX f o -25\nKPX f l 0\nK"
 & "PX f i -25\nKPX f f 0\nKPX f e 0\nKPX f dotlessi -35\nKPX f comma -15\n"
 & "KPX f a 0\n\nKPX g y 0\nKPX g r 0\nKPX g period -15\nKPX g o 0\nKPX g i"
 & " 0\nKPX g g 0\nKPX g e 0\nKPX g comma 0\nKPX g a 0\n\nKPX h y -15\n\nKP"
 & "X i v -10\n\nKPX k y -15\nKPX k o -15\nKPX k e -10\n\nKPX l y 0\nKPX l "
 & "w 0\n\nKPX m y 0\nKPX m u 0\n\nKPX n y 0\nKPX";

CONST E14_6 = 
   " n v -40\nKPX n u 0\n\nKPX o y 0\nKPX o x 0\nKPX o w -10\nKPX o v -10\n"
 & "KPX o g 0\n\nKPX p y 0\n\nKPX period quoteright -55\nKPX period quotedb"
 & "lright -55\n\nKPX quotedblleft quoteleft 0\nKPX quotedblleft A -10\n\nK"
 & "PX quotedblright space 0\n\nKPX quoteleft quoteleft -63\nKPX quoteleft "
 & "A -10\n\nKPX quoteright v -20\nKPX quoteright t 0\nKPX quoteright space"
 & " -74\nKPX quoteright s -37\nKPX quoteright r -20\nKPX quoteright quoter"
 & "ight -63\nKPX quoteright quotedblright 0\nKPX quoteright l 0\nKPX quote"
 & "right d -20\n\nKPX r y 0\nKPX r v -10\nKPX r u 0\nKPX r t 0\nKPX r s 0\n"
 & "KPX r r 0\nKPX r q -18\nKPX r period -100\nKPX r p -10\nKPX r o -18\nKP"
 & "X r n -15\nKPX r m 0\nKPX r l 0\nKPX r k 0\nKPX r i 0\nKPX r hyphen -37"
 & "\nKPX r g -10\nKPX r e -18\nKPX r d 0\nKPX r comma -92\nKPX r c -18\nKP"
 & "X r a 0\n\nKPX s w 0\n\nKPX space quoteleft 0\nKPX space quotedblleft 0"
 & "\nKPX space Y -55\nKPX space W -30\nKPX space V -45\nKPX space T -30\nK"
 & "PX space A -55\n\nKPX v period -70\nKPX v o -10\nKPX v e -10\nKPX v com"
 & "ma -55\nKPX v a -10\n\nKPX w period -70\nKPX w o -10\nKPX w h 0\nKPX w "
 & "e 0\nKPX w comma -55\nKPX w a 0\n\nKPX x e 0\n\nKPX y period -70\nKPX y"
 & " o -25\nKPX y e -10\nKPX y comma -55\nKPX y a 0\n\nKPX z o 0\nKPX z e 0"
 & "\nEndKernPairs\nEndKernData\nStartComposites 58\nCC Aacute 2 ; PCC A 0 "
 & "0 ; PCC acute 188 210 ;\nCC Acircumflex 2 ; PCC A 0 0 ; PCC circumflex "
 & "188 210 ;\nCC Adieresis 2 ; PCC A 0 0 ; PCC dieresis 188 210 ;\nCC Agra"
 & "ve 2 ; PCC A 0 0 ; PCC grave 188 210 ;\nCC Aring 2 ; PCC A 0 0 ; PCC ri"
 & "ng 180 195 ;\nCC Atilde 2 ; PCC A 0 0 ; PCC tilde 188 210 ;\nCC Ccedill"
 & "a 2 ; PCC C 0 0 ; PCC cedilla 208 0 ;\nCC Eacute 2 ; PCC E 0 0 ; PCC ac"
 & "ute 174 210 ;\nCC Ecircumflex 2 ; PCC E 0 0 ; PCC circumflex 174 210 ;\n"
 & "CC Edieresis 2 ; PCC E 0 0 ; PCC dieresis 174 210 ;\nCC Egrave 2 ; PCC "
 & "E 0 0 ; PCC grave 174 210 ;\nCC Iacute 2 ; PCC I 0 0 ; PCC acute 28 210"
 & " ;\nCC Icircumflex 2 ; PCC I 0 0 ; PCC circumflex 28 210 ;\nCC Idieresi"
 & "s 2 ; PCC I 0 0 ; PCC dieresis 28 210 ;\nCC Igrave 2 ; PCC I 0 0 ; PCC "
 & "grave 28 210 ;\nCC Ntilde 2 ; PCC N 0 0 ; PCC tilde 195 210 ;\nCC Oacut"
 & "e 2 ; PCC O 0 0 ; PCC acute 223 210 ;\nCC Ocirc";

CONST E14_7 = 
   "umflex 2 ; PCC O 0 0 ; PCC circumflex 223 210 ;\nCC Odieresis 2 ; PCC O"
 & " 0 0 ; PCC dieresis 223 210 ;\nCC Ograve 2 ; PCC O 0 0 ; PCC grave 223 "
 & "210 ;\nCC Otilde 2 ; PCC O 0 0 ; PCC tilde 223 210 ;\nCC Scaron 2 ; PCC"
 & " S 0 0 ; PCC caron 112 210 ;\nCC Uacute 2 ; PCC U 0 0 ; PCC acute 222 2"
 & "10 ;\nCC Ucircumflex 2 ; PCC U 0 0 ; PCC circumflex 222 210 ;\nCC Udier"
 & "esis 2 ; PCC U 0 0 ; PCC dieresis 222 210 ;\nCC Ugrave 2 ; PCC U 0 0 ; "
 & "PCC grave 222 210 ;\nCC Yacute 2 ; PCC Y 0 0 ; PCC acute 210 215 ;\nCC "
 & "Ydieresis 2 ; PCC Y 0 0 ; PCC dieresis 215 210 ;\nCC Zcaron 2 ; PCC Z 0"
 & " 0 ; PCC caron 167 210 ;\nCC aacute 2 ; PCC a 0 0 ; PCC acute 77 0 ;\nC"
 & "C acircumflex 2 ; PCC a 0 0 ; PCC circumflex 77 0 ;\nCC adieresis 2 ; P"
 & "CC a 0 0 ; PCC dieresis 77 0 ;\nCC agrave 2 ; PCC a 0 0 ; PCC grave 77 "
 & "0 ;\nCC aring 2 ; PCC a 0 0 ; PCC ring 77 0 ;\nCC atilde 2 ; PCC a 0 0 "
 & "; PCC tilde 77 0 ;\nCC ccedilla 2 ; PCC c 0 0 ; PCC cedilla 69 0 ;\nCC "
 & "eacute 2 ; PCC e 0 0 ; PCC acute 62 0 ;\nCC ecircumflex 2 ; PCC e 0 0 ;"
 & " PCC circumflex 62 0 ;\nCC edieresis 2 ; PCC e 0 0 ; PCC dieresis 62 0 "
 & ";\nCC egrave 2 ; PCC e 0 0 ; PCC grave 62 0 ;\nCC iacute 2 ; PCC dotles"
 & "si 0 0 ; PCC acute -34 0 ;\nCC icircumflex 2 ; PCC dotlessi 0 0 ; PCC c"
 & "ircumflex -34 0 ;\nCC idieresis 2 ; PCC dotlessi 0 0 ; PCC dieresis -34"
 & " 0 ;\nCC igrave 2 ; PCC dotlessi 0 0 ; PCC grave -34 0 ;\nCC ntilde 2 ;"
 & " PCC n 0 0 ; PCC tilde 112 0 ;\nCC oacute 2 ; PCC o 0 0 ; PCC acute 84 "
 & "0 ;\nCC ocircumflex 2 ; PCC o 0 0 ; PCC circumflex 84 0 ;\nCC odieresis"
 & " 2 ; PCC o 0 0 ; PCC dieresis 84 0 ;\nCC ograve 2 ; PCC o 0 0 ; PCC gra"
 & "ve 84 0 ;\nCC otilde 2 ; PCC o 0 0 ; PCC tilde 84 0 ;\nCC scaron 2 ; PC"
 & "C s 0 0 ; PCC caron 28 0 ;\nCC uacute 2 ; PCC u 0 0 ; PCC acute 105 0 ;"
 & "\nCC ucircumflex 2 ; PCC u 0 0 ; PCC circumflex 105 0 ;\nCC udieresis 2"
 & " ; PCC u 0 0 ; PCC dieresis 105 0 ;\nCC ugrave 2 ; PCC u 0 0 ; PCC grav"
 & "e 105 0 ;\nCC yacute 2 ; PCC y 0 0 ; PCC acute 84 0 ;\nCC ydieresis 2 ;"
 & " PCC y 0 0 ; PCC dieresis 84 0 ;\nCC zcaron 2 ; PCC z 0 0 ; PCC caron 5"
 & "6 0 ;\nEndComposites\nEndFontMetrics\n";

CONST E15 = 
   "StartFontMetrics 2.0\nComment Copyright (c) 1985, 1987, 1989, 1990 Adob"
 & "e Systems Incorporated.  All rights reserved.\nComment Creation Date: T"
 & "hu Mar 15 10:24:18 1990\nComment UniqueID 28362\nComment VMusage 7572 4"
 & "2473\nFontName Helvetica-Oblique\nFullName Helvetica Oblique\nFamilyNam"
 & "e Helvetica\nWeight Medium\nItalicAngle -12\nIsFixedPitch false\nFontBB"
 & "ox -170 -225 1116 931\nUnderlinePosition -100\nUnderlineThickness 50\nV"
 & "ersion 001.006\nNotice Copyright (c) 1985, 1987, 1989, 1990 Adobe Syste"
 & "ms Incorporated.  All rights reserved.Helvetica is a trademark of Linot"
 & "ype AG and/or its subsidiaries.\nEncodingScheme AdobeStandardEncoding\n"
 & "CapHeight 718\nXHeight 523\nAscender 718\nDescender -207\nStartCharMetr"
 & "ics 228\nC 32 ; WX 278 ; N space ; B 0 0 0 0 ;\nC 33 ; WX 278 ; N excla"
 & "m ; B 90 0 340 718 ;\nC 34 ; WX 355 ; N quotedbl ; B 168 463 438 718 ;\n"
 & "C 35 ; WX 556 ; N numbersign ; B 73 0 631 688 ;\nC 36 ; WX 556 ; N doll"
 & "ar ; B 69 -115 617 775 ;\nC 37 ; WX 889 ; N percent ; B 147 -19 889 703"
 & " ;\nC 38 ; WX 667 ; N ampersand ; B 77 -15 647 718 ;\nC 39 ; WX 222 ; N"
 & " quoteright ; B 151 463 310 718 ;\nC 40 ; WX 333 ; N parenleft ; B 108 "
 & "-207 454 733 ;\nC 41 ; WX 333 ; N parenright ; B -9 -207 337 733 ;\nC 4"
 & "2 ; WX 389 ; N asterisk ; B 165 431 475 718 ;\nC 43 ; WX 584 ; N plus ;"
 & " B 85 0 606 505 ;\nC 44 ; WX 278 ; N comma ; B 56 -147 214 106 ;\nC 45 "
 & "; WX 333 ; N hyphen ; B 93 232 357 322 ;\nC 46 ; WX 278 ; N period ; B "
 & "87 0 214 106 ;\nC 47 ; WX 278 ; N slash ; B -21 -19 452 737 ;\nC 48 ; W"
 & "X 556 ; N zero ; B 93 -19 608 703 ;\nC 49 ; WX 556 ; N one ; B 207 0 50"
 & "8 703 ;\nC 50 ; WX 556 ; N two ; B 26 0 617 703 ;\nC 51 ; WX 556 ; N th"
 & "ree ; B 75 -19 610 703 ;\nC 52 ; WX 556 ; N four ; B 61 0 576 703 ;\nC "
 & "53 ; WX 556 ; N five ; B 68 -19 621 688 ;\nC 54 ; WX 556 ; N six ; B 91"
 & " -19 615 703 ;\nC 55 ; WX 556 ; N seven ; B 137 0 669 688 ;\nC 56 ; WX "
 & "556 ; N eight ; B 74 -19 607 703 ;\nC 57 ; WX 556 ; N nine ; B 82 -19 6"
 & "09 703 ;\nC 58 ; WX 278 ; N colon ; B 87 0 301 516 ;\nC 59 ; WX 278 ; N"
 & " semicolon ; B 56 -147 301 516 ;\nC 60 ; WX 584 ; N less ; B ";

CONST E15_0 = 
   "94 11 641 495 ;\nC 61 ; WX 584 ; N equal ; B 63 115 628 390 ;\nC 62 ; W"
 & "X 584 ; N greater ; B 50 11 597 495 ;\nC 63 ; WX 556 ; N question ; B 1"
 & "61 0 610 727 ;\nC 64 ; WX 1015 ; N at ; B 215 -19 965 737 ;\nC 65 ; WX "
 & "667 ; N A ; B 14 0 654 718 ;\nC 66 ; WX 667 ; N B ; B 74 0 712 718 ;\nC"
 & " 67 ; WX 722 ; N C ; B 108 -19 782 737 ;\nC 68 ; WX 722 ; N D ; B 81 0 "
 & "764 718 ;\nC 69 ; WX 667 ; N E ; B 86 0 762 718 ;\nC 70 ; WX 611 ; N F "
 & "; B 86 0 736 718 ;\nC 71 ; WX 778 ; N G ; B 111 -19 799 737 ;\nC 72 ; W"
 & "X 722 ; N H ; B 77 0 799 718 ;\nC 73 ; WX 278 ; N I ; B 91 0 341 718 ;\n"
 & "C 74 ; WX 500 ; N J ; B 47 -19 581 718 ;\nC 75 ; WX 667 ; N K ; B 76 0 "
 & "808 718 ;\nC 76 ; WX 556 ; N L ; B 76 0 555 718 ;\nC 77 ; WX 833 ; N M "
 & "; B 73 0 914 718 ;\nC 78 ; WX 722 ; N N ; B 76 0 799 718 ;\nC 79 ; WX 7"
 & "78 ; N O ; B 105 -19 826 737 ;\nC 80 ; WX 667 ; N P ; B 86 0 737 718 ;\n"
 & "C 81 ; WX 778 ; N Q ; B 105 -56 826 737 ;\nC 82 ; WX 722 ; N R ; B 88 0"
 & " 773 718 ;\nC 83 ; WX 667 ; N S ; B 90 -19 713 737 ;\nC 84 ; WX 611 ; N"
 & " T ; B 148 0 750 718 ;\nC 85 ; WX 722 ; N U ; B 123 -19 797 718 ;\nC 86"
 & " ; WX 667 ; N V ; B 173 0 800 718 ;\nC 87 ; WX 944 ; N W ; B 169 0 1081"
 & " 718 ;\nC 88 ; WX 667 ; N X ; B 19 0 790 718 ;\nC 89 ; WX 667 ; N Y ; B"
 & " 167 0 806 718 ;\nC 90 ; WX 611 ; N Z ; B 23 0 741 718 ;\nC 91 ; WX 278"
 & " ; N bracketleft ; B 21 -196 403 722 ;\nC 92 ; WX 278 ; N backslash ; B"
 & " 140 -19 291 737 ;\nC 93 ; WX 278 ; N bracketright ; B -14 -196 368 722"
 & " ;\nC 94 ; WX 469 ; N asciicircum ; B 42 264 539 688 ;\nC 95 ; WX 556 ;"
 & " N underscore ; B -27 -125 540 -75 ;\nC 96 ; WX 222 ; N quoteleft ; B 1"
 & "65 470 323 725 ;\nC 97 ; WX 556 ; N a ; B 61 -15 559 538 ;\nC 98 ; WX 5"
 & "56 ; N b ; B 58 -15 584 718 ;\nC 99 ; WX 500 ; N c ; B 74 -15 553 538 ;"
 & "\nC 100 ; WX 556 ; N d ; B 84 -15 652 718 ;\nC 101 ; WX 556 ; N e ; B 8"
 & "4 -15 578 538 ;\nC 102 ; WX 278 ; N f ; B 86 0 416 728 ; L i fi ; L l f"
 & "l ;\nC 103 ; WX 556 ; N g ; B 42 -220 610 538 ;\nC 104 ; WX 556 ; N h ;"
 & " B 65 0 573 718 ;\nC 105 ; WX 222 ; N i ; B 67 0 308 718 ;\nC 106 ; WX "
 & "222 ; N j ; B -60 -210 308 718 ;\nC 107 ; WX 500 ; N k ; ";

CONST E15_1 = 
   "B 67 0 600 718 ;\nC 108 ; WX 222 ; N l ; B 67 0 308 718 ;\nC 109 ; WX 8"
 & "33 ; N m ; B 65 0 852 538 ;\nC 110 ; WX 556 ; N n ; B 65 0 573 538 ;\nC"
 & " 111 ; WX 556 ; N o ; B 83 -14 585 538 ;\nC 112 ; WX 556 ; N p ; B 14 -"
 & "207 584 538 ;\nC 113 ; WX 556 ; N q ; B 84 -207 605 538 ;\nC 114 ; WX 3"
 & "33 ; N r ; B 77 0 446 538 ;\nC 115 ; WX 500 ; N s ; B 63 -15 529 538 ;\n"
 & "C 116 ; WX 278 ; N t ; B 102 -7 368 669 ;\nC 117 ; WX 556 ; N u ; B 94 "
 & "-15 600 523 ;\nC 118 ; WX 500 ; N v ; B 119 0 603 523 ;\nC 119 ; WX 722"
 & " ; N w ; B 125 0 820 523 ;\nC 120 ; WX 500 ; N x ; B 11 0 594 523 ;\nC "
 & "121 ; WX 500 ; N y ; B 15 -214 600 523 ;\nC 122 ; WX 500 ; N z ; B 31 0"
 & " 571 523 ;\nC 123 ; WX 334 ; N braceleft ; B 92 -196 445 722 ;\nC 124 ;"
 & " WX 260 ; N bar ; B 90 -19 324 737 ;\nC 125 ; WX 334 ; N braceright ; B"
 & " 0 -196 354 722 ;\nC 126 ; WX 584 ; N asciitilde ; B 111 180 580 326 ;\n"
 & "C 161 ; WX 333 ; N exclamdown ; B 77 -195 326 523 ;\nC 162 ; WX 556 ; N"
 & " cent ; B 95 -115 584 623 ;\nC 163 ; WX 556 ; N sterling ; B 49 -16 634"
 & " 718 ;\nC 164 ; WX 167 ; N fraction ; B -170 -19 482 703 ;\nC 165 ; WX "
 & "556 ; N yen ; B 81 0 699 688 ;\nC 166 ; WX 556 ; N florin ; B -52 -207 "
 & "654 737 ;\nC 167 ; WX 556 ; N section ; B 76 -191 584 737 ;\nC 168 ; WX"
 & " 556 ; N currency ; B 60 99 646 603 ;\nC 169 ; WX 191 ; N quotesingle ;"
 & " B 157 463 285 718 ;\nC 170 ; WX 333 ; N quotedblleft ; B 138 470 461 7"
 & "25 ;\nC 171 ; WX 556 ; N guillemotleft ; B 146 108 554 446 ;\nC 172 ; W"
 & "X 333 ; N guilsinglleft ; B 137 108 340 446 ;\nC 173 ; WX 333 ; N guils"
 & "inglright ; B 111 108 314 446 ;\nC 174 ; WX 500 ; N fi ; B 86 0 587 728"
 & " ;\nC 175 ; WX 500 ; N fl ; B 86 0 585 728 ;\nC 177 ; WX 556 ; N endash"
 & " ; B 51 240 623 313 ;\nC 178 ; WX 556 ; N dagger ; B 135 -159 622 718 ;"
 & "\nC 179 ; WX 556 ; N daggerdbl ; B 52 -159 623 718 ;\nC 180 ; WX 278 ; "
 & "N periodcentered ; B 129 190 257 315 ;\nC 182 ; WX 537 ; N paragraph ; "
 & "B 126 -173 650 718 ;\nC 183 ; WX 350 ; N bullet ; B 91 202 413 517 ;\nC"
 & " 184 ; WX 222 ; N quotesinglbase ; B 21 -149 180 106 ;\nC 185 ; WX 333 "
 & "; N quotedblbase ; B -6 -149 318 106 ;\nC 186 ; WX 33";

CONST E15_2 = 
   "3 ; N quotedblright ; B 124 463 448 718 ;\nC 187 ; WX 556 ; N guillemot"
 & "right ; B 120 108 528 446 ;\nC 188 ; WX 1000 ; N ellipsis ; B 115 0 908"
 & " 106 ;\nC 189 ; WX 1000 ; N perthousand ; B 88 -19 1029 703 ;\nC 191 ; "
 & "WX 611 ; N questiondown ; B 85 -201 534 525 ;\nC 193 ; WX 333 ; N grave"
 & " ; B 170 593 337 734 ;\nC 194 ; WX 333 ; N acute ; B 248 593 475 734 ;\n"
 & "C 195 ; WX 333 ; N circumflex ; B 147 593 438 734 ;\nC 196 ; WX 333 ; N"
 & " tilde ; B 125 606 490 722 ;\nC 197 ; WX 333 ; N macron ; B 143 627 468"
 & " 684 ;\nC 198 ; WX 333 ; N breve ; B 167 595 476 731 ;\nC 199 ; WX 333 "
 & "; N dotaccent ; B 249 604 362 706 ;\nC 200 ; WX 333 ; N dieresis ; B 16"
 & "8 604 443 706 ;\nC 202 ; WX 333 ; N ring ; B 214 572 402 756 ;\nC 203 ;"
 & " WX 333 ; N cedilla ; B 2 -225 232 0 ;\nC 205 ; WX 333 ; N hungarumlaut"
 & " ; B 157 593 565 734 ;\nC 206 ; WX 333 ; N ogonek ; B 43 -225 249 0 ;\n"
 & "C 207 ; WX 333 ; N caron ; B 177 593 468 734 ;\nC 208 ; WX 1000 ; N emd"
 & "ash ; B 51 240 1067 313 ;\nC 225 ; WX 1000 ; N AE ; B 8 0 1097 718 ;\nC"
 & " 227 ; WX 370 ; N ordfeminine ; B 100 304 449 737 ;\nC 232 ; WX 556 ; N"
 & " Lslash ; B 41 0 555 718 ;\nC 233 ; WX 778 ; N Oslash ; B 43 -19 890 73"
 & "7 ;\nC 234 ; WX 1000 ; N OE ; B 98 -19 1116 737 ;\nC 235 ; WX 365 ; N o"
 & "rdmasculine ; B 100 304 468 737 ;\nC 241 ; WX 889 ; N ae ; B 61 -15 909"
 & " 538 ;\nC 245 ; WX 278 ; N dotlessi ; B 95 0 294 523 ;\nC 248 ; WX 222 "
 & "; N lslash ; B 41 0 347 718 ;\nC 249 ; WX 611 ; N oslash ; B 29 -22 647"
 & " 545 ;\nC 250 ; WX 944 ; N oe ; B 83 -15 964 538 ;\nC 251 ; WX 611 ; N "
 & "germandbls ; B 67 -15 658 728 ;\nC -1 ; WX 611 ; N Zcaron ; B 23 0 741 "
 & "929 ;\nC -1 ; WX 500 ; N ccedilla ; B 74 -225 553 538 ;\nC -1 ; WX 500 "
 & "; N ydieresis ; B 15 -214 600 706 ;\nC -1 ; WX 556 ; N atilde ; B 61 -1"
 & "5 592 722 ;\nC -1 ; WX 278 ; N icircumflex ; B 95 0 411 734 ;\nC -1 ; W"
 & "X 333 ; N threesuperior ; B 90 270 436 703 ;\nC -1 ; WX 556 ; N ecircum"
 & "flex ; B 84 -15 578 734 ;\nC -1 ; WX 556 ; N thorn ; B 14 -207 584 718 "
 & ";\nC -1 ; WX 556 ; N egrave ; B 84 -15 578 734 ;\nC -1 ; WX 333 ; N two"
 & "superior ; B 64 281 449 703 ;\nC -1 ; WX 556 ; N eac";

CONST E15_3 = 
   "ute ; B 84 -15 587 734 ;\nC -1 ; WX 556 ; N otilde ; B 83 -14 602 722 ;"
 & "\nC -1 ; WX 667 ; N Aacute ; B 14 0 683 929 ;\nC -1 ; WX 556 ; N ocircu"
 & "mflex ; B 83 -14 585 734 ;\nC -1 ; WX 500 ; N yacute ; B 15 -214 600 73"
 & "4 ;\nC -1 ; WX 556 ; N udieresis ; B 94 -15 600 706 ;\nC -1 ; WX 834 ; "
 & "N threequarters ; B 130 -19 861 703 ;\nC -1 ; WX 556 ; N acircumflex ; "
 & "B 61 -15 559 734 ;\nC -1 ; WX 722 ; N Eth ; B 69 0 764 718 ;\nC -1 ; WX"
 & " 556 ; N edieresis ; B 84 -15 578 706 ;\nC -1 ; WX 556 ; N ugrave ; B 9"
 & "4 -15 600 734 ;\nC -1 ; WX 1000 ; N trademark ; B 186 306 1056 718 ;\nC"
 & " -1 ; WX 556 ; N ograve ; B 83 -14 585 734 ;\nC -1 ; WX 500 ; N scaron "
 & "; B 63 -15 552 734 ;\nC -1 ; WX 278 ; N Idieresis ; B 91 0 458 901 ;\nC"
 & " -1 ; WX 556 ; N uacute ; B 94 -15 600 734 ;\nC -1 ; WX 556 ; N agrave "
 & "; B 61 -15 559 734 ;\nC -1 ; WX 556 ; N ntilde ; B 65 0 592 722 ;\nC -1"
 & " ; WX 556 ; N aring ; B 61 -15 559 756 ;\nC -1 ; WX 500 ; N zcaron ; B "
 & "31 0 571 734 ;\nC -1 ; WX 278 ; N Icircumflex ; B 91 0 452 929 ;\nC -1 "
 & "; WX 722 ; N Ntilde ; B 76 0 799 917 ;\nC -1 ; WX 556 ; N ucircumflex ;"
 & " B 94 -15 600 734 ;\nC -1 ; WX 667 ; N Ecircumflex ; B 86 0 762 929 ;\n"
 & "C -1 ; WX 278 ; N Iacute ; B 91 0 489 929 ;\nC -1 ; WX 722 ; N Ccedilla"
 & " ; B 108 -225 782 737 ;\nC -1 ; WX 778 ; N Odieresis ; B 105 -19 826 90"
 & "1 ;\nC -1 ; WX 667 ; N Scaron ; B 90 -19 713 929 ;\nC -1 ; WX 667 ; N E"
 & "dieresis ; B 86 0 762 901 ;\nC -1 ; WX 278 ; N Igrave ; B 91 0 351 929 "
 & ";\nC -1 ; WX 556 ; N adieresis ; B 61 -15 559 706 ;\nC -1 ; WX 778 ; N "
 & "Ograve ; B 105 -19 826 929 ;\nC -1 ; WX 667 ; N Egrave ; B 86 0 762 929"
 & " ;\nC -1 ; WX 667 ; N Ydieresis ; B 167 0 806 901 ;\nC -1 ; WX 737 ; N "
 & "registered ; B 54 -19 837 737 ;\nC -1 ; WX 778 ; N Otilde ; B 105 -19 8"
 & "26 917 ;\nC -1 ; WX 834 ; N onequarter ; B 150 -19 802 703 ;\nC -1 ; WX"
 & " 722 ; N Ugrave ; B 123 -19 797 929 ;\nC -1 ; WX 722 ; N Ucircumflex ; "
 & "B 123 -19 797 929 ;\nC -1 ; WX 667 ; N Thorn ; B 86 0 712 718 ;\nC -1 ;"
 & " WX 584 ; N divide ; B 85 -19 606 524 ;\nC -1 ; WX 667 ; N Atilde ; B 1"
 & "4 0 699 917 ;\nC -1 ; WX 722 ; N Uacute ; B 123 -19 79";

CONST E15_4 = 
   "7 929 ;\nC -1 ; WX 778 ; N Ocircumflex ; B 105 -19 826 929 ;\nC -1 ; WX"
 & " 584 ; N logicalnot ; B 106 108 628 390 ;\nC -1 ; WX 667 ; N Aring ; B "
 & "14 0 654 931 ;\nC -1 ; WX 278 ; N idieresis ; B 95 0 416 706 ;\nC -1 ; "
 & "WX 278 ; N iacute ; B 95 0 448 734 ;\nC -1 ; WX 556 ; N aacute ; B 61 -"
 & "15 587 734 ;\nC -1 ; WX 584 ; N plusminus ; B 39 0 618 506 ;\nC -1 ; WX"
 & " 584 ; N multiply ; B 50 0 642 506 ;\nC -1 ; WX 722 ; N Udieresis ; B 1"
 & "23 -19 797 901 ;\nC -1 ; WX 584 ; N minus ; B 85 216 606 289 ;\nC -1 ; "
 & "WX 333 ; N onesuperior ; B 166 281 371 703 ;\nC -1 ; WX 667 ; N Eacute "
 & "; B 86 0 762 929 ;\nC -1 ; WX 667 ; N Acircumflex ; B 14 0 654 929 ;\nC"
 & " -1 ; WX 737 ; N copyright ; B 54 -19 837 737 ;\nC -1 ; WX 667 ; N Agra"
 & "ve ; B 14 0 654 929 ;\nC -1 ; WX 556 ; N odieresis ; B 83 -14 585 706 ;"
 & "\nC -1 ; WX 556 ; N oacute ; B 83 -14 587 734 ;\nC -1 ; WX 400 ; N degr"
 & "ee ; B 169 411 468 703 ;\nC -1 ; WX 278 ; N igrave ; B 95 0 310 734 ;\n"
 & "C -1 ; WX 556 ; N mu ; B 24 -207 600 523 ;\nC -1 ; WX 778 ; N Oacute ; "
 & "B 105 -19 826 929 ;\nC -1 ; WX 556 ; N eth ; B 81 -15 617 737 ;\nC -1 ;"
 & " WX 667 ; N Adieresis ; B 14 0 654 901 ;\nC -1 ; WX 667 ; N Yacute ; B "
 & "167 0 806 929 ;\nC -1 ; WX 260 ; N brokenbar ; B 90 -19 324 737 ;\nC -1"
 & " ; WX 834 ; N onehalf ; B 114 -19 839 703 ;\nEndCharMetrics\nStartKernD"
 & "ata\nStartKernPairs 250\n\nKPX A y -40\nKPX A w -40\nKPX A v -40\nKPX A"
 & " u -30\nKPX A Y -100\nKPX A W -50\nKPX A V -70\nKPX A U -50\nKPX A T -1"
 & "20\nKPX A Q -30\nKPX A O -30\nKPX A G -30\nKPX A C -30\n\nKPX B period "
 & "-20\nKPX B comma -20\nKPX B U -10\n\nKPX C period -30\nKPX C comma -30\n"
 & "\nKPX D period -70\nKPX D comma -70\nKPX D Y -90\nKPX D W -40\nKPX D V "
 & "-70\nKPX D A -40\n\nKPX F r -45\nKPX F period -150\nKPX F o -30\nKPX F "
 & "e -30\nKPX F comma -150\nKPX F a -50\nKPX F A -80\n\nKPX J u -20\nKPX J"
 & " period -30\nKPX J comma -30\nKPX J a -20\nKPX J A -20\n\nKPX K y -50\n"
 & "KPX K u -30\nKPX K o -40\nKPX K e -40\nKPX K O -50\n\nKPX L y -30\nKPX "
 & "L quoteright -160\nKPX L quotedblright -140\nKPX L Y -140\nKPX L W -70\n"
 & "KPX L V -110\nKPX L T -110\n\nKPX O period -40\nKPX O comma -40\nKPX O "
 & "Y -70\nKPX O X -60\nKPX O W -3";

CONST E15_5 = 
   "0\nKPX O V -50\nKPX O T -40\nKPX O A -20\n\nKPX P period -180\nKPX P o "
 & "-50\nKPX P e -50\nKPX P comma -180\nKPX P a -40\nKPX P A -120\n\nKPX Q "
 & "U -10\n\nKPX R Y -50\nKPX R W -30\nKPX R V -50\nKPX R U -40\nKPX R T -3"
 & "0\nKPX R O -20\n\nKPX S period -20\nKPX S comma -20\n\nKPX T y -120\nKP"
 & "X T w -120\nKPX T u -120\nKPX T semicolon -20\nKPX T r -120\nKPX T peri"
 & "od -120\nKPX T o -120\nKPX T hyphen -140\nKPX T e -120\nKPX T comma -12"
 & "0\nKPX T colon -20\nKPX T a -120\nKPX T O -40\nKPX T A -120\n\nKPX U pe"
 & "riod -40\nKPX U comma -40\nKPX U A -40\n\nKPX V u -70\nKPX V semicolon "
 & "-40\nKPX V period -125\nKPX V o -80\nKPX V hyphen -80\nKPX V e -80\nKPX"
 & " V comma -125\nKPX V colon -40\nKPX V a -70\nKPX V O -40\nKPX V G -40\n"
 & "KPX V A -80\n\nKPX W y -20\nKPX W u -30\nKPX W period -80\nKPX W o -30\n"
 & "KPX W hyphen -40\nKPX W e -30\nKPX W comma -80\nKPX W a -40\nKPX W O -2"
 & "0\nKPX W A -50\n\nKPX Y u -110\nKPX Y semicolon -60\nKPX Y period -140\n"
 & "KPX Y o -140\nKPX Y i -20\nKPX Y hyphen -140\nKPX Y e -140\nKPX Y comma"
 & " -140\nKPX Y colon -60\nKPX Y a -140\nKPX Y O -85\nKPX Y A -110\n\nKPX "
 & "a y -30\nKPX a w -20\nKPX a v -20\n\nKPX b y -20\nKPX b v -20\nKPX b u "
 & "-20\nKPX b period -40\nKPX b l -20\nKPX b comma -40\nKPX b b -10\n\nKPX"
 & " c k -20\nKPX c comma -15\n\nKPX colon space -50\n\nKPX comma quoterigh"
 & "t -100\nKPX comma quotedblright -100\n\nKPX e y -20\nKPX e x -30\nKPX e"
 & " w -20\nKPX e v -30\nKPX e period -15\nKPX e comma -15\n\nKPX f quoteri"
 & "ght 50\nKPX f quotedblright 60\nKPX f period -30\nKPX f o -30\nKPX f e "
 & "-30\nKPX f dotlessi -28\nKPX f comma -30\nKPX f a -30\n\nKPX g r -10\n\n"
 & "KPX h y -30\n\nKPX k o -20\nKPX k e -20\n\nKPX m y -15\nKPX m u -10\n\n"
 & "KPX n y -15\nKPX n v -20\nKPX n u -10\n\nKPX o y -30\nKPX o x -30\nKPX "
 & "o w -15\nKPX o v -15\nKPX o period -40\nKPX o comma -40\n\nKPX oslash z"
 & " -55\nKPX oslash y -70\nKPX oslash x -85\nKPX oslash w -70\nKPX oslash "
 & "v -70\nKPX oslash u -55\nKPX oslash t -55\nKPX oslash s -55\nKPX oslash"
 & " r -55\nKPX oslash q -55\nKPX oslash period -95\nKPX oslash p -55\nKPX "
 & "oslash o -55\nKPX oslash n -55\nKPX oslash m -55\nKPX oslash l -55\nKPX"
 & " oslash k -55\nKPX oslash j -55\nKPX oslash i -55\nKPX oslash h -55\nKP"
 & "X oslash g -55\nKPX oslas";

CONST E15_6 = 
   "h f -55\nKPX oslash e -55\nKPX oslash d -55\nKPX oslash comma -95\nKPX "
 & "oslash c -55\nKPX oslash b -55\nKPX oslash a -55\n\nKPX p y -30\nKPX p "
 & "period -35\nKPX p comma -35\n\nKPX period space -60\nKPX period quoteri"
 & "ght -100\nKPX period quotedblright -100\n\nKPX quotedblright space -40\n"
 & "\nKPX quoteleft quoteleft -57\n\nKPX quoteright space -70\nKPX quoterig"
 & "ht s -50\nKPX quoteright r -50\nKPX quoteright quoteright -57\nKPX quot"
 & "eright d -50\n\nKPX r y 30\nKPX r v 30\nKPX r u 15\nKPX r t 40\nKPX r s"
 & "emicolon 30\nKPX r period -50\nKPX r p 30\nKPX r n 25\nKPX r m 25\nKPX "
 & "r l 15\nKPX r k 15\nKPX r i 15\nKPX r comma -50\nKPX r colon 30\nKPX r "
 & "a -10\n\nKPX s w -30\nKPX s period -15\nKPX s comma -15\n\nKPX semicolo"
 & "n space -50\n\nKPX space quoteleft -60\nKPX space quotedblleft -30\nKPX"
 & " space Y -90\nKPX space W -40\nKPX space V -50\nKPX space T -50\n\nKPX "
 & "v period -80\nKPX v o -25\nKPX v e -25\nKPX v comma -80\nKPX v a -25\n\n"
 & "KPX w period -60\nKPX w o -10\nKPX w e -10\nKPX w comma -60\nKPX w a -1"
 & "5\n\nKPX x e -30\n\nKPX y period -100\nKPX y o -20\nKPX y e -20\nKPX y "
 & "comma -100\nKPX y a -20\n\nKPX z o -15\nKPX z e -15\nEndKernPairs\nEndK"
 & "ernData\nStartComposites 58\nCC Aacute 2 ; PCC A 0 0 ; PCC acute 208 19"
 & "5 ;\nCC Acircumflex 2 ; PCC A 0 0 ; PCC circumflex 208 195 ;\nCC Adiere"
 & "sis 2 ; PCC A 0 0 ; PCC dieresis 208 195 ;\nCC Agrave 2 ; PCC A 0 0 ; P"
 & "CC grave 208 195 ;\nCC Aring 2 ; PCC A 0 0 ; PCC ring 204 175 ;\nCC Ati"
 & "lde 2 ; PCC A 0 0 ; PCC tilde 208 195 ;\nCC Ccedilla 2 ; PCC C 0 0 ; PC"
 & "C cedilla 195 0 ;\nCC Eacute 2 ; PCC E 0 0 ; PCC acute 208 195 ;\nCC Ec"
 & "ircumflex 2 ; PCC E 0 0 ; PCC circumflex 208 195 ;\nCC Edieresis 2 ; PC"
 & "C E 0 0 ; PCC dieresis 208 195 ;\nCC Egrave 2 ; PCC E 0 0 ; PCC grave 2"
 & "08 195 ;\nCC Iacute 2 ; PCC I 0 0 ; PCC acute 14 195 ;\nCC Icircumflex "
 & "2 ; PCC I 0 0 ; PCC circumflex 14 195 ;\nCC Idieresis 2 ; PCC I 0 0 ; P"
 & "CC dieresis 14 195 ;\nCC Igrave 2 ; PCC I 0 0 ; PCC grave 14 195 ;\nCC "
 & "Ntilde 2 ; PCC N 0 0 ; PCC tilde 246 195 ;\nCC Oacute 2 ; PCC O 0 0 ; P"
 & "CC acute 264 195 ;\nCC Ocircumflex 2 ; PCC O 0 0 ; PCC circumflex 264 1"
 & "95 ;\nCC Odieresis 2 ; PCC O 0 0 ; PC";

CONST E15_7 = 
   "C dieresis 264 195 ;\nCC Ograve 2 ; PCC O 0 0 ; PCC grave 264 195 ;\nCC"
 & " Otilde 2 ; PCC O 0 0 ; PCC tilde 264 195 ;\nCC Scaron 2 ; PCC S 0 0 ; "
 & "PCC caron 208 195 ;\nCC Uacute 2 ; PCC U 0 0 ; PCC acute 236 195 ;\nCC "
 & "Ucircumflex 2 ; PCC U 0 0 ; PCC circumflex 236 195 ;\nCC Udieresis 2 ; "
 & "PCC U 0 0 ; PCC dieresis 236 195 ;\nCC Ugrave 2 ; PCC U 0 0 ; PCC grave"
 & " 236 195 ;\nCC Yacute 2 ; PCC Y 0 0 ; PCC acute 208 195 ;\nCC Ydieresis"
 & " 2 ; PCC Y 0 0 ; PCC dieresis 208 195 ;\nCC Zcaron 2 ; PCC Z 0 0 ; PCC "
 & "caron 180 195 ;\nCC aacute 2 ; PCC a 0 0 ; PCC acute 112 0 ;\nCC acircu"
 & "mflex 2 ; PCC a 0 0 ; PCC circumflex 112 0 ;\nCC adieresis 2 ; PCC a 0 "
 & "0 ; PCC dieresis 112 0 ;\nCC agrave 2 ; PCC a 0 0 ; PCC grave 112 0 ;\n"
 & "CC aring 2 ; PCC a 0 0 ; PCC ring 112 0 ;\nCC atilde 2 ; PCC a 0 0 ; PC"
 & "C tilde 102 0 ;\nCC ccedilla 2 ; PCC c 0 0 ; PCC cedilla 84 0 ;\nCC eac"
 & "ute 2 ; PCC e 0 0 ; PCC acute 112 0 ;\nCC ecircumflex 2 ; PCC e 0 0 ; P"
 & "CC circumflex 112 0 ;\nCC edieresis 2 ; PCC e 0 0 ; PCC dieresis 112 0 "
 & ";\nCC egrave 2 ; PCC e 0 0 ; PCC grave 112 0 ;\nCC iacute 2 ; PCC dotle"
 & "ssi 0 0 ; PCC acute -27 0 ;\nCC icircumflex 2 ; PCC dotlessi 0 0 ; PCC "
 & "circumflex -27 0 ;\nCC idieresis 2 ; PCC dotlessi 0 0 ; PCC dieresis -2"
 & "7 0 ;\nCC igrave 2 ; PCC dotlessi 0 0 ; PCC grave -27 0 ;\nCC ntilde 2 "
 & "; PCC n 0 0 ; PCC tilde 102 0 ;\nCC oacute 2 ; PCC o 0 0 ; PCC acute 11"
 & "2 0 ;\nCC ocircumflex 2 ; PCC o 0 0 ; PCC circumflex 112 0 ;\nCC odiere"
 & "sis 2 ; PCC o 0 0 ; PCC dieresis 112 0 ;\nCC ograve 2 ; PCC o 0 0 ; PCC"
 & " grave 112 0 ;\nCC otilde 2 ; PCC o 0 0 ; PCC tilde 112 0 ;\nCC scaron "
 & "2 ; PCC s 0 0 ; PCC caron 84 0 ;\nCC uacute 2 ; PCC u 0 0 ; PCC acute 1"
 & "12 0 ;\nCC ucircumflex 2 ; PCC u 0 0 ; PCC circumflex 112 0 ;\nCC udier"
 & "esis 2 ; PCC u 0 0 ; PCC dieresis 112 0 ;\nCC ugrave 2 ; PCC u 0 0 ; PC"
 & "C grave 112 0 ;\nCC yacute 2 ; PCC y 0 0 ; PCC acute 84 0 ;\nCC ydieres"
 & "is 2 ; PCC y 0 0 ; PCC dieresis 84 0 ;\nCC zcaron 2 ; PCC z 0 0 ; PCC c"
 & "aron 84 0 ;\nEndComposites\nEndFontMetrics\n";


BEGIN
END PklFontsBundle.
