(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: CallExpr.i3                                           *)
(* Last Modified On Fri Aug 23 18:13:04 1991 By kalsow         *)
(*      Modified On Fri Aug  3 02:44:12 1990 By muller         *)

INTERFACE CallExpr;

IMPORT Expr, Type, Temp;

PROCEDURE New (proc: Expr.T;  args: Expr.List): Expr.T;

(*******************************************************************)

TYPE
  MethodList <: ADDRESS;

TYPE
  Typer       = PROCEDURE (proc: Expr.T; VAR args: Expr.List): Type.T;
  TypeChecker = PROCEDURE (proc: Expr.T; VAR args: Expr.List;
                                         VAR cs: Expr.CheckState): Type.T;
  Compiler    = PROCEDURE (proc: Expr.T; args: Expr.List): Temp.T;
  Evaluator   = PROCEDURE (proc: Expr.T; args: Expr.List): Expr.T;
  Predicate   = PROCEDURE (proc: Expr.T; args: Expr.List): BOOLEAN;

PROCEDURE NewMethodList
  (minArgs      : INTEGER;
   maxArgs      : INTEGER;
   functional   : BOOLEAN;
   keywords     : BOOLEAN;
   fixedType    : Type.T;
   typeOf       : Typer;
   checker      : TypeChecker;
   compiler     : Compiler;
   evaluator    : Evaluator;
   isWritable   : Predicate;
   isDesignator : Predicate): MethodList;

PROCEDURE Is (e: Expr.T): BOOLEAN;

PROCEDURE IsNever (proc: Expr.T;  args: Expr.List): BOOLEAN;
PROCEDURE IsAlways (proc: Expr.T; args: Expr.List): BOOLEAN;
PROCEDURE NoValue (proc: Expr.T;  args: Expr.List): Expr.T;

END CallExpr.
