(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Expr.i3                                               *)
(* Last Modified On Mon Mar  2 10:15:43 PST 1992 By kalsow         *)

INTERFACE Expr;

IMPORT M3, Type, Token, MBuf;

TYPE
  T    = M3.Expr;
  List = UNTRACED REF ARRAY OF T;
  CheckState = M3.CheckState;

(*** phase 1 ***)

PROCEDURE Parse (READONLY fail: Token.Set): T;
(* parses an expression *)

(*** phase 2 ***)

PROCEDURE TypeOf (t: T): Type.T;
(* returns the type of the expression *)

PROCEDURE TypeCheck (t: T;  VAR cs: CheckState);
(* typechecks the expression. *)

(*** phase 3 ***)

PROCEDURE ConstValue (t: T): T;
(* Returns NIL if t is not a constant, otherwise returns a simplified
   expression that denotes t.  Value may be called before the expression
   is typechecked. *)

PROCEDURE GetBounds (t: T; VAR min, max: INTEGER);
(* returns upper and lower bounds for the value of the expression. *)

PROCEDURE IsDesignator (t: T): BOOLEAN;
(* TRUE iff t is a designator *)

PROCEDURE IsWritable (t: T): BOOLEAN;
(* TRUE iff t is a writable designator *)

PROCEDURE IsZeroes (t: T): BOOLEAN;
(* TRUE if t's binary representation is all zeroes *)

(*** phase 4 ****)

PROCEDURE Compile (t: T): M3.Temp;
(* emits code to evaluate the expression into the resulting temporary *)

PROCEDURE CompileLValue (t: T): M3.Temp;
(* emits code to evaluate the expression into the resulting temporary
   which must be able to act as an LValue for t *)

PROCEDURE Write (t: T;  t1, t2: M3.Temp);
(* writes the actual expression (called only by Temp.Write) *)

PROCEDURE IsEqual (a, b: T): BOOLEAN;
(* TRUE iff (value(a) = value(b)), assuming a constant global store *)

PROCEDURE Fingerprint (t: T;  map: Type.FPMap;  wr: MBuf.T);
(* emit the expression for a fingerprint *)

PROCEDURE GenLiteral (t: T);
(* emits the constant value t as a C initializer *)

END Expr.
