(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: ExprRep.i3                                            *)
(* Last Modified On Mon Mar  2 10:17:58 PST 1992 By kalsow     *)
(*      Modified On Thu Nov 29 03:45:22 1990 By muller         *)

INTERFACE ExprRep;

IMPORT M3, Type, MBuf;

REVEAL
  M3.Expr = M3.Node BRANDED "Expr.T" OBJECT
    type         : Type.T;
    checked      : BOOLEAN;
  METHODS
    typeOf       (): M3.Type                 := NoType;
    check        (VAR cs: M3.CheckState)     := NoCheck;
    write        (t1, t2: M3.Temp)           := NoWriter;
    isEqual      (e: M3.Expr): BOOLEAN       := NeverEq;
    evaluate     (): M3.Expr                 := NoValue;
    getBounds    (VAR min, max: INTEGER)     := NoBounds;
    isWritable   (): BOOLEAN                 := IsNever;
    isDesignator (): BOOLEAN                 := IsNever;
    isZeroes     (): BOOLEAN                 := IsNever;
    genLiteral   ()                          := NoLiteral;
    fprint       (map: Type.FPMap;  wr: MBuf.T);
    compile      (): M3.Temp;
  END;

TYPE Ta   = M3.Expr OBJECT a: M3.Expr     OVERRIDES isEqual := EqCheckA  END;
TYPE Tab  = M3.Expr OBJECT a, b: M3.Expr  OVERRIDES isEqual := EqCheckAB END;
TYPE Tabc = Tab     OBJECT class: INTEGER OVERRIDES isEqual := EqCheckAB END;

PROCEDURE Init (e: M3.Expr);
(* initializes the common part of an Expr.T *)

(* misc. useful methods *)
PROCEDURE NoType    (e: M3.Expr): M3.Type;
PROCEDURE NoCheck   (e: M3.Expr;  VAR cs: M3.CheckState);
PROCEDURE NoValue   (e: M3.Expr): M3.Expr;
PROCEDURE Self      (e: M3.Expr): M3.Expr;
PROCEDURE NoBounds  (e: M3.Expr;  VAR min, max: INTEGER);
PROCEDURE IsNever   (e: M3.Expr): BOOLEAN;
PROCEDURE IsAlways  (e: M3.Expr): BOOLEAN;
PROCEDURE NeverEq   (e: M3.Expr;  x: M3.Expr): BOOLEAN;
PROCEDURE NoWriter  (e: M3.Expr;  t1, t2: M3.Temp);
PROCEDURE NoLiteral (e: M3.Expr);

PROCEDURE EqCheckA  (e: Ta;  x: M3.Expr): BOOLEAN;
PROCEDURE EqCheckAB (e: Tab; x: M3.Expr): BOOLEAN;

END ExprRep.
