(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: NegateExpr.m3                                         *)
(* Last modified on Mon Jul  8 18:25:01 1991 by kalsow         *)
(*      modified on Thu Nov 29 03:29:51 1990 by muller         *)

MODULE NegateExpr;

IMPORT Expr, ExprRep, Type, Error, Int, Reel, LReel, EReel;
IMPORT IntegerExpr, ReelExpr, Temp, MBuf, Emit;

TYPE
  P = ExprRep.Ta BRANDED "NegateExpr.P" OBJECT
      OVERRIDES
        typeOf       := TypeOf;
        check        := Check;
        compile      := Compile;
        evaluate     := Fold;
        fprint       := FPrinter;
        write        := Writer;
        isEqual      := ExprRep.EqCheckA;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := ExprRep.IsNever;
	genLiteral   := ExprRep.NoLiteral;
      END;

PROCEDURE New (a: Expr.T): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.a := a;
    RETURN p;
  END New;

PROCEDURE TypeOf (p: P): Type.T =
  BEGIN
    RETURN Expr.TypeOf (p.a)
  END TypeOf;

PROCEDURE Check (p: P;  VAR cs: Expr.CheckState) =
  VAR t: Type.T;
  BEGIN
    Expr.TypeCheck (p.a, cs);
    t := Type.Base (Expr.TypeOf (p.a));
    IF (t # Int.T) AND (t # Reel.T) AND (t # LReel.T) AND (t # EReel.T) THEN
      Error.Msg ("illegal operands for unary \'-\'");
    END;
    p.type := t;
  END Check;

PROCEDURE Compile (p: P): Temp.T =
  VAR t1, t2: Temp.T;
  BEGIN
    t1 := Expr.Compile (p.a);
    t2 := Temp.AllocMacro (p, FALSE);
    Temp.Depend (t2, t1);
    RETURN t2;
  END Compile;

PROCEDURE Writer (<*UNUSED*> p: P;  t1: Temp.T;  <*UNUSED*> t2: Temp.T) =
  BEGIN
    Emit.OpT ("(-@)", t1);
  END Writer;

PROCEDURE Fold (p: P): Expr.T =
  VAR e1, e3: Expr.T;
  BEGIN
    e1 := Expr.ConstValue (p.a);
    e3 := NIL;
    IF    (e1 = NIL)                  THEN
    ELSIF IntegerExpr.Negate (e1, e3) THEN
    ELSIF ReelExpr.Negate    (e1, e3) THEN
    END;
    RETURN e3;
  END Fold;

PROCEDURE FPrinter (p: P;  map: Type.FPMap;  wr: MBuf.T) =
  BEGIN
    MBuf.PutText (wr, "U- ");
    Expr.Fingerprint (p.a, map, wr);
  END FPrinter;

BEGIN
END NegateExpr.
