(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: TypeExpr.m3                                           *)
(* Last modified on Mon Mar  2 10:56:57 PST 1992 by kalsow     *)
(*      modified on Tue Aug 28 06:03:04 1990 by muller         *)

MODULE TypeExpr;

IMPORT Expr, ExprRep, Type, Void, Emit, MBuf;
IMPORT String, Value, NamedExpr, QualifyExpr, Temp;

TYPE
  P = Expr.T BRANDED "TypeExpr.P"OBJECT
        t: Type.T;
      OVERRIDES
        typeOf       := ExprRep.NoType;
        check        := Check;
        compile      := Compile;
        evaluate     := ExprRep.Self;
        fprint       := FPrinter;
        write        := Writer;
        isEqual      := EqCheck;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsNever;
        isDesignator := ExprRep.IsNever;
	isZeroes     := ExprRep.IsNever;
	genLiteral   := ExprRep.NoLiteral;
      END;

PROCEDURE New (t: Type.T): Expr.T =
  VAR p := NEW (P);
  BEGIN
    ExprRep.Init (p);
    p.t := t;
    p.type := Void.T;
    RETURN p;
  END New;

PROCEDURE Split (e: Expr.T;  VAR t: Type.T): BOOLEAN =
  VAR obj: Value.T;  name: String.T;
  BEGIN
    TYPECASE e OF
    | NULL => RETURN FALSE;
    | P(p) => t := p.t;  RETURN TRUE;
    ELSE
      IF (NamedExpr.Split (e, name, obj) OR QualifyExpr.Split (e, obj))
        AND (Value.ClassOf (obj) = Value.Class.Type)
        THEN  t := Value.ToType (obj);  RETURN TRUE;
        ELSE  RETURN FALSE;
      END;
    END;
  END Split;

PROCEDURE Check (p: P;  <*UNUSED*> VAR cs: Expr.CheckState) =
  BEGIN
    Type.Check (p.t);
  END Check;

PROCEDURE EqCheck (a: P;  e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL => RETURN FALSE;
    | P(b) => RETURN Type.IsEqual (a.t, b.t, NIL);
    ELSE      RETURN FALSE;
    END;
  END EqCheck;

PROCEDURE Compile (p: P): Temp.T =
  BEGIN
    Type.Compile (p.t);
    RETURN Temp.FromExpr (p);
  END Compile;

PROCEDURE Writer (p: P;  <*UNUSED*> t1, t2: Temp.T) =
  BEGIN
    Emit.OpF (" @ ", p.t);
  END Writer;

PROCEDURE FPrinter (p: P;  map: Type.FPMap;  wr: MBuf.T) =
  BEGIN
    Type.Fingerprint (p.t, map, wr);
  END FPrinter;

BEGIN
END TypeExpr.
