(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: OpaqueType.i3                                         *)
(* Last Modified On Fri Nov  8 11:35:51 PST 1991 By kalsow         *)

INTERFACE OpaqueType;

IMPORT Type;

PROCEDURE New (super: Type.T): Type.T;

PROCEDURE NewNETWORK (super: Type.T): Type.T;
(* Only to be called by Netwrk.Initialize *)

PROCEDURE Is (t: Type.T): BOOLEAN;

PROCEDURE Super (t: Type.T): Type.T;

PROCEDURE IsSubtype (a, b: Type.T): BOOLEAN;

PROCEDURE Population (): INTEGER;
(* returns the number of opaque types that exist in the compilation *)

PROCEDURE UID (t: Type.T): INTEGER;
(* if t is an opaque type, return it's uid, otherwise return zero *)

END OpaqueType.
