(* new interface KRML *)
INTERFACE TrOffsets;

TYPE T <: ROOT;

(* The New and NewArray procedures return T elements that can be used
   in other calls to procedures in this interface.  The caller must
   not assume anything about the T values.  In particular, the return
   values from New and NewArray may be NIL.  It is, however, acceptable
   to pass in NIL as any parameter of type T in this interface. *)

PROCEDURE New( offset: INTEGER ): T;
(* return T for the given traced offset *)

PROCEDURE NewArray( offset, nbElems, elSize: CARDINAL; el: T ): T;
(* return T for an at the given offset nbElems-element array, whose
   elements have size elSize and traced offsets specified by el. *)

PROCEDURE Append( p, q: T ): T;
(* append q to p (let's face it:  T is some kind of linked list node),
   returning the T at the end of the resulting list *)

PROCEDURE Emit( p: T; inXFile: BOOLEAN );
(* Emit a string corresponding to the given T to the current emit
   stream (which is intended to be a .x file). *)

END TrOffsets.
