(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Formal.i3                                             *)
(* Last Modified On Thu Jun  4 09:39:07 PDT 1992 By kalsow     *)
(*      Modified On Wed Feb  7 01:02:52 1990 By muller         *)


INTERFACE Formal;

IMPORT Type, Value, String, Expr, Scope;

TYPE Mode = {mVALUE, mVAR, mCONST};

TYPE
  Info = RECORD
    name   : String.T;
    offset : INTEGER;
    mode   : Mode;
    type   : Type.T;
    dfault : Expr.T;
    unused : BOOLEAN;
  END;

PROCEDURE New (READONLY info: Info): Value.T;

PROCEDURE Split (formal: Value.T;  VAR info: Info);

PROCEDURE HasClosure (formal: Value.T): BOOLEAN;

PROCEDURE RefOpenArray (formal: Value.T): Type.T;
(* if formal is a VALUE ARRAY OF T parameter,
   RefOpenArray returns  REF ARRAY OF T, othewise it
   returns NIL. *)

PROCEDURE CheckArgs (VAR cs       : Value.CheckState;
                     VAR actuals  : Expr.List;
                READONLY formals  : ARRAY OF Value.T;
                         names    : Scope.NameList := NIL;
                         complain : BOOLEAN := TRUE;
			 nFormals : INTEGER := 99999): BOOLEAN;

END Formal.
