(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Variable.i3                                           *)
(* Last Modified On Fri Sep  4 13:59:15 PDT 1992 By rustan     *)
(*      Modified On Tue Jun  9 10:26:58 PDT 1992 By kalsow     *)
(*      Modified On Fri Apr 27 03:11:00 1990 By muller         *)

INTERFACE Variable;

IMPORT String, Type, Token, Value, Temp,  Scope, Decl;

TYPE
  T <: Value.T;

PROCEDURE ParseDecl (READONLY fail: Token.Set; att: Decl.Attributes);

PROCEDURE New (name: String.T;  used: BOOLEAN): T;
(* doesn't insert the object into any scope.... *)

PROCEDURE NewFormal (formal: Value.T;  name: String.T): T;

PROCEDURE BindType (t: T;  type: Type.T;
                    indirect, readonly, allowOpenArray: BOOLEAN:= FALSE);

PROCEDURE Split (t: T;  VAR type: Type.T;  VAR indirect, readonly: BOOLEAN);

PROCEDURE IsFormal (t: T): BOOLEAN;
PROCEDURE IsIndirect (t: T): BOOLEAN;
PROCEDURE HasClosure (t: T): BOOLEAN;

PROCEDURE SetBounds (t: T;  min, max: INTEGER);
PROCEDURE GetBounds (t: T;  VAR min, max: INTEGER);

PROCEDURE Load (t: T): Temp.T;
PROCEDURE LoadLValue (t: T);

PROCEDURE InitGlobal (t: T);

(* new KRML *)
PROCEDURE GenGlobalTracedOffsets (s: Scope.T);
(* end KRML *)
PROCEDURE GenGlobalMap (s: Scope.T): BOOLEAN;

PROCEDURE Initialize ();

END Variable.
