/* Copyright (C) 1990, Digital Equipment Corporation.         */
/* All rights reserved.                                       */
/* See the file COPYRIGHT for a full description.             */

/* Last modified on Fri Feb 28 11:23:46 PST 1992 by kalsow    */
/*      modified on Wed Mar 27 02:58:44 1991 by muller        */

/* for AP3000 */

/* These are the storage classes and type qualifiers */

#define _PRIVATE static
#define _IMPORT  extern
#define _EXPORT        

#define _LOCAL_PROC  static
#define _LOCAL       auto


#define _STACK_GROWS_DOWN
/* comment this out if stacks grow up (toward increasing addresses) */


/* A Modula-3 procedure value can be either a C function pointer or a
   pointer to a CLOSURE struct. The first field of CLOSURE structs
   "marker", is always equal to CLOSURE_MARKER.

   To test if a procedure value is a closure or not, we assume is it
   one and look at the marker field. If we don't find CLOSURE_MARKER,
   we have a C function pointer.

   Since a C function pointer is the address of the first instruction,
   we chose the value of CLOSURE_MARKER to be different from any
   instruction that may start a procedure. */
   
#define _CLOSURE_MARKER 0xffffffff      /* illegal opcode */
#define _IS_CLOSURE(p) ((p != 0) && ((_CLOSURE *)p)->marker == _CLOSURE_MARKER)



/* NILCHECKB must evaluate its argument 'e' (a char*) and
   generate a trap if it is NIL (0). */
extern volatile char _M3__nil_check_char;
#define _NILCHECKB(e) _M3__nil_check_char = ((char*)(e))[-1];



/* The type 'signed_char' is 'signed char' in ANSI-C,
   but CC may not like that. Same for 'signed_int'. */
typedef char signed_char;
typedef int  signed_int;

