/* Copyright (C) 1990, Digital Equipment Corporation.         */
/* All rights reserved.                                       */
/* See the file COPYRIGHT for a full description.             */

/* Last modified on Fri Feb 28 11:15:24 PST 1992 by kalsow    */
/*      modified on Wed Mar 27 03:00:53 1991 by muller        */

/* for IBMRT */

/* These are the storage classes and type qualifiers */

#define _PRIVATE static volatile
#define _IMPORT  extern volatile
#define _EXPORT         volatile

#define _LOCAL_PROC  static
#define _LOCAL       auto


#define _STACK_GROWS_DOWN
/* comment this out if stacks grow up (toward increasing addresses) */


/* IS_CLOSURE should return TRUE if p points to a closure, FALSE if it points
   to a C function */

/* Dick Orgass says:

This rather strange definition comes from the following obscure property
of the C Compiler/ld for this system.  If a function, say foo, is
declared in a C source file, there are two entries in the symbol table:
.foo (note the leading dot) is in the text segment and foo (without the
dot) is in the data segment.  Therefore, if one executes the assigment x
= foo;, the value of x is in the data segment.  Moreover,

	*foo == foo

but

	*(unsigned long *)foo == .foo

and is in the text segment.  This means that the proc field of a CLOSURE
always points to the data segment and *(unsigned long *)(CLOSURE *)
remains in the data segment.  I have no idea why this is the case.
*/

_IMPORT etext;
#define _IS_CLOSURE(p) \
	(p == 0 ? 0 : ((*((long unsigned *)p)) > ((unsigned long) &etext)))


/* NILCHECKB must evaluate its argument 'e' (a char*) and
   generate a trap if it is NIL (0). */
extern volatile char _M3__nil_check_char;
#define _NILCHECKB(e) _M3__nil_check_char = ((char*)(e))[-1];


/* The type 'signed_char' is 'signed char' in ANSI-C,
   but CC may not like that. Same for 'signed_int'. */
typedef signed char signed_char;
typedef signed int  signed_int;

#if defined (__HIGHC__)
#define _packed __packed /* This has to be redefined for High C
                            because it has special meaning. 
                            Micheal J. Bauers, BSI */
#endif


