(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Feb 28 20:14:09 PST 1992 by stolfi     *)
(*      modified on Tue Nov 19 17:45:11 PST 1991 by muller     *)
(*      modified on Wed Sep 25 00:02:34 1991 by kalsow         *)

INTERFACE Real;

(* Properties of REAL (for what machine???).

   This package defines some basic properties of the 
   built-in float type REAL.

   Index: REAL; floating-point; generics
*)
  
TYPE T = REAL;

CONST 
  Base: INTEGER = 2; 
  (* The radix of the floating-point representation for T *)

  Precision: INTEGER = 24;
  (* The number of digits of precision in the given Base for T. *)

  MaxFinite: T = 3.40282347E+38;
  (* The maximum finite value in T.  For non-IEEE implementations,
     this is the same as LAST(T). *)

  MinPos: T = 1.40239846E-45;
  (* The minimum positive value in T. *)

  MinPosNormal: T = 1.17549435E-38;
  (* The minimum positive "normal" value in T; differs from MinPos
     only for implementations with denormalized numbers. *)

END Real.

