(* new interface KRML *)
INTERFACE RTRegisters;

IMPORT Csetjmp;
FROM Ctypes IMPORT int;

(* Note, as is stated in RTMain.i3, this run-time assumes that
   a variable of type T need no initialization before it is passed
   to Save, and that both Save and Restore can be called before
   this interface and module have been initialized. *)

TYPE
  T = Csetjmp.jmp_buf;

<*EXTERNAL "_setjmp" *>  PROCEDURE Save( VAR regs: T ): int;
<*EXTERNAL "_longjmp" *> PROCEDURE Restore( VAR regs: T; val: int := 1 );

PROCEDURE SetStackPointer( VAR regs: T; sp: ADDRESS );
PROCEDURE GetStackPointer( READONLY regs: T ): ADDRESS;

PROCEDURE FlushStackCache();

END RTRegisters.
