(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Wed Jul  1 21:19:07 1992 by rustan         *)

(* new interface KRML *)
UNSAFE INTERFACE RTMemory;
(* this interface is unsafe because it reveals MEMORY_Start and MEMORY_End,
   whose inproper modification may havoc the run-time *)

VAR (* CONST *)
  MEMORY_Start: ADDRESS := NIL;
  MEMORY_End: ADDRESS := NIL;
  MainStackHigh: ADDRESS;
  MainStackLow: ADDRESS;
  SystemStackHigh: ADDRESS;
  SystemStackLow: ADDRESS;
  GcStackHigh: ADDRESS;
  GcStackLow: ADDRESS;

CONST
  (* There are AddrPerAlign addressable units per alignment.
     This means that AddrPerAlign satisfies, for any address a:
       ( INT(a) MOD AddrPerAlign = 0 ) = ( any object can start at address a )
     where INT(a) means LOOPHOLE( a, INTEGER ).  
     NOTE.  Changing this value will also require a change in M3Runtime.h.
     (See comment on RefHeader and Header in RTHeapKRML.m3.) *)
  AddrPerAlign = 1;

PROCEDURE Init( gcStackSize: CARDINAL );
(* sets up the variables declared above;
   called by RTHeap.InitHeap() before MEMORY_Start and MEMORY_End are used *)

END RTMemory.
