(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Wed Jul  1 21:19:07 1992 by rustan         *)

(* new module KRML *)
UNSAFE MODULE RTMemory;

IMPORT ThreadF;

(* Note, the ...StackHigh values specify the lowest address not used in
   a thread's stack.  This must be consistent with RTStack module and
   RTRegisters.New. *)

PROCEDURE Init( gcStackSize: CARDINAL ) =
  BEGIN
    (* this procedure should only be called once *)
    <* ASSERT MEMORY_End = NIL *>

    (* moreover, MEMORY_Start should have been initialized by the monitor
       program *)
    <* ASSERT MEMORY_Start # NIL *>

    (* Note the ugly -1 and corresponding +1 here.  Since the M3 compiler
       (incorrectly) handles addresses as unsigned (as opposed to signed)
       integers, this is needed. *)
    MainStackHigh := LOOPHOLE( 0-1, ADDRESS );
    MainStackLow := MainStackHigh + 1 - ThreadF.MainStackSize;

    SystemStackHigh := MainStackLow;
    SystemStackLow := SystemStackHigh - ThreadF.SystemStackSize;

    GcStackHigh := SystemStackLow;
    GcStackLow := GcStackHigh - gcStackSize;

    MEMORY_End := GcStackLow
  END Init;

BEGIN
END RTMemory.
