(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Tue Mar  3 17:08:14 PST 1992 by kalsow     *)

INTERFACE RTOS;

(* This interface provides platform specific OS hooks *)

CONST (* these values are ORed together to create a "mode" for mprotect *)
  Read_mode    = 1;
  Write_mode   = 2;
  Execute_mode = 4;

<*EXTERNAL*>
PROCEDURE mprotect (start: ADDRESS;  n_bytes, mode: INTEGER): INTEGER;
(* sets the VM page protection of the specified bytes.  The range of
   bytes must be page-aligned and must include an whole number of pages.
   The number of bytes actually affected are returned. *)

END RTOS.

