(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Sep  4 17:29:36 PDT 1992 by rustan     *)
(*      modified on Thu Jan 30 14:47:00 PST 1992 by kalsow     *)
(*      modified on Wed Jul  3 04:15:39 1991 by muller         *)

INTERFACE RTHeap;

(* This interface provides safe access to the storage allocator
   and garbage collector. *)

IMPORT RT0;


PROCEDURE Allocate( def: RT0.TypeDefinition ): ADDRESS;
(* REQUIRES NOT inSystemCritical *)
(* allocate an object whose type definition is specified by 'def' *)

PROCEDURE AllocateOpenArray( def: RT0.TypeDefinition;
                             READONLY s: ARRAY OF INTEGER ): ADDRESS;
(* REQUIRES NOT inSystemCritical *)
(* allocate an open array, whose type definition is specified by
   'def', and whose open array dimensions are given in array 's'. *)

PROCEDURE AllocateSurrogate( def: RT0.TypeDefinition;
                             sur: ADDRESS (* IPC.Surrogate *) ): ADDRESS;
(* REQUIRES inSystemCritical *)
(* make 'sur' into a surrogate for a concrete network object with global ID
   ('sur.pid','sur.id') and whose type definition is specified by 'def' *)

PROCEDURE AllocateBindings( def: RT0.TypeDefinition;
                            destPid: INTEGER ): ADDRESS;
(* REQUIRES NOT inSystemCritical *)
(* if destPid specifies the local processor,
     return Allocate(def)
   otherwise,
     allocate an open array of integers, whose size is the size of an
     IPC.Header record plus the data size, d say, of an object of type 'def',
     whose last d elements are initialized as if it were an object of
     type 'def'. *)

PROCEDURE DisposeTraced( VAR r: REFANY );
(* indicate non-interest in the traced object referenced by 'r'
   and set 'r' to NIL *)

PROCEDURE DisposeUntraced( VAR a: ADDRESS );
(* REQUIRES NOT inSystemCritical *)
(* indicate non-interest in the untraced non-object referenced by 'a'
   and set 'a' to NIL *)

PROCEDURE BackdoorDisposeUntraced( VAR a: ADDRESS );
(* REQUIRES inSystemCritical AND Thread.Self() # ThreadF.gcThread *)
(* Same as DisposeUntraced, except that here inSystemCritical is required.
   In addition, the calling thread must not be garbage collector thread. *)

PROCEDURE InitHeap();
(* initializes the heap; should be called as the first thing from
   RTMain.Run, and from nowhere else *)

PROCEDURE Collect();
(* Procedure executed by the garbage collector thread *)

END RTHeap.
