(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Tue Sep  8 13:58:41 PDT 1992 by rustan         *)
(*      modified on Fri Jun 21 17:20:23 1991 by kalsow         *)
(*      modified on Tue Nov  6 20:34:50 1990 by muller         *)

MODULE RTMath;

IMPORT Word;

(******************************************************** KRML tmp
PROCEDURE Ceiling (r: LONGREAL): INTEGER =
  BEGIN
    WITH ir = TRUNC (r) DO
      IF r > 0.0d0 THEN
        IF FLOAT (ir, LONGREAL) = r THEN
          RETURN ir
        ELSE
          RETURN ir + 1; END;
      ELSE
        RETURN ir; END; END;
  END Ceiling;

PROCEDURE Floor (r: LONGREAL): INTEGER =
  BEGIN
    WITH ir = TRUNC (r) DO 
      IF r < 0.0d0 THEN
        IF FLOAT (ir, LONGREAL) = r THEN
          RETURN ir;
        ELSE
          RETURN ir - 1; END;
      ELSE
        RETURN ir; END; END;
  END Floor;

PROCEDURE Round (r: LONGREAL): INTEGER =
  BEGIN
    IF r > 0.0d0 THEN
      RETURN TRUNC (r + 0.5d0);
    ELSE
      RETURN TRUNC (r - 0.5d0); END;
  END Round;


(* We assume that TRUNC is compiled without calling this module *)
PROCEDURE Trunc (r: LONGREAL): INTEGER =
  BEGIN
    RETURN TRUNC (r);
  END Trunc;
****************************************************** KRML tmp *)


PROCEDURE IDiv  (a, b: INTEGER): INTEGER =
  BEGIN
    IF a = 0 THEN 
                    RETURN 0;
    ELSIF a < 0 THEN
      IF b < 0 THEN RETURN Word.Divide (-a, -b);
      ELSE          RETURN - Word.Divide (-a-1, b) - 1; END;
    ELSE
      IF b < 0 THEN RETURN - Word.Divide (a-1, -b) - 1;
      ELSE          RETURN Word.Divide (a, b); END; END;
  END IDiv;

PROCEDURE IMod  (a, b: INTEGER): INTEGER =
  BEGIN
    IF a = 0 THEN
                    RETURN 0;
    ELSIF a < 0 THEN
      IF b < 0 THEN RETURN - Word.Mod (-a, -b);
      ELSE          RETURN b - 1 - Word.Mod (-a-1, b); END;
    ELSE
      IF b < 0 THEN RETURN b + 1 + Word.Mod (a-1, -b);
      ELSE          RETURN Word.Mod (a, b); END; END;
  END IMod;

BEGIN
END RTMath.

