(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Wed Jul  1 21:19:07 1992 by rustan         *)

(* Rustan Leino *)

UNSAFE MODULE Processor;

IMPORT System, IPC;


PROCEDURE ID(): INTEGER =
  BEGIN
    RETURN System.procID
  END ID;

PROCEDURE Main(): INTEGER =
  BEGIN
    RETURN System.procMain
  END Main;

PROCEDURE Min(): INTEGER =
  BEGIN
    RETURN System.procMin
  END Min;

PROCEDURE Max(): INTEGER =
  BEGIN
    RETURN System.procMax
  END Max;

PROCEDURE Count(): CARDINAL =
  BEGIN
    RETURN System.procMax - System.procMin + 1
  END Count;

PROCEDURE HostConnection(): INTEGER =
  BEGIN
    RETURN System.procHostConnection
  END HostConnection;

PROCEDURE Of( net: NETWORK ): INTEGER =
  BEGIN
    RETURN net.pid
  END Of;

BEGIN
END Processor.
