(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Wed Jul  1 21:19:07 1992 by rustan         *)

(* Rustan Leino *)

UNSAFE INTERFACE Surrogate;

IMPORT IPC;

PROCEDURE Find( pid, id: INTEGER; VAR sur: IPC.Surrogate ): BOOLEAN;
(* REQUIRES inSystemCritical *)
(* Searches surrogate table for entry (pid,id).  If present, the procedure
   returns TRUE and net becomes the associated value.  If not present,
   the procedure returns FALSE and net is undefined. *)

PROCEDURE Add( pid, id: INTEGER; net: IPC.Surrogate );
(* REQUIRES inSystemCritical *)
(* Adds (pid,id) to the surrogate table, associating with it net.
   It is assumed (pid,id) is not already present in the table. *)

PROCEDURE Remove( pid, id: INTEGER );
(* REQUIRES inSystemCritical *)
(* Removes (pid,id) from the surrogate table.  It is assumed (pid,id) is
   present in the table. *)

END Surrogate.
