(* Copyright (C) 1989, 1992 Digital Equipment Corporation                    *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Last Modified On Fri Jun 26 21:35:29 1992 By rustan                   *)
(*      Modified On Tue Mar  3 18:37:31 PST 1992 By muller                   *)

INTERFACE TextF;

REVEAL
  (* Remember, the report says that TEXT is predeclared and <: REFANY;
     just pretend that we have 
         TYPE
           TEXT <: REFANY
     in the Text interface. *)

  (* The array contains the characters of the text followed by a '\000' *)
 
  TEXT = BRANDED "Text 1.0" REF ARRAY OF CHAR;

(*********************************************** KRML
PROCEDURE New (n: CARDINAL): TEXT RAISES {};
  (* create a new text capable of holding n characters. Note that its actual
     length as an array is n+1 because of the null termination.
     The characters at positions [0..n-1] are left undefined. The character
     at position n is '\000' *)
********************************************* KRML *)

END TextF.
