/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>
#include <errno.h>
#include "tar.h"

void Fatal(char *msg)
{
  fprintf(stderr, "Fatal! %s!\n", msg);
  exit(1);
}

static int getnextslashpos (char * string, int pos)
  {
    if (string [pos] == '\0') {
      return pos;
    }
    do {
      pos++;
    } while ((string [pos] != '\0') && (string [pos] != '/'));
    return pos;
  }

static char actual_dir [256] = "";

static void check_directory (char * path)
  {
    int i, j, end = 0, r, len;
    char dirname [256], substr1 [256], substr2 [256];
    
    for (i = 0; i < strlen (path); i++) {
      if (path [i] == '/') {
        end = i;
      }
    }
    for (i = 0; i <= end; i++) {
      dirname [i] = path [i];
      dirname [i+1] = '\0';
    }
    
    if (strcmp (actual_dir, dirname) == 0) {
      return;
    }
    
    len = strlen (dirname);
    substr1 [0] = '\0';
    substr2 [0] = '\0';
    i = 0; j = 0;
    while (j < len - 1) {
      i = getnextslashpos (actual_dir, i);
      j = getnextslashpos (dirname, j);
      strncpy (substr1, actual_dir, i);
      substr1 [i] = '\0';
      strncpy (substr2, dirname, j);
      substr2 [j] = '\0';
      if (strcmp (substr1, substr2) != 0) {
        printf("Making directory %s\n", substr2);
        r = mkdir (substr2, 0);
        if (r < 0) {
	  printf ("mytar: create directory for %s failed\n", substr2);
	  exit (-1);
        }
      }
    }
    strcpy (actual_dir, dirname);
  }


char buf[512];

static void skip_file (int fd, int size)
  {
    int dsize;
    while (size) {
      if (size < 512) {
        dsize = size;
      } else {
        dsize = 512;
      }
      read(fd, buf, 512);
      size -= dsize;
    }
  }
  
static char * filename = 0;
static char * outputfile = 0;

main(int argc, char **argv)
{
  int i, j;
  if (argc < 2)
  {
    fprintf(stderr, "%s [-f filename] tarfile ...\n", argv [0]);
    fprintf(stderr, "%s [-f filename [-o outputfile]] tarfile ...\n", argv [0]);
    exit(1);
  }
  
  if (strcmp (argv [1], "-f") == 0) {
    filename = argv [2]; j = 3;
    outputfile = filename;
    if (strcmp (argv [3], "-o") == 0) {
      outputfile = argv [4]; j = 5;
    }
    for (i = j; i < argc; i++)
      tarread (argv [i]);
  } else {
    for (i = 1; i < argc; i++)
      tarread (argv[i]);
  }
}

typedef struct {
  char name [100];
  char mode [8];
  char uid [8];
  char gid [8];
  char size [12];
  char mtime [12];
  char chksum [8];
  char typeflag [1];
  char linkname [100];
  char magic [6];
  char version [2];
  char uname [32];
  char gname [32];
  char devmajor [8];
  char devminor [8];
  char prefix [155];
  char filler [12];
} TARREC;


tarread(char *fname)
{
  TARREC header;
  int r;
  int f;
  long perm, uid, gid, size, time, csum;
  int dsize;
  char changed_name [40];
  long posn=0, cur_pos, skipsize;
  
  if ((f = open(fname, O_RDONLY | O_BINARY, S_IREAD)) < 0) {
    printf ("mytar: cannot open tarfile %s\n", fname);
    return -1;
  }

  while (1)
  {
    if (read(f, &header, sizeof (header)) < 0) {
      break;
    }
    if (header.name[0] == 0) {
      printf ("mytar: untared %s\n", fname);
      break;
    }
    sscanf(header.mode, "%lo", &perm);
    sscanf(header.uid, "%lo", &uid);
    sscanf(header.gid, "%lo", &gid);
    sscanf(header.size, "%lo", &size);
    sscanf(header.mtime, "%lo", &time);
    strcpy (changed_name, header.name);
    printf("%ld %6lo %12ld %s", posn, perm, size, changed_name);
    if (header.typeflag[1] == 0x32)
      printf(" -> %s", header.filler);
    printf("\n"); fflush (stdout);
    posn += 512 + (size+511) & ~511;

    if ((filename != 0) && (strcmp (changed_name, filename) != 0)) {
      printf ("djtar: skipping %s: \n", changed_name);
      fflush (stdout);
      skip_file (f, size);
      continue;
    }

    if (header.typeflag [0] == DIRTYPE) {
      if (changed_name [strlen (changed_name) - 1] == '/') {
        changed_name[strlen(changed_name)-1] = 0;
      }
      
      printf("Making directory %s\n", changed_name);
      r = mkdir (changed_name, 0);
      if (r < 0) {
	printf ("mytar: cannot create directory %s\n", changed_name);
	exit (-1);
      }
      strcpy (actual_dir, changed_name);	/* new actual dir !!! */
    } else if ((header.typeflag [0] == REGTYPE) || 
               (header.typeflag [0] == AREGTYPE)) {
      /* check_directory (changed_name); */
      r = open(outputfile, O_WRONLY|O_BINARY|O_CREAT|O_EXCL,S_IWRITE|S_IREAD);
      printf ("--  Creating file %s\n", outputfile);
      if (r < 0) {
        printf ("mytar: cannot open file %s\n", outputfile);
	exit (-1);
      } else {
        while (size) {
          if (size < 512) {
            dsize = size;
          } else {
            dsize = 512;
	  }
          read(f, buf, 512);
          if (write(r, buf, dsize) < dsize) {
            printf("mytar: out of disk space\n");
            exit(1);
          }
          size -= dsize;
        }
        close(r);
      }
    } else if (header.typeflag [0] == LNKTYPE) {
      printf ("mytar: hard link ignored\n");
    } else if (header.typeflag [0] == SYMTYPE) {
      printf ("mytar: symbolic link ignored\n");
    } else {
      printf ("mytar: unsupported typeflag %c\n", header.typeflag [0]);
      exit (-1);
    }
    fflush (stdout);
  }
  printf ("mytar: closing tarfile\n");
  close(f);
}
