/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <stdio.h>
#include "/ex32/include/sys/mknod.h"

int main (int argc, char ** argv)
  {
    unsigned major, minor, device; char type; int result;
    
    if (argc != 5) {
      fprintf (stderr, "usage: %s device type major minor\n", argv [0]);
      return -1;
    }
    
    if (sscanf (argv [2], "%c", &type) != 1) {
      return -1;
    }
    if (sscanf (argv [3], "%u", &major) != 1) {
      return -1;
    }
    if (sscanf (argv [4], "%u", &minor) != 1) {
      return -1;
    }
    device = (major << 16) | minor;
    
    switch (type) {
    case 'b': result = mknod (argv [1], MKN_BSF, device);
              break;
    case 'c': result = mknod (argv [1], MKN_CSF, device);
              break;
    default : return -1;
    }
    return result;
  }
