/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <unistd.h>
#include <std.h>
#include <stdio.h>
#include <fcntl.h>

#define BUF_LEN		1024
#define NAME_LEN	80
#define ARGCOUNT	100

#define C_NORMAL	0
#define C_REDIR_OP	1
#define C_DREDIR_OP	2
#define C_REDIR_IP	4

static char command [BUF_LEN];
static char name [NAME_LEN];
static char * argv [ARGCOUNT];
static char * redirfile_op;
static char * redirfile_ip;
static int  redir = C_NORMAL;
static char prompt [BUF_LEN];
static int dos_mode = 0;

static int skip_blanks (char * command, int i)
  {
    while ((command [i] != '\0') && (command [i] == ' ')) {
      i++;
    }
    return i;
  }

static int skip_string (char * command, int i, char termch)
  {
    command [i] = ' ';			/* overwrite 'termch' */
    i++;
    while ((command [i] != '\0') && (command [i] != termch)) {
      i++;
    }
    if (command [i] == termch) {	/* overwrite 'termch' */
      command [i] = ' ';
      i++;
    }
    return i;
  }

static void process_command_line (char * command, char * name, char ** argv)
  {
    int i, j, len, string = 0;

    i = 0; len = strlen (command); redir = C_NORMAL;
    while ((i < NAME_LEN - 1)   && 
           (command [i] != ' ') && 
	   (command [i] != '\0')) {
      name [i] = command [i];
      i++;
      name [i] = '\0';
    }  

    if (dos_mode) {
      return;
    }    
    i = 0; j = 0;
    while ((j < ARGCOUNT - 1) && (i < len)) {
      if (command [i] == ' ') {		/* skip blanks */
	command [i] = '\0'; 
	i++;
        i = skip_blanks (command, i);
      }
      if ((command [i] != ' ') && (command [i] != '\0')) {
        if (command [i] == '>') {		/* redirect output */
	  i++;
	  redir |= C_REDIR_OP;
	  if (command [i] == '>') {		/* append redirection */
	    i++;
	    redir |= C_DREDIR_OP;
	  }
	  i = skip_blanks (command, i);
	  redirfile_op = &command [i];
	} else if (command [i] == '<') {	/* redirect input */
	  i++;
	  redir |= C_REDIR_IP;
	  i = skip_blanks (command, i);
	  redirfile_ip = &command [i];
	} else {				/* process argument */
          argv [j++]  = &command [i];		/* argument found */
	  argv [j]    = 0;
	  i++;
	}
	while (command [i] != '\0') {
	  if (command [i] == '\'') {		/* ARG='argument string' */
	    i = skip_string (command, i, '\'');
	  } else if (command [i] == '\"') {
	    i = skip_string (command, i, '\"');
	  } else if (command [i] == ' ') {
	    break;				/* process next argument */
	  } else {
	    i++;
	  }
	}
      }
      if (command [i] == '\0') {
	break;
      }
    }
  }

static int execute (char * name, char ** argv)
  {
    int status;
    if (fork () == 0) {
      /* child */
      if (redir != C_NORMAL) {
	if (redir & C_REDIR_IP) {
	  close (0);			/* close stdin */
	  open (redirfile_ip, O_RDONLY | O_BINARY);
	}
        if (redir & C_REDIR_OP) {
          close (1);			/* close stdout */
	  if (redir & C_DREDIR_OP) {
	    open (redirfile_op, O_CREAT | O_APPEND | O_WRONLY | O_BINARY);
	  } else {
	    open (redirfile_op, O_CREAT | O_TRUNC | O_WRONLY | O_BINARY);
	  }
	}
      }
      lseek (0, 0, SEEK_SET);
      lseek (1, 0, SEEK_SET);
      lseek (2, 0, SEEK_SET);
      if (execvp (name, (const char **) argv) < 0) {
        printf ("vssh: cannot execute %s\n", name);
        exit (-1);		/* child exit */
      }
    }
    /* parent */
    wait (&status);
    return status;
  }

static char execute_commandfile (char * filename)
  {
    FILE * file; int i; char ch;
    if ((file = fopen (filename, "r")) == NULL) {
      printf ("vssh: file %s not found\n", filename);
      return;
    }
    i = 0;
    while ((ch = fgetc (file)) != EOF) {
      command [i++] = ch;
      if (ch == '\n') {
        command [i - 1] = '\0';
	printf ("vssh: %s\n", command); fflush (stdout);
	process_command_line (command, name, argv);
	/* execute it */
	execute (name, argv);
        i = 0; 
      }
    }
    fclose (file);
  }

static void give_help ()
  {
    printf ("\nThe following commands are builtin:\n");
    printf ("exit		exit vssh\n");
    printf ("help		print this message\n");
    printf ("dos		enter DOS commands\n");
    printf ("ext		enter EXTENDER commands\n");
    printf ("\n");
  }

static void shell ()
  {
    char ch = ' '; 
    int len = 0, i = 0, j;

    while (1) {
      getcwd (prompt, BUF_LEN);
      printf ("%s>", prompt);
      fflush (stdout);
    
      len = read (0, command, sizeof (command));
      if (len > 1) {
        command [len - 1] = '\0'; 		/* overwrite '\n' */
      
        process_command_line (command, name, argv);
        if (strcmp (name, "exit") == 0) {
	  break;
	} else if (strcmp (name, "help") == 0) {
	  give_help ();
	  continue;
	} else if (strcmp (name, "dos") == 0) {
	  printf ("vssh: you can enter DOS commands now\n");
	  dos_mode = 1;
	  continue;
	} else if (strcmp (name, "ext") == 0) {
	  printf ("vssh: you can enter EXTENDER commands now\n");
	  dos_mode = 0;
	  continue;
	}
      
        if (! dos_mode) {
          if (name [0] == '@') {
            execute_commandfile (name);
	    continue;
          }

          execute (name, argv);
	} else {
	  dossys (command);
	}
      }
    }
  }

static void say_hello ()
  {
    printf ("\n");
    printf ("\t\tCopyright (C) 1994, Klaus Preschern.\n");
    printf ("\t\tAll rights reserved.\n");
    printf ("\t\tSee the file COPYRIGHT.KP for a full description.\n");
    printf ("\n\n");
    printf ("\t\tHi, this is the very simple shell (vssh).\n");
    printf ("\t\tType a command or 'exit'.\n");
    printf ("\n\n");
  }

int main (int argc, char ** m_argv, char ** envp)
  { 
    if (argc == 1) {
      say_hello ();
      shell ();
    } else if (strcmp (m_argv [1], "-c") == 0) { /* try to execute */
      int i;
      printf (" \b");
/***      
      printf ("vssh: ");
      for (i = 0; i < argc; i++) {
        printf ("%s ", m_argv [i]);
      }
      printf ("\n");
***/      
      process_command_line (m_argv [2], name, argv);
/***      
      for (i = 0; argv [i] != 0; i++) {
        printf ("%s", argv [i]);
      }
      printf ("\n");
***/      
      return execute (name, argv);
    } else {
      printf ("usage: vssh [-c commands]\n");
    }
    return 0;
  }
