/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <std.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include "/ex32/include/sys/message.h"
#include "/ex32/include/sys/syscalls.h"
#include "/ex32/include/signal.h"

#define TRUE			1
#define FALSE			0
#undef  DEBUG

#define MAX_ARGS		30
#define ARG_LEN			40
#define STACK_DEPTH		256
#define RET_INSTR		0xc3

extern int __pid;
extern void init_symbols (char *);
extern char * get_sym (int);

static int	tr_sp = 0;
static char	* tr_stack [STACK_DEPTH];
static void    	sigsegv_handler (void);
static int     	start_child (char **);
static int	tr_pid;
static char	* old_ptr = 0;
static int	old_eip, old_ret_addr;

static panic (int proc, char * string)
  {
    printf ("stacker panic (%d): %s\n", proc, string);
    kill (proc, SIGKILL);
    exit (-1);
  }

static void sigquit_handler ()
  {
    printf ("\nstacker: quit signal received\n");
    kill (tr_pid, SIGKILL);
    exit (0);
  }

static void sigsegv_handler ()
  {
    REGS regs; char * symbol;
    _procget (tr_pid, &regs);
    symbol = get_sym (regs.eip);
    printf ("\nreturn address =  %d\n", old_ret_addr);
    printf ("stacker: segmentation violation %d %s: eip = %d = 0x%x\n", 
             tr_pid, symbol, regs.eip, regs.eip);
    kill (tr_pid, SIGKILL);			 /* kill proc  */
    exit (0);					/* I have done my job. */
  } 


static char * st_tos ()
  {
    if (tr_sp > 0) {
      return tr_stack [tr_sp - 1];
    }
    return 0;
  }

static void st_push (char * symbol)
  {
    if (tr_sp < STACK_DEPTH) {
      tr_stack [tr_sp] = symbol;
      tr_sp++;
    } else {
      panic (tr_pid, "stack overflow");
    }
  }
  
static char * st_pop (void)
  {
    if (tr_sp > 0) {
      tr_sp--;
      return tr_stack [tr_sp];
    } else {
      panic (tr_pid, "stack underflow");
    }
  }  

static void ident (void)
  {
    int i;
    for (i = 1; i < tr_sp; i++) {
      printf ("  ");
    }
  }

static int get_dword (int pos)
  {
    int dword;
    _proccpy (tr_pid, __pid, (void *) pos, &dword, sizeof (dword));
    return dword;
  }


static int was_return = 0, output = 1;
static int save_ebp = 0, check_value, found = 0, instrcnt = 0;

static void check_point (int eip, int ebp, char * symbol)
  {
    if ((save_ebp) && (!found)) {
      int value;
      instrcnt++;
      value = get_dword (save_ebp);
      if ((instrcnt > 3) && (value != check_value)) {
        found = 1;
        printf ("\n------------------------------------------------------\n");
        printf ("ebp on stack changed at %d: value = %d, check_value = %d\n",
                 eip, value, check_value);
        printf ("------------------------------------------------------\n");
      }
      if ((strcmp (symbol, "_ThreadPosix__InitTopContext") == 0) &&
          (instrcnt > 3) && (save_ebp != ebp)) {
        found = 1;
        printf ("\n------------------------------------------------------\n");
        printf ("ebp register wrong at %d: ebp = %d, saved ebp = %d\n",
                 eip, ebp, save_ebp);
        printf ("------------------------------------------------------\n");	
      }
    }
  }

static void sigtrap_handler ()
  {
    REGS regs; char * symbol, * save; int ret_addr; byte instr; 
    
    _procget (tr_pid, &regs);
    symbol = get_sym (regs.eip);
    
    _proccpy (tr_pid, __pid, (void *) (regs.eip),
              &instr, sizeof (instr));
    if ((symbol != old_ptr) || (instr == RET_INSTR)) {
      ret_addr = get_dword (regs.esp);
    }
    
/*    check_point (regs.eip, regs.ebp, symbol);*/
    if (instr == RET_INSTR) {
      was_return = 1;
      if (output) {
        printf ("%7d:", regs.eip);
        ident ();
        printf ("%s return to %d\n", symbol, ret_addr);
      }
      st_pop ();
    } else if (was_return) {
      ret_addr = get_dword (regs.ebp + 4);
      was_return = 0;
      if (output) {
        printf ("%7d:", regs.eip);
        ident ();
        printf ("back in %s\n", symbol);
      }
      old_ptr = symbol;
    } else if (symbol != old_ptr) {
      st_push (symbol);
/***    
      if ((!save_ebp) && (strcmp (symbol, "_ThreadPosix__InitTopContext") == 0)) {
        save_ebp = regs.esp - 4;
	check_value = regs.ebp;
	output = 1;
      }
***/      
      if (output) {
        printf ("%7d:", regs.eip);
        ident ();
        printf ("%s --> %d <-- %d\n", symbol, old_eip, ret_addr);
      }
      old_ptr = symbol;
    }
    
    old_eip = regs.eip;
    old_ret_addr = ret_addr;
    signal (SIGTRAP, (SignalHandler) &sigtrap_handler);
/***    
    _procjmp (tr_pid, regs);
***/    
    kill (tr_pid, SIGUSR1);			 /* restart proc  */
  }

static int start_child (char ** argv)
  {
     int child; int i = 0;
     
#ifdef DEBUG
     printf ("exec (");
     while (argv [i] != 0) {
       printf ("%s ", argv [i]); i++;
     }
     printf (")\n");
     fflush (stdout);
#endif

     init_symbols (argv [0]);     
     
     if ((child = fork ()) == 0) {
       /* child */
       _setexec (EXEC_EMU | EXEC_DEBUG);
       if (execve (argv [0], (const char **) argv, environ) < 0) {
         panic (child, "cannot exec");
	 exit (-1);
       }
     }
     /* parent */
     return child;
  }


void main (int argc, char ** argv, char ** envp)
  {
    int status;
    
    if (argc < 2) {
      printf ("usage: %s program arguments ...\n", argv [0]);
      exit (-1);
    }
    
    signal (SIGSEGV,  (SignalHandler) &sigsegv_handler);
    signal (SIGTRAP,  (SignalHandler) &sigtrap_handler);
    signal (SIGQUIT,  (SignalHandler) &sigquit_handler);
    
    tr_pid = start_child (&argv [1]);
    /* parent */
    while (wait (&status) != tr_pid) ;
    printf ("\ntracer: process %d has said good bye with %d\n", tr_pid, status);
  }

