/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <stdio.h>
#include <aout.h>

#define BUF_SIZE		256
#define NIL_SYM			(struct sym_list *)(0)

typedef struct sym_entry {
  unsigned int		string_off;
  unsigned char		type;
  unsigned char		other;
  unsigned short	desc;
  unsigned int		val;
} SYM_ENTRY;

typedef struct sym_list {
  SYM_ENTRY		sym;
  char *		string;
  struct sym_list *	next;
} SYM_LIST;

static SYM_LIST * symlist = NIL_SYM;
static char str_buf [BUF_SIZE];

static void print_list ()
  {
    SYM_LIST * ptr;
    printf ("\n\n\nsymbol list:\n\n");
    ptr = symlist;
    while (ptr != NIL_SYM) {
      printf ("%s of type %d at address %d = %x\n",
              ptr->string, ptr->sym.type, ptr->sym.val, ptr->sym.val);
      ptr = ptr->next;
    }
  }

static void insert_list (SYM_ENTRY * sym, char * string)
  {
    SYM_LIST * new, * ptr, * pptr; int len;
    
    new = (SYM_LIST *) malloc (sizeof (SYM_LIST));
    new->sym  = *sym;
    new->next = NIL_SYM;
    len = strlen (string) + 1;			/* insert string */
    new->string = (char *) malloc (len);
    strncpy (new->string, string, len);
    
    pptr = NIL_SYM;
    ptr  = symlist;
    while ((ptr != NIL_SYM) && (ptr->sym.val < sym->val)) {
      pptr = ptr;
      ptr  = ptr->next;
    }
    if (pptr == NIL_SYM) {		/* new first or first */
      new->next = symlist;
      symlist   = new;
    } else {				/* new somewhere or last */
      new ->next = ptr;
      pptr->next = new;
    }
  }

static char * get_string (FILE * fd, int offset)
  {
    int i = 0;
    if (offset != ftell (fd)) {
      fseek (fd, offset, 0);
    }
    do {
      str_buf [i++] = fgetc (fd);
    } while ((i < BUF_SIZE) && (str_buf [i-1]));
    return (char *) 0;
  }

void init_symbols (char * fname)
  {
     FILE * fd1, * fd2; SYM_ENTRY sym;
     struct exec header;
     int nsyms, i; char * cp;

     if (((fd1 = fopen (fname, "rb")) == NULL) ||
	 ((fd2 = fopen (fname, "rb")) == NULL)) {
       printf ("Cannot open %s\n", fname);
       exit (-1);
     }

     if (fread (&header, sizeof (header), 1, fd1) != 1) {
       printf ("Cannot read header from %s\n", fname);
       exit (-1);
     }

     if (N_MAGIC (header) != ZMAGIC) {
       printf ("Bad magic number in %s\n", fname);
       exit (-1);
     }

     nsyms = header.a_syms / sizeof (SYM_ENTRY);
     printf ("Reading %d symbols from %s ...\n", nsyms, fname);

     fseek (fd1, N_SYMOFF (header), 0);

     for (i = 0; i < nsyms; i++) {
       if (fread (&sym, sizeof (sym), 1, fd1) != 1) {
	 printf ("Cannot read symbols from %s\n", fname);
	 exit (-1);
       }
       if (sym.string_off) {
	 get_string (fd2, N_STROFF (header) + sym.string_off);
       }
/***       
       printf ("%d: offset:%d type:%d %d %d %x %s\n", 
       		i+1,
		sym.string_off,
		(int) sym.type,
		(int) sym.other,
		(int) sym.desc,
		sym.val,
		str_buf);
***/		
       cp  = &str_buf [0];
       cp += strlen (cp) - 3;
       if ((strcmp (cp+1, ".o") != 0) &&  /* do not insert .o files   */
           (strcmp (cp+1, "d.") != 0) &&  /* i.e. gcc?_compiled. stuff */
	   (strcmp (cp, ".io")  != 0) &&  /* .io files */
	   (strcmp (cp, ".mo")  != 0) &&  /* .mo files */
	   (strcmp (str_buf, "___gnu_compiled_m3") != 0) &&
	   (strcmp (str_buf, "___gnu_compiled_c")  != 0)) {
         insert_list (&sym, str_buf);
       }
     }
     fclose (fd1); fclose (fd2);
  }

char * get_sym (int val)
  {
    SYM_LIST * ptr, * pptr;
    
    pptr = NIL_SYM;
    ptr = symlist;
    while ((ptr != NIL_SYM) && (ptr->sym.val <= val)) {
      pptr = ptr;
      ptr  = ptr->next;
    }
    
    if (pptr == NIL_SYM) {
      return (char *) 0;
    } else {
      return pptr->string;
    }
  }
