(* BarPM3Client.m3 *)
(* Last tweaked by Mike Spreitzer April 21, 1994 4:56 pm PDT *)

MODULE BazM3Client EXPORTS Main;
IMPORT Bar, Baz, Fmt, Foo, Ilu, IluBasics, ParseParams, RTMisc,
       Scan, Stdio, Text, Thread, Wr;

<*FATAL Thread.Alerted, Wr.Failure*>

PROCEDURE FmtU (u: Foo.U; call: BOOLEAN): TEXT =
  PROCEDURE FmtO (o: Foo.O): TEXT =
    VAR u2: Foo.U;
    VAR t1, t2: TEXT := "";
    BEGIN
      IF call THEN
        TRY
          u2 := o.U_CSS_to_U(u, icss);
          t2 := " => " & FmtU(u2, FALSE);
        EXCEPT
        | Foo.E1 (u3) => t2 := " => Foo.E1(" & FmtU(u3, FALSE) & ")"
        | Foo.E2 (i) => t2 := " => Foo.E2(" & Fmt.Int(i) & ")"
        | IluBasics.Failed (e) =>
            t2 := " => Ilu.Failed(" & IluBasics.FullInfo(e) & ")"
        END (*try*);
      END (*if*);
      TRY
        t1 := Ilu.SbhFromObject(o)
      EXCEPT
        IluBasics.Failed (e) =>
          t1 := "Ilu.Failed(" & IluBasics.FullInfo(e) & ")"
      END (*try*);
      RETURN t1 & t2;
    END FmtO;
  BEGIN
    TYPECASE u OF
    | Foo.U_R (x) =>
        RETURN
          Fmt.F("R{%s, %s}", Fmt.Int(x.v.i), FmtCSS(x.v.css));
    | Foo.U_RO (x) =>
        IF x.v # NIL THEN
          RETURN
            Fmt.F("RO{%s, %s}", Fmt.Int(x.v.i), FmtCSS(x.v.css))
        ELSE
          RETURN "RO-NOT"
        END;
    | Foo.U_CSS (x) => RETURN FmtCSS(x.v);
    | Foo.U_O (x) => RETURN "O " & FmtO(x.v);
    | Foo.U_OO (x) =>
        IF x.v # NIL THEN
          RETURN "OO " & FmtO(x.v)
        ELSE
          RETURN "OO-NOT"
        END (*if*);
    ELSE
      RETURN "??";
    END (*typecase*);
  END FmtU;

PROCEDURE FmtCSS (css: Foo.CSS): TEXT =
  VAR ans := "<";
  BEGIN
    FOR i := 0 TO NUMBER(css^) - 1 DO
      IF i # 0 THEN ans := ans & ", " END;
      ans := ans & "`" & css[i] & "'";
    END (*for*);
    RETURN ans & ">";
  END FmtCSS;

VAR sbh, mstid, method: TEXT;
VAR icss := NEW(Foo.CSS, 1);
VAR o: Baz.O;
VAR p: Bar.P;
VAR n, m: INTEGER;
VAR u: Foo.U;

BEGIN
  icss[0] := "icss";
  TRY
    ParseParams.BeginParsing(Stdio.stderr);
    sbh := ParseParams.GetNext();
    mstid := ParseParams.GetNext();
    o := Baz.ILU_SBH_To_O(sbh, mstid);
    p := Bar.ILU_Qua_P(o);
    IF p = NIL THEN
      Wr.PutText(Stdio.stderr, "p=NIL!\n");
      Wr.Flush(Stdio.stderr)
    END (*if*);
    method := ParseParams.GetNext();
    IF Text.Equal(method, "M1") THEN
      n := ParseParams.GetNextInt();
      u := o.M1(n);
      Wr.PutText(Stdio.stdout, "Got " & FmtU(u, TRUE) & "\n");
    ELSIF Text.Equal(method, "P1") THEN
      n := ParseParams.GetNextInt();
      m := p.P1(n);
      Wr.PutText(Stdio.stdout, "Got " & Fmt.Int(m) & "\n");
    ELSE
      n := ParseParams.NumParameters - ParseParams.NextParameter;
      icss := NEW(Foo.CSS, n);
      FOR i := 0 TO n - 1 DO
        icss[i] := ParseParams.GetNext()
      END;
      u := o.U_CSS_to_U(NEW(Foo.U_CSS, v := icss), icss);
      Wr.PutText(Stdio.stdout, "Got " & FmtU(u, TRUE) & "\n");
    END (*if*);
    ParseParams.EndParsing();
  EXCEPT
  | Scan.BadFormat =>
      Wr.PutText(
        Stdio.stderr,
        "Usage: BazM3Client SBH mstid (M1 i | P1 i | U-CSS-to-U elts)\n");
      RTMisc.Exit(1);
  | IluBasics.Failed (f) =>
      Wr.PutText(
        Stdio.stderr,
        "IluBasics.Failed(" & IluBasics.FullInfo(f) & ")\n");
      RTMisc.Exit(1);
  | Thread.Alerted =>
      Wr.PutText(Stdio.stderr, "Thread.Alerted\n");
      RTMisc.Exit(1);
  | Foo.E1 (v) =>
      Wr.PutText(Stdio.stderr, "Foo.E1(" & FmtU(v, TRUE) & ")\n");
      RTMisc.Exit(1);
  | Foo.E2 (v) =>
      Wr.PutText(Stdio.stderr, "Foo.E2(" & Fmt.Int(v) & ")\n");
      RTMisc.Exit(1);
  | Baz.E1 (v) =>
      Wr.PutText(Stdio.stderr, "Baz.E1(" & v & ")\n");
      RTMisc.Exit(1);
  END (*try*);
END BazM3Client.
