#include <stdio.h>

#include "Test1.h"
#include "Test2.h"
#include "Test3.h" 

int main(int ac, char **av)
{
    double	atof( );
    Test1_O1	handle;
    Test1_O2	o2;
    Test1_O3	o3;
    float	f;
    ILU_C_ENVIRONMENT	s;
    Test1_U	u;
    Test1_CSS	*css;
    Test1_ScS	scs[ 3 ];
    Test1_RO	ro;
    Test1_R	r;

    Test1__Initialize( );
    Test3__Initialize( );
    if ((handle = ILU_C_LookupObject ("Test1_Initial_Object@Test1-Server", &_Test1_O1__ILUClassRecord)) == NULL)
      exit(1);
/*
    if (ac < 2)
      exit(1);
    if ((handle = Test1_O1__CreateFromSBH (av[1], NULL)) == NULL)
      exit(1);
*/
    u._d = Test1_U_boolean;
    u._u.boolean = 1;
    scs[0] = "hello world";
    scs[1] = "hello mars";
    css = Test1_CSS_Create( 2, scs );
    u = Test1_O1_U_CSS_to_U( handle, &s, &u, css );
    printf( "u._d=%d, u._u.boolean = %u, u._u.O1 = 0x%lx\n", u._d, u._u.boolean, (unsigned long) u._u.O1 );
    ro = Test1_O1_f_CSS_to_RO( handle, &s, css );
    printf( "ro->i=%ld\n", ro->i );

    f = Test1_O1_R_ScS_to_F( handle, &s, ro, scs[0] );
    printf( "f=%f\n", f );

    Test1_O1_a_RO( handle, &s, ro );

    o2 = Test1_O1_get_O2 ( handle, &s );
    if (ILU_C_SUCCESSFUL(&s))
      {
	Test1_A0 a;
	ilu_byte *ap;
	Test1_A1 a1;
	Test1_I i;
	Test1_CSS css2;

	printf ("got O2, sbh = %s\n", ILU_C_SBHOfObject(o2));

	css2 = Test1_O2_OO_A0_to_CSS ( o2, &s, handle, a);
	if (ILU_C_SUCCESSFUL(&s))
	  {
	  }
	else
	  {
	    printf ("exception on Test1_O2_OO_A0_to_CSS, exception is \"%s\"\n", s.returnCode);
	  }

	r.css._length = 0;
	r.css._buffer = NULL;
	r.css._maximum = 0;
	r.i = 12;
	r.a[0] = "this is";
	r.a[1] = "data";
	r.a[2] = "initialization";
	a1[0] = "but this";
	a1[1] = "is";
	a1[2] = "fun";
	ap = Test1_O2_R_I_A1_to_I_A0 (o2, &s, &r, &i, a1);
      }
    else
      {
	printf ("couldn't get an instance of O2.  Exception is \"%s\".\n", s.returnCode);
      }

    o3 = Test1_O1_get_O3 ( handle, &s, ilu_FALSE );
    if (ILU_C_SUCCESSFUL(&s))
      {
	Test1_RS *rs = Test1_RS_Create (0, NULL);
	Test1_IS i2;

	printf ("got O3, sbh = %s, type = %s\n", ILU_C_SBHOfObject(o3), ILU_C_ClassName(o3));

	if (ILU_C_ClassRecordOfInstance(o3) != ILU_C_FindILUClassByTypeName("Test1.O3"))
	  {
	    printf ("instance of class %s received!\n", ILU_C_ClassName(o3));
	  }
	else
	  {
	    i2 = Test1_O3_RS_R_to_R_IS (o3, &s, rs, &r);
	    Test1_O3_O1_U_to_U (o3, &s, handle, &u);
	    printf( "u._d=%d, u._u.boolean = %u, u._u.O1 = 0x%lx\n", u._d, u._u.boolean, (unsigned long) u._u.O1 );
	  }
      }
    else
      {
	printf ("couldn't get an instance of O3.  Exception is \"%s\".\n", s.returnCode);
      }

    /* this next call should return an instance of Test3.O */
    o3 = Test1_O1_get_O3 ( handle, &s, ilu_TRUE );
    if (ILU_C_SUCCESSFUL(&s))
      {
	Test1_RS *rs = Test1_RS_Create (0, NULL);
	Test1_IS i2;

	printf ("got O3, sbh = %s, type = %s\n", ILU_C_SBHOfObject(o3), ILU_C_ClassName(o3));

	i2 = Test1_O3_RS_R_to_R_IS (o3, &s, rs, &r);
	Test1_O3_O1_U_to_U (o3, &s, handle, &u);
	printf( "u._d=%d, u._u.boolean = %u, u._u.O1 = 0x%lx\n", u._d, u._u.boolean, (unsigned long) u._u.O1 );

	if (ILU_C_ClassRecordOfInstance(o3) == ILU_C_FindILUClassByTypeName("Test3.O"))
	  {
	    Test1_U u2;

	    u2 = Test3_O_I_to_Test1U (o3, &s, 397);
	    if (! ILU_C_SUCCESSFUL(&s))
	      {
		printf ("exception on Test1_O2_OO_A0_to_CSS, exception is \"%s\"\n", s.returnCode);
	      }
	    else
	      printf( "Test3_O_I_to_Test1U:  u2._d=%d, u2._u.boolean = %u, u2._u.O1 = 0x%lx\n",
		     u2._d, u2._u.boolean, (unsigned long) u2._u.O1 );
	  }
      }
    else
      {
	printf ("couldn't get an instance of O3.  Exception is \"%s\".\n", s.returnCode);
      }

    exit(0);
}
