/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* Last tweaked by Mike Spreitzer September 9, 1993 3:06 pm PDT */

#include "ilu.H"
#include <iluServer.H>

extern "C" {
#include <stdio.h>
extern char *_ilu_Strdup(const char *);
}

iluObject::iluObject()
{
  this->ILURPCObject = NULL;
  this->ILURPCServer = NULL;
  this->ILUNMSHandle = NULL;
  this->ILUMostSpecificObj = NULL;
}

iluObject::~iluObject()
{
  if (this->ILURPCServer != NULL)
    {
      ilu::EnterServer(this->ILURPCServer, this->ILUInstanceClassRecord);
      if (this->ILURPCObject != NULL)
        {
          ilu::SetLanguageSpecificObject (this->ILURPCObject, NULL);
          this->ILURPCObject = NULL;
        }
      ilu::ExitServer(this->ILURPCServer, this->ILUInstanceClassRecord);
    }
  if (this->ILUNMSHandle != NULL)
    free(this->ILUNMSHandle);
}

struct registry_record {
  ilu_Class c;
  void *(*proc)(ilu_KernelObject);
  struct registry_record *next;
};

static struct registry_record *RegisteredClasses = NULL;

static struct registry_record * findRegistryRecordByClass (ilu_Class c)
{
  struct registry_record *p;

  for (p = RegisteredClasses;  p != NULL;  p = p->next)
    if (p->c == c)
      return (p);
  return (NULL);
}

void iluObject::RegisterClass (ilu_Class c, void * (*proc)(ilu_KernelObject))
{
  struct registry_record *p;

  if ((p = findRegistryRecordByClass(c)) == NULL)
    {
      p = (struct registry_record *) malloc(sizeof(struct registry_record));
      p->c = c;
      p->proc = proc;
      p->next = RegisteredClasses;
      RegisteredClasses = p;
      ilu::RegisterClass (c);
    }
}

void * iluObject::CreateFromRegistry (ilu_Class c, ilu_KernelObject obj)
{
  void *lspo;
  struct registry_record *p;

  if ((p = findRegistryRecordByClass(c)) == NULL)
    return (NULL);
  else
    {
      lspo = (*(p->proc))(obj);
      return(lspo);
    }
}

void *iluObject::ILUCastDown (ilu_Class cast_to)
{
  if (cast_to == NULL)
    return ((void *) this);
  else	/* don't know how to cast to anything in this method */
    return (NULL);
}

ilu_KernelObject iluObject::ILUGetRPCObject ()
{
  return (this->ILURPCObject);
}

void iluObject::ILUSetRPCObject (ilu_KernelObject obj)
{
  this->ILURPCServer = ilu::GetObjectServer(obj);
  this->ILURPCObject = obj;
}

ilu_CString iluObject::ILUStringBindingHandle ()
{
  return (ilu::SBHOfObject(this->ILUEnsureKernelObject()));
}

ilu_KernelObject iluObject::ILUEnsureKernelObject()
{
  if (this->ILURPCObject == NULL) {
    /* Should be a true object. */
    static int idcounter = 0;
    char * id;

    this->ILURPCServer = this->ILUGetServer()->ks;
    if (this->ILUInstanceClassRecord->cl_singleton)
      id = "0";
    else {
      char idbuf[10];

      sprintf(idbuf, "%u", ++idcounter);
      id = _ilu_Strdup(idbuf);
    }

    this->ILURPCObject = ilu::CreateTrueKernelObject
	(id, this->ILURPCServer, this->ILUInstanceClassRecord, (void *) this);
  }
  return this->ILURPCObject;
}

class iluServer * iluObject::ILUGetServer ()
{
  return ilu::GetDefaultServer();
}

void * iluObject::InputObject (ilu_Call call, ilu_Boolean discriminator_p, ilu_Class putative_class)
{
  ilu_KernelObject obj;
  void *lspo = NULL;
  class iluObject *o;
  ilu_Class c;

  if ((obj = ilu::InputObjectID (call, discriminator_p, putative_class)) == NULL)
    return (NULL);

  /* now Inside(obj->server, putative_class) */
  if ((o = (class iluObject *) ilu::GetLanguageSpecificObject(obj)) == NULL)
    {
      if ((c = ilu::GetObjectClass(obj)) != NULL)
	lspo = iluObject::CreateFromRegistry (c, obj);
    }
  else
    lspo = o->ILUMostSpecificObject();
  ilu::ExitServer(ilu::GetObjectServer(obj), putative_class);
  return(lspo);
}

ilu_Boolean iluObject::OutputObject (ilu_Call call, class iluObject *obj, ilu_Class putative_class)
{
  if (obj != NULL)
    obj->ILUEnsureKernelObject();
  return (ilu::OutputObjectID(call, obj->ILURPCObject, ilu_FALSE, putative_class));
}

ilu_Cardinal iluObject::SizeOfObject (ilu_Call call, class iluObject *obj, ilu_Class putative_class)
{
  if (obj != NULL)
    obj->ILUEnsureKernelObject();
  return (ilu::SizeOfObjectID(call, obj->ILURPCObject, ilu_FALSE, putative_class));
}

char * iluObject::ILUGetNMSHandle ()
{
  return (this->ILUNMSHandle);
}

void iluObject::ILUSetNMSHandle (char *handle)
{
  if (this->ILUNMSHandle != NULL)
    free(this->ILUNMSHandle);
  this->ILUNMSHandle = _ilu_Strdup(handle);
}
