/*
** Copyright (c) 1993, 1994 Xerox Corporation.  All Rights Reserved.
**
** Unlimited use, reproduction, and distribution of this software is
** permitted.  Any copy of this software must include both the above
** copyright notice of Xerox Corporation and this paragraph.  Any
** distribution of this software must comply with all applicable United
** States export control laws.  This software is made available AS IS,
** and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
** INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
** AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
** PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
** THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
** CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
** XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: orb.c,v 1.14 1994/04/14 00:12:12 janssen Exp $ */

#include <malloc.h>

#include "ilu-c.h"

#ifdef CORBA11	/* CORBA 1.1 */

ILU_C_Object	ILU_C_ORB[1];

void _ILU_C_SetProtocolError (Environment *status, ilu_ProtocolException perror)
{
  status->_major = StExcep_SYSTEM_EXCEPTION;
  status->freeRoutine = NULL;
  status->ptr = (void *) malloc(sizeof(StExcep_ex_body));
  ((StExcep_ex_body *)(status->ptr))->minor = 0;
  ((StExcep_ex_body *)(status->ptr))->minor = StExcep_NO;
  switch (perror)
    {
    case ilu_ProtocolException_NoSuchClassAtServer:
      status->returnCode = ex_StExcep_BAD_TYPECODE;
      break;

    case ilu_ProtocolException_ClassVersionMismatch:
      status->returnCode = ex_StExcep_BAD_TYPECODE;
      break;

    case ilu_ProtocolException_NoSuchMethodOnClass:
      status->returnCode = ex_StExcep_BAD_OPERATION;
      break;

    case ilu_ProtocolException_GarbageArguments:
      status->returnCode = ex_StExcep_BAD_PARAM;
      break;

    case ilu_ProtocolException_Unknown:
      status->returnCode = ex_StExcep_UNKNOWN;
      ((StExcep_ex_body *)(status->ptr))->minor = StExcep_MAYBE;
      break;

    case ilu_ProtocolException_LostConnection:
      status->returnCode = ex_StExcep_COMM_FAILURE;
      ((StExcep_ex_body *)(status->ptr))->minor = StExcep_MAYBE;
      break;

    case ilu_ProtocolException_RequestRejected:
      status->returnCode = ex_StExcep_BAD_OPERATION;
      break;

    case ilu_ProtocolException_RequestTimeout:
      status->returnCode = ex_StExcep_NO_RESPONSE;
      ((StExcep_ex_body *)(status->ptr))->minor = StExcep_MAYBE;
      break;

    default:
      break;

    }
}

ILU_C_ExceptionCode	ex_StExcep_UNKNOWN = "StExcep: an unknown exception was encountered";
ILU_C_ExceptionCode	ex_StExcep_BAD_PARAM = "StExcep: a bad parameter was passed";
ILU_C_ExceptionCode	ex_StExcep_NO_MEMORY = "StExcep: dynamic memory allocation failure";
ILU_C_ExceptionCode	ex_StExcep_IMP_LIMIT = "StExcep: some implementation limit exceeded";
ILU_C_ExceptionCode	ex_StExcep_COMM_FAILURE = "StExcep: communication failure";
ILU_C_ExceptionCode	ex_StExcep_INV_OBJREF = "StExcep: invalid object reference";
ILU_C_ExceptionCode	ex_StExcep_NO_PERMISSION = "StExcep: no permission for attempted operation";
ILU_C_ExceptionCode	ex_StExcep_INTERNAL = "StExcep: ORB internal error";
ILU_C_ExceptionCode	ex_StExcep_MARSHAL = "StExcep: error marshalling parameter or result";
ILU_C_ExceptionCode	ex_StExcep_INITIALIZE = "StExcep: ORB initialization failure";
ILU_C_ExceptionCode	ex_StExcep_NO_IMPLEMENT = "StExcep: operation implementation unavailable";
ILU_C_ExceptionCode	ex_StExcep_BAD_TYPECODE = "StExcep: bad typecode";
ILU_C_ExceptionCode	ex_StExcep_BAD_OPERATION = "StExcep: invalid operation";
ILU_C_ExceptionCode	ex_StExcep_NO_RESOURCES = "StExcep: insufficient resources for operation";
ILU_C_ExceptionCode	ex_StExcep_NO_RESPONSE = "StExcep: response to request not yet available";
ILU_C_ExceptionCode	ex_StExcep_PERSIST_STORE = "StExcep: persistent storage failure";
ILU_C_ExceptionCode	ex_StExcep_BAD_INV_ORDER = "StExcep: routine invocations out of order";
ILU_C_ExceptionCode	ex_StExcep_TRANSIENT = "StExcep: transient failure -- reissue request";
ILU_C_ExceptionCode	ex_StExcep_FREE_MEM = "StExcep: cannot free memory";
ILU_C_ExceptionCode	ex_StExcep_INV_IDENT = "StExcep: invalid identifier syntax";
ILU_C_ExceptionCode	ex_StExcep_INV_FLAG = "StExcep: invalid modifier or option was specified";
ILU_C_ExceptionCode	ex_StExcep_INTF_REPOS = "StExcep: error accessing interface repository";
ILU_C_ExceptionCode	ex_StExcep_CONTEXT = "StExcep: error processing context object";
ILU_C_ExceptionCode	ex_StExcep_OBJ_ADAPTER = "StExcep: error detected by object adapter";
ILU_C_ExceptionCode	ex_StExcep_DATA_CONVERSION = "StExcep: data conversion error";

#define SYS_EX(type,completion)	{s->_major=StExcep_SYSTEM_EXCEPTION;s->returnCode=(type);s->ptr=(void *)malloc(sizeof(StExcep_ex_body));s->freeRoutine=NULL;((StExcep_ex_body *)(s->ptr))->minor=0;((StExcep_ex_body *)(s->ptr))->completed=(completion);}

/*
** corba defined exception handling functions
*/

char *exception_id( 
    Environment		*ev )
{
  return(( char * ) ev->returnCode );
}

void *exception_value(
    Environment		*ev )
{
  return(( void * ) ev->ptr );
}

void exception_free( 
    Environment		*ev )
{
  if (ev->freeRoutine != NULL)
    (*ev->freeRoutine)(ev->ptr);
  free(ev->ptr);
  ev->ptr = NULL;
  ev->freeRoutine = NULL;
  return;
}

void ORBfree (void *ptr)
{
  if ( ptr )
    free( ptr );
  return;
}

ORBStatus ORB_create_list (Object h, Environment *s, long count, NVList *new_list)
{
  if (h != ILU_C_ORB)
    SYS_EX(ex_StExcep_INV_OBJREF,StExcep_NO)
  else
    SYS_EX(ex_StExcep_NO_IMPLEMENT,StExcep_NO)
}

ORBStatus ORB_create_operation_list (Object h, Environment *s, OperationDef oper, NVList *new_list)
{
  if (h != ILU_C_ORB)
    SYS_EX(ex_StExcep_INV_OBJREF,StExcep_NO)
  else
    SYS_EX(ex_StExcep_NO_IMPLEMENT,StExcep_NO)
}

ORBStatus ORB_get_default_context(Object h, Environment *s, Context *ctx)
{
  if (h != ILU_C_ORB)
    SYS_EX(ex_StExcep_INV_OBJREF,StExcep_NO)
  else
    SYS_EX(ex_StExcep_NO_IMPLEMENT,StExcep_NO)
}
    
char *ORB_object_to_string (Object h, Environment *s, Object o)
{
  char *sbh;

  if (h != ILU_C_ORB || ((sbh = ILU_C_SBHOfObject(o)) == NULL))
    {
      SYS_EX(ex_StExcep_INV_OBJREF,StExcep_NO)
      return (NULL);
    }
  else
    {
      s->_major = StExcep_NO_EXCEPTION;
      return (_ILU_C_Strdup(sbh));
    }
}

Object ORB_string_to_object (Object o, Environment *s, char *sbh)
{
  Object h;

  if (o != ILU_C_ORB || (h = ILU_C_SBHToObject (sbh, NULL, NULL)) == NULL)
    {
      SYS_EX(ex_StExcep_INV_OBJREF,StExcep_NO)
      return (NULL);
    }
  else
    {
      s->_major = StExcep_NO_EXCEPTION;
      return (h);
    }
}

ImplementationDef Object_get_implementation (Object h, Environment *s)
{
  SYS_EX(ex_StExcep_NO_IMPLEMENT,StExcep_NO)
  return NULL;
}

InterfaceDef Object_get_interface (Object h, Environment *s)
{
  SYS_EX(ex_StExcep_NO_IMPLEMENT,StExcep_NO)
  return NULL;
}

int Object_is_nil (Object h, Environment *s)
{
  s->_major = StExcep_NO_EXCEPTION;
  return (h == NULL);
}

Object Object_duplicate (Object	h, Environment *s)
{
  s->_major = StExcep_NO_EXCEPTION;
  return (h);
}

void Object_release (Object h, Environment *s)
{
  s->_major = StExcep_NO_EXCEPTION;
  /* ilu_DestroyObject( h ); */
}

ORBStatus Object_create_request (Object h, Environment *s, Context ctx, Identifier operation,
				 NVList arg_list, NamedValue *result, Request *request, Flags req_flags)
{
  SYS_EX(ex_StExcep_NO_IMPLEMENT,StExcep_NO)
}

#endif /* CORBA11 */

#ifdef CORBA12	/* CORBA 1.2 */

static ILU_C_Object	_ILU_C_ORB[1];
CORBA_Object		ILU_C_ORB = _ILU_C_ORB;

void _ILU_C_SetProtocolError (CORBA_Environment *status, ilu_ProtocolException perror)
{
  status->_major = CORBA_SYSTEM_EXCEPTION;
  status->freeRoutine = NULL;
  status->ptr = (void *) malloc(sizeof(CORBA_ex_body));
  ((CORBA_ex_body *)(status->ptr))->minor = 0;
  ((CORBA_ex_body *)(status->ptr))->minor = CORBA_COMPLETED_NO;
  switch (perror)
    {
    case ilu_ProtocolException_NoSuchClassAtServer:
      status->returnCode = ex_CORBA_BAD_TYPECODE;
      break;

    case ilu_ProtocolException_ClassVersionMismatch:
      status->returnCode = ex_CORBA_BAD_TYPECODE;
      break;

    case ilu_ProtocolException_NoSuchMethodOnClass:
      status->returnCode = ex_CORBA_BAD_OPERATION;
      break;

    case ilu_ProtocolException_GarbageArguments:
      status->returnCode = ex_CORBA_BAD_PARAM;
      break;

    case ilu_ProtocolException_Unknown:
      status->returnCode = ex_CORBA_UNKNOWN;
      ((CORBA_ex_body *)(status->ptr))->minor = CORBA_COMPLETED_MAYBE;
      break;

    case ilu_ProtocolException_LostConnection:
      status->returnCode = ex_CORBA_COMM_FAILURE;
      ((CORBA_ex_body *)(status->ptr))->minor = CORBA_COMPLETED_MAYBE;
      break;

    case ilu_ProtocolException_RequestRejected:
      status->returnCode = ex_CORBA_BAD_OPERATION;
      break;

    case ilu_ProtocolException_RequestTimeout:
      status->returnCode = ex_CORBA_NO_RESPONSE;
      ((CORBA_ex_body *)(status->ptr))->minor = CORBA_COMPLETED_MAYBE;
      break;

    default:
      break;

    }
}

ILU_C_ExceptionCode	ex_CORBA_UNKNOWN = "CORBA: an unknown exception was encountered";
ILU_C_ExceptionCode	ex_CORBA_BAD_PARAM = "CORBA: a bad parameter was passed";
ILU_C_ExceptionCode	ex_CORBA_NO_MEMORY = "CORBA: dynamic memory allocation failure";
ILU_C_ExceptionCode	ex_CORBA_IMP_LIMIT = "CORBA: some implementation limit exceeded";
ILU_C_ExceptionCode	ex_CORBA_COMM_FAILURE = "CORBA: communication failure";
ILU_C_ExceptionCode	ex_CORBA_INV_OBJREF = "CORBA: invalid object reference";
ILU_C_ExceptionCode	ex_CORBA_NO_PERMISSION = "CORBA: no permission for attempted operation";
ILU_C_ExceptionCode	ex_CORBA_INTERNAL = "CORBA: ORB internal error";
ILU_C_ExceptionCode	ex_CORBA_MARSHAL = "CORBA: error marshalling parameter or result";
ILU_C_ExceptionCode	ex_CORBA_INITIALIZE = "CORBA: ORB initialization failure";
ILU_C_ExceptionCode	ex_CORBA_NO_IMPLEMENT = "CORBA: operation implementation unavailable";
ILU_C_ExceptionCode	ex_CORBA_BAD_TYPECODE = "CORBA: bad typecode";
ILU_C_ExceptionCode	ex_CORBA_BAD_OPERATION = "CORBA: invalid operation";
ILU_C_ExceptionCode	ex_CORBA_NO_RESOURCES = "CORBA: insufficient resources for operation";
ILU_C_ExceptionCode	ex_CORBA_NO_RESPONSE = "CORBA: response to request not yet available";
ILU_C_ExceptionCode	ex_CORBA_PERSIST_STORE = "CORBA: persistent storage failure";
ILU_C_ExceptionCode	ex_CORBA_BAD_INV_ORDER = "CORBA: routine invocations out of order";
ILU_C_ExceptionCode	ex_CORBA_TRANSIENT = "CORBA: transient failure -- reissue request";
ILU_C_ExceptionCode	ex_CORBA_FREE_MEM = "CORBA: cannot free memory";
ILU_C_ExceptionCode	ex_CORBA_INV_IDENT = "CORBA: invalid identifier syntax";
ILU_C_ExceptionCode	ex_CORBA_INV_FLAG = "CORBA: invalid modifier or option was specified";
ILU_C_ExceptionCode	ex_CORBA_INTF_REPOS = "CORBA: error accessing interface repository";
ILU_C_ExceptionCode	ex_CORBA_BAD_CONTEXT = "CORBA: error processing context object";
ILU_C_ExceptionCode	ex_CORBA_OBJ_ADAPTER = "CORBA: error detected by object adapter";
ILU_C_ExceptionCode	ex_CORBA_DATA_CONVERSION = "CORBA: data conversion error";

#define SYS_EX(type,completion)	{s->_major=CORBA_SYSTEM_EXCEPTION;s->returnCode=(type);s->ptr=(void *)malloc(sizeof(CORBA_ex_body));s->freeRoutine=NULL;((CORBA_ex_body *)(s->ptr))->minor=0;((CORBA_ex_body *)(s->ptr))->completed=(completion);}

/*
** corba defined exception handling functions
*/

char *CORBA_exception_id (CORBA_Environment *ev)
{
  return(( char * ) ev->returnCode );
}

void *CORBAexception_value (CORBA_Environment *ev)
{
  return(( void * ) ev->ptr );
}

void CORBA_exception_free (CORBA_Environment *ev)
{
  if (ev->freeRoutine != NULL)
    (*ev->freeRoutine)(ev->ptr);
  free(ev->ptr);
  ev->ptr = NULL;
  ev->freeRoutine = NULL;
  return;
}

void CORBA_free (void *ptr)
{
  if ( ptr )
    free( ptr );
  return;
}

CORBA_ORBStatus CORBA_ORB_get_default_context (CORBA_Object h, CORBA_Environment *s, CORBA_Context *ctx)
{
  if (h != ILU_C_ORB)
    SYS_EX(ex_CORBA_INV_OBJREF,CORBA_COMPLETED_NO)
  else
    SYS_EX(ex_CORBA_NO_IMPLEMENT,CORBA_COMPLETED_NO)
}
    
char *CORBA_ORB_object_to_string (CORBA_Object h, CORBA_Environment *s, CORBA_Object o)
{
  char *sbh;

  if (h != ILU_C_ORB || ((sbh = ILU_C_SBHOfObject(o)) == NULL))
    {
      SYS_EX(ex_CORBA_INV_OBJREF,CORBA_COMPLETED_NO)
      return (NULL);
    }
  else
    {
      s->_major = CORBA_NO_EXCEPTION;
      return (_ILU_C_Strdup(sbh));
    }
}

CORBA_Object CORBA_ORB_string_to_object (CORBA_Object o, CORBA_Environment *s, char *sbh)
{
  CORBA_Object h;

  if (o != ILU_C_ORB || (h = ILU_C_SBHToObject (sbh, NULL, NULL)) == NULL)
    {
      SYS_EX(ex_CORBA_INV_OBJREF,CORBA_COMPLETED_NO)
      return (NULL);
    }
  else
    {
      s->_major = CORBA_NO_EXCEPTION;
      return (h);
    }
}

CORBA_boolean CORBA_Object_is_nil (CORBA_Object h, CORBA_Environment *s)
{
  s->_major = CORBA_NO_EXCEPTION;
  return (h == NULL);
}

CORBA_Object CORBA_Object_duplicate (CORBA_Object h, CORBA_Environment *s)
{
  s->_major = CORBA_NO_EXCEPTION;
  return (h);
}

void CORBA_Object_release (CORBA_Object h, CORBA_Environment *s)
{
  s->_major = CORBA_NO_EXCEPTION;
  /* ilu_DestroyObject( h ); */
}

#endif /* CORBA12 */

