/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: courier.h,v 1.9 1994/01/20 05:02:17 janssen Exp $ */
/* Last tweaked by Mike Spreitzer November 19, 1993 3:09 pm PST */

#include <stdio.h>

#include <sys/types.h>

#include <fcntl.h>

typedef enum { None, Input, Output, SizeOf } sequenceMode;

struct Courier {
  PACKET cr_in;			/* buffer for input from socket */
  PACKET cr_out;			/* buffer for output to socket */
  ilu_cardinal cr_sequence_length;	/* used in output/output of long seq.s */
  ilu_cardinal cr_sequence_limit;	/* used in ending long sequences */
  sequenceMode cr_sequence_mode;	/* used by EndSequence to descriminate */
};

typedef struct {
  ilu_Class cri_class;
  ilu_string cri_type_id;
  ilu_cardinal cri_pnumber, cri_version;
} courierinfo;

#define COURIER(conn) ((struct Courier *)((conn)->co_protocol_data))

#define PROGRAM_NUMBER_REGISTRY_NAME		"CourierRegistry"

#define courier_in(connection)		(COURIER(connection)->cr_in)
#define courier_out(connection)		(COURIER(connection)->cr_out)
