/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: error.c,v 1.3 1994/04/08 02:51:46 janssen Exp $ */
/* Last tweaked by Mike Spreitzer March 15, 1994 3:43 pm PST */

#define _POSIX_SOURCE

#ifdef MACOS
#pragma segment ilu
#endif

#include "error.h"

void ilu_FreeError(ilu_Error e)
{
  ilu_ErrorType t;
  t = e->type;
  (*t->freeproc)(e);
  free(e);
  return;
}

void * _ilu_ErrCons (ilu_ErrorType et, unsigned int size)
{
  ilu_Error f;
  int newsize = sizeof(struct _ilu_ErrorBase_s) + size;

  f = (ilu_Error) malloc(newsize);
  memset ((char *) f, 0, newsize);
  f->type = et;
  f->data = ((char *) f) + sizeof(struct _ilu_ErrorBase_s);
  return f;
}
