/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: hash.c,v 1.26 1994/03/16 00:32:31 spreitze Exp $ */
/* Last tweaked by Mike Spreitzer March 15, 1994 12:04 pm PST */

#define _POSIX_SOURCE

#ifdef MACOS
#pragma segment ilu
#endif

#include <string.h>	/* for memset */

#include "ilu.h"
#include "iluntrnl.h"

/*L2, Main unconstrained*/
/*L1 >= {some mutex that protects the table}*/

ilu_refany _ilu_hash_FindInTable (HashTable ht, ilu_refany key)
{
  struct hashTableSlot *slot;
  ilu_shortcardinal count;

  if (ht == NULL)
    return (NULL);
  slot = hashtable_slot(ht,hashtable_hash_index(ht, key));
  for (count = slot->hs_count;  count > 0;  count -= 1)
    if (hashtable_compare_keys(ht, key, slot->hs_entries[count - 1].he_key))
      return ((ilu_refany) slot->hs_entries[count - 1].he_data);
  return (NULL);
}

ilu_refany _ilu_hash_RemoveFromTable (HashTable ht, ilu_refany key)
{
  struct hashTableSlot *slot;
  ilu_shortcardinal count;

  if (ht == NULL)
    return (NULL);

  slot = hashtable_slot(ht,hashtable_hash_index(ht, key));
  for (count = 0;  count  < slot->hs_count;  count += 1)
    if (hashtable_compare_keys(ht, slot->hs_entries[count].he_key, key))
      {
	ilu_refany data = slot->hs_entries[count].he_data;
	if ((1 + (unsigned) count) < (unsigned) slot->hs_count)
	    slot->hs_entries[count] = slot->hs_entries[slot->hs_count-1];
	--ht->ht_nPairs;
	if (--slot->hs_count <= 0)
	  {
	    free(slot->hs_entries);
	    slot->hs_entries = NULL;
	    slot->hs_allocated = 0;
	    slot->hs_count = 0;
	  }
	return (data);
      }
  return (NULL);
}

ilu_boolean _ilu_hash_AddToTable (HashTable ht, ilu_refany key,
						ilu_refany obj)
{
  struct hashTableSlot *slot;
  ilu_shortcardinal count;

  if (ht == NULL)
    return (FALSE);

  slot = hashtable_slot(ht,hashtable_hash_index(ht, key));

  for (count = slot->hs_count;  count > 0;  count -= 1)
    if (hashtable_compare_keys(ht, key, slot->hs_entries[count - 1].he_key))
      FATAL("duplicate entry in hash table!");

  if (slot->hs_allocated == 0)
    {
      slot->hs_allocated = HASH_INCREMENT_SIZE;
      slot->hs_entries = (struct hashEntry *) malloc (
	sizeof(struct hashEntry) * slot->hs_allocated);
      slot->hs_count = 0;
    }
  else if (slot->hs_count >= slot->hs_allocated)
    slot->hs_entries = (struct hashEntry *) realloc (slot->hs_entries, (slot->hs_allocated += HASH_INCREMENT_SIZE) * sizeof(struct hashEntry));
  
  slot->hs_entries[slot->hs_count].he_key = key;
  slot->hs_entries[slot->hs_count].he_data = obj;
  slot->hs_count += 1;
  ht->ht_nPairs += 1;
  return (TRUE);
}

void _ilu_hash_BeginEnumeration (HashTable ht, HashEnumerator *he)
{
  he->hn_ht = ht;
  he->hn_index = 0;
  he->hn_count = ht->ht_slots[0].hs_count;
  return;
}

ilu_boolean _ilu_hash_Next(HashEnumerator *he, ilu_refany *key,
					       ilu_refany *data)
{
  if (he->hn_index >= he->hn_ht->ht_size)
      return(FALSE);
  if (he->hn_ht->ht_slots[he->hn_index].hs_count < he->hn_count)
      he->hn_count = he->hn_ht->ht_slots[he->hn_index].hs_count;
  while (he->hn_count <= 0) {
      if (++he->hn_index >= he->hn_ht->ht_size)
          return (FALSE);
      he->hn_count = he->hn_ht->ht_slots[he->hn_index].hs_count;
    }
  he->hn_count -= 1;
  *key  = he->hn_ht->ht_slots[he->hn_index].hs_entries[he->hn_count].he_key;
  *data = he->hn_ht->ht_slots[he->hn_index].hs_entries[he->hn_count].he_data;
  return (TRUE);
}

void _ilu_hash_TableEnumerate (HashTable ht, void (*proc) (ilu_refany entry_data, ilu_refany rock), ilu_refany rock)
{
  ilu_integer i;

  if (ht == NULL)
    return;

  for (i = 0;  i < ht->ht_size;  i += 1)
    if (ht->ht_slots[i].hs_count > 0)
      {
	ilu_shortcardinal j;

	for (j = 0;  j < ht->ht_slots[i].hs_count;  j += 1)
	  (*proc)(ht->ht_slots[i].hs_entries[j].he_data, rock);
      }
}

ilu_refany _ilu_hash_FindViaProc (HashTable ht, ilu_boolean (*proc) (ilu_refany entry_data, ilu_refany rock), ilu_refany rock)
{
  ilu_integer i;

  if (ht == NULL)
    return (NULL);

  for (i = 0;  i < ht->ht_size;  i += 1)
    if (ht->ht_slots[i].hs_count > 0)
      {
	ilu_shortcardinal j;

	for (j = 0;  j < ht->ht_slots[i].hs_count;  j += 1)
	  if ((*proc)(ht->ht_slots[i].hs_entries[j].he_data, rock))
	    return (ht->ht_slots[i].hs_entries[j].he_data);
      }
  return (NULL);
}

/*L1 unconstrained*/

ilu_boolean _ilu_hash_StringCompare (ilu_string key1, ilu_string key2)
{
  return (strcmp(key1, key2) == 0);
}

ilu_boolean _ilu_hash_PointerCompare (ilu_refany key1, ilu_refany key2)
{
  return (key1 == key2);
}

ilu_cardinal _ilu_hash_HashString (ilu_string key, ilu_cardinal size)
{
  ilu_cardinal val = 0;
  while (*key != '\0')
    val += *key++;
  return (val % size);
}

ilu_cardinal _ilu_hash_HashPointer (ilu_refany key, ilu_cardinal size)
{
  ilu_cardinal i = 0;
  ilu_cardinal val = 0;

  while (i < sizeof(ilu_refany))
    val += ((ilu_string )&key)[i++];
  return (val % size);
}

HashTable _ilu_hash_MakeNewTable (ilu_cardinal size,
	ilu_cardinal (*hashfn) (ilu_refany,ilu_cardinal),
	ilu_boolean (*compfn) (ilu_refany,ilu_refany))
{
  HashTable new = (HashTable) malloc (sizeof(struct hashTable));
  new->ht_size = size;
  new->ht_nPairs = 0;
  new->ht_slots = (struct hashTableSlot *) malloc(
	sizeof(struct hashTableSlot) * size);
  if (hashfn == NULL)
    new->ht_hashfn = (ilu_hashfnptr) _ilu_hash_HashString;
  else
    new->ht_hashfn = hashfn;
  if (compfn == NULL)
    new->ht_compfn = (ilu_compfnptr) _ilu_hash_StringCompare;
  else
    new->ht_compfn = compfn;
  memset ((void *)(new->ht_slots), 0, sizeof(struct hashTableSlot) * size);
  return (new);
}

/*L1 >= {some mutex that protects the table}*/

void _ilu_hash_FreeHashTable (HashTable ht, void (*freeKey)(ilu_refany),
					    void (*freeData)(ilu_refany))
{
  register ilu_cardinal i;

  if (ht == NULL)
    return;

  for (i = 0;  i < ht->ht_size;  i++) {
      if (ht->ht_slots[i].hs_count > 0 && ht->ht_slots[i].hs_entries != NULL) {
	  if (freeData != NULL OR freeKey != NULL) {
	      register ilu_cardinal j;

	      for (j = 0;  j < ht->ht_slots[i].hs_count;  j++) {
		  if (freeKey!=NULL && ht->ht_slots[i].hs_entries[j].he_key!=NULL)
		    (*freeKey)(ht->ht_slots[i].hs_entries[j].he_key);
		  if (freeData!=NULL
		      && ht->ht_slots[i].hs_entries[j].he_data!=NULL)
		    (*freeData)(ht->ht_slots[i].hs_entries[j].he_data);
		}
	    }
	  free (ht->ht_slots[i].hs_entries);
	}
      free(ht->ht_slots);
    }
  free(ht);
}

ilu_cardinal _ilu_hash_PairsInTable (HashTable ht)
{
  if (ht == NULL)
       return (0);
  else return (ht->ht_nPairs);
}
