/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: protocol.c,v 1.17 1994/02/15 20:33:29 janssen Exp $ */

#define _POSIX_SOURCE

#include "ilu.h"

#include "iluntrnl.h"
#include "transprt.h"
#include "protocol.h"
#include <string.h>

struct protocols_s {
  /*L1, L2, Main unconstrained*/
  
  ilu_string name;
  ilu_ProtocolType type;
  /*For calling: L1_sup < prmu, L2, Main unconstrained*/
  ilu_Protocol (*instantiator)(void);
};

/*L1, L2, Main unconstrained*/

static struct protocols_s protocols[] = {
#ifdef SUNRPC_PROTOCOL
  { "sunrpc", ilu_ProtocolType_SunRPC, _ilu_sunrpc_Protocol },
#endif /* SUNRPC_PROTOCOL */
#ifdef COURIER_PROTOCOL
  { "courier", ilu_ProtocolType_Courier, _ilu_courier_Protocol },
#endif /* COURIER_PROTOCOL */
  { NULL, 0, NULL } };

static struct protocols_s *FindProtocol (ilu_string pinfo)
{
  char buf[1000];
  ilu_integer i;

  if (pinfo != NULL)
    {
      ilu_string p;

      p = strchr(pinfo, '_');
      if (p == NULL)
	strcpy (buf, pinfo);
      else
	{
	  strncpy (buf, pinfo, p - pinfo);
	  buf[p - pinfo] = '\0';
	}
      for (i = 0;  protocols[i].name != NULL;  i += 1)
	if (_ilu_casefree_cmp(buf, protocols[i].name) == 0)
	  return(&protocols[i]);
    }
  return (NULL);
}

ilu_ProtocolType ilu_FindProtocolTypeFromInfo (ilu_string pinfo)
{
  struct protocols_s *p;

  if ((p = FindProtocol(pinfo)) == NULL)
    return (ilu_ProtocolType_None);
  else
    return (p->type);
}

/*L1_sup < prmu*/

ilu_Protocol _ilu_GetProtocolFromInfo (ilu_string pinfo)
{
  struct protocols_s *p;

  if ((p = FindProtocol(pinfo)) == NULL)
    return (NULL);
  else
    return ((*(p->instantiator))());
}
