/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: protocol.h,v 1.19 1994/01/20 05:02:17 janssen Exp $ */
/* Last tweaked by Mike Spreitzer December 21, 1993 2:22 pm PST */

#define protocol_type(protocol)		((protocol)->pr_type)
#define protocol_concurrent(protocol)	((protocol)->pr_concurrent_requests)

#define protocol_free_data_block(protocol,block)	((*((protocol)->pr_free_data_block))(block))
#define protocol_create_data_block(protocol)		((*((protocol)->pr_create_data_block))())
#define protocol_read_packet(protocol,bs,plen,ptype,psn)	((*((protocol)->pr_read_packet))((bs),(plen),(ptype),(psn)))
#define protocol_form_handle(protocol,object)	((*((protocol)->pr_form_handle))(object))

#define protocol_flush(protocol,call)		((*((protocol)->pr_flush))(call))

#define protocol_interpret_pipe_request(protocol,call,packet,len) ((*((protocol)->pr_interpret_pipe_request))((call),(packet),(len)))
#define protocol_interpret_request(protocol,call,packet,len) ((*((protocol)->pr_interpret_request))((call),(packet),(len)))
#define protocol_interpret_reply(protocol,call,packet,len,estatus) ((*((protocol)->pr_interpret_reply))((call),(packet),(len),(estatus)))

#define protocol_begin_request(protocol,call,pclass,method,argSize) ((*((protocol)->pr_begin_request))((call),(pclass),(method),(argSize)))
#define protocol_begin_reply(protocol,call,exceptions_p,argSize) ((*((protocol)->pr_begin_reply))((call),(exceptions_p),(argSize)))
#define protocol_begin_exception(protocol,call,exceptionCode,argSize) ((*((protocol)->pr_begin_exception))((call),(exceptionCode),(argSize)))
#define protocol_finish_exception(protocol,call) ((*((protocol)->pr_finish_exception))((call)))
#define protocol_finish_request(protocol,call) ((*((protocol)->pr_finish_request))((call)))
#define protocol_resend_request(protocol,call) ((*((protocol)->pr_resend_request))((call)))
#define protocol_drop_request(protocol,call) ((*((protocol)->pr_drop_request))((call)))
#define protocol_finish_reply(protocol,call) ((*((protocol)->pr_finish_reply))((call)))

#define protocol_skip_bytes(protocol,call,numBytes) ((*((protocol)->pr_skip_bytes))((call),(numBytes)))

#define protocol_output_optional(protocol,call,i) ((*((protocol)->pr_output_optional))((call),(i)))
#define protocol_input_optional(protocol,call,i) ((*((protocol)->pr_input_optional))((call),(i)))
#define protocol_size_of_optional(protocol,call,i) ((*((protocol)->pr_size_of_optional))((call),(i)))

#define protocol_output_integer(protocol,call,i) ((*((protocol)->pr_output_integer))((call),(i)))
#define protocol_input_integer(protocol,call,i) ((*((protocol)->pr_input_integer))((call),(i)))
#define protocol_size_of_integer(protocol,call,i) ((*((protocol)->pr_size_of_integer))((call),(i)))

#define protocol_output_cardinal(protocol,call,i) ((*((protocol)->pr_output_cardinal))((call),(i)))
#define protocol_input_cardinal(protocol,call,i) ((*((protocol)->pr_input_cardinal))((call),(i)))
#define protocol_size_of_cardinal(protocol,call,i) ((*((protocol)->pr_size_of_cardinal))((call),(i)))

#define protocol_output_short_integer(protocol,call,i) ((*((protocol)->pr_output_shortinteger))((call),(i)))
#define protocol_input_short_integer(protocol,call,i) ((*((protocol)->pr_input_shortinteger))((call),(i)))
#define protocol_size_of_short_integer(protocol,call,i) ((*((protocol)->pr_size_of_shortinteger))((call),(i)))

#define protocol_output_short_cardinal(protocol,call,i) ((*((protocol)->pr_output_shortcardinal))((call),(i)))
#define protocol_input_short_cardinal(protocol,call,i) ((*((protocol)->pr_input_shortcardinal))((call),(i)))
#define protocol_size_of_short_cardinal(protocol,call,i) ((*((protocol)->pr_size_of_shortcardinal))((call),(i)))

#define protocol_output_long_integer(protocol,call,i) ((*((protocol)->pr_output_longinteger))((call),(i)))
#define protocol_input_long_integer(protocol,call,i) ((*((protocol)->pr_input_longinteger))((call),(i)))
#define protocol_size_of_long_integer(protocol,call,i) ((*((protocol)->pr_size_of_longinteger))((call),(i)))

#define protocol_output_long_cardinal(protocol,call,i) ((*((protocol)->pr_output_longcardinal))((call),(i)))
#define protocol_input_long_cardinal(protocol,call,i) ((*((protocol)->pr_input_longcardinal))((call),(i)))
#define protocol_size_of_long_cardinal(protocol,call,i) ((*((protocol)->pr_size_of_longcardinal))((call),(i)))

#define protocol_output_long_real(protocol,call,i) ((*((protocol)->pr_output_longreal))((call),(i)))
#define protocol_input_long_real(protocol,call,i) ((*((protocol)->pr_input_longreal))((call),(i)))
#define protocol_size_of_long_real(protocol,call,i) ((*((protocol)->pr_size_of_longreal))((call),(i)))

#define protocol_output_real(protocol,call,i) ((*((protocol)->pr_output_real))((call),(i)))
#define protocol_input_real(protocol,call,i) ((*((protocol)->pr_input_real))((call),(i)))
#define protocol_size_of_real(protocol,call,i) ((*((protocol)->pr_size_of_real))((call),(i)))

#define protocol_output_short_real(protocol,call,i) ((*((protocol)->pr_output_shortreal))((call),(i)))
#define protocol_input_short_real(protocol,call,i) ((*((protocol)->pr_input_shortreal))((call),(i)))
#define protocol_size_of_short_real(protocol,call,i) ((*((protocol)->pr_size_of_shortreal))((call),(i)))

#define protocol_output_enum_code(protocol,call,i) ((*((protocol)->pr_output_enum_code))((call),(i)))
#define protocol_input_enum_code(protocol,call,i) ((*((protocol)->pr_input_enum_code))((call),(i)))
#define protocol_size_of_enum_code(protocol,call,i) ((*((protocol)->pr_size_of_enum_code))((call),(i)))

#define protocol_output_character(protocol,call,i) ((*((protocol)->pr_output_character))((call),(i)))
#define protocol_input_character(protocol,call,i) ((*((protocol)->pr_input_character))((call),(i)))
#define protocol_size_of_character(protocol,call,i) ((*((protocol)->pr_size_of_character))((call),(i)))

#define protocol_output_shortchar(protocol,call,i) ((*((protocol)->pr_output_shortchar))((call),(i)))
#define protocol_input_shortchar(protocol,call,i) ((*((protocol)->pr_input_shortchar))((call),(i)))
#define protocol_size_of_shortchar(protocol,call,i) ((*((protocol)->pr_size_of_shortchar))((call),(i)))

#define protocol_output_byte(protocol,call,i) ((*((protocol)->pr_output_byte))((call),(i)))
#define protocol_input_byte(protocol,call,i) ((*((protocol)->pr_input_byte))((call),(i)))
#define protocol_size_of_byte(protocol,call,i) ((*((protocol)->pr_size_of_byte))((call),(i)))

#define protocol_output_boolean(protocol,call,i) ((*((protocol)->pr_output_boolean))((call),(i)))
#define protocol_input_boolean(protocol,call,i) ((*((protocol)->pr_input_boolean))((call),(i)))
#define protocol_size_of_boolean(protocol,call,i) ((*((protocol)->pr_size_of_boolean))((call),(i)))

#define protocol_output_string(protocol,call,s,len,limit) ((*((protocol)->pr_output_string))((call),(s),(len),(limit)))
#define protocol_input_string(protocol,call,s,len,limit) ((*((protocol)->pr_input_string))((call),(s),(len),(limit)))
#define protocol_size_of_string(protocol,call,i,len,limit) ((*((protocol)->pr_size_of_string))((call),(i),(len),(limit)))

#define protocol_output_stringvec(protocol,call,i,len) ((*((protocol)->pr_output_stringvec))((call),(i),(len)))
#define protocol_input_stringvec(protocol,call,i,len) ((*((protocol)->pr_input_stringvec))((call),(i),(len)))
#define protocol_size_of_stringvec(protocol,call,i,len) ((*((protocol)->pr_size_of_stringvec))((call),(i),(len)))

#define protocol_output_wstring(protocol,call,s,len,limit) ((*((protocol)->pr_output_wstring))((call),(s),(len),(limit)))
#define protocol_input_wstring(protocol,call,s,len,limit) ((*((protocol)->pr_input_wstring))((call),(s),(len),(limit)))
#define protocol_size_of_wstring(protocol,call,i,len,limit) ((*((protocol)->pr_size_of_wstring))((call),(i),(len),(limit)))

#define protocol_output_wstringvec(protocol,call,i,len) ((*((protocol)->pr_output_wstringvec))((call),(i),(len)))
#define protocol_input_wstringvec(protocol,call,i,len) ((*((protocol)->pr_input_wstringvec))((call),(i),(len)))
#define protocol_size_of_wstringvec(protocol,call,i,len) ((*((protocol)->pr_size_of_wstringvec))((call),(i),(len)))

#define protocol_output_bytes(protocol,call,i,len,limit) ((*((protocol)->pr_output_bytes))((call),(i),(len),(limit)))
#define protocol_input_bytes(protocol,call,i,len,limit) ((*((protocol)->pr_input_bytes))((call),(i),(len),(limit)))
#define protocol_size_of_bytes(protocol,call,i,len,limit) ((*((protocol)->pr_size_of_bytes))((call),(i),(len),(limit)))

#define protocol_output_opaque(protocol,call,i,len) ((*((protocol)->pr_output_opaque))((call),(i),(len)))
#define protocol_input_opaque(protocol,call,i,len) ((*((protocol)->pr_input_opaque))((call),(i),(len)))
#define protocol_size_of_opaque(protocol,call,i,len) ((*((protocol)->pr_size_of_opaque))((call),(i),(len)))

#define protocol_output_object_id(protocol,call,i,desc_p) ((*((protocol)->pr_output_object_id))((call),(i),(desc_p)))
#define protocol_input_object_id(protocol,call,i,desc_p) ((*((protocol)->pr_input_object_id))((call),(i),(desc_p)))
#define protocol_size_of_object_id(protocol,call,i,desc_p) ((*((protocol)->pr_size_of_object_id))((call),(i),(desc_p)))

#define protocol_output_pipe(protocol,call,i) ((*((protocol)->pr_output_pipe))((call),(i)))
#define protocol_input_pipe(protocol,call,i) ((*((protocol)->pr_input_pipe))((call),(i)))
#define protocol_size_of_pipe(protocol,call,i) ((*((protocol)->pr_size_of_pipe))((call),(i)))

#define protocol_output_sequence(protocol,call,i,limit) ((*((protocol)->pr_output_sequence))((call),(i),(limit)))
#define protocol_output_sequence_mark(protocol,call,extent)	((*((protocol)->pr_output_sequence_mark))((call),(extent)))
#define protocol_input_sequence(protocol,call,i,limit) ((*((protocol)->pr_input_sequence))((call),(i),(limit)))
#define protocol_input_sequence_mark(protocol,call,extent)	((*((protocol)->pr_input_sequence_mark))((call),(extent)))
#define protocol_end_sequence(protocol,call) ((*((protocol)->pr_end_sequence))((call)))
#define protocol_size_of_sequence(protocol,call,i,limit) ((*((protocol)->pr_size_of_sequence))((call),(i),(limit)))

#define protocol_output_union(protocol,call,i) ((*((protocol)->pr_output_union))((call),(i)))
#define protocol_input_union(protocol,call,i) ((*((protocol)->pr_input_union))((call),(i)))
#define protocol_end_union(protocol,call) ((*((protocol)->pr_end_union))((call)))
#define protocol_size_of_union(protocol,call,i) ((*((protocol)->pr_size_of_union))((call),(i)))

#define protocol_output_array(protocol,call,len) ((*((protocol)->pr_output_array))((call),(len)))
#define protocol_input_array(protocol,call) ((*((protocol)->pr_input_array))((call)))
#define protocol_end_array(protocol,call) ((*((protocol)->pr_end_array))((call)))
#define protocol_size_of_array(protocol,call,len) ((*((protocol)->pr_size_of_array))((call),(len)))

#define protocol_output_record(protocol,call) ((*((protocol)->pr_output_record))((call)))
#define protocol_input_record(protocol,call) ((*((protocol)->pr_input_record))((call)))
#define protocol_end_record(protocol,call) ((*((protocol)->pr_end_record))((call)))
#define protocol_size_of_record(protocol,call) ((*((protocol)->pr_size_of_record))((call)))

