/*
 * support.c -- support for library routines (e.g. bcopy() not provided by
 * some OSs
 *
 * Antony Courtney, 7/18/93
 */
#include "ilu.h"
#include "iluntrnl.h"

#define RAND_PID 12300	/* a random pid */

void ilu_sup_bcopy(char *src,char *dst,unsigned long len)
{
	if (src > (dst+len))
		for (; len--; *dst++=*src++)
			;
	else 
		for (dst+=len, src+=len; len--; *--dst=*--src)
			;
}

/* a version of strtoul() that _works_ (sort of).  Note:  This is a very crude implementation... */
unsigned long _ilu_strtoul(char *start, char **end,int base)
{
	unsigned long rval=0;
	
	while (*start==' ')
		start++;
	while ((*start!=' ') && (*start!='\r') && (*start!='\n') && (*start!='\t') && (*start!='\0')) {
		if ((*start >= '0') && (*start<='9')) {
			rval*=base;
			rval+=(*start-'0');
		} else {
			if ((*start >= 'a') && (*start <='z')) {
				rval*=base;
				rval+=(*start-'a'+10);
			} else {
				if ((*start >= 'A') && (*start <= 'Z')) {
					rval*=base;
					rval+=(*start-'A'+10);
				}
			}
		}
		start++;
	}
	if (end!=NULL)
		*end=start;
	return rval;
}

int ilu_sup_getpid()
{
	return RAND_PID;
}
