_ilu_hash_TableEnumerate (HashTable ht, void (*proc) (/* ??? */), ilu_refany rock)
{
  ilu_integer i;

  if (ht == NULL)
    return (NULL);

  for (i = 0;  i < ht->size;  i += 1)
    if (ht->slots[i].count > 0)
      {
	int j;

	for (j = 0;  j < ht->slots[i].count;  j += 1)
	  (*proc)(ht->slots[i].entries[j].data, rock);
      }
}

ilu_refany _ilu_hash_FindViaProc (HashTable ht, ilu_boolean (*proc) (/* ??? */), ilu_refany rock)
{
  ilu_integer i;

  if (ht == NULL)
    return (NULL);

  for (i = 0;  i < ht->size;  i += 1)
    if (ht->slots[i].count > 0)
      {
	int j;

	for (j = 0;  j < ht->slots[i].count;  j += 1)
	  if ((*proc)(ht->slots[i].entries[j].data, rock))
	    return (ht->slots[i].entries[j].data);
      }
  return (NULL);
}

ilu_boolean _ilu_hash_StringCompare (ilu_string key1, ilu_string key2)
{
  return (strcmp(key1, key2) == 0);
}

ilu_boolean _ilu_hash_PointerCompare (ilu_refany key1, ilu_refany key2)
{
  return (key1 == key2);
}

ilu_cardinal _ilu_hash_HashString (ilu_string key, ilu_cardinal size)
{
  ilu_cardinal val = 0;
  while (*key != '\0')
    val += *key++;
  return (val % size);
}

ilu_cardinal _ilu_hash_HashPointer (ilu_refany key, ilu_cardinal size)
{
  ilu_cardinal i = 0;
  ilu_cardinal val = 0;

  while (i < sizeof(ilu_refany))
    val += ((ilu_string )&key)[i++];
  return (val % size);
}

ilu_refany _ilu_hash_MakeNewTable (ilu_cardinal size,
	ilu_cardinal (*hashfn) (ilu_refany,ilu_cardinal),
	ilu_boolean (*compfn) (ilu_refany,ilu_refany))
{
  HashTable new = (HashTable) malloc (sizeof(struct hashTable));
  new->size = size;
  new->slots = (struct hashTableSlot *) malloc(sizeof(struct hashTableSlot) * size);
  if (hashfn == NULL)
    new->hashfn = (ilu_hashfnptr) _ilu_hash_HashString;
  else
    new->hashfn = hashfn;
  if (compfn == NULL)
    new->compfn = (ilu_compfnptr) _ilu_hash_StringCompare;
  else
    new->compfn = compfn;
  memset(new->slots, 0, sizeof(struct hashTableSlot) * size);
  return ((ilu_refany) new);
}

void _ilu_hash_FreeHashTable (HashTable ht, void (*freeKey)(ilu_refany), void (*freeData)(ilu_refany))
{
  register ilu_cardinal i;

  if (ht == NULL)
    return;

  for (i = 0;  i < ht->size;  i++)
    {
      if (ht->slots[i].count > 0 && ht->slots[i].entries != NULL)
	{
	  if (freeData != NULL OR freeKey != NULL)
	    {
	      register ilu_cardinal j;

	      for (j = 0;  j < ht->slots[i].count;  j++)
		{
		  if (freeKey != NULL AND ht->slots[i].entries[j].key != NULL)
		    (*freeKey)(ht->slots[i].entries[j].key);
		  if (freeData != NULL AND ht->slots[i].entries[j].data != NULL)
		    (*freeData)(ht->slots[i].entries[j].data);
		}
	    }
	  free (ht->slots[i].entries);
	}
      free(&ht->slots[i]);
    }
  free(ht);
}

ilu_cardinal _ilu_hash_CountObjectsInTable (HashTable ht)
{
  register ilu_cardinal i;
  ilu_cardinal size = 0;

  if (ht == NULL)
    return (0);

  for (i = 0;  i < ht->size;  i++)
    size += ht->slots[i].count;
  return (size);
}
