(* IluBasics.i3 *)
(* Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights
   Reserved.

   Unlimited use, reproduction, and distribution of this software is
   permitted.  Any copy of this software must include both the above
   copyright notice of Xerox Corporation and this paragraph.  Any
   distribution of this software must comply with all applicable United
   States export control laws.  This software is made available AS IS,
   and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
   INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND
   NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY LIABILITY
   FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS EXPRESSLY
   DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING NEGLIGENCE)
   OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGES. *)
(* Last tweaked by Mike Spreitzer November 10, 1993 9:26 am PST *)

INTERFACE IluBasics;

(* The generic exception. *)
EXCEPTION Failed(Failure);

TYPE
  Failure = ExceptionArgT BRANDED OBJECT END;
  (* Various subtypes of this object type can be defined to identify
     certain cases, and pass information about them, in an
     easily-recognized way. *)

TYPE
  ExceptionArgT = OBJECT
                    info  : TEXT;
                    subArg: ExceptionArgT := NIL;
                  END;

PROCEDURE FullInfo (e: ExceptionArgT; separator: TEXT := " - "): TEXT;

END IluBasics.
